/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.metedata.transformer.convert.support.container;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.metadata.print.control.BaseControl;
import kd.bos.metadata.print.control.LayoutCell;
import kd.bos.metadata.print.control.LayoutColumn;
import kd.bos.print.api.metedata.control.grid.layoutgrid.LayoutGridCell;
import kd.bos.print.business.metedata.transformer.convert.ConversionUtils;
import kd.bos.print.business.metedata.transformer.convert.converter.ConvertResult;
import kd.bos.print.business.metedata.transformer.convert.support.TextConverter;

public class LayoutGridCellConverter<S extends LayoutCell, T extends LayoutGridCell>
extends TextConverter<S, T> {
    @Override
    public Map<String, String> getConvertPairType() {
        HashMap<String, String> convertPair = new HashMap<String, String>(2);
        convertPair.put("sourceType", LayoutCell.class.getName());
        convertPair.put("targetType", LayoutGridCell.class.getName());
        return convertPair;
    }

    @Override
    public ConvertResult<T> convert(S source) {
        ConvertResult<LayoutGridCell> convertResult = new ConvertResult<LayoutGridCell>();
        convertResult.setTarget(new LayoutGridCell());
        this.convert(source, convertResult);
        return convertResult;
    }

    @Override
    public ConvertResult<T> convert(S source, ConvertResult<T> convertResult) {
        return convertResult;
    }

    @Override
    public ConvertResult<T> convert(S source, Map ctx) {
        ConvertResult<LayoutGridCell> convertResult = new ConvertResult<LayoutGridCell>();
        convertResult.setTarget(new LayoutGridCell());
        this.convert(source, convertResult, ctx);
        return convertResult;
    }

    public ConvertResult<T> convert(S source, ConvertResult<T> convertResult, Map ctx) {
        this.map = ctx;
        super.convert(source, convertResult);
        LayoutGridCell target = (LayoutGridCell)convertResult.getTarget();
        Map mapKeyItems = (Map)ctx.get("mapItems");
        this.setWH(mapKeyItems, source, target);
        this.setDefalutVuale(target);
        this.setPid(mapKeyItems, target, source);
        target.setRowId(((BaseControl)mapKeyItems.get(source.getParentId())).getId());
        target.setColumnId(this.findColumnId(mapKeyItems, source.getIndex(), source.getParentId()));
        target.setCellType("Layout");
        return convertResult;
    }

    private void setPid(Map<String, BaseControl<?>> mapKeyItems, LayoutGridCell target, S source) {
        BaseControl<?> rowControl = mapKeyItems.get(source.getParentId());
        BaseControl<?> gridControl = mapKeyItems.get(rowControl.getParentId());
        target.setParentId(gridControl.getId());
    }

    private String findColumnId(Map<String, BaseControl<?>> mapKeyItems, int index, String pid) {
        ArrayList layoutColumns = new ArrayList();
        for (Map.Entry<String, BaseControl<?>> key : mapKeyItems.entrySet()) {
            LayoutColumn layoutColumn;
            if (!(key.getValue() instanceof LayoutColumn) || !(layoutColumn = (LayoutColumn)key.getValue()).getParentId().equals(mapKeyItems.get(pid).getParentId())) continue;
            layoutColumns.add(key.getValue());
        }
        ConversionUtils.sortControls(layoutColumns);
        BaseControl column = (BaseControl)layoutColumns.get(index);
        return column.getId();
    }

    private void setDefalutVuale(LayoutGridCell target) {
        target.setBorderType("noneBorder");
    }

    private void setWH(Map<String, BaseControl<?>> mapKeyItems, S source, LayoutGridCell target) {
        if (source.getWidth() == null) {
            String cId = this.findColumnId(mapKeyItems, source.getIndex(), source.getParentId());
            BaseControl<?> baseControl = mapKeyItems.get(cId);
            LocaleString width = baseControl.getWidth();
            target.setWidth(ConversionUtils.getLocaleNumByLocaleString(width));
        }
        if (source.getHeight() == null) {
            target.setHeight(ConversionUtils.getLocaleNumByLocaleString(mapKeyItems.get(source.getParentId()).getHeight()));
        }
    }

    @Override
    public String getControlType() {
        return "LayoutCell";
    }
}

