/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.metedata.transformer.convert.support.container;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.metadata.print.control.BaseControl;
import kd.bos.metadata.print.control.BaseGrid;
import kd.bos.metadata.print.control.DataRow;
import kd.bos.metadata.print.control.LayoutColumn;
import kd.bos.metadata.print.control.LayoutGrid;
import kd.bos.metadata.print.control.LayoutRow;
import kd.bos.print.api.metedata.LocaleValue;
import kd.bos.print.business.metedata.transformer.convert.ConversionUtils;
import kd.bos.print.business.metedata.transformer.convert.converter.ConvertResult;
import kd.bos.print.business.metedata.transformer.convert.support.BaseControlConverter;

public class LayoutGridConverter<S extends BaseGrid, T extends kd.bos.print.api.metedata.control.grid.layoutgrid.LayoutGrid>
extends BaseControlConverter<S, T> {
    @Override
    public Map<String, String> getConvertPairType() {
        HashMap<String, String> convertPair = new HashMap<String, String>(2);
        convertPair.put("sourceType", LayoutGrid.class.getName());
        convertPair.put("targetType", kd.bos.print.api.metedata.control.grid.layoutgrid.LayoutGrid.class.getName());
        return convertPair;
    }

    @Override
    public ConvertResult<T> convert(S source) {
        ConvertResult<kd.bos.print.api.metedata.control.grid.layoutgrid.LayoutGrid> convertResult = new ConvertResult<kd.bos.print.api.metedata.control.grid.layoutgrid.LayoutGrid>();
        convertResult.setTarget(new kd.bos.print.api.metedata.control.grid.layoutgrid.LayoutGrid());
        this.convert(source, convertResult);
        return convertResult;
    }

    @Override
    public ConvertResult<T> convert(S source, ConvertResult<T> convertResult) {
        kd.bos.print.api.metedata.control.grid.layoutgrid.LayoutGrid target = (kd.bos.print.api.metedata.control.grid.layoutgrid.LayoutGrid)convertResult.getTarget();
        target.setFontName(ConversionUtils.getNameByLocaleString(source.getFontName()));
        target.setFontSizeF(new LocaleValue((Object)Float.valueOf(new BigDecimal(source.getFontSize()).floatValue())));
        target.setBorderType("noneBorder");
        target.setBorder(ConversionUtils.parseStyel(source.getStyle()));
        Map<String, List> map = this.getRowAndColumnMap(source);
        target.setHeight(this.getHeight(source, map.get("row")));
        target.setWidth(this.getWidth(source, map.get("column")));
        this.setMergeBlock(source, target);
        return convertResult;
    }

    private LocaleValue<Number> getHeight(S source, List<BaseControl> rowList) {
        Float height = new Float(0.0f);
        for (BaseControl layoutRow : rowList) {
            height = Float.valueOf(height.floatValue() + ConversionUtils.getNumByLocaleString(layoutRow.getHeight()).floatValue());
        }
        return new LocaleValue((Object)height);
    }

    private LocaleValue<Number> getWidth(S source, List<LayoutColumn> comList) {
        Float width = new Float(0.0f);
        for (LayoutColumn layoutColumn : comList) {
            width = Float.valueOf(width.floatValue() + ConversionUtils.getNumByLocaleString(layoutColumn.getWidth()).floatValue());
        }
        return new LocaleValue((Object)width);
    }

    private void setMergeBlock(S source, kd.bos.print.api.metedata.control.grid.layoutgrid.LayoutGrid target) {
        List mergeBlocks = source.getMergeBlocks();
        LinkedHashMap mergeConfig = new LinkedHashMap();
        target.setMergeConfig(mergeConfig);
        if (source.getMergeBlocks() != null) {
            for (Map map : mergeBlocks) {
                LinkedHashMap<String, Integer> configs = new LinkedHashMap<String, Integer>();
                Integer columnStart = (Integer)map.get("left");
                Integer columnLength = (Integer)map.get("right") - (Integer)map.get("left") + 1;
                Integer rowStart = (Integer)map.get("top");
                Integer rowLength = (Integer)map.get("bottom") - (Integer)map.get("top") + 1;
                String key = rowStart.toString() + "_" + columnStart.toString();
                configs.put("columnLength", columnLength);
                configs.put("rowLength", rowLength);
                configs.put("columnStart", columnStart);
                configs.put("rowStart", rowStart);
                mergeConfig.put(key, configs);
            }
        }
    }

    private Map<String, List> getRowAndColumnMap(S source) {
        List controls = source.get();
        HashMap<String, List> map = new HashMap<String, List>();
        for (BaseControl baseControl : controls) {
            if (baseControl instanceof LayoutColumn) {
                List colList = map.getOrDefault("column", new ArrayList());
                colList.add(baseControl);
                map.putIfAbsent("column", colList);
                continue;
            }
            if (!(baseControl instanceof LayoutRow) && !(baseControl instanceof DataRow)) continue;
            List rowList = map.getOrDefault("row", new ArrayList());
            rowList.add(baseControl);
            map.putIfAbsent("row", rowList);
        }
        return map;
    }

    @Override
    public String getControlType() {
        return "LayoutGrid";
    }
}

