/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.scheme.dao;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.product.ProductSettingService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.devportal.BizCloudServiceHelp;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.svc.util.TreeNodeFilter;
import org.apache.commons.beanutils.MethodUtils;

public class CloudAppMenuDao {
    private static final Log log = LogFactory.getLog(CloudAppMenuDao.class);
    private static final String ROOT_NODE = "rootNode";
    private static final String APP_IDS = "appIds";
    private static final String App_EXT_IDS = "appExtIds";

    private CloudAppMenuDao() {
    }

    @Deprecated
    public static TreeNode getTree() {
        JSONArray data = BizAppServiceHelp.getAllAppInfo();
        String lang = RequestContext.get().getLang().getLocale().toString();
        if (data != null && !data.isEmpty()) {
            String rootTreeId = ROOT_NODE;
            TreeNode root = new TreeNode("", rootTreeId, ResManager.loadKDString((String)"\u5168\u90e8", (String)"CloudAppMenuDao_0", (String)"bos-print-business", (Object[])new Object[0]));
            ArrayList<TreeNode> clouds = new ArrayList<TreeNode>(10);
            ArrayList<String> appIdList = new ArrayList<String>(10);
            HashMap<String, TreeNode> appMap = new HashMap<String, TreeNode>(16);
            for (int i = 0; i < data.size(); ++i) {
                TreeNode cloud;
                JSONArray temp = data.getJSONArray(i);
                if (temp == null || temp.isEmpty() || (cloud = CloudAppMenuDao.getCloudNode(temp, rootTreeId, lang)) == null) continue;
                List<String> appIds = CloudAppMenuDao.buildCloudAppNode(cloud, temp, lang, appMap);
                appIdList.addAll(appIds);
                if (CollectionUtils.isEmpty((Collection)cloud.getChildren())) continue;
                clouds.add(cloud);
            }
            CloudAppMenuDao.buildPrintEntityNodes(appIdList, appMap);
            root.setChildren(clouds);
            return root;
        }
        return null;
    }

    public static TreeNode getTreeIncludeAll(IPageCache pageCache, String level, boolean isRunTime) {
        TreeNode root = new TreeNode();
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"CloudAppMenuDao_0", (String)"bos-print-business", (Object[])new Object[0]));
        root.setParentid("");
        root.setId(ROOT_NODE);
        root.setIsOpened(true);
        ArrayList<String> appIdList = new ArrayList<String>(10);
        HashMap<String, TreeNode> appMap = new HashMap<String, TreeNode>(16);
        TreeNodeFilter treeNodeFilter = new TreeNodeFilter();
        List<TreeNode> cloudNodes = CloudAppMenuDao.getAllCloudNodes(treeNodeFilter);
        Map<String, List<DynamicObject>> allAppMap = BizAppServiceHelp.getAllBizAppsByCloudID(cloudNodes.stream().map(TreeNode::getId).collect(Collectors.toList())).stream().collect(Collectors.groupingBy(m -> m.getString("bizcloud")));
        HashMap<String, List<String>> appExtIds = new HashMap<String, List<String>>(16);
        ArrayList<String> appIds = new ArrayList<String>(10);
        for (TreeNode treeNode : cloudNodes) {
            treeNode.setData((Object)"cloud");
            List<DynamicObject> appDynamicObjs = allAppMap.get(treeNode.getId());
            if (appDynamicObjs == null) continue;
            List<TreeNode> appNodes = new ArrayList(appDynamicObjs.size());
            Map<String, String> extAppNameMap = CloudAppMenuDao.getExtAppNameMap(appDynamicObjs, appExtIds);
            for (DynamicObject appDynamicObj : appDynamicObjs) {
                if (!"0".equals(appDynamicObj.getString("type")) || isRunTime && "1".equals(appDynamicObj.getString("deploystatus"))) continue;
                TreeNode node = new TreeNode();
                String nodeId = appDynamicObj.getString("id");
                String name = extAppNameMap.getOrDefault(nodeId, appDynamicObj.getString("name"));
                node.setId(nodeId);
                node.setText(name);
                node.setParentid(treeNode.getId());
                appNodes.add(node);
            }
            appNodes = treeNodeFilter.filterAppTreeNode(appNodes);
            for (TreeNode appNode : appNodes) {
                String nodeId = appNode.getId();
                appIds.add(nodeId);
                if (!appExtIds.containsKey(nodeId)) continue;
                appIds.addAll((Collection)appExtIds.get(nodeId));
            }
            CloudAppMenuDao.addChildNode(treeNode, appNodes);
            appIdList.addAll(appNodes.stream().map(TreeNode::getId).filter(StringUtils::isNotBlank).collect(Collectors.toList()));
            appMap.putAll(appNodes.stream().collect(Collectors.toMap(TreeNode::getId, Function.identity())));
        }
        if ("menu".equals(level)) {
            CloudAppMenuDao.buildPrintEntityNodes(appIdList, appMap);
        }
        CloudAppMenuDao.removeEmptyCloudNode(cloudNodes);
        root.setChildren(cloudNodes);
        if (pageCache != null) {
            pageCache.put(App_EXT_IDS, SerializationUtils.toJsonString(appExtIds));
            pageCache.put(APP_IDS, SerializationUtils.toJsonString(appIds));
        }
        return root;
    }

    public static TreeNode getTreeIncludeAll() {
        return CloudAppMenuDao.getTreeIncludeAll(null, "menu", false);
    }

    private static Map<String, String> getExtAppNameMap(List<DynamicObject> appDynamicObjs, Map<String, List<String>> appExtIds) {
        HashMap<String, String> extAppNameMap = new HashMap<String, String>(16);
        HashMap<String, Integer> pathLen = new HashMap<String, Integer>(16);
        for (DynamicObject appDynamicObj : appDynamicObjs) {
            List<Object> extAppIds;
            if ("0".equals(appDynamicObj.getString("type"))) continue;
            String name = appDynamicObj.getString("name");
            String inheritpath = appDynamicObj.getString("inheritpath");
            String sourceAppId = appDynamicObj.getString("masterid");
            if (!appExtIds.containsKey(sourceAppId)) {
                extAppIds = new ArrayList(10);
                extAppIds.add(String.valueOf(appDynamicObj.get("id")));
                appExtIds.put(sourceAppId, extAppIds);
            } else {
                extAppIds = appExtIds.get(sourceAppId);
                extAppIds.add(String.valueOf(appDynamicObj.get("id")));
            }
            int length = String.valueOf(inheritpath).length();
            if (!extAppNameMap.containsKey(sourceAppId)) {
                extAppNameMap.put(sourceAppId, name);
                pathLen.put(sourceAppId, length);
                continue;
            }
            Integer maxLen = pathLen.getOrDefault(sourceAppId, 0);
            if (maxLen >= length) continue;
            extAppNameMap.put(sourceAppId, name);
            pathLen.put(sourceAppId, length);
        }
        return extAppNameMap;
    }

    private static void removeEmptyCloudNode(List<TreeNode> cloudNodes) {
        if (CollectionUtils.isEmpty(cloudNodes)) {
            return;
        }
        Iterator<TreeNode> cloudIterator = cloudNodes.iterator();
        while (cloudIterator.hasNext()) {
            TreeNode cloud = cloudIterator.next();
            List appNodes = cloud.getChildren();
            if (!CollectionUtils.isEmpty((Collection)appNodes)) continue;
            cloudIterator.remove();
        }
    }

    private static Set<String> getExtendedAppIds() {
        HashSet<String> extendedAppIds = new HashSet<String>();
        QFilter mstNotNUll = new QFilter("masterid", "is not null", (Object)Boolean.TRUE);
        QFilter mstEmpty = new QFilter("masterid", "!=", (Object)" ");
        QFilter[] mstfilters = new QFilter[]{mstNotNUll, mstEmpty};
        Map appExtends = BusinessDataServiceHelper.loadFromCache((String)"bos_devportal_bizapp", (String)"masterid,visible", (QFilter[])mstfilters);
        if (!CollectionUtils.isEmpty((Map)appExtends)) {
            for (DynamicObject obj : appExtends.values()) {
                String masterStr = obj.getString("masterid");
                extendedAppIds.add(masterStr);
            }
        }
        return extendedAppIds;
    }

    private static List<TreeNode> getAllCloudNodes(TreeNodeFilter treeNodeFilter) {
        ArrayList<TreeNode> cloudNode = new ArrayList();
        DynamicObjectCollection dynamicObjects = BizCloudServiceHelp.getAllBizClouds();
        for (DynamicObject dynamicObject : dynamicObjects) {
            TreeNode node = new TreeNode();
            node.setId(dynamicObject.getString("id"));
            node.setText(dynamicObject.getString("name"));
            node.setParentid(ROOT_NODE);
            cloudNode.add(node);
        }
        cloudNode = treeNodeFilter.filterCloudTreeNode(cloudNode);
        return cloudNode;
    }

    private static TreeNode addChildNode(TreeNode pnode, List<TreeNode> childNodes) {
        for (int i = 0; i < childNodes.size(); ++i) {
            TreeNode cnode = childNodes.get(i);
            cnode.setData((Object)"app");
            String parentId = cnode.getParentid();
            if (!pnode.getId().equals(parentId)) continue;
            pnode.addChild(CloudAppMenuDao.addChildNode(cnode, childNodes));
        }
        return pnode;
    }

    private static void buildPrintEntityNodes(List<String> appIds, Map<String, TreeNode> appMap) {
        if (CollectionUtils.isEmpty(appIds)) {
            return;
        }
        SqlBuilder extAppSql = new SqlBuilder();
        extAppSql.append("SELECT FID,FMASTERID FROM T_META_BIZAPP WHERE ", new Object[0]);
        extAppSql.appendIn(" FMASTERID ", new ArrayList<String>(appIds));
        HashMap ext2Src = new HashMap(16);
        appIds.addAll((Collection)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)extAppSql, resultSet -> {
            ArrayList<String> extAppIds = new ArrayList<String>(16);
            while (resultSet.next()) {
                String extId = resultSet.getString("FID");
                String srcId = resultSet.getString("FMASTERID");
                extAppIds.add(extId);
                ext2Src.put(extId, srcId);
            }
            return extAppIds;
        }));
        SqlBuilder sql = new SqlBuilder();
        sql.append(" SELECT A.FID,A.FNUMBER,A.FBIZAPPID,B.FNAME  FROM T_META_ENTITYDESIGN A  left join T_META_ENTITYDESIGN_L B ON A.FID = B.FID ", new Object[0]);
        sql.append("  WHERE ", new Object[0]);
        sql.append(" B.FLOCALEID= ?", new Object[]{RequestContext.get().getLang().getLocale().toString()});
        sql.append(" and ", new Object[0]);
        sql.appendIn("FBIZAPPID ", new ArrayList<String>(appIds));
        sql.append(" ORDER BY A.FCREATEDATE ASC ", new Object[0]);
        SqlBuilder sql1 = new SqlBuilder();
        sql1.append("select FBILLFORMID from t_bas_printtplinfo ", new Object[0]);
        try (DataSet dataSet = DB.queryDataSet((String)CloudAppMenuDao.class.getName(), (DBRoute)DBRoute.meta, (SqlBuilder)sql);
             DataSet tplDataSet = DB.queryDataSet((String)CloudAppMenuDao.class.getName(), (DBRoute)DBRoute.basedata, (SqlBuilder)sql1);
             DataSet rows = dataSet.join(tplDataSet, JoinType.INNER).on("FNUMBER", "FBILLFORMID").select(new String[]{"FID", "FNUMBER", "FBIZAPPID", "FNAME"}).finish();){
            if (rows != null && !rows.isEmpty()) {
                while (rows.hasNext()) {
                    Row row = rows.next();
                    String id = row.getString("FID");
                    String appId = row.getString("FBIZAPPID");
                    String formId = row.getString("FNUMBER");
                    String number = row.getString("FNUMBER");
                    String name = row.getString("FNAME");
                    TreeNode appNode = appMap.get(appId);
                    if (appNode == null) {
                        appNode = appMap.get(ext2Src.get(appId));
                    }
                    if (!StringUtils.isNotBlank((CharSequence)id) || !StringUtils.isNotBlank((CharSequence)formId) || !StringUtils.isNotBlank((CharSequence)number) || !formId.equals(number) || appNode == null) continue;
                    TreeNode menuNode = new TreeNode(appNode.getId(), id, "");
                    menuNode.setData((Object)"menu");
                    menuNode.setText(name);
                    if (appNode.getChildren() == null) {
                        appNode.setChildren(new ArrayList(16));
                    }
                    appNode.getChildren().add(menuNode);
                }
            }
        }
    }

    public static List<String> getBlackListByAppId(String appId) {
        return Collections.EMPTY_LIST;
    }

    public static List<String> getHiddenMenusByAppId(String appId) {
        ProductSettingService service;
        List blackMenus;
        ArrayList<String> hiddenMenus = new ArrayList<String>();
        List<String> hideMenus = CloudAppMenuDao.getHideMenus();
        if (!CollectionUtils.isEmpty(hideMenus)) {
            hiddenMenus.addAll(hideMenus);
        }
        if (!CollectionUtils.isEmpty((Collection)(blackMenus = (service = (ProductSettingService)ServiceFactory.getService(ProductSettingService.class)).getAppMenuBlackList(appId)))) {
            hiddenMenus.addAll(blackMenus);
        }
        ArrayList noPermMenuIds = new ArrayList();
        noPermMenuIds.addAll(PermissionServiceHelper.getAllNoPermMenuIdsByAppId((Long)Long.parseLong(RequestContext.get().getUserId()), (String)appId));
        if (!CollectionUtils.isEmpty(noPermMenuIds)) {
            hiddenMenus.addAll(noPermMenuIds);
        }
        return hiddenMenus;
    }

    private static List<String> getHideMenus() {
        String className = "kd.bos.portal.pluginnew.CardUtils";
        try {
            Class factory = TypesContainer.getOrRegister((String)className);
            return (List)MethodUtils.invokeMethod(factory.newInstance(), (String)"getHideMenus", null);
        }
        catch (Exception e) {
            log.error("\u53cd\u5c04\u8c03\u7528\u95e8\u6237getHideMenus\u65b9\u6cd5\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private static List<String> buildCloudAppNode(TreeNode cloud, JSONArray temp, String lang, Map<String, TreeNode> appMap) {
        ArrayList<String> appIds = new ArrayList<String>(10);
        for (int i = 0; i < temp.size(); ++i) {
            JSONObject obj = temp.getJSONObject(i);
            if (obj == null || obj.isEmpty() || obj.containsKey((Object)"iscloud")) continue;
            String id = obj.getString("id");
            String parentId = obj.getString("cloudid");
            String number = obj.getString("number");
            JSONObject name = obj.getJSONObject("name");
            String text = "";
            if (name != null && name.containsKey((Object)lang)) {
                text = name.getString(lang);
            }
            appIds.add(id);
            TreeNode app = new TreeNode(parentId, id, text);
            app.setData((Object)"app");
            app.setChildren(new ArrayList());
            appMap.put(id, app);
            cloud.getChildren().add(app);
        }
        return appIds;
    }

    private static TreeNode getCloudNode(JSONArray temp, String rootTreeId, String lang) {
        TreeNode cloud = null;
        for (int j = 0; j < temp.size(); ++j) {
            Boolean isCloud;
            JSONObject obj = temp.getJSONObject(j);
            if (obj == null || obj.isEmpty() || (isCloud = obj.getBoolean("iscloud")) == null || !isCloud.booleanValue()) continue;
            String cloudId = obj.getString("id");
            JSONObject name = obj.getJSONObject("name");
            String text = "";
            if (name != null && name.containsKey((Object)lang)) {
                text = name.getString(lang);
            }
            cloud = new TreeNode(rootTreeId, cloudId, text);
            cloud.setData((Object)"cloud");
            cloud.setChildren(new ArrayList(10));
            break;
        }
        return cloud;
    }
}

