/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.scheme.dao;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;

public class PrintConditionDao {
    public static Map<String, Object> getPrintConditionByBillId(String billId) {
        String selectSql = "select fid,fbillid,fbillnumber,fcondition,fpriority from t_bas_printcondition where fbillid =?";
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>(10);
        params.add(new SqlParameter("fbillid", 12, (Object)billId));
        try (DataSet dataSet = DB.queryDataSet((String)PrintConditionDao.class.getName(), (DBRoute)DBRoute.basedata, (String)selectSql, (Object[])params.toArray(new SqlParameter[0]));){
            if (dataSet != null && !dataSet.isEmpty()) {
                HashMap<String, Object> result = new HashMap<String, Object>(16);
                Row row = dataSet.next();
                result.put("id", row.getLong("fid"));
                result.put("billId", row.getString("fbillid"));
                result.put("billNumber", row.getString("fbillnumber"));
                result.put("condition", row.getString("fcondition"));
                result.put("priority", row.getString("fpriority"));
                HashMap<String, Object> hashMap = result;
                return hashMap;
            }
        }
        return Collections.emptyMap();
    }

    public static Map<String, Object> getPrintConditionByBillNumber(String billNumber) {
        String selectSql = "select fid,fbillid,fbillnumber,fcondition,fpriority from t_bas_printcondition where fbillnumber =?";
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>(10);
        params.add(new SqlParameter("fbillnumber", 12, (Object)billNumber));
        try (DataSet dataSet = DB.queryDataSet((String)PrintConditionDao.class.getName(), (DBRoute)DBRoute.basedata, (String)selectSql, (Object[])params.toArray(new SqlParameter[0]));){
            if (dataSet != null && !dataSet.isEmpty()) {
                HashMap<String, Object> result = new HashMap<String, Object>(16);
                Row row = dataSet.next();
                result.put("id", row.getLong("fid"));
                result.put("billId", row.getString("fbillid"));
                result.put("billNumber", row.getString("fbillnumber"));
                result.put("condition", row.getString("fcondition"));
                result.put("priority", row.getString("fpriority"));
                HashMap<String, Object> hashMap = result;
                return hashMap;
            }
            Map<String, Object> map = Collections.emptyMap();
            return map;
        }
    }

    public static void savePrintCondition(String billId, String billNumber, String condition) {
        PrintConditionDao.savePrintCondition(billId, billNumber, condition, true);
    }

    public static void savePrintCondition(String billId, String billNumber, String condition, boolean priority) {
        if (StringUtils.isBlank((CharSequence)billId) || StringUtils.isBlank((CharSequence)billNumber) || StringUtils.isBlank((CharSequence)condition)) {
            return;
        }
        String selectSql = "select fid from t_bas_printcondition where fbillnumber =?";
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>(10);
        params.add(new SqlParameter("fbillnumber", 12, (Object)billNumber));
        try (DataSet dataSet = DB.queryDataSet((String)PrintConditionDao.class.getName(), (DBRoute)DBRoute.basedata, (String)selectSql, (Object[])params.toArray(new SqlParameter[0]));){
            if (dataSet != null && !dataSet.isEmpty()) {
                PrintConditionDao.updatePrintConditionByBillNumber(billNumber, condition, priority);
            } else {
                String insertSql = "insert into t_bas_printcondition (fid,fbillid, fbillnumber, fcondition, fpriority) values(?, ?, ?, ?, ?)";
                long pKey = DB.genGlobalLongId();
                Object[] param = new Object[]{pKey, billId, billNumber, condition, priority};
                DB.execute((DBRoute)DBRoute.basedata, (String)insertSql, (Object[])param);
            }
        }
    }

    public static void updatePrintConditionByBillId(String billId, String condition) {
        PrintConditionDao.updatePrintConditionByBillId(billId, condition, true);
    }

    public static void updatePrintConditionByBillId(String billId, String condition, boolean priority) {
        String updateSql = "update t_bas_printcondition set fcondition =?,fmodifydate=?,fmodifierid=?, fpriority=? where fbillid=? ";
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>(10);
        params.add(new SqlParameter("fcondition", 2004, (Object)condition));
        params.add(new SqlParameter("fmodifydate", 93, (Object)new Timestamp(System.currentTimeMillis())));
        params.add(new SqlParameter("fmodifierid", -5, (Object)RequestContext.get().getCurrUserId()));
        params.add(new SqlParameter("fpriority", 1, (Object)priority));
        params.add(new SqlParameter("fbillid", 12, (Object)billId));
        DB.update((DBRoute)DBRoute.basedata, (String)updateSql, (Object[])params.toArray(new SqlParameter[params.size()]));
    }

    public static void updatePrintConditionByBillNumber(String billNumber, String condition) {
        PrintConditionDao.updatePrintConditionByBillNumber(billNumber, condition, true);
    }

    public static void updatePrintConditionByBillNumber(String billNumber, String condition, boolean priority) {
        String updateSql = "update t_bas_printcondition set fcondition =?,fmodifydate=?,fmodifierid=?,fpriority=? where fbillnumber=? ";
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>(10);
        params.add(new SqlParameter("fcondition", 2004, (Object)condition));
        params.add(new SqlParameter("fmodifydate", 93, (Object)new Timestamp(System.currentTimeMillis())));
        params.add(new SqlParameter("fmodifierid", -5, (Object)RequestContext.get().getCurrUserId()));
        params.add(new SqlParameter("fpriority", 1, (Object)priority));
        params.add(new SqlParameter("fbillnumber", 12, (Object)billNumber));
        DB.update((DBRoute)DBRoute.basedata, (String)updateSql, (Object[])params.toArray(new SqlParameter[params.size()]));
    }

    public static List<Map<String, Object>> getNewPrintTemplateById(List<String> ids) {
        return PrintConditionDao.getPrintTemplateInfo(ids, "bos_manageprinttpl");
    }

    private static List<Map<String, Object>> getPrintTemplateInfo(List<String> ids, String formNumber) {
        QFilter idFilter = new QFilter("printtplid.id", "in", ids);
        String selectFields = "id,isdefault,printtplid.number,printtplid.name,printtplid.id,type,enable";
        DynamicObjectCollection data = QueryServiceHelper.query((String)formNumber, (String)selectFields, (QFilter[])new QFilter[]{idFilter});
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(data.size());
        for (DynamicObject obj : data) {
            HashMap<String, Object> temp = new HashMap<String, Object>(16);
            temp.put("id", obj.getLong("id"));
            temp.put("number", obj.getString("printtplid.number"));
            temp.put("name", obj.getString("printtplid.name"));
            temp.put("metaId", obj.getString("printtplid.id"));
            temp.put("isDefault", obj.get("isdefault"));
            temp.put("enable", obj.get("enable"));
            result.add(temp);
        }
        return result;
    }

    public static List<Map<String, Object>> getPrintTemplateById(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append(" select fprinttplid,ftype from t_bas_printtplinfo ", new Object[0]);
        sql.append("  where ", new Object[0]);
        sql.appendIn("fprinttplid", new ArrayList<String>(ids));
        try (DataSet dataSet = DB.queryDataSet((String)PrintConditionDao.class.getName(), (DBRoute)DBRoute.basedata, (SqlBuilder)sql);){
            if (dataSet != null && !dataSet.isEmpty()) {
                List<Map<String, Object>> oldTplInfos;
                List<Map<String, Object>> newTplInfos;
                ArrayList<String> newTplIds = new ArrayList<String>(10);
                ArrayList<String> oldTplIds = new ArrayList<String>(10);
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    String type = row.getString("ftype");
                    String tplId = row.getString("fprinttplid");
                    if ("B".equals(type)) {
                        newTplIds.add(tplId);
                        continue;
                    }
                    oldTplIds.add(tplId);
                }
                ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(10);
                if (!CollectionUtils.isEmpty(newTplIds) && !CollectionUtils.isEmpty(newTplInfos = PrintConditionDao.getNewPrintTemplateById(newTplIds))) {
                    result.addAll(newTplInfos);
                }
                if (!CollectionUtils.isEmpty(oldTplIds) && !CollectionUtils.isEmpty(oldTplInfos = PrintConditionDao.getPrintTemplateInfo(oldTplIds, "bas_manageprinttpl"))) {
                    result.addAll(oldTplInfos);
                }
                ArrayList<Map<String, Object>> arrayList = result;
                return arrayList;
            }
        }
        return Collections.emptyList();
    }
}

