/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.scheme.dao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.print.business.scheme.dao.CloudAppMenuDao;
import kd.bos.print.business.scheme.entity.Tuple4;
import kd.bos.print.business.scheme.util.PageCacheUtils;
import kd.bos.print.business.scheme.util.SettingUtils;

public class TreeDataDao {
    private static final String TREE_CLOUD_CACHE_KEY = "print_scheme_tree_cloud";
    private static final String TREE_CACHE_KEY = "print_scheme_tree";
    private static final String TREE_CACHE_MAP_KEY = "print_scheme_tree_map";
    private static final String TREE_SEARCH_QUEUE_KEY = "print_scheme_tree_queue";
    private static final String TREE_SEARCH_ONCE_END_KEY = "once_query_end";
    private static final String TREE_SEARCH_TEXT_KEY = "tree_search_text";

    public static List<TreeNode> getAllCloudNodes(IPageCache pageCache) {
        List<TreeNode> cloudNodes = PageCacheUtils.getDataFromPageCache(pageCache, TREE_CLOUD_CACHE_KEY, TreeNode.class);
        if (!CollectionUtils.isEmpty(cloudNodes)) {
            return cloudNodes;
        }
        String localeId = RequestContext.get().getLang().name();
        SqlBuilder sql = new SqlBuilder();
        sql.append("select a.fid, al.fname ", new Object[0]);
        sql.append(" from t_meta_bizcloud a ", new Object[0]);
        sql.append(" inner join t_meta_bizcloud_l al ", new Object[0]);
        sql.append(" on a.fid = al.fid ", new Object[0]);
        sql.append(" where al.flocaleid =?", new Object[]{localeId});
        sql.append(" and a.fvisible = '1' ", new Object[0]);
        List<String> cloudBlacklist = SettingUtils.getBlackCloudIds();
        if (!CollectionUtils.isEmpty(cloudBlacklist)) {
            cloudBlacklist = cloudBlacklist.stream().map(s -> "'" + s + "'").collect(Collectors.toList());
            sql.append(" and a.fid not in (" + String.join((CharSequence)",", cloudBlacklist) + ")", new Object[0]);
        }
        sql.append(" order by a.fid asc", new Object[0]);
        try (DataSet dataSet = DB.queryDataSet((String)TreeDataDao.class.getName(), (DBRoute)DBRoute.meta, (SqlBuilder)sql);){
            if (dataSet != null && !dataSet.isEmpty()) {
                ArrayList bizCloudList = new ArrayList(10);
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    HashMap<String, String> bizCloudMap = new HashMap<String, String>();
                    bizCloudMap.put("id", "1_split_" + row.getString(0));
                    bizCloudMap.put("name", row.getString(1));
                    bizCloudList.add(bizCloudMap);
                }
                ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(bizCloudList.size());
                for (Map map : bizCloudList) {
                    TreeNode treeNode = new TreeNode();
                    String id = (String)map.get("id");
                    String name = (String)map.get("name");
                    treeNode.setParentid("0");
                    treeNode.setId(id);
                    treeNode.setText(name);
                    treeNode.addChildren(new ArrayList());
                    treeNode.setData((Object)1);
                    treeNodes.add(treeNode);
                }
                PageCacheUtils.cacheDataToPageCache(pageCache, TREE_CLOUD_CACHE_KEY, treeNodes, TreeNode.class);
                ArrayList<TreeNode> arrayList = treeNodes;
                return arrayList;
            }
        }
        return Collections.emptyList();
    }

    public static List<TreeNode> getAllClouds(IPageCache pageCache) {
        Tuple<TreeNode, List<TreeNode>> data = TreeDataDao.getRuntimeAppTree(pageCache);
        List clouds = (List)data.item2;
        if (!CollectionUtils.isEmpty((Collection)clouds)) {
            clouds.stream().forEach(new Consumer<TreeNode>(){

                @Override
                public void accept(TreeNode treeNode) {
                    treeNode.setChildren(new ArrayList());
                }
            });
            return clouds;
        }
        return Collections.emptyList();
    }

    public static List<TreeNode> getAllCloudsByUpdate(IPageCache pageCache) {
        Tuple<TreeNode, List<TreeNode>> data = TreeDataDao.getRuntimeAppTreeByUpdate(pageCache);
        List clouds = (List)data.item2;
        if (!CollectionUtils.isEmpty((Collection)clouds)) {
            clouds.stream().forEach(new Consumer<TreeNode>(){

                @Override
                public void accept(TreeNode treeNode) {
                    treeNode.setChildren(new ArrayList());
                }
            });
            return clouds;
        }
        return Collections.emptyList();
    }

    public static List<TreeNode> getAppByCloudId(IPageCache pageCache, String cloudId) {
        Map<String, TreeNode> cacheValue;
        TreeNode cloud;
        if (!StringUtils.isEmpty((Object)cloudId) && (cloud = (cacheValue = PageCacheUtils.getFromPageCache(pageCache, TREE_CACHE_MAP_KEY)).get(cloudId)) != null && !CollectionUtils.isEmpty((Collection)cloud.getChildren())) {
            List apps = cloud.getChildren();
            apps.stream().forEach(new Consumer<TreeNode>(){

                @Override
                public void accept(TreeNode treeNode) {
                    treeNode.setChildren(new ArrayList());
                }
            });
            return apps;
        }
        return Collections.emptyList();
    }

    public static List<TreeNode> getChildrenById(IPageCache pageCache, String nodeId) {
        Map<String, TreeNode> cacheValue;
        TreeNode parentNode;
        if (!StringUtils.isEmpty((Object)nodeId) && (parentNode = (cacheValue = PageCacheUtils.getFromPageCache(pageCache, TREE_CACHE_MAP_KEY)).get(nodeId)) != null && !CollectionUtils.isEmpty((Collection)parentNode.getChildren())) {
            List children = parentNode.getChildren();
            children.stream().forEach(new Consumer<TreeNode>(){

                @Override
                public void accept(TreeNode treeNode) {
                    if ("menu".equals(treeNode.getData())) {
                        treeNode.setChildren(null);
                    } else if (CollectionUtils.isEmpty((Collection)treeNode.getChildren())) {
                        treeNode.setChildren(null);
                    } else {
                        treeNode.setChildren(new ArrayList());
                    }
                }
            });
            return children;
        }
        return Collections.emptyList();
    }

    private static Tuple<TreeNode, List<TreeNode>> getRuntimeAppTree(IPageCache pageCache) {
        List clouds;
        TreeNode treeNode = CloudAppMenuDao.getTreeIncludeAll();
        if (treeNode != null && !CollectionUtils.isEmpty((Collection)(clouds = treeNode.getChildren()))) {
            HashMap<String, TreeNode> result = new HashMap<String, TreeNode>(16);
            AtomicInteger index = new AtomicInteger(1);
            TreeDataDao.listToMap(clouds, result, index);
            PageCacheUtils.cacheDataToPageCache(pageCache, TREE_CACHE_MAP_KEY, result);
            return new Tuple((Object)treeNode, (Object)clouds);
        }
        return new Tuple((Object)treeNode, Collections.emptyList());
    }

    private static Tuple<TreeNode, List<TreeNode>> getRuntimeAppTreeByUpdate(IPageCache pageCache) {
        List clouds;
        TreeNode treeNode = CloudAppMenuDao.getTreeIncludeAll(pageCache, "app", true);
        if (treeNode != null && !CollectionUtils.isEmpty((Collection)(clouds = treeNode.getChildren()))) {
            HashMap<String, TreeNode> result = new HashMap<String, TreeNode>(16);
            AtomicInteger index = new AtomicInteger(1);
            TreeDataDao.listToMapByUpdate(clouds, result, index);
            PageCacheUtils.cacheDataToPageCache(pageCache, TREE_CACHE_MAP_KEY, result);
            return new Tuple((Object)treeNode, (Object)clouds);
        }
        return new Tuple((Object)treeNode, Collections.emptyList());
    }

    private static void listToMap(List<TreeNode> treeNodes, Map<String, TreeNode> map, AtomicInteger index) {
        for (TreeNode treeNode : treeNodes) {
            String nodeId = treeNode.getId();
            Object data = treeNode.getData();
            String parentId = treeNode.getParentid();
            if ("cloud".equals(data)) {
                nodeId = "cloud_" + nodeId;
            } else if ("app".equals(data)) {
                nodeId = "app_" + nodeId;
                parentId = "cloud_" + parentId;
            } else if ("menu".equals(data)) {
                nodeId = "menu_" + nodeId;
                parentId = "app_" + parentId;
            }
            treeNode.setId(nodeId);
            treeNode.setParentid(parentId);
            treeNode.setLongNumber(String.valueOf(index.incrementAndGet()));
            map.put(nodeId, treeNode);
            if (CollectionUtils.isEmpty((Collection)treeNode.getChildren())) continue;
            TreeDataDao.listToMap(treeNode.getChildren(), map, index);
        }
    }

    private static void listToMapByUpdate(List<TreeNode> treeNodes, Map<String, TreeNode> map, AtomicInteger index) {
        for (TreeNode treeNode : treeNodes) {
            String nodeId = treeNode.getId();
            Object data = treeNode.getData();
            String parentId = treeNode.getParentid();
            if ("cloud".equals(data)) {
                nodeId = "cloud_" + nodeId;
            } else if ("app".equals(data)) {
                nodeId = "app_" + nodeId;
                parentId = "cloud_" + parentId;
            } else if ("menu".equals(data)) {
                return;
            }
            treeNode.setId(nodeId);
            treeNode.setParentid(parentId);
            treeNode.setLongNumber(String.valueOf(index.incrementAndGet()));
            map.put(nodeId, treeNode);
            if (CollectionUtils.isEmpty((Collection)treeNode.getChildren())) continue;
            TreeDataDao.listToMapByUpdate(treeNode.getChildren(), map, index);
        }
    }

    public static Tuple4<List<TreeNode>, TreeNode, String, String> searchNodes(IPageCache pageCache, String searchText) {
        if (!StringUtils.isEmpty((Object)searchText)) {
            PageCacheUtils.checkCacheSearchTextInPageCache(pageCache, TREE_SEARCH_TEXT_KEY, TREE_SEARCH_QUEUE_KEY, searchText);
            Queue<String> result = PageCacheUtils.getDataQueueFromPageCache(pageCache, TREE_SEARCH_QUEUE_KEY + searchText, String.class);
            Map<String, TreeNode> cacheValue = PageCacheUtils.getFromPageCache(pageCache, TREE_CACHE_MAP_KEY);
            if (CollectionUtils.isEmpty(result)) {
                ArrayList<String> cloudTreeNodes = new ArrayList<String>(10);
                ArrayList<String> appTreeNodes = new ArrayList<String>(10);
                ArrayList<String> menuTreeNodes = new ArrayList<String>(10);
                for (TreeNode temp : cacheValue.values()) {
                    String text = temp.getText();
                    String longNumber = temp.getLongNumber();
                    if (!text.contains(searchText)) continue;
                    if ("cloud".equals(temp.getData())) {
                        cloudTreeNodes.add(temp.getId() + "_" + longNumber);
                        continue;
                    }
                    if ("app".equals(temp.getData())) {
                        appTreeNodes.add(temp.getId() + "_" + longNumber);
                        continue;
                    }
                    if (!"menu".equals(temp.getData())) continue;
                    menuTreeNodes.add(temp.getId() + "_" + longNumber);
                }
                Comparator comparator = (o1, o2) -> {
                    try {
                        int index1 = Integer.parseInt(o1.substring(o1.lastIndexOf(95) + 1));
                        int index2 = Integer.parseInt(o2.substring(o2.lastIndexOf(95) + 1));
                        if (index1 > index2) {
                            return 1;
                        }
                        if (index1 < index2) {
                            return -1;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return 0;
                };
                result = new LinkedList<String>();
                if (!CollectionUtils.isEmpty(cloudTreeNodes)) {
                    Collections.sort(cloudTreeNodes, comparator);
                    result.addAll(cloudTreeNodes);
                }
                if (!CollectionUtils.isEmpty(appTreeNodes)) {
                    Collections.sort(appTreeNodes, comparator);
                    result.addAll(appTreeNodes);
                }
                if (!CollectionUtils.isEmpty(menuTreeNodes)) {
                    Collections.sort(menuTreeNodes, comparator);
                    result.addAll(menuTreeNodes);
                }
                if (!CollectionUtils.isEmpty(result)) {
                    result.offer(TREE_SEARCH_ONCE_END_KEY);
                }
            }
            if (!CollectionUtils.isEmpty(result)) {
                Tuple4<List<TreeNode>, TreeNode, String, String> matchNodes = TreeDataDao.searchTreeNodesFromQueue(result, cacheValue, searchText);
                PageCacheUtils.cacheDataCollectionToPageCache(pageCache, TREE_SEARCH_QUEUE_KEY + searchText, result);
                return matchNodes;
            }
        }
        return new Tuple4(Collections.emptyList(), null, null, null);
    }

    public static Tuple4<List<TreeNode>, TreeNode, String, String> searchNodesByUpdate(IPageCache pageCache, String searchText) {
        if (!StringUtils.isEmpty((Object)searchText)) {
            PageCacheUtils.checkCacheSearchTextInPageCache(pageCache, TREE_SEARCH_TEXT_KEY, TREE_SEARCH_QUEUE_KEY, searchText);
            Queue<String> result = PageCacheUtils.getDataQueueFromPageCache(pageCache, TREE_SEARCH_QUEUE_KEY + searchText, String.class);
            Map<String, TreeNode> cacheValue = PageCacheUtils.getFromPageCache(pageCache, TREE_CACHE_MAP_KEY);
            if (CollectionUtils.isEmpty(result)) {
                ArrayList<String> cloudTreeNodes = new ArrayList<String>(10);
                ArrayList<String> appTreeNodes = new ArrayList<String>(10);
                ArrayList<String> menuTreeNodes = new ArrayList<String>(10);
                for (TreeNode temp : cacheValue.values()) {
                    String text = temp.getText();
                    String longNumber = temp.getLongNumber();
                    if (!text.contains(searchText)) continue;
                    if ("cloud".equals(temp.getData())) {
                        cloudTreeNodes.add(temp.getId() + "_" + longNumber);
                        continue;
                    }
                    if ("app".equals(temp.getData())) {
                        appTreeNodes.add(temp.getId() + "_" + longNumber);
                        continue;
                    }
                    if (!"menu".equals(temp.getData())) continue;
                    menuTreeNodes.add(temp.getId() + "_" + longNumber);
                }
                Comparator comparator = (o1, o2) -> {
                    try {
                        int index1 = Integer.parseInt(o1.substring(o1.lastIndexOf(95) + 1));
                        int index2 = Integer.parseInt(o2.substring(o2.lastIndexOf(95) + 1));
                        if (index1 > index2) {
                            return 1;
                        }
                        if (index1 < index2) {
                            return -1;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return 0;
                };
                result = new LinkedList<String>();
                if (!CollectionUtils.isEmpty(cloudTreeNodes)) {
                    Collections.sort(cloudTreeNodes, comparator);
                    result.addAll(cloudTreeNodes);
                }
                if (!CollectionUtils.isEmpty(appTreeNodes)) {
                    Collections.sort(appTreeNodes, comparator);
                    result.addAll(appTreeNodes);
                }
                if (!CollectionUtils.isEmpty(menuTreeNodes)) {
                    Collections.sort(menuTreeNodes, comparator);
                    result.addAll(menuTreeNodes);
                }
                if (!CollectionUtils.isEmpty(result)) {
                    result.offer(TREE_SEARCH_ONCE_END_KEY);
                }
            }
            if (!CollectionUtils.isEmpty(result)) {
                Tuple4<List<TreeNode>, TreeNode, String, String> matchNodes = TreeDataDao.searchTreeNodesFromQueue(result, cacheValue, searchText);
                PageCacheUtils.cacheDataCollectionToPageCache(pageCache, TREE_SEARCH_QUEUE_KEY + searchText, result);
                return matchNodes;
            }
        }
        return new Tuple4(Collections.emptyList(), null, null, null);
    }

    private static Tuple4<List<TreeNode>, TreeNode, String, String> searchTreeNodesFromQueue(Queue<String> queue, Map<String, TreeNode> cacheValue, String searchText) {
        String nodeId = queue.poll();
        if (TREE_SEARCH_ONCE_END_KEY.equals(nodeId)) {
            queue.offer(TREE_SEARCH_ONCE_END_KEY);
            nodeId = queue.poll();
        }
        queue.offer(nodeId);
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(10);
        if (nodeId == null) {
            return new Tuple4(Collections.emptyList(), null, null, null);
        }
        TreeNode currentNode = cacheValue.get(nodeId.substring(0, nodeId.lastIndexOf(95)));
        if (currentNode == null) {
            return new Tuple4(Collections.emptyList(), null, null, null);
        }
        if (nodeId.startsWith("menu_")) {
            while (true) {
                TreeNode current;
                List<String> hiddenMenus = null;
                String currentId = "";
                if (nodeId != null && (current = cacheValue.get(nodeId.substring(0, nodeId.lastIndexOf(95)))) != null) {
                    String appNodeId = current.getParentid();
                    String appId = appNodeId.substring(appNodeId.indexOf(95) + 1);
                    hiddenMenus = CloudAppMenuDao.getBlackListByAppId(appId);
                    currentId = nodeId.substring(nodeId.indexOf(95) + 1, nodeId.lastIndexOf(95));
                }
                if (hiddenMenus == null || hiddenMenus.isEmpty() || !hiddenMenus.contains(currentId)) break;
                nodeId = queue.poll();
            }
            queue.offer(nodeId);
        }
        if (nodeId == null) {
            return new Tuple4(Collections.emptyList(), null, null, null);
        }
        if (nodeId.startsWith("app_")) {
            String parentId = currentNode.getParentid();
            TreeNode parentNode = cacheValue.get(parentId);
            if (!CollectionUtils.isEmpty((Collection)parentNode.getChildren())) {
                List appNodes = parentNode.getChildren();
                appNodes.stream().forEach(new Consumer<TreeNode>(){

                    @Override
                    public void accept(TreeNode treeNode) {
                        if (CollectionUtils.isEmpty((Collection)treeNode.getChildren())) {
                            treeNode.setChildren(null);
                        } else {
                            treeNode.setChildren(new ArrayList());
                        }
                    }
                });
                nodes.addAll(appNodes);
            } else {
                if (CollectionUtils.isEmpty((Collection)currentNode.getChildren())) {
                    currentNode.setChildren(null);
                } else {
                    currentNode.setChildren(new ArrayList());
                }
                nodes.add(currentNode);
            }
        } else if (nodeId.startsWith("menu_")) {
            String parentAppId = currentNode.getParentid();
            TreeNode parentAppNode = cacheValue.get(parentAppId);
            if (!CollectionUtils.isEmpty((Collection)parentAppNode.getChildren())) {
                List menuNodes = parentAppNode.getChildren();
                menuNodes.stream().forEach(new Consumer<TreeNode>(){

                    @Override
                    public void accept(TreeNode treeNode) {
                        treeNode.setChildren(null);
                    }
                });
                String appId = parentAppId.substring(parentAppId.indexOf("_") + 1);
                List<String> hiddenMenus = CloudAppMenuDao.getBlackListByAppId(appId);
                if (hiddenMenus != null && !hiddenMenus.isEmpty() && !CollectionUtils.isEmpty(hiddenMenus)) {
                    Iterator iterator = menuNodes.iterator();
                    while (iterator.hasNext()) {
                        TreeNode menuNode = (TreeNode)iterator.next();
                        String id = menuNode.getId();
                        String menuId = id.substring(id.indexOf(95) + 1);
                        if (!hiddenMenus.contains(menuId)) continue;
                        iterator.remove();
                    }
                }
                nodes.addAll(menuNodes);
            } else {
                nodes.add(currentNode);
            }
            String cloudId = parentAppNode.getParentid();
            TreeNode cloudNode = cacheValue.get(cloudId);
            if (!CollectionUtils.isEmpty((Collection)cloudNode.getChildren())) {
                List appNodes = cloudNode.getChildren();
                appNodes.stream().forEach(new Consumer<TreeNode>(){

                    @Override
                    public void accept(TreeNode treeNode) {
                        if (!CollectionUtils.isEmpty((Collection)treeNode.getChildren())) {
                            treeNode.setChildren(new ArrayList());
                        } else {
                            treeNode.setChildren(null);
                        }
                    }
                });
                nodes.addAll(appNodes);
            } else {
                parentAppNode.setChildren(new ArrayList());
                nodes.add(parentAppNode);
            }
        }
        TreeNode parentNode = cacheValue.get(currentNode.getParentid());
        return new Tuple4<List<TreeNode>, TreeNode, String, String>(nodes, currentNode, currentNode.getParentid(), parentNode != null ? parentNode.getParentid() : null);
    }

    public static Tuple<TreeNode, List<TreeNode>> getChildrenNodeById(IPageCache pageCache, String nodeId) {
        Map<String, TreeNode> cacheValue;
        TreeNode parentNode;
        if (!StringUtils.isEmpty((Object)nodeId) && (parentNode = (cacheValue = PageCacheUtils.getFromPageCache(pageCache, TREE_CACHE_MAP_KEY)).get(nodeId)) != null && !CollectionUtils.isEmpty((Collection)parentNode.getChildren())) {
            String appId;
            List<String> hiddenMenus;
            List children = parentNode.getChildren();
            children.stream().forEach(new Consumer<TreeNode>(){

                @Override
                public void accept(TreeNode treeNode) {
                    if ("menu".equals(treeNode.getData())) {
                        treeNode.setChildren(null);
                    } else if (CollectionUtils.isEmpty((Collection)treeNode.getChildren())) {
                        treeNode.setChildren(null);
                    } else {
                        treeNode.setChildren(new ArrayList());
                    }
                }
            });
            if (nodeId.startsWith("app_") && !CollectionUtils.isEmpty(hiddenMenus = CloudAppMenuDao.getBlackListByAppId(appId = nodeId.substring(nodeId.indexOf(95) + 1)))) {
                Iterator iterator = children.iterator();
                while (iterator.hasNext()) {
                    TreeNode menuNode = (TreeNode)iterator.next();
                    String id = menuNode.getId();
                    String menuId = id.substring(id.indexOf(95) + 1);
                    if (!hiddenMenus.contains(menuId)) continue;
                    iterator.remove();
                }
            }
            return new Tuple((Object)parentNode, (Object)children);
        }
        return new Tuple(null, Collections.emptyList());
    }
}

