/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.scheme.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.business.scheme.dao.TreeDataDao;
import kd.bos.print.business.scheme.entity.Tuple4;
import kd.bos.print.business.scheme.util.PageCacheUtils;

public abstract class AbstractTreeListPlugin
extends AbstractListPlugin
implements SearchEnterListener,
TreeNodeClickListener,
TreeNodeQueryListener {
    private static final String TREE_WIDGET_KEY = "tree";
    private static final String SEARCH_WIDGET_KEY = "searchap";
    private static final String TYPE_KEY = "bos-print-business";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeLeft = (TreeView)this.getControl(TREE_WIDGET_KEY);
        treeLeft.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        treeLeft.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search search = (Search)this.getControl(SEARCH_WIDGET_KEY);
        search.addEnterListener((SearchEnterListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initTree();
    }

    private void initTree() {
        TreeView tree = (TreeView)this.getView().getControl(TREE_WIDGET_KEY);
        tree.deleteAllNodes();
        TreeNode root = new TreeNode();
        root.setParentid("");
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"CloudAppMenuDao_0", (String)TYPE_KEY, (Object[])new Object[0]));
        root.setId("rootNode");
        root.setIsOpened(true);
        tree.addNode(root);
        List<TreeNode> cloudNodes = TreeDataDao.getAllClouds(this.getPageCache());
        tree.addNodes(cloudNodes);
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        String searchText = searchEnterEvent.getText();
        TreeView tree = (TreeView)this.getView().getControl(TREE_WIDGET_KEY);
        Tuple4<List<TreeNode>, TreeNode, String, String> result = TreeDataDao.searchNodes(this.getPageCache(), searchText);
        List treeNodes = (List)result.item1;
        TreeNode focusNode = (TreeNode)result.item2;
        if (focusNode == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22\uff0c\u6ca1\u6709\u627e\u5230\u641c\u7d22\u9879\u3002", (String)"AbstractTreeListPlugin_1", (String)TYPE_KEY, (Object[])new Object[0]));
            return;
        }
        if (!treeNodes.isEmpty()) {
            TreeNodeEvent event = new TreeNodeEvent((Object)this, (Object)focusNode.getParentid(), (Object)focusNode.getId());
            this.treeNodeClick(event);
            String nodeId = focusNode.getId();
            if (nodeId.startsWith("app_")) {
                tree.addNodes(treeNodes);
                tree.expand((String)result.item3);
            } else if (nodeId.startsWith("menu_")) {
                ArrayList<TreeNode> appNodes = new ArrayList<TreeNode>(10);
                ArrayList<TreeNode> menuNodes = new ArrayList<TreeNode>(10);
                for (TreeNode treeNode : treeNodes) {
                    if (treeNode.getId().startsWith("menu_")) {
                        menuNodes.add(treeNode);
                        continue;
                    }
                    if (!treeNode.getId().startsWith("app_")) continue;
                    appNodes.add(treeNode);
                }
                tree.addNodes(appNodes);
                tree.addNodes(menuNodes);
                tree.expand((String)result.item4);
                tree.expand((String)result.item3);
            }
            tree.focusNode(focusNode);
        } else if (focusNode != null && focusNode.getId().startsWith("cloud_")) {
            tree.focusNode(focusNode);
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        Object nodeId = evt.getNodeId();
        Object parentId = evt.getParentNodeId();
        if (nodeId != null) {
            String nodeIdStr = String.valueOf(nodeId);
            if (nodeIdStr.startsWith("menu_") && parentId != null) {
                String id = nodeIdStr.replace("menu_", "");
                String number = MetadataDao.getNumberById((String)id);
                PageCacheUtils.cacheValueToPageCache(this.getPageCache(), "form_id", id);
                PageCacheUtils.cacheValueToPageCache(this.getPageCache(), "form_number", number);
            } else {
                PageCacheUtils.removeValueFromPageCache(this.getPageCache(), "form_id");
                PageCacheUtils.removeValueFromPageCache(this.getPageCache(), "form_number");
            }
            TreeNodeEvent event = new TreeNodeEvent((Object)this, parentId, nodeId);
            this.queryTreeNodeChildren(event);
            TreeView tree = (TreeView)this.getView().getControl(TREE_WIDGET_KEY);
            tree.expand(nodeId.toString());
            this.afterTreeNodeFocus(nodeIdStr);
        }
    }

    public void queryTreeNodeChildren(TreeNodeEvent treeNodeEvent) {
        TreeView tree = (TreeView)this.getView().getControl(TREE_WIDGET_KEY);
        String nodeId = treeNodeEvent.getNodeId().toString();
        Tuple<TreeNode, List<TreeNode>> nodes = null;
        if (nodeId.startsWith("cloud_") || nodeId.startsWith("app_")) {
            nodes = TreeDataDao.getChildrenNodeById(this.getPageCache(), nodeId);
        }
        if (nodes != null && !CollectionUtils.isEmpty((Collection)((Collection)nodes.item2))) {
            tree.addNodes((List)nodes.item2);
        }
        if (nodes != null && nodes.item1 != null) {
            tree.focusNode((TreeNode)nodes.item1);
        }
    }

    public abstract void afterTreeNodeFocus(String var1);
}

