/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.scheme.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.business.scheme.dao.PrintConditionDao;
import kd.bos.print.business.scheme.entity.ComplexSettingItem;
import kd.bos.print.business.scheme.plugin.AbstractTreeListPlugin;
import kd.bos.print.business.scheme.util.PageCacheUtils;
import kd.bos.print.business.scheme.util.PrintConditionHelpUtils;
import org.apache.commons.beanutils.MethodUtils;

public class PrintNewSchemeFormPlugin
extends AbstractTreeListPlugin {
    private static final Log log = LogFactory.getLog(PrintNewSchemeFormPlugin.class);
    private final String FILTER_WIDGET_NAME_KEY = "filtername";
    private final String ENTRY_WIDGET_KEY = "entryentity";
    private final String FILTER_WIDGET_CON_KEY = "filtercondition";
    private final String FILTER_WIDGET_TYPE_KEY = "filtertype";
    private final String WIDGET_ENABLE_KEY = "enable";
    private final String FILTER_WIDGET_TEMP_KEY = "filtertemplateid";
    private final String SAVE_KEY = "save";
    private final String QUIT_KEY = "quit";
    private final String WIDGET_ADD_ROW = "addrow";
    private final String WIDGET_DELETE_ROW = "deleterow";
    private final String HEIGHT_PRIO_CHECKBOXFIELD = "height_prio_checkboxfield";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"filtername"});
        this.addItemClickListeners(new String[]{"toolbarap", "advcontoolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
    }

    @Override
    public void afterTreeNodeFocus(String nodeId) {
        Map<String, String> templates = this.getUserPermNewPrintTemplateMap(PageCacheUtils.getValueFromPageCache(this.getPageCache(), "form_number"));
        this.initSettingEntry(nodeId, templates);
        this.initSelectTemplate(nodeId, templates);
        if (nodeId.startsWith("menu_")) {
            PageCacheUtils.cacheValueToPageCache(this.getPageCache(), "focus_menu", nodeId);
        } else {
            PageCacheUtils.removeValueFromPageCache(this.getPageCache(), "focus_menu");
        }
    }

    private void initSelectTemplate(String nodeId, Map<String, String> templates) {
        if (!nodeId.startsWith("menu_")) {
            return;
        }
        ComboEdit defaultCombo = (ComboEdit)this.getView().getControl("filtertemplateid");
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(10);
        for (Map.Entry<String, String> entry : templates.entrySet()) {
            ComboItem item = new ComboItem();
            item.setValue(entry.getKey());
            item.setCaption(new LocaleString(entry.getValue()));
            comboItems.add(item);
        }
        defaultCombo.setComboItems(comboItems);
    }

    private Map<String, String> getUserPermNewPrintTemplateMap(String billFromId) {
        String className = "kd.bos.template.orgctrl.service.PrintTemplateServiceImpl";
        try {
            Class factory = TypesContainer.getOrRegister((String)className);
            Object[] params = new Object[]{billFromId};
            Class[] parameterTypes = new Class[]{String.class};
            return (Map)MethodUtils.invokeMethod(factory.newInstance(), (String)"getUserPermPrintTemplateMap", (Object[])params, (Class[])parameterTypes);
        }
        catch (Exception e) {
            log.error("\u53cd\u5c04\u8c03\u7528\u670d\u52a1\u65b9\u6cd5\u83b7\u53d6\u6253\u5370\u6a21\u7248\u5f02\u5e38", (Throwable)e);
            return Collections.emptyMap();
        }
    }

    private void initSettingEntry(String nodeId, Map<String, String> templates) {
        this.getModel().deleteEntryData("entryentity");
        if (nodeId.startsWith("menu_")) {
            String billNumber = PageCacheUtils.getValueFromPageCache(this.getPageCache(), "form_number");
            Map<String, Object> conditionMap = PrintConditionDao.getPrintConditionByBillNumber(billNumber);
            if (!conditionMap.isEmpty() && conditionMap.get("condition") != null) {
                Object conditionObj = conditionMap.get("condition");
                if (StringUtils.isBlank((Object)conditionObj)) {
                    return;
                }
                List objs = SerializationUtils.fromJsonStringToList((String)conditionObj.toString(), ComplexSettingItem.class);
                if (!CollectionUtils.isEmpty((Collection)objs)) {
                    this.getModel().batchCreateNewEntryRow("entryentity", objs.size());
                    for (int i = 0; i < objs.size(); ++i) {
                        ComplexSettingItem filterItem = (ComplexSettingItem)objs.get(i);
                        this.getModel().setValue("enable", (Object)filterItem.isEnable(), i);
                        this.getModel().setValue("filtertype", (Object)filterItem.getFiltertype(), i);
                        this.getModel().setValue("filtername", (Object)filterItem.getFiltername(), i);
                        this.getModel().setValue("filtercondition", filterItem.getFiltercondition(), i);
                        this.getModel().setValue("filtertemplateid", (Object)filterItem.getFiltertemplateid(), i);
                    }
                    Tuple<StringBuilder, List<String>> checkResult = PrintConditionHelpUtils.checkCondition(objs);
                    List existTplIds = (List)checkResult.item2;
                    StringBuilder message = (StringBuilder)checkResult.item1;
                    List<String> permTplIds = PrintConditionHelpUtils.checkTemplatePerm(PageCacheUtils.getValueFromPageCache(this.getPageCache(), "form_number"), existTplIds);
                    existTplIds.removeAll(permTplIds);
                    if (StringUtils.isNotBlank((CharSequence)message.toString()) || !CollectionUtils.isEmpty((Collection)existTplIds)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u88ab\u5220\u9664\u3001\u88ab\u7981\u7528\u6216\u65e0\u6743\u9650\u7684\u6a21\u677f\u3002", (String)"PrintNewSchemeFormPlugin_5", (String)"bos-print-business", (Object[])new Object[0]));
                    }
                }
            }
            if (CollectionUtils.isEmpty(conditionMap) || null == conditionMap.get("priority")) {
                this.getModel().setValue("height_prio_checkboxfield", (Object)true);
            } else {
                String priority = (String)conditionMap.get("priority");
                if ("1".equals(priority)) {
                    this.getModel().setValue("height_prio_checkboxfield", (Object)true);
                } else {
                    this.getModel().setValue("height_prio_checkboxfield", (Object)false);
                }
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String controlKey = control.getKey();
        if ("filtername".equals(controlKey)) {
            this.showFilterEditForm();
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String focusMenu;
        String key = evt.getItemKey();
        if (("addrow".equals(key) || "deleterow".equals(key)) && StringUtils.isBlank((CharSequence)(focusMenu = PageCacheUtils.getValueFromPageCache(this.getPageCache(), "focus_menu")))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5177\u4f53\u8868\u5355\u8fdb\u884c\u914d\u7f6e\u3002", (String)"PrintNewSchemeFormPlugin_4", (String)"bos-print-business", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        if (e.getOperationResult() != null && e.getOperationResult().isSuccess() && "donothing_save".equals(operateKey)) {
            String focusMenu = PageCacheUtils.getValueFromPageCache(this.getPageCache(), "focus_menu");
            if (StringUtils.isBlank((CharSequence)focusMenu)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5177\u4f53\u83dc\u5355\u8fdb\u884c\u914d\u7f6e\u3002", (String)"PrintNewSchemeFormPlugin_6", (String)"bos-print-business", (Object[])new Object[0]));
                return;
            }
            Tuple<Boolean, String> result = this.validateCondition();
            if (((Boolean)result.item1).booleanValue()) {
                this.saveConditionData();
            } else {
                this.getView().showErrorNotification((String)result.item2);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String focusMenu;
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("refresh".equals(key) && StringUtils.isNotEmpty((CharSequence)(focusMenu = PageCacheUtils.getValueFromPageCache(this.getPageCache(), "focus_menu")))) {
            Map<String, String> templates = this.getUserPermNewPrintTemplateMap(PageCacheUtils.getValueFromPageCache(this.getPageCache(), "form_number"));
            this.initSettingEntry(focusMenu, templates);
            this.initSelectTemplate(focusMenu, templates);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map retData;
        super.closedCallBack(closedCallBackEvent);
        if ("filtername".equals(closedCallBackEvent.getActionId()) && (retData = (Map)closedCallBackEvent.getReturnData()) != null) {
            int currentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            this.getModel().setValue("filtername", retData.get("name"), currentRowIndex);
            this.getModel().setValue("filtercondition", retData.get("condition"), currentRowIndex);
        }
    }

    private void showFilterEditForm() {
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        Object name = this.getModel().getValue("filtername", currentRowIndex);
        Object condition = this.getModel().getValue("filtercondition", currentRowIndex);
        Object type = this.getModel().getValue("filtertype", currentRowIndex);
        if (null == type || StringUtils.isBlank((Object)type)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6761\u4ef6\u8bbe\u7f6e\u7c7b\u578b\u4e3a\u7a7a\uff0c\u8bf7\u9009\u62e9\u7c7b\u578b\u3002", (String)"PrintNewSchemeFormPlugin_7", (String)"bos-print-business", (Object[])new Object[0]));
            return;
        }
        if (Integer.parseInt(type.toString()) == 2) {
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bos_printfilterediter");
        showParameter.setCustomParam("formid", (Object)PageCacheUtils.getValueFromPageCache(this.getPageCache(), "form_number"));
        showParameter.setCustomParam("name", name);
        showParameter.setCustomParam("condition", condition);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "filtername");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void saveConditionData() {
        int count = this.getModel().getEntryRowCount("entryentity");
        boolean priority = (Boolean)this.getModel().getValue("height_prio_checkboxfield");
        String billNumber = PageCacheUtils.getValueFromPageCache(this.getPageCache(), "form_number");
        if (count > 0) {
            DynamicObjectCollection conditions = this.getModel().getEntryEntity("entryentity");
            String conditionStr = SerializationUtils.toJsonString((Object)conditions);
            String billId = PageCacheUtils.getValueFromPageCache(this.getPageCache(), "form_id");
            PrintConditionDao.savePrintCondition(billId, billNumber, conditionStr, priority);
        } else {
            PrintConditionDao.updatePrintConditionByBillNumber(billNumber, "", priority);
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"PrintNewSchemeFormPlugin_3", (String)"bos-print-business", (Object[])new Object[0]));
    }

    private Tuple<Boolean, String> validateCondition() {
        String message = "";
        Boolean isValid = true;
        DynamicObjectCollection objs = this.getModel().getEntryEntity("entryentity");
        int filterTypeCount = 0;
        boolean existTemplateId = true;
        for (DynamicObject obj : objs) {
            if (null == obj.getString("filtertype")) {
                message = ResManager.loadKDString((String)"\u6761\u4ef6\u8bbe\u7f6e\u7c7b\u578b\u4e3a\u7a7a\uff0c\u8bf7\u9009\u62e9\u7c7b\u578b\u3002", (String)"PrintNewSchemeFormPlugin_7", (String)"bos-print-business", (Object[])new Object[0]);
                isValid = false;
                break;
            }
            if (Integer.parseInt(obj.getString("filtertype")) == 2) {
                ++filterTypeCount;
            }
            if (!obj.getBoolean("enable") || !StringUtils.isEmpty((CharSequence)obj.getString("filtertemplateid"))) continue;
            existTemplateId = false;
        }
        if (filterTypeCount > 1) {
            message = ResManager.loadKDString((String)"\u53ea\u80fd\u6dfb\u52a0\u4e00\u6761\u7c7b\u578b\u4e3a\u201c\u5176\u5b83\u201d\u7684\u6761\u4ef6\u3002", (String)"PrintNewSchemeFormPlugin_1", (String)"bos-print-business", (Object[])new Object[0]);
            isValid = false;
        } else if (!existTemplateId) {
            message = ResManager.loadKDString((String)"\u542f\u7528\u6761\u4ef6\u65f6\uff0c\u6253\u5370\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PrintNewSchemeFormPlugin_2", (String)"bos-print-business", (Object[])new Object[0]);
            isValid = false;
        }
        return new Tuple((Object)isValid, (Object)message);
    }
}

