/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.scheme.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.print.business.scheme.dao.PrintConditionDao;
import kd.bos.print.business.scheme.entity.ComplexSettingItem;
import kd.bos.print.business.scheme.service.IPrintConditionService;
import kd.bos.print.business.scheme.util.PrintConditionHelpUtils;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.bos.service.TimeService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserService;

public class PrintConditionServiceImpl
implements IPrintConditionService {
    @Override
    public boolean haveNewPrintCondition(String billFormNumber) {
        Map<String, Object> result = PrintConditionDao.getPrintConditionByBillNumber(billFormNumber);
        return !result.isEmpty() && result.get("condition") != null && StringUtils.isNotBlank((Object)result.get("condition"));
    }

    @Override
    public Map<String, Object> buildPrintJobByCondition(String billFormNumber, List<Object> pkIds, IFormView view, Object printerId, String caption, Map<String, Object> workflowParam) {
        ArrayList<Object> unMatchBillIds;
        ArrayList<String> unUseTemplateIds;
        ArrayList jobs;
        StringBuilder messages;
        HashMap<String, Object> result;
        block6: {
            block5: {
                boolean status = false;
                result = new HashMap<String, Object>(16);
                Tuple<Boolean, Object> validateResult = PrintConditionHelpUtils.validateCondition(billFormNumber);
                if (!((Boolean)validateResult.item1).booleanValue()) {
                    return (Map)validateResult.item2;
                }
                List objs = (List)validateResult.item2;
                Tuple<StringBuilder, List<String>> checkResult = PrintConditionHelpUtils.checkCondition(objs);
                messages = (StringBuilder)checkResult.item1;
                List<String> enableTemplates = PrintConditionHelpUtils.checkTemplatePerm(billFormNumber, (List)checkResult.item2);
                List availableFilterSetting = objs.stream().filter(p -> p.isEnable() && StringUtils.isNotBlank((CharSequence)p.getFiltertemplateid()) && enableTemplates.contains(p.getFiltertemplateid())).collect(Collectors.toList());
                jobs = new ArrayList(10);
                MainEntityType dt = EntityMetadataCache.getDataEntityType((String)billFormNumber);
                unUseTemplateIds = new ArrayList<String>(10);
                for (ComplexSettingItem item : availableFilterSetting) {
                    if (!StringUtils.isNotBlank((Object)item.getFiltercondition()) || item.getFiltertype() != 1) continue;
                    FilterCondition filterCondition = item.getFiltercondition() instanceof String ? (FilterCondition)SerializationUtils.fromJsonString((String)item.getFiltercondition().toString(), FilterCondition.class) : (FilterCondition)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)item.getFiltercondition()), FilterCondition.class);
                    FilterBuilder filterBuilder = new FilterBuilder(dt, filterCondition, true);
                    filterBuilder.setTimeService((ITimeService)new TimeService());
                    filterBuilder.setUserService((IUserService)new UserService());
                    filterBuilder.buildFilter(true);
                    String pkName = dt.getPrimaryKey().getName();
                    QFilter[] filters = new QFilter[]{filterBuilder.getQFilter(), new QFilter(pkName, "in", pkIds)};
                    Map filterObjs = BusinessDataServiceHelper.loadFromCache((String)billFormNumber, (QFilter[])filters);
                    if (filterObjs.size() > 0) {
                        ArrayList billIds = new ArrayList(filterObjs.keySet());
                        HashMap<String, Object> job = new HashMap<String, Object>(16);
                        job.put("pageId", view.getPageId());
                        job.put("formId", billFormNumber);
                        job.put("billIds", billIds);
                        job.put("printerId", printerId);
                        job.put("templateId", item.getFiltertemplateid());
                        job.put("name", caption);
                        job.put("workFlowParams", workflowParam);
                        jobs.add(job);
                    }
                    unUseTemplateIds.add(item.getFiltertemplateid());
                }
                Optional<ComplexSettingItem> other = availableFilterSetting.stream().filter(o -> o.getFiltertype() == 2).findFirst();
                unMatchBillIds = new ArrayList<Object>(10);
                if (!other.isPresent()) break block5;
                ComplexSettingItem otherSetting = other.get();
                if (!enableTemplates.contains(otherSetting.getFiltertemplateid())) break block6;
                ArrayList<Object> otherMatchIds = new ArrayList<Object>();
                for (int i = 0; i < pkIds.size(); ++i) {
                    Object id = pkIds.get(i);
                    boolean isMatch = jobs.stream().anyMatch(p -> {
                        Object billIdObj = p.get("billIds");
                        if (billIdObj instanceof List) {
                            List billIds = (List)billIdObj;
                            return billIds.contains(id);
                        }
                        return false;
                    });
                    if (isMatch) continue;
                    otherMatchIds.add(id);
                }
                if (otherMatchIds.isEmpty()) break block6;
                HashMap<String, Object> job = new HashMap<String, Object>(16);
                job.put("pageId", view.getPageId());
                job.put("formId", billFormNumber);
                job.put("billIds", otherMatchIds);
                job.put("printerId", printerId);
                job.put("templateId", otherSetting.getFiltertemplateid());
                job.put("name", caption);
                job.put("workFlowParams", workflowParam);
                jobs.add(job);
                break block6;
            }
            for (int i = 0; i < pkIds.size(); ++i) {
                Object id = pkIds.get(i);
                boolean isMatch = jobs.stream().anyMatch(p -> {
                    Object billIdObj = p.get("billIds");
                    if (billIdObj instanceof List) {
                        List billIds = (List)billIdObj;
                        return billIds.contains(id);
                    }
                    return false;
                });
                if (isMatch) continue;
                unMatchBillIds.add(id);
            }
        }
        result.put("status", 0);
        result.put("message", messages.toString());
        result.put("jobs", jobs);
        result.put("unMatchBillIds", unMatchBillIds);
        result.put("unUseTempIds", unUseTemplateIds);
        return result;
    }

    @Override
    public Map<Object, List<Object>> getMatchIdsWithTemplate(String billFormNumber, List<Object> pkIds) {
        ComplexSettingItem otherSetting;
        HashMap<Object, List<Object>> result = new HashMap<Object, List<Object>>(16);
        Tuple<Boolean, Object> validateResult = PrintConditionHelpUtils.validateCondition(billFormNumber);
        List objs = (List)validateResult.item2;
        if (!((Boolean)validateResult.item1).booleanValue()) {
            for (ComplexSettingItem obj : objs) {
                result.put(obj.getFiltertemplateid(), Collections.emptyList());
            }
            return result;
        }
        Tuple<StringBuilder, List<String>> checkResult = PrintConditionHelpUtils.checkCondition(objs);
        List<String> enableTemplates = PrintConditionHelpUtils.checkTemplatePerm(billFormNumber, (List)checkResult.item2);
        List availableFilterSetting = objs.stream().filter(p -> p.isEnable() && StringUtils.isNotBlank((CharSequence)p.getFiltertemplateid()) && enableTemplates.contains(p.getFiltertemplateid())).collect(Collectors.toList());
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)billFormNumber);
        HashSet matchIds = new HashSet(10);
        for (ComplexSettingItem item : availableFilterSetting) {
            if (!StringUtils.isNotBlank((Object)item.getFiltercondition()) || item.getFiltertype() != 1) continue;
            FilterCondition filterCondition = item.getFiltercondition() instanceof String ? (FilterCondition)SerializationUtils.fromJsonString((String)item.getFiltercondition().toString(), FilterCondition.class) : (FilterCondition)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)item.getFiltercondition()), FilterCondition.class);
            FilterBuilder filterBuilder = new FilterBuilder(dt, filterCondition, true);
            filterBuilder.setTimeService((ITimeService)new TimeService());
            filterBuilder.setUserService((IUserService)new UserService());
            filterBuilder.buildFilter(true);
            String pkName = dt.getPrimaryKey().getName();
            QFilter[] filters = new QFilter[]{filterBuilder.getQFilter(), new QFilter(pkName, "in", pkIds)};
            Map filterObjs = BusinessDataServiceHelper.loadFromCache((String)billFormNumber, (QFilter[])filters);
            if (filterObjs.size() <= 0) continue;
            ArrayList billIds = new ArrayList(filterObjs.keySet());
            result.put(item.getFiltertemplateid(), billIds);
            matchIds.addAll(billIds);
        }
        Optional<ComplexSettingItem> other = availableFilterSetting.stream().filter(o -> o.getFiltertype() == 2).findFirst();
        if (other.isPresent() && enableTemplates.contains((otherSetting = other.get()).getFiltertemplateid())) {
            ArrayList<Object> otherMatchIds = new ArrayList<Object>();
            for (int i = 0; i < pkIds.size(); ++i) {
                Object id = pkIds.get(i);
                boolean isMatch = matchIds.contains(id);
                if (isMatch) continue;
                otherMatchIds.add(id);
            }
            if (!otherMatchIds.isEmpty()) {
                result.put(otherSetting.getFiltertemplateid(), otherMatchIds);
            }
        }
        return result;
    }
}

