/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.scheme.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;

public class PageCacheUtils {
    private static Log logger = LogFactory.getLog(PageCacheUtils.class);

    public static <T> List<T> getDataFromPageCache(IPageCache pageCache, String key, Class<T> tClass) {
        String cacheValueStr = pageCache.getBigObject(key);
        if (StringUtils.isNotBlank((CharSequence)cacheValueStr)) {
            List valueList = SerializationUtils.fromJsonStringToList((String)cacheValueStr, tClass);
            return valueList;
        }
        return Collections.emptyList();
    }

    public static <T> void cacheDataToPageCache(IPageCache pageCache, String key, List<T> data, Class<T> tClass) {
        if (!CollectionUtils.isEmpty(data)) {
            List<T> rawData = PageCacheUtils.getDataFromPageCache(pageCache, key, tClass);
            if (!CollectionUtils.isEmpty(rawData)) {
                data.addAll(0, rawData);
            }
            pageCache.putBigObject(key, SerializationUtils.toJsonString(data));
        }
    }

    public static void cacheDataCollectionToPageCache(IPageCache pageCache, String key, Collection data) {
        if (!CollectionUtils.isEmpty((Collection)data)) {
            pageCache.putBigObject(key, SerializationUtils.toJsonString((Object)data));
        }
    }

    public static <T> Queue<T> getDataQueueFromPageCache(IPageCache pageCache, String key, Class<T> tClass) {
        List<T> data = PageCacheUtils.getDataFromPageCache(pageCache, key, tClass);
        if (!CollectionUtils.isEmpty(data)) {
            return new LinkedList<T>(data);
        }
        return new LinkedList();
    }

    public static void cacheDataToPageCache(IPageCache pageCache, String key, Object data) {
        if (data != null) {
            pageCache.putBigObject(key, SerializationUtils.toJsonString((Object)data));
        }
    }

    public static <T> T getFromPageCache(IPageCache pageCache, String key, Class<T> tClass) {
        String cacheValueStr = pageCache.getBigObject(key);
        if (StringUtils.isNotBlank((CharSequence)cacheValueStr)) {
            return (T)SerializationUtils.fromJsonString((String)cacheValueStr, tClass);
        }
        return null;
    }

    public static Map<String, TreeNode> getFromPageCache(IPageCache pageCache, String key) {
        String cacheValueStr = pageCache.getBigObject(key);
        if (StringUtils.isNotBlank((CharSequence)cacheValueStr)) {
            try {
                ObjectMapper objectMapper = SerializationUtils.getObjectMapper2();
                return (Map)objectMapper.readValue(cacheValueStr, (TypeReference)new TypeReference<HashMap<String, TreeNode>>(){});
            }
            catch (Exception e) {
                logger.error("deserialize cache value occur error\uff1a", (Throwable)e);
            }
        }
        return Collections.emptyMap();
    }

    public static void checkCacheSearchTextInPageCache(IPageCache pageCache, String key, String queueKey, String currentSearchText) {
        String lastSearchText = pageCache.get(key);
        if (!currentSearchText.equals(lastSearchText)) {
            pageCache.removeBigObject(queueKey + lastSearchText);
            pageCache.put(key, currentSearchText);
        }
    }

    public static void cacheValueToPageCache(IPageCache pageCache, String key, String formNumber) {
        pageCache.put(key, formNumber);
    }

    public static String getValueFromPageCache(IPageCache pageCache, String key) {
        return pageCache.get(key);
    }

    public static void removeValueFromPageCache(IPageCache pageCache, String key) {
        pageCache.remove(key);
    }
}

