/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.scheme.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.business.scheme.dao.PrintConditionDao;
import kd.bos.print.business.scheme.entity.ComplexSettingItem;
import org.apache.commons.beanutils.MethodUtils;

public class PrintConditionHelpUtils {
    private static Log logger = LogFactory.getLog(PrintConditionHelpUtils.class);

    private PrintConditionHelpUtils() {
    }

    public static Tuple<Boolean, Object> validateCondition(String billFormNumber) {
        Map<String, Object> conditionMap = PrintConditionDao.getPrintConditionByBillNumber(billFormNumber);
        return PrintConditionHelpUtils.validateCondition(conditionMap);
    }

    public static Tuple<Boolean, Object> validateCondition(Map<String, Object> conditionMap) {
        int status = 0;
        HashMap<String, Object> result = new HashMap<String, Object>();
        StringBuilder messages = new StringBuilder();
        if (conditionMap.isEmpty() || StringUtils.isBlank((Object)conditionMap.get("condition"))) {
            status = -1;
            messages.append(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u6253\u5370\u6761\u4ef6\u3002", (String)"PrintConditionHelpUtils_1", (String)"bos-print-business", (Object[])new Object[0]));
            result.put("status", status);
            result.put("message", messages.toString());
            result.put("jobs", Collections.emptyList());
            return new Tuple((Object)Boolean.FALSE, result);
        }
        Object conditionObj = conditionMap.get("condition");
        List objs = SerializationUtils.fromJsonStringToList((String)conditionObj.toString(), ComplexSettingItem.class);
        if (CollectionUtils.isEmpty((Collection)objs)) {
            status = -1;
            messages.append(ResManager.loadKDString((String)"\u5f53\u524d\u8bbe\u7f6e\u6253\u5370\u6761\u4ef6\u4e3a\u7a7a\u3002", (String)"PrintConditionHelpUtils_2", (String)"bos-print-business", (Object[])new Object[0]));
            result.put("status", status);
            result.put("message", messages.toString());
            result.put("jobs", Collections.emptyList());
            return new Tuple((Object)Boolean.FALSE, result);
        }
        boolean hasEnableComplexSetting = objs.stream().anyMatch(ComplexSettingItem::isEnable);
        if (!hasEnableComplexSetting) {
            status = -1;
            messages.append(ResManager.loadKDString((String)"\u5f53\u524d\u8bbe\u7f6e\u6253\u5370\u6761\u4ef6\u90fd\u672a\u542f\u7528\u3002", (String)"PrintConditionHelpUtils_3", (String)"bos-print-business", (Object[])new Object[0]));
            result.put("status", status);
            result.put("message", messages.toString());
            result.put("jobs", Collections.emptyList());
            return new Tuple((Object)Boolean.FALSE, result);
        }
        return new Tuple((Object)Boolean.TRUE, (Object)objs);
    }

    public static Tuple<StringBuilder, List<String>> checkCondition(List<ComplexSettingItem> setting) {
        StringBuilder messages = new StringBuilder();
        ArrayList<String> templateIds = new ArrayList<String>(10);
        setting.forEach(item -> {
            if (item.isEnable() && StringUtils.isNotBlank((CharSequence)item.getFiltertemplateid())) {
                templateIds.add(item.getFiltertemplateid());
            }
        });
        List<Map<String, Object>> templates = PrintConditionDao.getPrintTemplateById(templateIds);
        ArrayList<String> existTemplateIds = new ArrayList<String>(10);
        ArrayList enableTemplateIds = new ArrayList(10);
        HashMap<String, String> templateNameMap = new HashMap<String, String>(16);
        templates.forEach(stringObjectMap -> {
            Object id = stringObjectMap.get("metaId");
            if (id != null) {
                existTemplateIds.add(id.toString());
                templateNameMap.put(id.toString(), stringObjectMap.get("name") != null ? stringObjectMap.get("name").toString() : "");
                Object enableObj = stringObjectMap.get("enable");
                if ("1".equals(enableObj) || "".equals(enableObj)) {
                    enableTemplateIds.add(id.toString());
                }
            }
        });
        templateIds.removeAll(existTemplateIds);
        messages.append(PrintConditionHelpUtils.buildTipMessage(templateIds, templateNameMap, true));
        existTemplateIds.removeAll(enableTemplateIds);
        messages.append(PrintConditionHelpUtils.buildTipMessage(existTemplateIds, templateNameMap, false));
        if (StringUtils.isNotBlank((CharSequence)messages.toString())) {
            messages.append(ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u9009\u62e9\u6a21\u677f", (String)"PrintConditionHelpUtils_4", (String)"bos-print-business", (Object[])new Object[0]));
        }
        return new Tuple((Object)messages, enableTemplateIds);
    }

    private static String buildTipMessage(List<String> ids, Map<String, String> name, boolean tipUnExist) {
        StringBuilder message = new StringBuilder();
        if (!CollectionUtils.isEmpty(ids)) {
            for (String id : ids) {
                String templateName = name.get(id);
                message.append(ResManager.loadKDString((String)"\u6a21\u677f", (String)"PrintConditionHelpUtils_5", (String)"bos-print-business", (Object[])new Object[0])).append("\"");
                if (StringUtils.isNotBlank((CharSequence)templateName)) {
                    message.append(templateName);
                } else {
                    message.append(id);
                }
                if (tipUnExist) {
                    message.append("\"").append(ResManager.loadKDString((String)"\u5df2\u88ab\u5220\u9664", (String)"PrintConditionHelpUtils_6", (String)"bos-print-business", (Object[])new Object[0]));
                } else {
                    message.append("\"").append(ResManager.loadKDString((String)"\u5df2\u88ab\u7981\u7528", (String)"PrintConditionHelpUtils_7", (String)"bos-print-business", (Object[])new Object[0]));
                }
                message.append("\uff0c");
            }
        }
        return message.toString();
    }

    public static List<String> checkTemplatePerm(String billFormNumber, List<String> templateIds) {
        String className = "kd.bos.template.orgctrl.service.PrintTemplateServiceImpl";
        try {
            Class factory = TypesContainer.getOrRegister((String)className);
            Object[] params = new Object[]{billFormNumber};
            Map permTemplates = (Map)MethodUtils.invokeMethod(factory.newInstance(), (String)"getUserPermPrintTemplateMap", (Object[])params);
            Set permTplIds = permTemplates.keySet();
            ArrayList<String> result = new ArrayList<String>(10);
            for (String temp : templateIds) {
                if (!permTplIds.contains(temp)) continue;
                result.add(temp);
            }
            return result;
        }
        catch (Exception e) {
            logger.error("\u53cd\u5c04\u8c03\u7528\u670d\u52a1\u65b9\u6cd5\u83b7\u53d6\u6709\u6743\u7684\u65b0\u65e7\u6a21\u7248\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            return Collections.emptyList();
        }
    }
}

