/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.service;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.PrintCountProp;
import kd.bos.entity.property.PrintTimeProp;
import kd.bos.entity.property.PrintUserProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.service.DispatchServiceHelper;
import kd.bos.mservice.form.FormService;
import kd.bos.mservice.print.BosPrintBusinessService;
import kd.bos.mservice.print.BosPrintService;
import kd.bos.mservice.print.param.PrintDeployFile;
import kd.bos.mservice.print.param.PrintInfoParam;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.api.PrintParam;
import kd.bos.print.api.PrintTask;
import kd.bos.print.api.PrintWork;
import kd.bos.print.api.metedata.PrintMetadata;
import kd.bos.print.api.metedata.control.Paper;
import kd.bos.print.api.utils.ConfigConstUtil;
import kd.bos.print.business.control.PrintControlUtils;
import kd.bos.print.business.designer.TplType;
import kd.bos.print.business.metedata.PrintMetadataUtil;
import kd.bos.print.business.metedata.bean.IPrintBaseXml;
import kd.bos.print.business.metedata.bean.LibraryMetaLangXml;
import kd.bos.print.business.metedata.bean.LibraryMetaXml;
import kd.bos.print.business.metedata.bean.PrintMetaLangXml;
import kd.bos.print.business.metedata.bean.PrintTplMetaXml;
import kd.bos.print.business.metedata.bean.ResPowerScope;
import kd.bos.print.business.metedata.bean.TplResource;
import kd.bos.print.business.metedata.service.migrate.AbstractImpExp;
import kd.bos.print.business.metedata.service.migrate.LibraryTplImpExp;
import kd.bos.print.business.metedata.service.migrate.PrintTplImpExp;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.bos.svc.acl.AclAdapter;
import kd.bos.svc.util.print.PrtTaskResult;
import kd.bos.svc.util.print.PrtTaskResultServiceHelper;
import kd.bos.url.UrlService;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class BosPrintBusinessServiceImpl
implements BosPrintBusinessService<PrintWork> {
    private static final String PRINT_RESOURCE_TABLENAME = "t_svc_printresource";
    private static final String PRINT_RESOURCE = "bos_print_resource";
    private static final String PROJECT_NAME = "bos-print-business";
    private static final String BAS_MANAGEPRINTTPL = "bas_manageprinttpl";
    private static final String SVC_PRINT = "svc-print";
    private static final Log log = LogFactory.getLog(BosPrintBusinessServiceImpl.class);
    private static final String IDX_OUTOFRANGE_WARNING_CODE = "SYS.cts.WARNING_001";

    public String getDomainModel() {
        return PrintControlUtils.getControlModel();
    }

    public String getDomainModel(String bizType) {
        return PrintControlUtils.getControlModel(bizType);
    }

    public long saveFile(Map<String, Object> param) {
        return this.saveFile(param, true);
    }

    public long saveFile(Map<String, Object> param, boolean needTplExist) {
        String printtplid = (String)param.get("printtplid");
        if (StringUtils.isBlank((CharSequence)printtplid)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u677fid\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BosPrintBusinessServiceImpl_0", (String)PROJECT_NAME, (Object[])new Object[0]));
        }
        if (needTplExist) {
            boolean tplExist = QueryServiceHelper.exists((String)"bos_print_meta", (Object)printtplid);
            if (!tplExist) {
                tplExist = QueryServiceHelper.exists((String)"bos_printtpl_lbr", (Object)printtplid);
            }
            if (!tplExist) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u677f\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BosPrintBusinessServiceImpl_3", (String)PROJECT_NAME, (Object[])new Object[0]));
            }
        }
        String fileName = (String)param.get("fileName");
        String url = (String)param.get("url");
        String fileSuffix = fileName.substring(fileName.lastIndexOf(46) + 1);
        ResPowerScope powerScope = ResPowerScope.POWER_INNER;
        Object paramPowerScope = param.get("powerScope");
        if (paramPowerScope != null) {
            ResPowerScope scope = ResPowerScope.getValue((String)paramPowerScope);
            if (scope == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6743\u9650\u8303\u56f4powerScope\uff0c\u4e0d\u7b26\u5408\u89c4\u8303\u3002", (String)"BosPrintBusinessServiceImpl_7", (String)PROJECT_NAME, (Object[])new Object[0]));
            }
            powerScope = scope;
        }
        String type = "0";
        int fileSize = -1;
        InputStream inputStream = FileServiceFactory.getImageFileService().getInputStream(url);
        Long rcId = (Long)param.get("rcId");
        if (rcId == null) {
            rcId = DB.genLongId((String)PRINT_RESOURCE_TABLENAME);
        }
        long creator = RequestContext.get().getCurrUserId();
        boolean isSysTpl = this.isSysTpl(printtplid);
        String insertSql = "insert into %s(fid,filename,filetype,ftype,filesize,fprinttplid,fpowerscope,fcreatorid,fcreatetime,%s) values(?,?,?,?,?,?,?,?,?,?)";
        Object[] sqlParams = new SqlParameter[10];
        sqlParams[0] = new SqlParameter("fid", -5, (Object)rcId);
        sqlParams[1] = new SqlParameter("filename", -9, (Object)fileName);
        sqlParams[2] = new SqlParameter("filetype", 12, (Object)fileSuffix);
        sqlParams[3] = new SqlParameter("ftype", 12, (Object)type);
        sqlParams[5] = new SqlParameter("fprinttplid", 12, (Object)printtplid);
        sqlParams[6] = new SqlParameter("fpowerscope", 12, (Object)powerScope.getCode());
        sqlParams[7] = new SqlParameter("fcreatorid", -5, (Object)creator);
        sqlParams[8] = new SqlParameter("fcreatetime", 91, (Object)new Date());
        try {
            fileSize = inputStream.available();
            sqlParams[4] = new SqlParameter("filesize", 4, (Object)fileSize);
            if (isSysTpl && needTplExist) {
                byte[] bytes = this.readFile(inputStream);
                insertSql = String.format(insertSql, PRINT_RESOURCE_TABLENAME, "fdata");
                sqlParams[9] = new SqlParameter("fdata", 2004, (Object)bytes);
            } else {
                insertSql = String.format(insertSql, PRINT_RESOURCE_TABLENAME, "furl");
                sqlParams[9] = new SqlParameter("furl", 12, (Object)url);
            }
            DB.execute((DBRoute)DBRoute.basedata, (String)insertSql, (Object[])sqlParams);
        }
        catch (Exception e) {
            ErrorCode errorCode = new ErrorCode("print-exception", e.getMessage());
            throw new KDBizException((Throwable)e, errorCode, null);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error((Throwable)e);
                }
            }
        }
        return rcId;
    }

    private byte[] readFile(InputStream inputStream) throws IOException {
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            int n;
            byte[] buffer = new byte[4096];
            while ((n = inputStream.read(buffer)) != -1) {
                output.write(buffer, 0, n);
            }
            byte[] byArray = output.toByteArray();
            return byArray;
        }
    }

    private boolean isSysTpl(String tplId) {
        return QueryServiceHelper.exists((String)"bos_printtpl_lbr", (Object)tplId);
    }

    public void saveTplResources(String tplId, List<TplResource> resources) {
        DynamicObjectCollection data;
        if (StringUtils.isBlank((CharSequence)tplId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u677fid\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BosPrintBusinessServiceImpl_0", (String)PROJECT_NAME, (Object[])new Object[0]));
        }
        String insertSql = "insert into %s(fid,filename,filetype,ftype,filesize,fprinttplid,fpowerscope,fcreatorid,fcreatetime,furl,fdata) values(?,?,?,?,?,?,?,?,?,?,?)";
        insertSql = String.format(insertSql, PRINT_RESOURCE_TABLENAME);
        ArrayList<SqlParameter[]> saveList = new ArrayList<SqlParameter[]>(10);
        long currUserId = RequestContext.get().getCurrUserId();
        BusinessDataWriter.delete((String)PRINT_RESOURCE, (QFilter[])new QFilter[]{new QFilter("printtplid", "=", (Object)tplId)});
        ArrayList<Long> ids = new ArrayList<Long>(10);
        for (TplResource resource : resources) {
            ids.add(resource.getRcId());
        }
        ArrayList<Long> existIds = new ArrayList<Long>(10);
        if (!ids.isEmpty() && (data = QueryServiceHelper.query((String)PRINT_RESOURCE, (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)})) != null && !data.isEmpty()) {
            for (DynamicObject object : data) {
                existIds.add(object.getLong("id"));
            }
        }
        for (TplResource resource : resources) {
            if (existIds.contains(resource.getRcId())) continue;
            SqlParameter[] sqlParams = new SqlParameter[]{new SqlParameter("fid", -5, (Object)resource.getRcId()), new SqlParameter("filename", -9, (Object)resource.getFilename()), new SqlParameter("filetype", 12, (Object)resource.getFiletype()), new SqlParameter("ftype", 12, (Object)resource.getType()), new SqlParameter("filesize", -5, (Object)resource.getFilesize()), new SqlParameter("fprinttplid", 12, (Object)tplId), new SqlParameter("fpowerscope", 12, (Object)resource.getPowerscope()), new SqlParameter("fcreatorid", -5, (Object)currUserId), new SqlParameter("fcreatetime", 91, (Object)new Date()), new SqlParameter("furl", 12, (Object)resource.getUrl()), new SqlParameter("fdata", 2004, (Object)resource.getData())};
            saveList.add(sqlParams);
        }
        TXHandle tx = TX.required();
        Object object = null;
        try {
            if (!saveList.isEmpty()) {
                DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql, saveList);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (object != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    public Map<String, Object> getFileInfo(long rcId) {
        String sql = "select filename,filetype,ftype,filesize,furl,fprinttplid,fpowerscope,fcreatorid,fcreatetime,fdata from %s where fid=?";
        sql = String.format(sql, PRINT_RESOURCE_TABLENAME);
        Map res = (Map)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[]{rcId}, rSet -> {
            HashMap<String, Object> result = new HashMap<String, Object>(16);
            while (rSet.next()) {
                result.put("id", rcId);
                result.put("fileName", rSet.getString(1));
                result.put("fileType", rSet.getString(2));
                result.put("type", rSet.getString(3));
                result.put("fileSize", rSet.getInt(4));
                result.put("url", rSet.getString(5));
                result.put("printtplid", rSet.getString(6));
                result.put("powerscope", rSet.getString(7));
                result.put("creatorid", rSet.getString(8));
                result.put("createtime", rSet.getDate(9));
                result.put("data", rSet.getBytes(10));
            }
            return result;
        });
        return res;
    }

    public static List<TplResource> getFileListInfo(List<Long> rcIds) {
        String sql = "select filename,filetype,ftype,filesize,furl,fprinttplid,fpowerscope,fcreatorid,fcreatetime,fid,fdata from %s where fid in (%s)";
        sql = String.format(sql, PRINT_RESOURCE_TABLENAME, StringUtils.join((Object[])rcIds.toArray(), (String)","));
        List res = (List)DB.query((DBRoute)DBRoute.basedata, (String)sql, null, rSet -> {
            ArrayList<TplResource> list = new ArrayList<TplResource>(10);
            while (rSet.next()) {
                TplResource resource = new TplResource();
                resource.setFilename(rSet.getString(1));
                resource.setFiletype(rSet.getString(2));
                resource.setType(rSet.getString(3));
                resource.setFilesize((long)rSet.getInt(4));
                resource.setUrl(rSet.getString(5));
                resource.setPrinttplid(rSet.getString(6));
                resource.setPowerscope(rSet.getString(7));
                resource.setCreatorid(rSet.getLong(8));
                resource.setCreatetime((Date)rSet.getDate(9));
                resource.setRcId(rSet.getLong(10));
                resource.setData(rSet.getBytes(11));
                list.add(resource);
            }
            return list;
        });
        return res;
    }

    public Map<String, Object> deleteFile(long rcId) {
        Map<String, Object> result = this.getFileInfo(rcId);
        if (result == null || result.isEmpty()) {
            return result;
        }
        String sql = "delete from %s where fid=?";
        sql = String.format(sql, PRINT_RESOURCE_TABLENAME);
        Object[] sqlParams = new SqlParameter[]{new SqlParameter("fid", -5, (Object)rcId)};
        DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])sqlParams);
        return result;
    }

    @Deprecated
    public String createPdfUrl(List<Object> taskList, String lang) {
        List tasks = taskList.stream().map(p -> p == null ? null : (PrintTask)p).collect(Collectors.toList());
        PrintWork printWork = new PrintWork();
        printWork.setExpType("pdf");
        printWork.setPageId(((PrintTask)tasks.get(0)).getPageId());
        printWork.setTaskList(tasks);
        String taskId = this.doPrint((String)null, printWork);
        PrtTaskResult taskResult = PrtTaskResultServiceHelper.getPrtResult((String)taskId);
        List attachList = taskResult.getAttach();
        if (attachList == null || attachList.isEmpty()) {
            return null;
        }
        PrtTaskResult.Attach attach = null;
        for (PrtTaskResult.Attach att : attachList) {
            if (!"B".equalsIgnoreCase(att.getSource())) continue;
            attach = att;
            break;
        }
        if (attach == null) {
            return null;
        }
        String downloadUrl = UrlService.getDomainContextUrl() + "/api/print/download.do?taskId=%s&attachId=%s";
        downloadUrl = String.format(downloadUrl, taskId, attach.getAttachId());
        return downloadUrl;
    }

    public String doPrint(String taskId, PrintWork work) {
        List tasks = work.getTaskList();
        String formId = null;
        for (PrintTask task : tasks) {
            if (formId != null) continue;
            formId = task.getFormId();
        }
        work.setHorEconomizePaper(false);
        work.setVerEconomizePaper(false);
        String billFormId = formId;
        if (work instanceof PrintParam && StringUtils.isNotBlank((CharSequence)((PrintParam)work).getBillFormId())) {
            billFormId = ((PrintParam)work).getBillFormId();
            try {
                FormConfig formConfig = FormMetadataCache.getFormConfig((String)billFormId);
                billFormId = formConfig.getEntityTypeId();
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)billFormId)) {
            String key = billFormId + "_printsetting";
            String settingData = UserConfigServiceHelper.getSetting((long)RequestContext.get().getCurrUserId(), (String)key);
            if (StringUtils.isNotBlank((CharSequence)settingData)) {
                Map jsonData = (Map)SerializationUtils.fromJsonString((String)settingData, Map.class);
                if (jsonData != null && jsonData.get("hSavePage") instanceof Boolean) {
                    work.setHorEconomizePaper(Boolean.parseBoolean(jsonData.get("hSavePage").toString()));
                }
                if (jsonData != null && jsonData.get("vSavePage") instanceof Boolean) {
                    work.setVerEconomizePaper(Boolean.parseBoolean(jsonData.get("vSavePage").toString()));
                }
                if (jsonData != null && jsonData.get("economizeByBill") instanceof Boolean) {
                    work.setEconomizeByBill(Boolean.parseBoolean(jsonData.get("economizeByBill").toString()));
                }
                if (jsonData != null && StringUtils.isNotBlank(jsonData.get("pageNumType"))) {
                    work.setPageNumType(jsonData.get("pageNumType").toString());
                }
                if (jsonData != null && jsonData.get("pageSeparation") instanceof Boolean) {
                    work.setPageSeparation(Boolean.parseBoolean(jsonData.get("pageSeparation").toString()));
                }
                if (jsonData != null && StringUtils.isNotBlank(jsonData.get("fileCreateType"))) {
                    work.setFileCreateType(jsonData.get("fileCreateType").toString());
                }
                if (StringUtils.isBlank((CharSequence)work.getPrinterId()) && jsonData != null && jsonData.get("printerid") != null) {
                    work.setPrinterId(jsonData.get("printerid").toString());
                }
            }
        }
        try {
            work.setBizOp(true);
            String appId = SVC_PRINT;
            boolean hasDeployAppPrint = AclAdapter.getAclServiceLookup().hasDeployedAppId(appId);
            if (hasDeployAppPrint) {
                taskId = (String)DispatchServiceHelper.invokeBOSServiceByAppId((String)appId, (String)"BosPrintService", (String)"doPrint", (Object[])new Object[]{taskId, work});
            } else if (work instanceof PrintParam) {
                taskId = ((BosPrintService)ServiceFactory.getService(BosPrintService.class)).doPrint(taskId, (Object)work);
            } else {
                appId = this.getAppId(work, formId);
                if (StringUtils.isBlank((CharSequence)appId)) {
                    appId = "bos";
                }
                taskId = (String)DispatchServiceHelper.invokeBOSServiceByAppId((String)appId, (String)"BosPrintService", (String)"doPrint", (Object[])new Object[]{taskId, work});
            }
            return taskId;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            if (ConfigConstUtil.isShowStackTrace()) {
                throw e;
            }
            if (e instanceof KDBizException) {
                throw e;
            }
            Throwable cause = e;
            while (cause != null && cause.getCause() != null) {
                if (!((cause = cause.getCause()) instanceof KDBizException)) continue;
                throw (KDBizException)cause;
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u6253\u5370\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u65e5\u5fd7\u3002", (String)"BosPrintBusinessServiceImpl_6", (String)PROJECT_NAME, (Object[])new Object[0]));
        }
    }

    private String getAppId(PrintWork work, String formId) {
        if (StringUtils.isNotBlank((CharSequence)work.getAppNumber())) {
            return work.getAppNumber();
        }
        String appId = null;
        String pageId = work.getPageId();
        if (StringUtils.isNotBlank((CharSequence)pageId)) {
            IFormView view = SessionManager.getCurrent().getViewNoPlugin(pageId);
            if (view != null) {
                appId = view.getFormShowParameter().getAppId();
            }
        } else if (StringUtils.isNotBlank((CharSequence)formId)) {
            appId = ((FormService)ServiceFactory.getService(FormService.class)).getAppId(formId);
        }
        if (StringUtils.isBlank(appId)) {
            log.warn("BosPrintServiceImpl.getAppId appid=null");
        }
        return appId;
    }

    public PrintMetadata getPrintMetadata(String tplId) {
        return PrintMetadataUtil.getPrintMetadata(tplId);
    }

    public static String preview(PrintMetadata metadata, String curLang) {
        String formId;
        MainEntityType entityType;
        String type = metadata.getType();
        Object pkId = 0;
        PrintTask task = new PrintTask();
        String printType = "dynamic";
        if (StringUtils.equals((CharSequence)TplType.PrintTpl.toString(), (CharSequence)type) && ((entityType = EntityMetadataCache.getDataEntityType((String)(formId = metadata.getFormId()))) instanceof BillEntityType || entityType instanceof BasedataEntityType)) {
            printType = "billForm";
            DynamicObjectCollection collection = QueryServiceHelper.query((String)formId, (String)"id", (QFilter[])new QFilter[1], (String)"id desc", (int)1);
            if (collection.size() > 0) {
                pkId = ((DynamicObject)collection.stream().findFirst().get()).get("id");
            }
        }
        task.setFormId(metadata.getFormId());
        ArrayList<Integer> pkIdList = new ArrayList<Integer>(1);
        pkIdList.add((Integer)pkId);
        task.setPkIds(pkIdList);
        task.setMetadata(metadata);
        task.setPrintType(printType);
        try {
            String appId = SVC_PRINT;
            if (!AclAdapter.getAclServiceLookup().hasDeployedAppId(appId)) {
                String formId2 = metadata.getFormId();
                appId = StringUtils.isNotBlank((CharSequence)formId2) ? ((FormService)ServiceFactory.getService(FormService.class)).getAppId(formId2) : "bos";
            }
            PrintParam work = new PrintParam();
            work.setPrintLang(curLang);
            work.add(task);
            work.setExpType(PrintWork.EXP_TYPE.EXP_PDF.getCode());
            Paper paper = null;
            paper = metadata.getPaper();
            if (paper != null) {
                work.setHorEconomizePaper(paper.isHorizonEconomize());
                work.setVerEconomizePaper(paper.isVerticalEconomize());
            }
            work.setBizOp(true);
            String url = (String)DispatchServiceHelper.invokeBOSServiceByAppId((String)appId, (String)"BosPrintService", (String)"doPreview", (Object[])new Object[]{work});
            return url;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            if (ConfigConstUtil.isShowStackTrace()) {
                throw e;
            }
            if (e instanceof KDBizException) {
                throw e;
            }
            Throwable cause = e;
            while (cause != null && cause.getCause() != null) {
                if (!((cause = cause.getCause()) instanceof KDBizException)) continue;
                throw (KDBizException)cause;
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u6253\u5370\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u65e5\u5fd7\u3002", (String)"BosPrintBusinessServiceImpl_6", (String)PROJECT_NAME, (Object[])new Object[0]));
        }
    }

    @Deprecated
    public static Map<String, Object> validatePrintFormula(List<Object> formulaData) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        String status = "success";
        String result = "result";
        String msg = ResManager.loadKDString((String)"\u6821\u9a8c\u6210\u529f", (String)"BosPrintBusinessServiceImpl_2", (String)PROJECT_NAME, (Object[])new Object[0]);
        if (formulaData.isEmpty() || formulaData.size() == 1 && StringUtils.isBlank((Object)formulaData.get(0))) {
            map.put(result, status);
            map.put("msg", msg);
            return map;
        }
        try {
            DispatchServiceHelper.invokeBOSServiceByAppId((String)"bos", (String)"BosPrintService", (String)"formulaResolution", (Object[])new Object[]{formulaData, "validateFormula"});
        }
        catch (Exception e) {
            status = "fail";
            msg = e.getMessage();
        }
        map.put(result, status);
        map.put("msg", msg);
        return map;
    }

    @Deprecated
    public static Map<String, Object> validatePrintFormula(List<Object> formulaData, String dataSource) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        for (Object object : formulaData) {
            if (!(object instanceof Map)) continue;
            String ds = (String)((Map)object).get("dataSource");
            String dsType = (String)((Map)object).get("dsType");
            if (!"Entry".equals(dsType) && !"Subentry".equals(dsType) && !"Attach".equals(dsType) && !"Approveline".equals(dsType) && !"Approveactivity".equals(dsType) || !StringUtils.isNotBlank((CharSequence)dataSource) || dataSource.equals(ds)) continue;
            String status = "fail";
            String msg = ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u4e0d\u540c\u5355\u636e\u4f53\u7684\u5b57\u6bb5\u7ec4\u5408\uff0c\u8bf7\u68c0\u67e5\u516c\u5f0f", (String)"BosPrintBusinessServiceImpl_4", (String)PROJECT_NAME, (Object[])new Object[0]);
            map.put("result", status);
            map.put("msg", msg);
            return map;
        }
        return BosPrintBusinessServiceImpl.validatePrintFormula(formulaData);
    }

    public static Map<String, Object> validatePrintFormula(List<Object> formulaData, String dataSource, String tplVersion) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        if (dataSource != null) {
            for (Object object : formulaData) {
                if (!(object instanceof Map)) continue;
                String ds = (String)((Map)object).get("dataSource");
                String dsType = (String)((Map)object).get("dsType");
                if (!"Entry".equals(dsType) && !"Subentry".equals(dsType) && !"Attach".equals(dsType) && !"Approveline".equals(dsType) && !"Approveactivity".equals(dsType) || !StringUtils.isNotBlank((CharSequence)dataSource) || dataSource.equals(ds)) continue;
                String status = "fail";
                String msg = ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u4e0d\u540c\u5355\u636e\u4f53\u7684\u5b57\u6bb5\u7ec4\u5408\uff0c\u8bf7\u68c0\u67e5\u516c\u5f0f", (String)"BosPrintBusinessServiceImpl_4", (String)PROJECT_NAME, (Object[])new Object[0]);
                map.put("result", status);
                map.put("msg", msg);
                return map;
            }
        }
        String status = "success";
        String result = "result";
        String msg = ResManager.loadKDString((String)"\u6821\u9a8c\u6210\u529f", (String)"BosPrintBusinessServiceImpl_2", (String)PROJECT_NAME, (Object[])new Object[0]);
        if (formulaData.isEmpty() || formulaData.size() == 1 && StringUtils.isBlank((Object)formulaData.get(0))) {
            map.put(result, status);
            map.put("msg", msg);
            return map;
        }
        try {
            DispatchServiceHelper.invokeBOSServiceByAppId((String)"bos", (String)"BosPrintService", (String)"formulaResolution", (Object[])new Object[]{formulaData, "validateFormula", tplVersion});
        }
        catch (Exception e) {
            status = "fail";
            msg = e.getMessage();
        }
        map.put(result, status);
        map.put("msg", msg);
        return map;
    }

    public Map<String, Object> deployPrintFile(List<PrintDeployFile> prtFiles) {
        if (CollectionUtils.isEmpty(prtFiles)) {
            return null;
        }
        for (PrintDeployFile prtFile : prtFiles) {
            String fileName = prtFile.getFileName();
            String content = prtFile.getContent();
            if (StringUtils.isBlank((CharSequence)content)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6253\u5370\u6587\u4ef6\u90e8\u7f72\u5931\u8d25\uff0c\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a\uff0cfileName=%s\u3002", (String)"BosPrintBusinessServiceImpl_9", (String)PROJECT_NAME, (Object[])new Object[0]), fileName));
            }
            try {
                JAXBContext cont = JAXBContext.newInstance((Class[])new Class[]{LibraryMetaXml.class, PrintTplMetaXml.class, PrintMetaLangXml.class, LibraryMetaLangXml.class});
                Unmarshaller unmarshaller = cont.createUnmarshaller();
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document document = db.parse(new ByteArrayInputStream(content.getBytes()));
                Object baseXml = unmarshaller.unmarshal((Node)document);
                AbstractImpExp impExpService = this.createImpExpService(baseXml);
                if (baseXml instanceof IPrintBaseXml) {
                    impExpService.deployFile(baseXml);
                    continue;
                }
                if (baseXml instanceof PrintMetaLangXml) {
                    impExpService.saveTplMeteL((PrintMetaLangXml)baseXml);
                    continue;
                }
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6253\u5370\u6587\u4ef6\u90e8\u7f72\u5931\u8d25\uff0c\u672a\u8bc6\u522b\u7684\u6587\u4ef6\u5185\u5bb9\uff0cfileName=%s\u3002", (String)"BosPrintBusinessServiceImpl_8", (String)PROJECT_NAME, (Object[])new Object[0]), fileName));
            }
            catch (Exception e) {
                log.error((Throwable)e);
                throw new KDBizException(e.getMessage());
            }
        }
        return null;
    }

    private AbstractImpExp createImpExpService(Object baseXml) {
        if (baseXml instanceof LibraryMetaXml || baseXml instanceof LibraryMetaLangXml) {
            return new LibraryTplImpExp();
        }
        return new PrintTplImpExp();
    }

    public void updatePrintCountField(String entityTypeId, List<Object> pkIds, String recordModel) {
        if (entityTypeId == null || pkIds == null || pkIds.isEmpty() || recordModel == null) {
            return;
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityTypeId);
        if (!(dataEntityType instanceof BillEntityType)) {
            return;
        }
        Map allFields = dataEntityType.getFields();
        List printCountProps = allFields.values().stream().filter(property -> property instanceof PrintCountProp).filter(prop -> StringUtils.isNotBlank((CharSequence)prop.getAlias())).collect(Collectors.toList());
        if (!printCountProps.isEmpty()) {
            ISimpleProperty pkProp = dataEntityType.getPrimaryKey();
            QFilter[] qFilters = new QFilter[]{new QFilter(pkProp.getName(), "in", (Object)pkIds.toArray())};
            String selectedFields = printCountProps.stream().map(IMetadata::getName).collect(Collectors.joining(","));
            Map dataEntites = BusinessDataServiceHelper.loadFromCache((String)entityTypeId, (String)(pkProp.getName() + "," + selectedFields), (QFilter[])qFilters);
            for (DynamicObject dynamicObject : dataEntites.values()) {
                for (IDataEntityProperty property2 : printCountProps) {
                    Integer printCount;
                    PrintCountProp printCountProp = (PrintCountProp)property2;
                    if (PrintCountProp.PrintRecordModel.PRINT.getValue().equals(recordModel) && recordModel.equals(printCountProp.getRecordModel())) {
                        printCount = (Integer)printCountProp.getValue((Object)dynamicObject);
                        printCountProp.setValue((Object)dynamicObject, (Object)(printCount + 1));
                        continue;
                    }
                    if (!PrintCountProp.PrintRecordModel.OPERATE.getValue().equals(recordModel) || !recordModel.equals(printCountProp.getRecordModel()) && !StringUtils.isEmpty((CharSequence)printCountProp.getRecordModel())) continue;
                    printCount = (Integer)printCountProp.getValue((Object)dynamicObject);
                    printCountProp.setValue((Object)dynamicObject, (Object)(printCount + 1));
                }
            }
            try {
                SaveServiceHelper.save((DynamicObject[])dataEntites.values().toArray(new DynamicObject[0]));
            }
            catch (Exception e) {
                throw new KDException((Throwable)e, new ErrorCode("print-exception", "%s"), new Object[]{ResManager.loadKDString((String)"\u66f4\u65b0\u6253\u5370\u6b21\u6570\u65f6\u53d1\u751f\u9519\u8bef\u3002", (String)"AbstractPrint_33", (String)"bos-noteprint", (Object[])new Object[0])});
            }
        }
    }

    public void updatePrintInfo(PrintInfoParam param) {
        String entityTypeId = param.getEntityTypeId();
        List pkIds = param.getPkIds();
        String recordModel = param.getRecordModel();
        if (StringUtils.isBlank((CharSequence)entityTypeId) || CollectionUtils.isEmpty((Collection)pkIds) || StringUtils.isBlank((CharSequence)recordModel)) {
            return;
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityTypeId);
        if (!(dataEntityType instanceof BillEntityType)) {
            return;
        }
        long userId = param.getUserId();
        if (userId == -1L) {
            userId = RequestContext.get().getCurrUserId();
        }
        Map allFields = dataEntityType.getFields();
        ArrayList<PrintCountProp> printCountProps = new ArrayList<PrintCountProp>(1);
        ArrayList<PrintUserProp> printUserProps = new ArrayList<PrintUserProp>(1);
        ArrayList<PrintTimeProp> printTimeProps = new ArrayList<PrintTimeProp>(1);
        for (IDataEntityProperty property : allFields.values()) {
            if (property instanceof PrintCountProp && StringUtils.isNotBlank((CharSequence)property.getAlias())) {
                printCountProps.add((PrintCountProp)property);
                continue;
            }
            if (property instanceof PrintUserProp && StringUtils.isNotBlank((CharSequence)property.getAlias())) {
                printUserProps.add((PrintUserProp)property);
                continue;
            }
            if (!(property instanceof PrintTimeProp) || !StringUtils.isNotBlank((CharSequence)property.getAlias())) continue;
            printTimeProps.add((PrintTimeProp)property);
        }
        ArrayList<Object> allProp = new ArrayList<Object>(3);
        allProp.addAll(printCountProps);
        allProp.addAll(printUserProps);
        allProp.addAll(printTimeProps);
        if (!allProp.isEmpty()) {
            ISimpleProperty pkProp = dataEntityType.getPrimaryKey();
            QFilter[] qFilters = new QFilter[]{new QFilter(pkProp.getName(), "in", (Object)pkIds.toArray())};
            String selectedFields = allProp.stream().map(IMetadata::getName).collect(Collectors.joining(","));
            Map dataEntites = BusinessDataServiceHelper.loadFromCache((String)entityTypeId, (String)(pkProp.getName() + "," + selectedFields), (QFilter[])qFilters);
            for (DynamicObject dynamicObject : dataEntites.values()) {
                for (PrintCountProp printCountProp : printCountProps) {
                    Integer printCount;
                    if (recordModel.equals(PrintCountProp.PrintRecordModel.PRINT.getValue()) && recordModel.equals(printCountProp.getRecordModel())) {
                        printCount = (Integer)printCountProp.getValue((Object)dynamicObject);
                        printCountProp.setValue((Object)dynamicObject, (Object)(printCount + 1));
                        continue;
                    }
                    if (!recordModel.equals(PrintCountProp.PrintRecordModel.OPERATE.getValue()) || !recordModel.equals(printCountProp.getRecordModel()) && !StringUtils.isEmpty((CharSequence)printCountProp.getRecordModel())) continue;
                    printCount = (Integer)printCountProp.getValue((Object)dynamicObject);
                    printCountProp.setValue((Object)dynamicObject, (Object)(printCount + 1));
                }
                if (!recordModel.equals(PrintCountProp.PrintRecordModel.PRINT.getValue())) continue;
                for (PrintUserProp printUserProp : printUserProps) {
                    printUserProp.setValue((Object)dynamicObject, (Object)userId);
                }
                Date date = new Date();
                for (PrintTimeProp printTimeProp : printTimeProps) {
                    printTimeProp.setValue((Object)dynamicObject, (Object)date);
                }
            }
            try {
                SaveServiceHelper.save((DynamicObject[])dataEntites.values().toArray(new DynamicObject[0]));
            }
            catch (Exception e) {
                throw new KDException((Throwable)e, new ErrorCode("print-exception", "%s"), new Object[]{ResManager.loadKDString((String)"\u66f4\u65b0\u6253\u5370\u6b21\u6570\u65f6\u53d1\u751f\u9519\u8bef\u3002", (String)"AbstractPrint_33", (String)"bos-noteprint", (Object[])new Object[0])});
            }
        }
    }
}

