/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.upgrade;

import java.awt.Font;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class FontsUpgradeService
implements IUpgradeService {
    private static Log logger = LogFactory.getLog(FontsUpgradeService.class);

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        try {
            this.upgrate(result);
        }
        catch (Exception e) {
            result.setErrorInfo(e.getMessage());
            result.setSuccess(false);
            logger.error("\u6253\u5370\u5b57\u4f53\u8fc1\u5165\u65b0\u5e93\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        return result;
    }

    private void upgrate(UpgradeResult result) {
        result.setLog(ResManager.loadKDString((String)"\u6253\u5370\u5b57\u4f53\u8fc1\u79fb\u5f00\u59cb\u6267\u884c\u3002", (String)"FontsUpgradeService_0", (String)"bos-print-business", (Object[])new Object[0]));
        int count = 0;
        int success = 0;
        Map fontManageMap = BusinessDataServiceHelper.loadFromCache((String)"bos_fontmanagement", (String)"id,number,name,fontname,tenantid,creator,createtime,modifier,modifytime", null);
        List pkIds = fontManageMap.keySet().stream().map(pkId -> String.valueOf(pkId)).collect(Collectors.toList());
        count = pkIds.size();
        QFilter[] attachmentFilters = new QFilter[]{new QFilter("FInterID", "in", pkIds), new QFilter("FBillType", "=", (Object)"bos_fontmanagement")};
        Map attachments = BusinessDataServiceHelper.loadFromCache((String)"bos_attachment", (QFilter[])attachmentFilters);
        HashMap<String, DynamicObject> attachMap = new HashMap<String, DynamicObject>(16);
        for (DynamicObject dynamicObject : attachments.values()) {
            attachMap.put(dynamicObject.getString("FInterID"), dynamicObject);
        }
        for (Map.Entry entry : fontManageMap.entrySet()) {
            Throwable throwable;
            Object fontId = entry.getKey();
            DynamicObject fontMag = (DynamicObject)entry.getValue();
            if (!attachMap.containsKey(String.valueOf(fontId))) continue;
            DynamicObject attObj = (DynamicObject)attachMap.get(String.valueOf(fontId));
            String url = attObj.getString("FFileId");
            long pkId2 = fontMag.getLong("id");
            long rcId = this.getLongId();
            String fontNum = null;
            try {
                throwable = null;
                try (InputStream inputStream = FileServiceFactory.getAttachmentFileService().getInputStream(url);){
                    Font font = Font.createFont(0, inputStream);
                    fontNum = font.getFamily(Locale.ENGLISH);
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (Exception e) {
                logger.error("\u5b57\u4f53\u8fc1\u79fb\u5931\u8d25" + fontId, (Throwable)e);
                continue;
            }
            try {
                TXHandle tx = TX.required();
                throwable = null;
                try {
                    this.saveResource(rcId, pkId2, attObj);
                    this.saveFont(rcId, pkId2, fontNum, fontMag);
                    logger.info("\u5b57\u4f53\u8fc1\u79fb\u6210\u529f" + fontId);
                    ++success;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (tx == null) continue;
                    if (throwable != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    tx.close();
                }
            }
            catch (Exception e) {
                logger.error("\u5b57\u4f53\u8fc1\u79fb\u5f02\u5e38" + fontId, (Throwable)e);
            }
        }
        result.setLog(String.format(ResManager.loadKDString((String)"\u6253\u5370\u5b57\u4f53\u8fc1\u79fb\u6267\u884c\u5b8c\u6210: \u603b\u5171%s\u6761\uff0c\u6210\u529f%s\u6761\u3002", (String)"FontsUpgradeService_1", (String)"bos-print-business", (Object[])new Object[0]), count, success));
    }

    private void saveResource(long rcId, long pkId, DynamicObject attObj) {
        String insertSql = "insert into t_svc_printresource(fid,filename,filetype,ftype,filesize,fprinttplid,fpowerscope,fcreatorid,fcreatetime,furl,fdata) values(?,?,?,?,?,?,?,?,?,?,?)";
        String delSql = "delete from t_svc_printresource where fid=?";
        Object[] sqlParams = new SqlParameter[11];
        String name = attObj.getString("FAttachmentName");
        String fileType = name.substring(name.lastIndexOf(46) + 1);
        sqlParams[0] = new SqlParameter("fid", -5, (Object)rcId);
        sqlParams[1] = new SqlParameter("filename", -9, (Object)name);
        sqlParams[2] = new SqlParameter("filetype", 12, (Object)fileType);
        sqlParams[3] = new SqlParameter("ftype", 12, (Object)"3");
        sqlParams[4] = new SqlParameter("filesize", -5, (Object)"-1");
        sqlParams[5] = new SqlParameter("fprinttplid", 12, (Object)pkId);
        sqlParams[6] = new SqlParameter("fpowerscope", 12, (Object)"4");
        sqlParams[7] = new SqlParameter("fcreatorid", -5, (Object)attObj.getLong("fcreatemen_id"));
        sqlParams[8] = new SqlParameter("fcreatetime", 91, (Object)new Date());
        sqlParams[9] = new SqlParameter("furl", 12, (Object)attObj.getString("FFileId"));
        sqlParams[10] = new SqlParameter("fdata", 2004, null);
        DB.execute((DBRoute)DBRoute.basedata, (String)delSql, (Object[])new SqlParameter[]{new SqlParameter("fid", -5, (Object)rcId)});
        DB.execute((DBRoute)DBRoute.basedata, (String)insertSql, (Object[])sqlParams);
    }

    private void saveFont(long rcId, long pkId, String fontNumber, DynamicObject fontMag) {
        String insertSql = "insert into t_svc_printfont(fid,fbillno,fnumber,fname,frcid,ftenantid,fsource,fordernum,fcreatorid,fcreatetime,fmodifierid,fmodifytime,fbillstatus,falias) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        String delSql = "delete from t_svc_printfont where fid=?";
        ILocaleString fontLoacleName = (ILocaleString)fontMag.get("name");
        Object[] sqlParams = new SqlParameter[]{new SqlParameter("fid", -5, (Object)pkId), new SqlParameter("fbillno", 12, (Object)pkId), new SqlParameter("fnumber", 12, (Object)fontNumber), new SqlParameter("fname", 12, fontMag.get("fontname")), new SqlParameter("frcid", 12, (Object)rcId), new SqlParameter("ftenantid", 12, fontMag.get("tenantid")), new SqlParameter("fsource", 12, (Object)"2"), new SqlParameter("fordernum", 12, (Object)100), new SqlParameter("fcreatorid", -5, fontMag.get("creator_id")), new SqlParameter("fcreatetime", 91, fontMag.get("createtime")), new SqlParameter("fmodifierid", 91, fontMag.get("modifier_id")), new SqlParameter("fmodifytime", 91, fontMag.get("modifytime")), new SqlParameter("fbillstatus", 91, (Object)"B"), new SqlParameter("falias", 91, (Object)fontLoacleName.getLocaleValue_zh_CN())};
        String delSqlL = "delete from t_svc_printfont_l where fid=? ";
        String insertSqlL = "insert into t_svc_printfont_l(fpkid,fid,flocaleid,falias) values(?,?,?,?)";
        ArrayList<SqlParameter[]> list = new ArrayList<SqlParameter[]>(10);
        for (Map.Entry entry : fontLoacleName.entrySet()) {
            SqlParameter[] sqlParamsL = new SqlParameter[]{new SqlParameter("fpkid", 12, (Object)this.genStringId()), new SqlParameter("fid", 12, (Object)pkId), new SqlParameter("flocaleid", 12, entry.getKey()), new SqlParameter("falias", 12, entry.getValue())};
            list.add(sqlParamsL);
        }
        DB.execute((DBRoute)DBRoute.basedata, (String)delSql, (Object[])new SqlParameter[]{new SqlParameter("fid", -5, (Object)pkId)});
        DB.execute((DBRoute)DBRoute.basedata, (String)insertSql, (Object[])sqlParams);
        DB.execute((DBRoute)DBRoute.basedata, (String)delSqlL, (Object[])new SqlParameter[]{new SqlParameter("fid", -5, (Object)pkId)});
        DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSqlL, list);
    }

    private long getLongId() {
        return DB.genLongId((String)"t_svc_printresource");
    }

    private String genStringId() {
        return DB.genStringId((String)"t_svc_printfont_l");
    }
}

