/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.upgrade;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class ManagePrintTplAddNameAndNumberUpgradeService
implements IUpgradeService {
    private static Log logger = LogFactory.getLog(ManagePrintTplAddNameAndNumberUpgradeService.class);
    private int batchCount = 500;
    private List<String> errList = new ArrayList<String>(10);

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        try {
            this.upgrate(result);
        }
        catch (Exception e) {
            result.setErrorInfo(e.getMessage());
            result.setSuccess(false);
            logger.error("\u6a21\u7248\u7f16\u7801\u540d\u79f0\u540c\u6b65\u5931\u8d25", (Throwable)e);
        }
        return result;
    }

    private void upgrate(UpgradeResult result) {
        List<Map<Long, String>> allPkIdListMap = this.getAllPkIdListMap();
        for (Map<Long, String> map : allPkIdListMap) {
            this.upgrateNameAndNumber(map);
        }
        int size = 0;
        for (Map<Long, String> map : allPkIdListMap) {
            size += map.size();
        }
        this.errList.add(0, String.format(ResManager.loadKDString((String)"\u6a21\u7248\u7f16\u7801\u540d\u79f0\u8fc1\u79fb\u5b8c\u6210,\u603b\u8ba1(%1$s),\u5931\u8d25\uff08%2$s)", (String)"ManagePrintTplAddNameAndNumberUpgradeService_0", (String)"bos-print-business", (Object[])new Object[0]), size, this.errList.size()));
        String string = StringUtils.join((Object[])this.errList.toArray(), (String)";\n");
        result.setErrorInfo(string);
        logger.info(string);
    }

    /*
     * WARNING - void declaration
     */
    private void upgrateNameAndNumber(Map<Long, String> allPkIdMap) {
        void var14_24;
        Object[] fPrintTplIds = allPkIdMap.values().toArray();
        SqlBuilder sqlBuilder1 = new SqlBuilder();
        sqlBuilder1.append("select fid,fnumber from t_svc_printmeta where ", new Object[0]);
        sqlBuilder1.appendIn("fid", fPrintTplIds);
        List loadNumberMapList = (List)DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)sqlBuilder1, resultSet -> {
            ArrayList res = new ArrayList(10);
            while (resultSet.next()) {
                String fid = resultSet.getString("fid");
                String number = resultSet.getString("fnumber");
                HashMap<String, String> map = new HashMap<String, String>(3);
                map.put("id", fid);
                map.put("number", number);
                res.add(map);
            }
            return res;
        });
        SqlBuilder sqlBuilder2 = new SqlBuilder();
        sqlBuilder2.append("select fid,fname from t_svc_printmeta_l where ", new Object[0]);
        sqlBuilder2.appendIn("fid", fPrintTplIds);
        Map loadNameMap = (Map)DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)sqlBuilder2, resultSet -> {
            HashMap<String, LocaleString> res = new HashMap<String, LocaleString>(10);
            while (resultSet.next()) {
                String fid = resultSet.getString("fid");
                String name = resultSet.getString("fname");
                LocaleString map = res.getOrDefault(fid, new LocaleString());
                map.put("id", (Object)fid);
                map.put("name", (Object)name);
                res.put(fid, map);
            }
            return res;
        });
        if (CollectionUtils.isEmpty((Collection)loadNumberMapList)) {
            return;
        }
        HashMap numberMap = new HashMap(16);
        HashMap nameMap = new HashMap(16);
        for (Map map : loadNumberMapList) {
            ILocaleString localeName;
            Object v = map.get("id");
            String number = (String)map.get("number");
            if (StringUtils.isNotBlank((CharSequence)number)) {
                numberMap.put(v, number);
            }
            if (CollectionUtils.isEmpty((Map)(localeName = (ILocaleString)loadNameMap.get(v)))) continue;
            nameMap.put(v, localeName);
        }
        String updateNumberSql = "update t_bas_printtplinfo set fnumber = ? where fprinttplid=?";
        ArrayList<SqlParameter[]> numberParamsList = new ArrayList<SqlParameter[]>(10);
        for (Object object : fPrintTplIds) {
            if (!numberMap.containsKey(object)) continue;
            SqlParameter[] sqlParameterArray = new SqlParameter[]{new SqlParameter("fnumber", 12, (Object)numberMap.getOrDefault(object, " ")), new SqlParameter("fprinttplid", 12, object)};
            numberParamsList.add(sqlParameterArray);
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("delete from t_bas_printtplinfo_l where ", new Object[0]);
        sqlBuilder.appendIn("fid", new ArrayList<Long>(allPkIdMap.keySet()));
        ArrayList nameParamsList = new ArrayList(10);
        String insertNameSql = "insert into t_bas_printtplinfo_l (fpkid,fid,flocaleid,fname) values (?,?,?,?)";
        for (Map.Entry<Long, String> entry : allPkIdMap.entrySet()) {
            Long id = entry.getKey();
            String printTplId = entry.getValue();
            ILocaleString localeName = (ILocaleString)nameMap.get(printTplId);
            if (CollectionUtils.isEmpty((Map)localeName)) continue;
            localeName.forEach((key, value) -> {
                String pkId = ID.genStringId();
                SqlParameter[] sqlParameters = new SqlParameter[]{new SqlParameter("fpkid", 12, (Object)pkId), new SqlParameter("fid", -5, (Object)id), new SqlParameter("flocaleid", 12, key), new SqlParameter("fname", 12, (Object)(StringUtils.isBlank((CharSequence)value) ? " " : value))};
                nameParamsList.add(sqlParameters);
            });
        }
        Object var14_22 = null;
        try (TXHandle tXHandle = TX.required();){
            try {
                DB.executeBatch((DBRoute)DBRoute.basedata, (String)updateNumberSql, numberParamsList);
                DB.execute((DBRoute)DBRoute.basedata, (SqlBuilder)sqlBuilder);
                if (!CollectionUtils.isEmpty(nameParamsList)) {
                    DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertNameSql, nameParamsList);
                }
            }
            catch (Exception e) {
                Exception exception = e;
                logger.error((Throwable)e);
                tXHandle.markRollback();
            }
        }
        if (var14_24 != null) {
            this.tryAgain(allPkIdMap, (Exception)var14_24);
        }
    }

    private void tryAgain(Map<Long, String> allPkIdMap, Exception e) {
        LinkedHashMap map = new LinkedHashMap(16);
        int count = 500;
        int size = allPkIdMap.size();
        if (size == 1) {
            String message = e.getMessage();
            this.errList.add(String.format("tryAgain fail %s", allPkIdMap.toString()) + message);
        } else {
            count = size > 100 ? 100 : (size > 10 ? 10 : 1);
        }
        int finalCount = count;
        allPkIdMap.forEach((key, value) -> {
            map.put(key, value);
            if (map.size() >= finalCount) {
                this.upgrateNameAndNumber(map);
                map.clear();
            }
        });
    }

    private List<Map<Long, String>> getAllPkIdListMap() {
        ArrayList<Map<Long, String>> res = new ArrayList<Map<Long, String>>(10);
        String selectSql = "select fid,fprinttplid from t_bas_printtplinfo";
        DB.query((DBRoute)DBRoute.basedata, (String)selectSql, rSet -> {
            LinkedHashMap<Long, String> map = new LinkedHashMap<Long, String>(10);
            while (rSet.next()) {
                Long id = rSet.getLong(1);
                String fprinttplid = rSet.getString(2);
                if (StringUtils.isBlank((CharSequence)fprinttplid)) continue;
                map.put(id, fprinttplid);
                if (map.size() < this.batchCount) continue;
                LinkedHashMap<Long, String> mapCopy = new LinkedHashMap<Long, String>(map.size());
                mapCopy.putAll(map);
                res.add(mapCopy);
                map.clear();
            }
            if (map.size() > 0) {
                res.add(map);
            }
            return map;
        });
        return res;
    }
}

