/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.upgrade;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class UpgradeOldTplService
implements IUpgradeService {
    private static Log logger = LogFactory.getLog(UpgradeOldTplService.class);
    private int totalSum;
    private int errSum;
    private List<String> errList;

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        try {
            this.upgrate(result);
        }
        catch (Exception e) {
            result.setErrorInfo(e.getMessage());
            result.setSuccess(false);
            logger.error("\u6a21\u7248\u8fc1\u79fb\u5931\u8d25", (Throwable)e);
        }
        return result;
    }

    private void upgrate(UpgradeResult result) {
        this.totalSum = 0;
        this.errSum = 0;
        this.errList = new ArrayList<String>();
        String delSql = "delete from t_svc_printmeta where ftype='A' ";
        String delLSql = "delete from t_svc_printmeta_l where fid in(select fid from t_svc_printmeta where ftype='A'  )";
        try (TXHandle tx = TX.required();){
            DB.execute((DBRoute)DBRoute.basedata, (String)delLSql, null);
            DB.execute((DBRoute)DBRoute.basedata, (String)delSql, null);
        }
        String updateSql = "update t_bas_printtplinfo set ftype='A' where ftype <> 'B'";
        DB.execute((DBRoute)DBRoute.basedata, (String)updateSql, null);
        List<String> pkList = this.getAllPkIds();
        this.totalSum = pkList.size();
        this.transOldTpl(pkList, 500);
        DataEntityCacheManager cacheManager = new DataEntityCacheManager("t_svc_printmeta");
        cacheManager.removeByDt();
        this.errList.add(0, String.format(ResManager.loadKDString((String)"\u6a21\u7248\u8fc1\u79fb\u5b8c\u6210,\u603b\u8ba1(%1$s),\u5931\u8d25\uff08%2$s)\u3002", (String)"UpgradeOldTplService_0", (String)"bos-print-business", (Object[])new Object[0]), this.totalSum, this.errSum));
        String lastMsg = StringUtils.join((Object[])this.errList.toArray(), (String)";\n");
        result.setErrorInfo(lastMsg);
        logger.info(lastMsg);
    }

    private void transOldTpl(List<String> pkList, int batchCount) {
        ArrayList<String> queryPks = new ArrayList<String>();
        for (String pk : pkList) {
            if (queryPks.size() < batchCount) {
                queryPks.add(pk);
                continue;
            }
            this.transOldTpl(queryPks);
            queryPks.clear();
            queryPks.add(pk);
        }
        if (!queryPks.isEmpty()) {
            this.transOldTpl(queryPks);
            queryPks.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transOldTpl(List<String> pkIds) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select F.fid,F.fnumber,F.fmodifierid,F.fcreatedate,F.fmodifydate,F.fbizappid,F.fisv,E.fnumber fbillformid from t_meta_formdesign F left join t_meta_entitydesign E on F.fentityid=E.fid where ", new Object[0]);
        sqlBuilder.appendIn("F.fid", pkIds.toArray());
        String insertSql = "insert into t_svc_printmeta(fid,fmasterid,fnumber,fname,fbillformid,fcreatorid,fcreatetime,fmodifierid,fmodifytime,fbizappid,ftpltype,ftype,fstatus,fenable,fversion) values(?,?,?,?,?,?,?,?,?,?,?,'A','B','1','1') ";
        List insertSqlParams = (List)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sqlBuilder, rSet -> {
            ArrayList<SqlParameter[]> list = new ArrayList<SqlParameter[]>(10);
            while (rSet.next()) {
                long modifyid = 0L;
                Object modifierId = rSet.getObject("fmodifierid");
                if (StringUtils.isBlank((Object)modifierId)) {
                    try {
                        modifyid = Long.parseLong(modifierId.toString());
                    }
                    catch (Exception e) {
                        modifyid = 0L;
                        logger.info("\u4fee\u6539\u4eba\u8f6c\u6362\u4e3aLong\u5931\u8d25\uff1a", (Object)e);
                    }
                }
                SqlParameter[] sqlParams = new SqlParameter[11];
                sqlParams[0] = new SqlParameter("fid", 12, (Object)rSet.getString("fid"));
                sqlParams[1] = new SqlParameter("fmasterid", 12, (Object)rSet.getString("fid"));
                sqlParams[2] = new SqlParameter("fnumber", 12, (Object)rSet.getString("fnumber"));
                sqlParams[3] = new SqlParameter("fname", 12, (Object)" ");
                sqlParams[4] = new SqlParameter("fbillformid", 12, (Object)rSet.getString("fbillformid"));
                sqlParams[5] = new SqlParameter("fcreatorid", -5, (Object)modifyid);
                sqlParams[6] = new SqlParameter("fcreatetime", 91, (Object)rSet.getDate("fcreatedate"));
                sqlParams[7] = new SqlParameter("fmodifierid", -5, (Object)modifyid);
                sqlParams[8] = new SqlParameter("fmodifytime", 91, (Object)rSet.getDate("fmodifydate"));
                sqlParams[9] = new SqlParameter("fbizappid", 12, (Object)rSet.getString("fbizappid"));
                String ftpltype = StringUtils.equalsIgnoreCase((CharSequence)rSet.getString("fisv"), (CharSequence)"kingdee") ? "1" : "0";
                sqlParams[10] = new SqlParameter("ftpltype", 12, (Object)ftpltype);
                list.add(sqlParams);
            }
            return list;
        });
        SqlBuilder sqlBuilderL = new SqlBuilder();
        sqlBuilderL.append("select fpkid,fid,flocaleid,fname from t_meta_formdesign_l where ", new Object[0]);
        sqlBuilderL.appendIn("fid", pkIds.toArray());
        String insertSqlL = "insert into t_svc_printmeta_L(FPKID,FID,FLOCALEID,FNAME) values(?,?,?,?)";
        List insertSqlParamsL = (List)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sqlBuilderL, rSet -> {
            ArrayList<SqlParameter[]> list = new ArrayList<SqlParameter[]>(4);
            while (rSet.next()) {
                SqlParameter[] sqlParams = new SqlParameter[]{new SqlParameter("fpkid", 12, (Object)DB.genStringId((String)"t_meta_formdesign_l")), new SqlParameter("fid", 12, (Object)rSet.getString("fid")), new SqlParameter("flocaleid", 12, (Object)rSet.getString("flocaleid")), new SqlParameter("fname", 12, (Object)rSet.getString("fname"))};
                list.add(sqlParams);
            }
            return list;
        });
        Exception ex = null;
        try (TXHandle tx = TX.required();){
            DB.executeBatch((DBRoute)DBRoute.base, (String)insertSql, (List)insertSqlParams);
            if (insertSqlParamsL.size() > 0) {
                DB.executeBatch((DBRoute)DBRoute.base, (String)insertSqlL, (List)insertSqlParamsL);
            }
        }
        if (ex != null) {
            int size = pkIds.size();
            if (size == 1) {
                this.handErrTpl((Object[])insertSqlParams.get(0), insertSqlParamsL, ex);
            } else if (size > 100) {
                this.transOldTpl(pkIds, 100);
            } else if (size > 10) {
                this.transOldTpl(pkIds, 10);
            } else {
                this.transOldTpl(pkIds, 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handErrTpl(Object[] insertSqlParams, List<Object[]> insertSqlParamsL, Exception ex) {
        KDException kdBizException;
        ErrorCode errorCode;
        boolean handFlag = false;
        if (ex instanceof KDException && "bos.sQLDuplicateKey".equals((errorCode = (kdBizException = (KDException)ex).getErrorCode()).getCode())) {
            SqlParameter insertSqlParam = (SqlParameter)insertSqlParams[2];
            insertSqlParam.setValue((Object)(insertSqlParam.getValue() + "(old)"));
            handFlag = true;
        }
        if (!handFlag) {
            String msg = String.format(ResManager.loadKDString((String)"\u5185\u7801\u3010%1$s\u3011,\u7f16\u53f7\u3010%2$s\u3011\u6a21\u7248\u8fc1\u79fb\u5931\u8d25,\u9519\u8bef\u539f\u56e0\uff1a%3$s\u3002", (String)"UpgradeOldTplService_1", (String)"bos-print-business", (Object[])new Object[0]), insertSqlParams[0], insertSqlParams[2], ex.getMessage());
            ++this.errSum;
            this.errList.add(msg);
            return;
        }
        String insertSql = "insert into t_svc_printmeta(fid,fmasterid,fnumber,fname,fbillformid,fcreatorid,fcreatetime,fmodifierid,fmodifytime,fbizappid,ftpltype,ftype,fstatus,fenable,fversion) values(?,?,?,?,?,?,?,?,?,?,?,'A','B','1','1') ";
        String insertSqlL = "insert into t_svc_printmeta_L(FPKID,FID,FLOCALEID,FNAME) values(?,?,?,?)";
        try (TXHandle tx = TX.required();){
            DB.execute((DBRoute)DBRoute.base, (String)insertSql, (Object[])insertSqlParams);
            if (insertSqlParamsL.size() > 0) {
                DB.executeBatch((DBRoute)DBRoute.base, (String)insertSqlL, insertSqlParamsL);
            }
        }
    }

    private List<String> getAllPkIds() {
        String selectSql = "select fid from t_meta_formdesign where fmodeltype='PrintModel' ";
        List pkList = (List)DB.query((DBRoute)DBRoute.meta, (String)selectSql, rSet -> {
            ArrayList<String> list = new ArrayList<String>(10);
            while (rSet.next()) {
                list.add(rSet.getString(1));
            }
            return list;
        });
        return pkList;
    }
}

