/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.utils;

import java.util.HashSet;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.param.CustomParam;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.util.StringUtils;
import org.apache.commons.lang.ObjectUtils;

public class PrintParamUtils {
    private static final int MAX_BILLNO_CREATE_FILE_NUM = 100;
    private static boolean BOS_PRINT_BIZTYPE_EXT = false;

    public static boolean isTemplateOrgIsolated() {
        String suffix = "printtpl.org.enable";
        String tenantId = RequestContext.get().getTenantId();
        String value = System.getProperty(tenantId + "_" + suffix, "false");
        return Boolean.parseBoolean(value);
    }

    public static int getMaxBillNoCreateFileNum() {
        Map customParam = SystemParamServiceHelper.loadCustomParameterFromCache((CustomParam)new CustomParam());
        String maxZipFileNum = (String)customParam.get("MAX_BILLNO_CREATE_FILE_NUM");
        if (StringUtils.isNumeric((String)maxZipFileNum)) {
            try {
                return Integer.parseInt(maxZipFileNum);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 100;
    }

    public static boolean isOpenBizTypeExt() {
        CustomParam customParam = new CustomParam();
        customParam.setGroupNumber("kd_svc_customerparam");
        HashSet<String> set = new HashSet<String>();
        set.add("BOS_PRINT_BIZTYPE_EXT");
        customParam.setSearchKeySet(set);
        Map parameterMap = SystemParamServiceHelper.loadCustomParameterFromCache((CustomParam)customParam);
        String bizTypeExt = parameterMap.getOrDefault("BOS_PRINT_BIZTYPE_EXT", "false");
        if (!ObjectUtils.equals((Object)bizTypeExt, (Object)BOS_PRINT_BIZTYPE_EXT)) {
            EntityMetadataCache.removeDataEntityTypeLocalCache((String)"bos_manageprinttpl");
        }
        BOS_PRINT_BIZTYPE_EXT = Boolean.parseBoolean(bizTypeExt);
        return BOS_PRINT_BIZTYPE_EXT;
    }
}

