/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.util.StringUtils;
import kd.data.idi.data.BudgetConfig;
import kd.data.idi.util.IDIJSONUtils;

public class IDIBudgetFormPlugin
extends AbstractFormPlugin {
    private static final String KEY_CONTROL_OK = "btnok";
    private static final String KEY_PARAMETER_ENTITYNUMBER = "entitynumber";
    private static final String KEY_PARAMETER_DETAILCONFIG = "detailConfig";
    private static final String KEY_FIELD_AMOUNTFIELD = "amountfield";
    private static final String KEY_FIELD_DETECTEDTEXT = "detectedtext";
    private static final String KEY_FIELD_NOTDETECTEDTEXT = "notdetectedtext";
    private static final String KEY_FIELD_DETECTEDICON = "detectedicon";
    private static final String KEY_FIELD_NOTDETECTEDICON = "notdetectedicon";
    private static final String KEY_PARAMETER_ONLYHEADFIELD = "onlyheadfield";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_CONTROL_OK});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        switch (key = ctl.getKey()) {
            case "btnok": {
                if (!this.validate()) break;
                String result = this.save();
                this.getView().returnDataToParent((Object)result);
                this.getView().close();
            }
        }
    }

    private String save() {
        BudgetConfig bc = new BudgetConfig();
        IDataModel model = this.getModel();
        bc.setAmountField((String)model.getValue(KEY_FIELD_AMOUNTFIELD));
        bc.setDetectedIcon((String)model.getValue(KEY_FIELD_DETECTEDICON));
        bc.setDetectedText((String)model.getValue(KEY_FIELD_DETECTEDTEXT));
        bc.setNotDetectedIcon((String)model.getValue(KEY_FIELD_NOTDETECTEDICON));
        bc.setNotDetectedText((String)model.getValue(KEY_FIELD_NOTDETECTEDTEXT));
        return IDIJSONUtils.toJsonString((Object)bc);
    }

    private boolean validate() {
        String amountField = (String)this.getModel().getValue(KEY_FIELD_AMOUNTFIELD);
        if (StringUtils.isEmpty((String)amountField)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6e90\u5355\u68c0\u67e5\u5b57\u6bb5\u3002", (String)"IDIBudgetFormPlugin_0", (String)"data-idi-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void afterCreateNewData(EventObject e) {
        boolean isOnlyHeadField;
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String entityNumber = (String)fsp.getCustomParam(KEY_PARAMETER_ENTITYNUMBER);
        String detailConfig = (String)fsp.getCustomParam(KEY_PARAMETER_DETAILCONFIG);
        String onlyHeadField = (String)fsp.getCustomParam(KEY_PARAMETER_ONLYHEADFIELD);
        boolean bl = isOnlyHeadField = !StringUtils.isBlank((String)onlyHeadField) && Boolean.parseBoolean(onlyHeadField);
        if (StringUtils.isNotEmpty((String)entityNumber)) {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            EntityTypeUtil helper = new EntityTypeUtil();
            List cols = helper.getFilterColumns((IDataEntityType)entityType, isOnlyHeadField);
            this.initAmountFieldCombo(cols, isOnlyHeadField, entityNumber);
        }
        if (!StringUtils.isEmpty((String)detailConfig)) {
            BudgetConfig bc = (BudgetConfig)IDIJSONUtils.cast((String)detailConfig, BudgetConfig.class);
            IDataModel model = this.getModel();
            model.setValue(KEY_FIELD_AMOUNTFIELD, (Object)bc.getAmountField());
            model.setValue(KEY_FIELD_DETECTEDTEXT, (Object)bc.getDetectedText());
            model.setValue(KEY_FIELD_DETECTEDICON, (Object)bc.getDetectedIcon());
            model.setValue(KEY_FIELD_NOTDETECTEDTEXT, (Object)bc.getNotDetectedText());
            model.setValue(KEY_FIELD_NOTDETECTEDICON, (Object)bc.getNotDetectedIcon());
        }
    }

    private void initAmountFieldCombo(List<Map<String, Object>> filterFieldList, boolean isOnlyHeadField, String entityNumber) {
        if (filterFieldList == null) {
            return;
        }
        ArrayList<ComboItem> list = new ArrayList<ComboItem>();
        for (Map<String, Object> map : filterFieldList) {
            String type = (String)map.get("type");
            if (!"number".equalsIgnoreCase(type)) continue;
            String entryEntity = (String)map.get("entryEntity");
            String fieldName = (String)map.get("fieldName");
            String fieldCaption = (String)map.get("fieldCaption");
            LocaleString localeString = new LocaleString();
            localeString.setLocaleValue(fieldCaption);
            String value = fieldName;
            if (!StringUtils.isEmpty((String)entryEntity) && !entityNumber.equals(entryEntity)) {
                value = entryEntity + "." + fieldName;
            }
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(localeString);
            comboItem.setValue(value);
            list.add(comboItem);
        }
        if (!list.isEmpty()) {
            ComboEdit comboEdit = (ComboEdit)this.getControl(KEY_FIELD_AMOUNTFIELD);
            comboEdit.setComboItems(list);
        }
    }
}

