/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.formplugin;

import java.io.Serializable;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.service.KDDateFormatUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.data.idi.util.IDIJSONUtils;

public class IDIDimensionValueFormPlugin
extends AbstractFormPlugin {
    private static final String CONTROL_OK = "btnok";
    private static final String CUSTOM_PARAM = "param";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{CONTROL_OK});
    }

    public void afterCreateNewData(EventObject e) {
        DimParam dp = this.getCustomParam();
        if (dp != null) {
            this.settingFieldVisible(dp);
            this.initFieldValue(dp);
        }
    }

    public void click(EventObject evt) {
        DimParam dp;
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        if (CONTROL_OK.equals(key) && (dp = this.getCustomParam()) != null) {
            MultiFuncFieldSelectEnum fieldSelectEnum = dp.getFieldSelectEnum();
            Object enumValue = model.getValue(fieldSelectEnum.getCode());
            if (enumValue == null || String.valueOf(enumValue).isEmpty()) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"IDIDimensionValueFormPlugin_0", (String)"data-idi-formplugin", (Object[])new Object[0]));
                return;
            }
            HashMap<String, String> dataMap = new HashMap<String, String>(2);
            String dataStr = fieldSelectEnum.toString(enumValue);
            dataMap.put(dataStr, dataStr);
            switch (fieldSelectEnum) {
                case TEXT: 
                case DATE: {
                    view.returnDataToParent(dataMap);
                    break;
                }
                case COMBO: {
                    List<ComboItem> comboItems = dp.genComboItem();
                    Optional<ComboItem> selectItem = comboItems.stream().filter(item -> dataStr.equals(item.getValue())).findAny();
                    selectItem.ifPresent(comboItem -> dataMap.put(dataStr, comboItem.getCaption().toString()));
                    view.returnDataToParent(dataMap);
                    break;
                }
                default: {
                    throw new KDBizException("unsupported type in click");
                }
            }
            view.close();
        }
    }

    private void initFieldValue(DimParam dp) {
        MultiFuncFieldSelectEnum fieldSelectEnum = dp.getFieldSelectEnum();
        String valueStr = dp.getData();
        switch (fieldSelectEnum) {
            case TEXT: {
                this.getModel().setValue(fieldSelectEnum.getCode(), (Object)valueStr);
                break;
            }
            case DATE: {
                Object value = fieldSelectEnum.convertData(valueStr);
                this.getModel().setValue(fieldSelectEnum.getCode(), value);
                break;
            }
            case COMBO: {
                this.getModel().setValue(fieldSelectEnum.getCode(), (Object)valueStr);
                ComboEdit comboEdit = (ComboEdit)this.getControl(fieldSelectEnum.getCode());
                comboEdit.setComboItems(dp.genComboItem());
                break;
            }
            default: {
                throw new KDBizException("unsupported type in set value");
            }
        }
    }

    private void settingFieldVisible(DimParam dp) {
        MultiFuncFieldSelectEnum fieldSelectEnum = dp.getFieldSelectEnum();
        String[] visibleFieldNumbers = (String[])Stream.of(fieldSelectEnum.getCode()).toArray(String[]::new);
        this.getView().setVisible(Boolean.TRUE, visibleFieldNumbers);
    }

    private DimParam getCustomParam() {
        String paramStr = (String)this.getView().getFormShowParameter().getCustomParam(CUSTOM_PARAM);
        if (StringUtils.isEmpty((String)paramStr)) {
            return null;
        }
        return (DimParam)IDIJSONUtils.cast((String)paramStr, DimParam.class);
    }

    public static void openDefaultValueFillingPage(AbstractFormPlugin plugIn, String field, String value, String dimensionId, String closeActionId) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("idi_dimensionvalue");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugIn, closeActionId));
        DimParam dp = new DimParam(MultiFuncFieldSelectEnum.getEnumByCode(field), dimensionId, value);
        formShowParameter.setCustomParam(CUSTOM_PARAM, (Object)IDIJSONUtils.toJsonString((Object)dp));
        plugIn.getView().showForm(formShowParameter);
    }

    public static enum MultiFuncFieldSelectEnum {
        TEXT("text"),
        DATE("date"),
        COMBO("combo");

        private final String code;

        private MultiFuncFieldSelectEnum(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }

        public static MultiFuncFieldSelectEnum getEnumByCode(String code) {
            for (MultiFuncFieldSelectEnum enums : MultiFuncFieldSelectEnum.values()) {
                if (!enums.getCode().equals(code)) continue;
                return enums;
            }
            throw new KDBizException("not exit MultiFuncFieldSelectEnum by " + code);
        }

        public Object convertData(String data) {
            if (this == DATE) {
                try {
                    return KDDateFormatUtils.getDateFormat().parse(data);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return data;
        }

        public String toString(Object data) {
            if (this == DATE) {
                try {
                    return KDDateFormatUtils.getDateFormat().format(data);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return data == null ? null : String.valueOf(data);
        }
    }

    protected static class DimParam
    implements Serializable {
        public static final long serialVersionUID = 8222040969094219724L;
        MultiFuncFieldSelectEnum fieldSelectEnum;
        String dimIdStr;
        String data;

        public DimParam(MultiFuncFieldSelectEnum fieldSelectEnum, String dimIdStr, String data) {
            this.fieldSelectEnum = fieldSelectEnum;
            this.dimIdStr = dimIdStr;
            this.data = data;
        }

        public MultiFuncFieldSelectEnum getFieldSelectEnum() {
            return this.fieldSelectEnum;
        }

        public void setFieldSelectEnum(MultiFuncFieldSelectEnum fieldSelectEnum) {
            this.fieldSelectEnum = fieldSelectEnum;
        }

        public String getDimIdStr() {
            return this.dimIdStr;
        }

        public void setDimIdStr(String dimIdStr) {
            this.dimIdStr = dimIdStr;
        }

        public String getData() {
            return this.data;
        }

        public void setData(String data) {
            this.data = data;
        }

        public List<ComboItem> genComboItem() {
            if (StringUtils.isEmpty((String)this.dimIdStr)) {
                throw new KDBizException("dimsnion is null");
            }
            if (this.fieldSelectEnum != MultiFuncFieldSelectEnum.COMBO) {
                throw new KDBizException("unsupported type");
            }
            DynamicObject dimension = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(this.dimIdStr), (String)"pa_dimension");
            return dimension.getDynamicObjectCollection("entryentityenums").stream().map(obj -> new ComboItem(new LocaleString(obj.getString("title")), obj.getString("value"))).collect(Collectors.toList());
        }
    }
}

