/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.TextProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.data.idi.data.DimensionTypeEnum;
import kd.data.idi.data.FasindexConfig;
import kd.data.idi.data.NumericalUnitEnum;
import kd.data.idi.engine.FasindexHelper;
import kd.data.idi.formplugin.IDIDimensionValueFormPlugin;
import kd.data.idi.formplugin.IDISelectFieldDialogPlugin;
import kd.data.idi.util.IDIJSONUtils;

public class IDIFasindexFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String CUSTOM_ENTITYNUMBER = "entitynumber";
    private static final String CUSTOM_CONFIG = "detailConfig";
    private static final String CONTROL_OK = "btnok";
    private static final String ACTION_MODIFYFASINDEX = "modifyfasindex";
    private static final String ACTION_SAVEFASINDEX = "savefasindex";
    private static final String FIELD_SOURFIELDTXT = "sourcefieldtxt";
    private static final String FIELD_SOURFIELD = "sourcefield";
    private static final String FIELD_FIXVALUETXT = "fixvaluetxt";
    private static final String FIELD_FIXVALUE = "fixvalue";
    private static final String FIELD_FASINDEX = "fasindex";
    private static final String FIELD_SHOWDIMENSION = "showdimension";
    private static final String FIELD_SHOWTYPE = "showtype";
    private static final String FIELD_VALUETYPE = "valuetype";
    private static final String FIELD_DIMENSION = "dimension";
    private static final String FIELD_ORG = "org";
    private static final String FIELD_CURRENCY = "currency";
    private static final String FIELD_FASINDEXUNIT = "fasindexunit";
    private static final String FIELD_NUMERICALUNIT = "numericalunit";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String PROPERTYSEPARATOR = ".";
    private static final String ACTION_SET_DIMENSIONFIELD = "setdimensionfield";
    private static final String ACTION_SET_DIMENSIONVALUE = "setdimensionValue";
    private static final String VALIDATE_SUCCESS = "success";
    private static final String VALIDATE_FAIL = "fail";
    private static final String VALIDATE_WARN = "warn";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{CONTROL_OK, FIELD_SOURFIELDTXT, FIELD_FIXVALUETXT});
        BasedataEdit defaultDimension = (BasedataEdit)this.getControl(FIELD_SHOWDIMENSION);
        defaultDimension.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        RequestContext context = RequestContext.get();
        this.getModel().setValue(FIELD_ORG, (Object)context.getOrgId());
        String configStr = (String)this.getView().getFormShowParameter().getCustomParam(CUSTOM_CONFIG);
        if (StringUtils.isNotEmpty((String)configStr)) {
            FasindexConfig config = (FasindexConfig)IDIJSONUtils.cast((String)configStr, FasindexConfig.class);
            this.getModel().setValue(FIELD_FASINDEX, (Object)config.getFasindexId());
            this.getModel().setValue(FIELD_SHOWTYPE, (Object)config.getShowType().getType());
            this.getModel().setValue(FIELD_VALUETYPE, (Object)config.valueTypeListToStr());
            this.getModel().setValue(FIELD_NUMERICALUNIT, (Object)(config.getNumericalUnit() == null ? NumericalUnitEnum.NULL.getCode() : config.getNumericalUnit().getCode()));
            List dimensionValueList = config.getDimensionValueList();
            if (dimensionValueList == null || dimensionValueList.isEmpty()) {
                return;
            }
            Object[] showDimensionIds = new Object[dimensionValueList.size()];
            for (int i = 0; i < dimensionValueList.size(); ++i) {
                int rowIndex = this.getModel().createNewEntryRow(ENTRY_ENTITY);
                FasindexConfig.DimensionValue dv = (FasindexConfig.DimensionValue)dimensionValueList.get(i);
                this.getModel().setValue(FIELD_DIMENSION, (Object)dv.getDimensionId(), rowIndex);
                this.getModel().setValue(FIELD_SOURFIELDTXT, (Object)dv.getPropertyName(), rowIndex);
                this.getModel().setValue(FIELD_SOURFIELD, (Object)dv.getProperty(), rowIndex);
                this.getModel().setValue(FIELD_FIXVALUETXT, (Object)dv.getDisplayFixValue(), rowIndex);
                this.getModel().setValue(FIELD_FIXVALUE, (Object)dv.getFixValue(), rowIndex);
                showDimensionIds[i] = dv.getDimensionId();
            }
            this.getModel().setValue(FIELD_SHOWDIMENSION, (Object)showDimensionIds);
            this.fasindexControl((DynamicObject)this.getModel().getValue(FIELD_FASINDEX));
        }
        this.getModel().setDataChanged(false);
    }

    public void click(EventObject evt) {
        String key;
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "btnok": {
                String result = this.validate();
                if (VALIDATE_SUCCESS.equals(result)) {
                    this.doSaveData();
                    break;
                }
                if (!VALIDATE_WARN.equals(result)) break;
                if (this.getModel().getDataChanged()) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u7ef4\u5ea6\u53d6\u503c\uff0c\u5c06\u6309\u6240\u6709\u7ec4\u5408\u8ba1\u7b97\u6307\u6807\uff0c\u662f\u5426\u7ee7\u7eed\u4fdd\u5b58\uff1f", (String)"IDIFasindexFormPlugin_11", (String)"data-idi-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(ACTION_SAVEFASINDEX, (IFormPlugin)this));
                    break;
                }
                this.getView().close();
                break;
            }
            case "sourcefieldtxt": {
                this.showField();
                break;
            }
            case "fixvaluetxt": {
                this.showValue();
            }
        }
    }

    private void doSaveData() {
        FasindexConfig config = this.getReturnData();
        String returnData = IDIJSONUtils.toJsonString((Object)config);
        this.getView().returnDataToParent((Object)returnData);
        this.getView().close();
    }

    private FasindexConfig getReturnData() {
        FasindexConfig config = new FasindexConfig();
        DynamicObject fasindex = (DynamicObject)this.getModel().getValue(FIELD_FASINDEX);
        config.setFasindexId(fasindex.getLong("id"));
        config.setPrecision(fasindex.getInt("precision"));
        String showType = (String)this.getModel().getValue(FIELD_SHOWTYPE);
        config.setShowType(FasindexConfig.ShowTypeEnum.convert((String)showType));
        String valueType = (String)this.getModel().getValue(FIELD_VALUETYPE);
        config.strToValueTypeList(valueType);
        String numericalUnit = (String)this.getModel().getValue(FIELD_NUMERICALUNIT);
        config.setNumericalUnit(NumericalUnitEnum.convertFromMatchType((String)numericalUnit));
        int rowCount = this.getModel().getEntryRowCount(ENTRY_ENTITY);
        if (rowCount > 0) {
            ArrayList<FasindexConfig.DimensionValue> dimensionValueList = new ArrayList<FasindexConfig.DimensionValue>(rowCount);
            for (int i = 0; i < rowCount; ++i) {
                FasindexConfig.DimensionValue dimvalue = new FasindexConfig.DimensionValue();
                DynamicObject dim = (DynamicObject)this.getModel().getValue(FIELD_DIMENSION, i);
                dimvalue.setDimensionId(((Long)dim.getPkValue()).longValue());
                String propertyName = (String)this.getModel().getValue(FIELD_SOURFIELDTXT, i);
                String property = (String)this.getModel().getValue(FIELD_SOURFIELD, i);
                String fixValueTxt = (String)this.getModel().getValue(FIELD_FIXVALUETXT, i);
                String fixValue = (String)this.getModel().getValue(FIELD_FIXVALUE, i);
                dimvalue.setProperty(property);
                dimvalue.setPropertyName(propertyName);
                dimvalue.setDisplayFixValue(fixValueTxt);
                dimvalue.setFixValue(fixValue);
                dimvalue.setFix(StringUtils.isNotEmpty((String)fixValue));
                DimensionTypeEnum type = DimensionTypeEnum.getEnum((String)dim.getString("dimensiontype"));
                dimvalue.setBasedata(type == DimensionTypeEnum.DATABASE || type == DimensionTypeEnum.ASSISTANTDATA || type == DimensionTypeEnum.PERIOD);
                dimvalue.setPeriodDimension(this.isPeriodDimension(type, IDIFasindexFormPlugin.getDimensionSource(dim, type)));
                dimensionValueList.add(dimvalue);
            }
            config.setDimensionValueList(dimensionValueList);
        }
        return config;
    }

    private boolean isPeriodDimension(DimensionTypeEnum dimensionTypeEnum, String baseEntityId) {
        if (dimensionTypeEnum == DimensionTypeEnum.DATABASE) {
            return "bd_period".equals(baseEntityId) || "pa_analysisperiod".equals(baseEntityId);
        }
        return dimensionTypeEnum == DimensionTypeEnum.PERIOD;
    }

    private void showValue() {
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
        int rowCount = this.getModel().getEntryRowCount(ENTRY_ENTITY);
        if (rowCount > 0) {
            DimensionTypeEnum dataTypeEnum;
            DynamicObject dimension = (DynamicObject)this.getModel().getValue(FIELD_DIMENSION, currentRowIndex);
            String baseEntityId = IDIFasindexFormPlugin.getDimensionSource(dimension, dataTypeEnum = DimensionTypeEnum.getEnum((String)dimension.getString("dimensiontype")));
            if (StringUtils.isNotEmpty((String)baseEntityId)) {
                this.showBasedataForm(baseEntityId, dimension);
                return;
            }
            String field = dataTypeEnum.getField();
            if (StringUtils.isNotEmpty((String)field)) {
                this.showDimensionValueForm(currentRowIndex, field, dimension);
            }
        }
    }

    private void showDimensionValueForm(int rowIndex, String field, DynamicObject dimension) {
        String value = (String)this.getModel().getValue(FIELD_FIXVALUE, rowIndex);
        IDIDimensionValueFormPlugin.openDefaultValueFillingPage(this, field, value, String.valueOf(dimension.getPkValue()), ACTION_SET_DIMENSIONVALUE);
    }

    private void showBasedataForm(String baseEntityId, DynamicObject dimension) {
        QFilter filter;
        ListShowParameter lsp = new ListShowParameter();
        lsp.setBillFormId(baseEntityId);
        FormConfig formConfig = FormMetadataCache.getListFormConfig((String)baseEntityId);
        String FormId = formConfig == null ? "bos_listf7" : formConfig.getF7ListFormId();
        lsp.setFormId(FormId);
        lsp.getOpenStyle().setShowType(ShowType.Modal);
        if ("bos_assistantdata_detail".equals(baseEntityId)) {
            long assistantTypeId = dimension.getLong("assistantsource_id");
            lsp.getListFilterParameter().getQFilters().add(new QFilter("group", "=", (Object)assistantTypeId));
        }
        if ((filter = FasindexHelper.queryDimensionQFilter((Long)dimension.getLong("id"))) != null) {
            lsp.getListFilterParameter().getQFilters().add(filter);
        }
        lsp.setLookUp(true);
        lsp.setMultiSelect(false);
        lsp.setShowTitle(false);
        lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACTION_SET_DIMENSIONVALUE));
        StyleCss sc = new StyleCss();
        sc.setHeight("580px");
        sc.setWidth("960px");
        lsp.getOpenStyle().setInlineStyleCss(sc);
        this.getView().showForm((FormShowParameter)lsp);
    }

    private void showField() {
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
        int rowCount = this.getModel().getEntryRowCount(ENTRY_ENTITY);
        if (rowCount > 0) {
            DynamicObject dimension = (DynamicObject)this.getModel().getValue(FIELD_DIMENSION, currentRowIndex);
            DimensionTypeEnum dataTypeEnum = DimensionTypeEnum.getEnum((String)dimension.getString("dimensiontype"));
            String baseEntityId = IDIFasindexFormPlugin.getDimensionSource(dimension, dataTypeEnum);
            String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam(CUSTOM_ENTITYNUMBER);
            Map<String, String> availableField = this.matchDimensionPropertyInHeadAndEntry(entityNumber, dataTypeEnum, baseEntityId);
            String selectField = (String)this.getModel().getValue(FIELD_SOURFIELD);
            IDISelectFieldDialogPlugin.openBy(this, availableField, selectField, ACTION_SET_DIMENSIONFIELD);
        }
    }

    private Map<String, String> matchDimensionPropertyInHeadAndEntry(String entityNumber, DimensionTypeEnum dimensionTypeEnum, String baseEntityId) {
        HashMap<String, String> availableField = new HashMap<String, String>();
        this.getPropertyInHeadAndEntry(entityNumber, property -> {
            String displayName;
            String name = property.getName();
            String string = displayName = property.getDisplayName() == null ? null : property.getDisplayName().toString();
            if (this.isSelect((IDataEntityProperty)property, dimensionTypeEnum, baseEntityId) && StringUtils.isNotEmpty((String)displayName) && StringUtils.isNotEmpty((String)property.getAlias())) {
                if (property.getParent() instanceof EntryType) {
                    EntryType parentType = (EntryType)property.getParent();
                    String parentName = parentType.getName();
                    String parentDisplayName = parentType.getDisplayName() == null ? null : parentType.getDisplayName().toString();
                    String subPropertyName = parentName + PROPERTYSEPARATOR + name;
                    String subPropertyDisplayName = parentDisplayName + PROPERTYSEPARATOR + displayName;
                    availableField.put(subPropertyName, subPropertyDisplayName);
                } else {
                    availableField.put(name, displayName);
                }
            }
        });
        return availableField;
    }

    public static String getDimensionSource(DynamicObject dimension, DimensionTypeEnum dimensionTypeEnum) {
        String baseEntityId;
        switch (dimensionTypeEnum) {
            case DATABASE: 
            case PERIOD: {
                DynamicObject dimensionSource = dimension.getDynamicObject("dimensionsource");
                baseEntityId = dimensionSource.getString("number");
                break;
            }
            case ASSISTANTDATA: {
                baseEntityId = "bos_assistantdata_detail";
                break;
            }
            default: {
                baseEntityId = null;
            }
        }
        return baseEntityId;
    }

    private boolean isSelect(IDataEntityProperty property, DimensionTypeEnum dimensionTypeEnum, String baseEntityId) {
        boolean result = false;
        if (property instanceof FlexProp) {
            return result;
        }
        switch (dimensionTypeEnum) {
            case DATABASE: 
            case PERIOD: {
                result = ("bd_period".equals(baseEntityId) || "pa_analysisperiod".equals(baseEntityId)) && property instanceof DateTimeProp || property instanceof BasedataProp && ((BasedataProp)property).getBaseEntityId().equals(baseEntityId);
                break;
            }
            case ASSISTANTDATA: {
                result = property instanceof BasedataProp && ((BasedataProp)property).getBaseEntityId().equals("bos_assistantdata_detail");
                break;
            }
            case OTHER: {
                result = property instanceof TextProp;
                break;
            }
            case DATE: {
                result = property instanceof DateTimeProp;
                break;
            }
            case COMBO: {
                result = property instanceof ComboProp;
            }
        }
        return result;
    }

    private void getPropertyInHeadAndEntry(String entityNumber, Consumer<IDataEntityProperty> consumer) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        DataEntityPropertyCollection properties = entityType.getProperties();
        if (properties != null && !properties.isEmpty()) {
            for (IDataEntityProperty property : properties) {
                String name = property.getName();
                if ("id".equals(name)) continue;
                if (property instanceof EntryProp) {
                    EntryProp entryProp = (EntryProp)property;
                    DataEntityPropertyCollection entryProperties = entryProp._collectionItemPropertyType.getProperties();
                    for (IDataEntityProperty subProp : entryProperties) {
                        consumer.accept(subProp);
                    }
                    continue;
                }
                consumer.accept(property);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (this.stopPropertyChange()) {
            this.clearStopPropertyChange();
            return;
        }
        String property = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newData = changeData.getNewValue();
        Object oldData = changeData.getOldValue();
        switch (property) {
            case "fasindex": {
                this.showConfirm((DynamicObject)oldData);
                break;
            }
            case "showdimension": {
                this.changeShowDimension((DynamicObjectCollection)newData);
                break;
            }
            case "sourcefieldtxt": {
                this.deleteField((String)newData);
                break;
            }
            case "fixvaluetxt": {
                this.changeValue((String)newData);
            }
        }
    }

    private void changeValue(String newData) {
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
        if (StringUtils.isEmpty((String)newData)) {
            this.getModel().setValue(FIELD_FIXVALUE, null, currentRowIndex);
        } else {
            DynamicObject dimension;
            DimensionTypeEnum dataTypeEnum;
            int rowCount = this.getModel().getEntryRowCount(ENTRY_ENTITY);
            if (rowCount > 0 && DimensionTypeEnum.OTHER == (dataTypeEnum = DimensionTypeEnum.getEnum((String)(dimension = (DynamicObject)this.getModel().getValue(FIELD_DIMENSION, currentRowIndex)).getString("dimensiontype")))) {
                this.getModel().setValue(FIELD_FIXVALUE, (Object)newData, currentRowIndex);
            }
            this.setStopPropertyChange();
            this.getModel().setValue(FIELD_SOURFIELDTXT, null);
            this.getModel().setValue(FIELD_SOURFIELD, null);
            this.clearStopPropertyChange();
        }
    }

    private void deleteField(String newValue) {
        if (StringUtils.isEmpty((String)newValue)) {
            int currentRowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
            this.getModel().setValue(FIELD_SOURFIELD, null, currentRowIndex);
        }
    }

    private void changeShowDimension(DynamicObjectCollection newValue) {
        if (newValue == null) {
            this.getModel().deleteEntryData(ENTRY_ENTITY);
        } else {
            Set<Long> idSet = this.toIdSet(newValue);
            int rowCount = this.getModel().getEntryRowCount(ENTRY_ENTITY);
            HashSet<Long> commonIdSet = new HashSet<Long>(10);
            if (rowCount > 0) {
                ArrayList<Integer> indexList = new ArrayList<Integer>(rowCount);
                for (int i = 0; i < rowCount; ++i) {
                    DynamicObject dimObj = (DynamicObject)this.getModel().getValue(FIELD_DIMENSION, i);
                    Long id = dimObj.getLong("id");
                    if (!idSet.contains(id)) {
                        indexList.add(i);
                        continue;
                    }
                    commonIdSet.add(id);
                }
                if (!indexList.isEmpty()) {
                    int[] indexs = new int[indexList.size()];
                    int count = 0;
                    for (Integer index : indexList) {
                        indexs[count++] = index;
                    }
                    this.getModel().deleteEntryRows(ENTRY_ENTITY, indexs);
                }
            }
            if (idSet.size() > commonIdSet.size()) {
                idSet.removeAll(commonIdSet);
                for (Long aLong : idSet) {
                    int rowIndex = this.getModel().createNewEntryRow(ENTRY_ENTITY);
                    this.getModel().setValue(FIELD_DIMENSION, (Object)aLong, rowIndex);
                }
            }
        }
    }

    private Set<Long> toIdSet(DynamicObjectCollection dimensionCols) {
        HashSet<Long> idSet = new HashSet<Long>(dimensionCols.size());
        for (DynamicObject dimensionCol : dimensionCols) {
            idSet.add(dimensionCol.getLong("fbasedataid_id"));
        }
        return idSet;
    }

    private void showConfirm(DynamicObject oldValue) {
        if (oldValue == null) {
            this.changeFasindex();
        } else {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u4fee\u6539\u6307\u6807\u5c06\u6e05\u7a7a\u914d\u7f6e\u4fe1\u606f\uff0c\u662f\u5426\u4fee\u6539\uff1f", (String)"IDIFasindexFormPlugin_2", (String)"data-idi-formplugin", (Object[])new Object[0]), null, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(ACTION_MODIFYFASINDEX, (IFormPlugin)this), null, String.valueOf(oldValue.getPkValue()));
        }
    }

    private void changeFasindex() {
        this.getModel().setValue(FIELD_SHOWDIMENSION, null);
        this.getModel().setValue(FIELD_VALUETYPE, (Object)FasindexConfig.ValueTypeEnum.C_00.getType());
        DynamicObject fasindex = (DynamicObject)this.getModel().getValue(FIELD_FASINDEX);
        this.fasindexControl(fasindex);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String actionId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (MessageBoxResult.Yes == result) {
            if (ACTION_MODIFYFASINDEX.equals(actionId)) {
                this.changeFasindex();
            }
            if (ACTION_SAVEFASINDEX.equals(actionId)) {
                this.doSaveData();
            }
        } else if (ACTION_MODIFYFASINDEX.equals(actionId)) {
            String pkStr = messageBoxClosedEvent.getCustomVaule();
            this.setStopPropertyChange();
            this.getModel().setValue(FIELD_FASINDEX, (Object)Long.valueOf(pkStr));
            this.clearStopPropertyChange();
        }
    }

    private void clearStopPropertyChange() {
        this.getPageCache().remove("nochange");
    }

    private void setStopPropertyChange() {
        this.getPageCache().put("nochange", "true");
    }

    private boolean stopPropertyChange() {
        return Boolean.parseBoolean(this.getPageCache().get("nochange"));
    }

    private String validate() {
        Object fasindex = this.getModel().getValue(FIELD_FASINDEX);
        if (fasindex == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u6307\u6807\u3002", (String)"IDIFasindexFormPlugin_3", (String)"data-idi-formplugin", (Object[])new Object[0]));
            return VALIDATE_FAIL;
        }
        DynamicObjectCollection showDimension = (DynamicObjectCollection)this.getModel().getValue(FIELD_SHOWDIMENSION);
        if (showDimension == null || showDimension.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u6307\u6807\u5c55\u793a\u7ef4\u5ea6\u3002", (String)"IDIFasindexFormPlugin_4", (String)"data-idi-formplugin", (Object[])new Object[0]));
            return VALIDATE_FAIL;
        }
        String valueTypeListStr = (String)this.getModel().getValue(FIELD_VALUETYPE);
        if (StringUtils.isEmpty((String)valueTypeListStr)) {
            return VALIDATE_FAIL;
        }
        String[] types = valueTypeListStr.split(",");
        HashSet<String> typeSet = new HashSet<String>(10);
        for (String type : types) {
            if (!StringUtils.isNotEmpty((String)type)) continue;
            typeSet.add(type);
        }
        typeSet.remove(FasindexConfig.ValueTypeEnum.C_00.getType());
        boolean needPeriod = typeSet.size() > 0;
        boolean hasPeriod = false;
        boolean hasEmptyValue = false;
        boolean hasPeriodValue = true;
        int rowCount = this.getModel().getEntryRowCount(ENTRY_ENTITY);
        ArrayList<String> propertyList = new ArrayList<String>(rowCount);
        for (int i = 0; i < rowCount; ++i) {
            String field = (String)this.getModel().getValue(FIELD_SOURFIELDTXT, i);
            DynamicObject dim = (DynamicObject)this.getModel().getValue(FIELD_DIMENSION, i);
            DimensionTypeEnum type = DimensionTypeEnum.getEnum((String)dim.getString("dimensiontype"));
            boolean isBase = type != DimensionTypeEnum.OTHER;
            String value = (String)this.getModel().getValue(isBase ? FIELD_FIXVALUE : FIELD_FIXVALUETXT, i);
            boolean currentRowEmpty = false;
            if (StringUtils.isEmpty((String)field) && StringUtils.isEmpty((String)value)) {
                hasEmptyValue = true;
                currentRowEmpty = true;
            }
            if (this.isPeriodDimension(type, IDIFasindexFormPlugin.getDimensionSource(dim, type))) {
                hasPeriod = true;
                hasPeriodValue = !currentRowEmpty;
            }
            propertyList.add((String)this.getModel().getValue(FIELD_SOURFIELD, i));
        }
        if (needPeriod && !hasPeriod) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u503c\u7c7b\u578b\u6d89\u53ca\u4e0e\u5f80\u671f\u6bd4\u8f83\uff0c\u8bf7\u5728\u201c\u6307\u6807\u5c55\u793a\u7ef4\u5ea6\u201d\u9009\u62e9\u671f\u95f4\u7ef4\u5ea6\u3002", (String)"IDIFasindexFormPlugin_0", (String)"data-idi-formplugin", (Object[])new Object[0]));
            return VALIDATE_FAIL;
        }
        if (needPeriod && hasPeriod && !hasPeriodValue) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u503c\u7c7b\u578b\u6d89\u53ca\u4e0e\u5f80\u671f\u6bd4\u8f83\uff0c\u8bf7\u5728\u201c\u6307\u6807\u7ef4\u5ea6\u53d6\u503c\u201d\u4e2d\u8bbe\u7f6e\u671f\u95f4\u7ef4\u5ea6\u53d6\u503c\u3002", (String)"IDIFasindexFormPlugin_1", (String)"data-idi-formplugin", (Object[])new Object[0]));
            return VALIDATE_FAIL;
        }
        if (this.checkProperty(propertyList)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6307\u6807\u7ef4\u5ea6\u53d6\u503c\u4e2d\u6e90\u5355\u5b57\u6bb5\u6765\u6e90\u4e8e\u591a\u4e2a\u5206\u5f55\uff0c\u8bf7\u4fee\u6539\u540e\u4fdd\u5b58\u3002", (String)"IDIFasindexFormPlugin_9", (String)"data-idi-formplugin", (Object[])new Object[0]));
            return VALIDATE_FAIL;
        }
        if (hasEmptyValue) {
            return VALIDATE_WARN;
        }
        return VALIDATE_SUCCESS;
    }

    private boolean checkProperty(List<String> propertyList) {
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam(CUSTOM_ENTITYNUMBER);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        Map entryMap = entityType.getAllEntities();
        HashSet<String> entrySet = new HashSet<String>(2);
        Set keySet = entryMap.keySet();
        for (String entry : keySet) {
            if (entityNumber.equals(entry)) continue;
            for (String property : propertyList) {
                String str;
                if (!property.startsWith(str = entry + '.')) continue;
                entrySet.add(entry);
            }
        }
        return entrySet.size() > 1;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object data;
        String actionId = closedCallBackEvent.getActionId();
        if (ACTION_SET_DIMENSIONFIELD.equals(actionId)) {
            Map selectFields;
            Set entrySet;
            Iterator iterator;
            Object returnData = closedCallBackEvent.getReturnData();
            if (returnData instanceof Map && (iterator = (entrySet = (selectFields = (Map)returnData).entrySet()).iterator()).hasNext()) {
                Map.Entry next = iterator.next();
                IDataModel model = this.getModel();
                int dimensionEntryIndex = model.getEntryCurrentRowIndex(ENTRY_ENTITY);
                model.setValue(FIELD_SOURFIELD, next.getKey(), dimensionEntryIndex);
                model.setValue(FIELD_SOURFIELDTXT, next.getValue(), dimensionEntryIndex);
                this.setStopPropertyChange();
                this.getModel().setValue(FIELD_FIXVALUETXT, null);
                this.getModel().setValue(FIELD_FIXVALUE, null);
                this.clearStopPropertyChange();
            }
        } else if (ACTION_SET_DIMENSIONVALUE.equals(actionId) && (data = closedCallBackEvent.getReturnData()) != null) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
            DynamicObject dimension = (DynamicObject)this.getModel().getValue(FIELD_DIMENSION, rowIndex);
            DimensionTypeEnum dataTypeEnum = DimensionTypeEnum.getEnum((String)dimension.getString("dimensiontype"));
            switch (dataTypeEnum) {
                case DATABASE: 
                case PERIOD: 
                case ASSISTANTDATA: {
                    ListSelectedRowCollection rowCollection = (ListSelectedRowCollection)data;
                    ListSelectedRow row = rowCollection.get(0);
                    this.getModel().setValue(FIELD_FIXVALUETXT, (Object)row.getName(), rowIndex);
                    this.getModel().setValue(FIELD_FIXVALUE, (Object)String.valueOf(row.getPrimaryKeyValue()), rowIndex);
                    break;
                }
                case OTHER: 
                case DATE: 
                case COMBO: {
                    Map dataMap = (Map)data;
                    Map.Entry entry = dataMap.entrySet().iterator().next();
                    this.getModel().setValue(FIELD_FIXVALUETXT, entry.getValue(), rowIndex);
                    this.getModel().setValue(FIELD_FIXVALUE, entry.getKey(), rowIndex);
                }
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        IDataEntityProperty property = beforeF7SelectEvent.getProperty();
        String propertyName = property.getName();
        if (FIELD_SHOWDIMENSION.equals(propertyName)) {
            DynamicObject fasindex = (DynamicObject)this.getModel().getValue(FIELD_FASINDEX);
            if (fasindex == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6307\u6807\u3002", (String)"IDIFasindexFormPlugin_7", (String)"data-idi-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            RequestContext context = RequestContext.get();
            List idList = FasindexHelper.getDimensionFromFsaindex((long)((Long)fasindex.getPkValue()), (long)context.getOrgId());
            if (!idList.isEmpty()) {
                QFilter filter = new QFilter("id", "in", (Object)idList);
                beforeF7SelectEvent.addCustomQFilter(filter);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u7ef4\u5ea6\u3002", (String)"IDIFasindexFormPlugin_8", (String)"data-idi-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
            }
        }
    }

    private void fasindexControl(DynamicObject fasindexObj) {
        if (fasindexObj == null) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{FIELD_CURRENCY, FIELD_FASINDEXUNIT, FIELD_NUMERICALUNIT});
            this.getModel().setValue(FIELD_NUMERICALUNIT, (Object)NumericalUnitEnum.NULL.getCode());
        } else {
            String unitCategory = fasindexObj.getString("unitcategory");
            UnitCategoryEnum unitCategoryEnum = UnitCategoryEnum.getEnum(unitCategory);
            if (unitCategoryEnum == null) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{FIELD_CURRENCY, FIELD_FASINDEXUNIT, FIELD_NUMERICALUNIT});
                this.getModel().setValue(FIELD_NUMERICALUNIT, (Object)NumericalUnitEnum.NULL.getCode());
            } else {
                switch (unitCategoryEnum) {
                    case AMOUNT: {
                        this.getView().setVisible(Boolean.valueOf(false), new String[]{FIELD_FASINDEXUNIT});
                        this.getView().setVisible(Boolean.valueOf(true), new String[]{FIELD_CURRENCY, FIELD_NUMERICALUNIT});
                        ComboEdit comboEdit = (ComboEdit)this.getControl(FIELD_NUMERICALUNIT);
                        ArrayList<ComboItem> data = new ArrayList<ComboItem>(5);
                        data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u65e0", (String)"IDIFasindexFormPlugin_10", (String)"data-idi-formplugin", (Object[])new Object[0])), NumericalUnitEnum.NULL.getCode()));
                        data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5343", (String)"NumericalUnitEnum_0", (String)"data-idi-core", (Object[])new Object[0])), NumericalUnitEnum.THOUSAND.getCode()));
                        data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4e07", (String)"NumericalUnitEnum_1", (String)"data-idi-core", (Object[])new Object[0])), NumericalUnitEnum.TENTHOUSAND.getCode()));
                        data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4ebf", (String)"NumericalUnitEnum_2", (String)"data-idi-core", (Object[])new Object[0])), NumericalUnitEnum.HUNDREDMILLION.getCode()));
                        comboEdit.setComboItems(data);
                        DynamicObject currency = fasindexObj.getDynamicObject("unit");
                        if (currency == null) break;
                        this.getModel().setValue(FIELD_CURRENCY, (Object)currency.getString("name"));
                        break;
                    }
                    case QTY: {
                        this.getView().setVisible(Boolean.valueOf(false), new String[]{FIELD_CURRENCY, FIELD_NUMERICALUNIT});
                        this.getView().setVisible(Boolean.valueOf(true), new String[]{FIELD_FASINDEXUNIT});
                        DynamicObject unit = fasindexObj.getDynamicObject("unit");
                        if (unit == null) break;
                        this.getModel().setValue(FIELD_FASINDEXUNIT, (Object)unit.getString("name"));
                        break;
                    }
                    case NUMERICAL: {
                        this.getView().setVisible(Boolean.valueOf(false), new String[]{FIELD_CURRENCY, FIELD_FASINDEXUNIT});
                        this.getView().setVisible(Boolean.valueOf(true), new String[]{FIELD_NUMERICALUNIT});
                    }
                }
            }
        }
    }

    public static enum UnitCategoryEnum {
        AMOUNT("1"),
        QTY("2"),
        NUMERICAL("0");

        private String code;

        private UnitCategoryEnum(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }

        public static UnitCategoryEnum getEnum(String code) {
            if (code == null) {
                return null;
            }
            switch (code) {
                case "1": {
                    return AMOUNT;
                }
                case "2": {
                    return QTY;
                }
                case "0": {
                    return NUMERICAL;
                }
            }
            return null;
        }
    }
}

