/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.util.StringUtils;
import kd.data.idi.data.TimeLine;
import kd.data.idi.util.IDIJSONUtils;

public class IDIFutureFormPlugin
extends AbstractFormPlugin {
    public static final String CustParamKey_ENTITY_NUMBER = "entitynumber";
    public static final String CustomParam_DETAIL_CONFIG = "detailConfig";
    public static final String CustomParam_ONLYHEADFIELD = "onlyheadfield";
    public static final String Key_BTN_OK = "btn_ok";
    public static final String Key_HOVER_COMBO = "hover_combo";
    public static final String Key_ROW_ROWFIELDLEFT = "rowfieldleft";
    public static final String Key_ROW_ROWFIELDRIGHT = "rowfieldright";
    public static final String Key_TARGET = "target";
    public static final String PARAM_CONFIG = "config";
    public static final String PARAM_BILLTYPE = "billType";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{Key_BTN_OK});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        switch (key = ctl.getKey()) {
            case "btn_ok": {
                if (!this.validate()) break;
                TimeLine lineConfig = this.getReturnData();
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put(PARAM_CONFIG, lineConfig);
                DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue(Key_TARGET);
                result.put(PARAM_BILLTYPE, dynamicObject.getPkValue());
                this.getView().returnDataToParent((Object)IDIJSONUtils.toJsonString(result));
                this.getView().close();
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_ENTITY_NUMBER);
        String onlyHeadField = (String)this.getView().getFormShowParameter().getCustomParam(CustomParam_ONLYHEADFIELD);
        this.initComboField(entityNumber, onlyHeadField);
        this.fillField(entityNumber);
    }

    private void fillField(String entityNumber) {
        String detailData = (String)this.getView().getFormShowParameter().getCustomParam(CustomParam_DETAIL_CONFIG);
        if (StringUtils.isNotEmpty((String)detailData)) {
            TimeLine timeLine = (TimeLine)IDIJSONUtils.cast((String)detailData, TimeLine.class);
            List rowFields = timeLine.getRowFields();
            String remark = timeLine.getRemark();
            this.getModel().setValue(Key_ROW_ROWFIELDLEFT, rowFields.get(0));
            this.getModel().setValue(Key_ROW_ROWFIELDRIGHT, rowFields.get(1));
            this.getModel().setValue(Key_HOVER_COMBO, (Object)remark);
        }
        if (StringUtils.isNotEmpty((String)entityNumber)) {
            this.getModel().setValue(Key_TARGET, (Object)entityNumber);
        }
    }

    private void initComboField(String entityNumber, String onlyHeadField) {
        List<List<ComboItem>> fieldItems = this.getSrcFieldItems(entityNumber, onlyHeadField);
        if (!fieldItems.isEmpty()) {
            ComboEdit firstFiled = (ComboEdit)this.getControl(Key_ROW_ROWFIELDLEFT);
            firstFiled.setComboItems(fieldItems.get(0));
            ComboEdit secondFiled = (ComboEdit)this.getControl(Key_ROW_ROWFIELDRIGHT);
            secondFiled.setComboItems(fieldItems.get(1));
            ComboEdit srcFiled = (ComboEdit)this.getControl(Key_HOVER_COMBO);
            srcFiled.setComboItems(fieldItems.get(1));
        }
    }

    private List<List<ComboItem>> getSrcFieldItems(String entityNumber, String onlyHeadField) {
        List<List<ComboItem>> currColl = new ArrayList<List<ComboItem>>();
        if (StringUtils.isNotEmpty((String)entityNumber)) {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            EntityTypeUtil helper = new EntityTypeUtil();
            List cols = helper.getFilterColumns((IDataEntityType)entityType, !StringUtils.isBlank((String)onlyHeadField) && Boolean.parseBoolean(onlyHeadField));
            currColl = this.createComboItem(entityNumber, cols);
        }
        return currColl;
    }

    private List<List<ComboItem>> createComboItem(String entityNumber, List<Map<String, Object>> listNodes) {
        if (listNodes == null) {
            return null;
        }
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(listNodes.size());
        ArrayList<ComboItem> dateList = new ArrayList<ComboItem>(10);
        ArrayList<List<ComboItem>> result = new ArrayList<List<ComboItem>>(2);
        result.add(dateList);
        result.add(list);
        for (Map<String, Object> map : listNodes) {
            String entryEntity = (String)map.get("entryEntity");
            String fieldName = (String)map.get("fieldName");
            String fieldCaption = (String)map.get("fieldCaption");
            String type = (String)map.get("type");
            LocaleString localeString = new LocaleString();
            localeString.setLocaleValue(fieldCaption);
            String value = fieldName;
            if (!StringUtils.isEmpty((String)entryEntity) && !entityNumber.equals(entryEntity)) {
                value = entryEntity + "." + fieldName;
            }
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(localeString);
            comboItem.setValue(value);
            if ("datetime".equals(type) || "date".equals(type)) {
                dateList.add(comboItem);
                continue;
            }
            list.add(comboItem);
        }
        return result;
    }

    private TimeLine getReturnData() {
        TimeLine timeLine = new TimeLine();
        ArrayList<String> rowFields = new ArrayList<String>();
        String fieldLeft = (String)this.getModel().getValue(Key_ROW_ROWFIELDLEFT);
        String fieldRight = (String)this.getModel().getValue(Key_ROW_ROWFIELDRIGHT);
        rowFields.add(fieldLeft);
        rowFields.add(fieldRight);
        timeLine.setRowFields(rowFields);
        String remark = (String)this.getModel().getValue(Key_HOVER_COMBO);
        timeLine.setRemark(remark);
        return timeLine;
    }

    private boolean validate() {
        DynamicObject target = (DynamicObject)this.getModel().getValue(Key_TARGET);
        if (target == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u201c\u76ee\u6807\u5355\u7c7b\u578b\u201d\u3002", (String)"IDIFutureFormPlugin_1", (String)"data-idi-formplugin", (Object[])new Object[0]));
            return false;
        }
        String fieldLeft = (String)this.getModel().getValue(Key_ROW_ROWFIELDLEFT);
        String fieldRight = (String)this.getModel().getValue(Key_ROW_ROWFIELDRIGHT);
        if (StringUtils.isEmpty((String)fieldLeft) || StringUtils.isEmpty((String)fieldRight)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u65f6\u95f4\u8f74\u5de6\u4fa7\u548c\u53f3\u4fa7\u5b57\u6bb5\u3002", (String)"IDIFutureFormPlugin_0", (String)"data-idi-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String property = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if (Key_TARGET.equalsIgnoreCase(property)) {
            this.initComboField(newValue == null ? null : (String)((DynamicObject)newValue).getPkValue(), null);
            this.getModel().setValue(Key_ROW_ROWFIELDLEFT, null);
            this.getModel().setValue(Key_ROW_ROWFIELDRIGHT, null);
            this.getModel().setValue(Key_HOVER_COMBO, null);
        }
    }
}

