/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.data.idi.data.Decision;
import kd.data.idi.engine.ParamFactory;
import kd.data.idi.util.IDIJSONUtils;

public class IDIMoveDecisionFormPlugin
extends AbstractFormPlugin {
    private static final String FIELD_AREA = "area";
    private static final String BTN_OK = "btnok";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String parentPageId = fsp.getParentPageId();
        if (StringUtils.isNotEmpty((String)parentPageId)) {
            IDataModel dataModel = this.getView().getParentView().getModel();
            int currentEntryIndex = dataModel.getEntryCurrentRowIndex("c_panel");
            int rowCount = dataModel.getEntryRowCount("c_panel");
            ComboEdit comboEdit = (ComboEdit)this.getView().getControl(FIELD_AREA);
            ArrayList<ComboItem> list = new ArrayList<ComboItem>(2);
            for (int i = 0; i < rowCount; ++i) {
                if (i == currentEntryIndex) continue;
                String areaId = (String)dataModel.getValue("c_id", i);
                String areaName = (String)dataModel.getValue("c_name", i);
                if (!StringUtils.isNotEmpty((String)areaId) || !StringUtils.isNotEmpty((String)areaName)) continue;
                ComboItem ci = new ComboItem();
                ci.setValue(areaId);
                ci.setCaption(new LocaleString(areaName));
                list.add(ci);
            }
            if (CollectionUtils.isNotEmpty(list)) {
                comboEdit.setComboItems(list);
            }
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (BTN_OK.equalsIgnoreCase(key)) {
            String areaId = (String)this.getModel().getValue(FIELD_AREA);
            if (StringUtils.isNotEmpty((String)areaId)) {
                IFormView parentView = this.getView().getParentView();
                IDataModel dataModel = parentView.getModel();
                int rowCount = dataModel.getEntryRowCount("c_panel");
                EntryGrid entryGrid = (EntryGrid)parentView.getControl("d_panel");
                int[] selectIndexes = entryGrid.getSelectRows();
                int decisionCountLimit = ParamFactory.getNumbClassification();
                for (int i = 0; i < rowCount; ++i) {
                    String targetAreaId = (String)dataModel.getValue("c_id", i);
                    if (!areaId.equals(targetAreaId)) continue;
                    String decisionJson = (String)dataModel.getValue("c_decision_json", i);
                    int targetDecisionCount = 0;
                    if (StringUtils.isNotEmpty((String)decisionJson)) {
                        List decisionList = IDIJSONUtils.jsonCastToList((String)decisionJson, Decision.class);
                        int n = targetDecisionCount = decisionList == null ? 0 : decisionList.size();
                    }
                    if (decisionCountLimit >= selectIndexes.length + targetDecisionCount) break;
                    String errorMesg = ResManager.loadKDString((String)"\u79fb\u52a8\u5931\u8d25\uff0c%1$s\u5206\u7c7b\u6700\u591a\u652f\u6301\u914d\u7f6e%2$s\u4e2a\u68c0\u67e5\u9879\u3002", (String)"IDIMoveDecisionFormPlugin_0", (String)"data-idi-formplugin", (Object[])new Object[0]);
                    String mesg = String.format(errorMesg, dataModel.getValue("c_name", i), decisionCountLimit);
                    this.getView().showTipNotification(mesg);
                    return;
                }
            }
            this.getView().returnDataToParent((Object)areaId);
            this.getView().close();
        }
    }

    public static void openF7(AbstractFormPlugin plugin, String actionId) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("idi_movedecision");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, actionId));
        plugin.getView().showForm(fsp);
    }
}

