/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.formplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mutex.impl.MutexLockInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.data.idi.util.IDIDisclaimerUtil;

public class IDISchemaListPlugin
extends AbstractListPlugin {
    private static final String CustParamKey_BillId = "billId";
    private static final String CustParamKey_ISCOPY = "iscopy";
    private static final String CustParamKey_ONLYVIEW = "onlyview";
    private static final String FormId_Schema_Config = "idi_schema_config";
    private static final String Key_TABAP = "tabap";
    private static final String Key_BILLLISTAP = "billlistap";
    private static final String OperateKey_Copy = "copy";
    private static final String OperateKey_New = "new";
    private static final String CLOSED_CALLBACK_DISCLAIMER = "closedCallbackDisclaimer";
    private static final String OPERATION_ENABLE = "enable";
    private static final String ActionId_LockedConfirm = "lockedConfirm";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        if (OPERATION_ENABLE.equals(formOperate.getOperateKey())) {
            Object[] ids = args.getListSelectedData().getPrimaryKeyValues();
            if (IDIDisclaimerUtil.isNewsAndEnabled((Object[])ids) && !IDIDisclaimerUtil.disclaimerStatus()) {
                IDIDisclaimerUtil.showDisclaimer((IFormView)this.getView(), (AbstractFormPlugin)this);
                args.setCancel(true);
            }
        } else if ("modify".equals(formOperate.getOperateKey())) {
            formOperate.getOption().setVariableValue("ignoreValidation", Boolean.TRUE.toString());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (OperateKey_New.equals(args.getOperateKey()) || "modify".equals(args.getOperateKey()) || "view".equals(args.getOperateKey()) || OperateKey_Copy.equals(args.getOperateKey())) {
            Object pkValue;
            FormShowParameter showParameter = new FormShowParameter();
            String permission = null;
            String operateCaption = null;
            if (OperateKey_New.equals(args.getOperateKey())) {
                permission = "47156aff000000ac";
                operateCaption = ResManager.loadKDString((String)"\u65b0\u589e", (String)"IDISchemaListPlugin_0", (String)"data-idi-formplugin", (Object[])new Object[0]);
                showParameter.setStatus(OperationStatus.ADDNEW);
            } else if (OperateKey_Copy.equals(args.getOperateKey())) {
                permission = "4730fc9f000020ae";
                operateCaption = ResManager.loadKDString((String)"\u590d\u5236", (String)"IDISchemaListPlugin_2", (String)"data-idi-formplugin", (Object[])new Object[0]);
                showParameter.setStatus(OperationStatus.ADDNEW);
                showParameter.setCustomParam(CustParamKey_ISCOPY, (Object)Boolean.TRUE);
                pkValue = this.getSelectedPkValue();
                if (pkValue == null) {
                    return;
                }
                showParameter.setCustomParam(CustParamKey_BillId, pkValue);
            } else if ("modify".equals(args.getOperateKey()) || "view".equals(args.getOperateKey())) {
                permission = "4715a0df000000ac";
                operateCaption = ResManager.loadKDString((String)"\u4fee\u6539", (String)"IDISchemaListPlugin_4", (String)"data-idi-formplugin", (Object[])new Object[0]);
                pkValue = this.getPkValue(args);
                if (pkValue == null) {
                    return;
                }
                showParameter.setCustomParam(CustParamKey_BillId, pkValue);
                showParameter.setStatus(OperationStatus.EDIT);
                if ("modify".equals(args.getOperateKey())) {
                    if (!this.requireDataMutex(pkValue)) {
                        return;
                    }
                } else if ("view".equals(args.getOperateKey())) {
                    showParameter.setCustomParam(CustParamKey_ONLYVIEW, (Object)true);
                }
            }
            String userID = String.valueOf(RequestContext.get().getCurrUserId());
            if (StringUtils.isNotEmpty((String)userID) && StringUtils.isNotEmpty((String)permission) && !PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(userID), (String)"idi", (String)FormId_Schema_Config, (String)permission)) {
                String errorMesg = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u4e1a\u52a1\u5bf9\u8c61\u201c\u51b3\u7b56\u65b9\u6848\u914d\u7f6e\u201d\u64cd\u4f5c\u201c%s\u201d\u7684\u529f\u80fd\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"IDISchemaListPlugin_3", (String)"data-idi-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(String.format(errorMesg, operateCaption));
                return;
            }
            showParameter.setFormId(FormId_Schema_Config);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.getOpenStyle().setTargetKey(Key_TABAP);
            CloseCallBack closeCallBack = new CloseCallBack(((Object)((Object)this)).getClass().getName(), "listoperation");
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(showParameter);
        }
    }

    private boolean requireDataMutex(Object pkValue) {
        if (pkValue == null) {
            return true;
        }
        StringBuilder failInfo = new StringBuilder();
        MutexLockInfo lockInfo = new MutexLockInfo(String.valueOf(pkValue), null, null, "idi_schema", "modify", true, null);
        boolean isLockSucceed = MutexHelper.require((IFormView)this.getView(), (MutexLockInfo)lockInfo, (StringBuilder)failInfo);
        if (!isLockSucceed) {
            this.showLockedConfirm(failInfo);
        }
        return isLockSucceed;
    }

    private void showLockedConfirm(StringBuilder failInfo) {
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
        btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"IDISchemaListPlugin_6", (String)"data-idi-formplugin", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u67e5\u770b\u5355\u636e", (String)"IDISchemaListPlugin_7", (String)"data-idi-formplugin", (Object[])new Object[0]));
        this.getView().showConfirm(failInfo.toString(), null, MessageBoxOptions.YesNo, null, new ConfirmCallBackListener(ActionId_LockedConfirm, (IFormPlugin)this), btnNameMaps, "");
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        MessageBoxResult messageBoxResult = messageBoxClosedEvent.getResult();
        String actionId = messageBoxClosedEvent.getCallBackId();
        if (MessageBoxResult.Yes == messageBoxResult && ActionId_LockedConfirm.equals(actionId)) {
            this.getView().invokeOperation("view");
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedcallbackevent) {
        String actionId = closedcallbackevent.getActionId();
        String returnData = (String)closedcallbackevent.getReturnData();
        if (CLOSED_CALLBACK_DISCLAIMER.equals(actionId)) {
            if (Boolean.parseBoolean(returnData)) {
                this.getView().invokeOperation(OPERATION_ENABLE);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u63a5\u53d7\u514d\u8d23\u58f0\u660e\uff0c\u4e0d\u5141\u8bb8\u542f\u7528\u65b0\u95fb\u7c7b\u68c0\u67e5\u9879\u3002", (String)"IDISchemaListPlugin_5", (String)"data-idi-formplugin", (Object[])new Object[0]));
            }
        }
        ((IListView)this.getView()).refresh();
    }

    private Object getSelectedPkValue() {
        BillList list = (BillList)this.getView().getControl(Key_BILLLISTAP);
        ListSelectedRowCollection selectedRows = list.getSelectedRows();
        Object[] pks = selectedRows.getPrimaryKeyValues();
        if (pks.length > 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"IDISchemaListPlugin_1", (String)"data-idi-formplugin", (Object[])new Object[0]));
            return null;
        }
        return pks[0];
    }

    private Object getPkValue(AfterDoOperationEventArgs args) {
        FormOperate formOperate;
        ListSelectedRow row;
        Object source = args.getSource();
        if (source instanceof FormOperate && (row = (formOperate = (FormOperate)source).getListFocusRow()) != null) {
            return row.getPrimaryKeyValue();
        }
        return null;
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        CommonFilterColumn entityNumberName = (CommonFilterColumn)args.getFilterColumn("sourceentitynumber.name");
        ArrayList<ComboItem> dv = new ArrayList<ComboItem>();
        HashSet<String> newValues = new HashSet<String>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"IDISchemaListPlugin.filterContainerInit", (String)"idi_schema", (String)"number,sourceentitynumber.id,sourceentitynumber.name", null, null);){
            if (dataSet != null && !dataSet.isEmpty()) {
                for (Row row : dataSet) {
                    String idStr = row.getString("sourceentitynumber.id");
                    if (!newValues.add(idStr)) continue;
                    ComboItem item = new ComboItem();
                    item.setCaption(new LocaleString(row.getString("sourceentitynumber.name")));
                    item.setValue(idStr);
                    dv.add(item);
                }
            }
        }
        entityNumberName.setComboItems(dv);
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        if ("sourceentitynumber.id".equals(args.getFieldName())) {
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"IDISchemaListPlugin.filterContainerInit", (String)"idi_schema", (String)"number,sourceentitynumber.id,sourceentitynumber.name", null, null);){
                if (dataSet != null && !dataSet.isEmpty()) {
                    ArrayList<String> idList = new ArrayList<String>();
                    for (Row row : dataSet) {
                        idList.add(row.getString("sourceentitynumber.id"));
                    }
                    args.getQfilters().add(new QFilter("id", "in", (Object)idList.toArray()));
                }
            }
        }
    }

    public void afterQueryOfExport(AfterQueryOfExportEvent e) {
        IDataEntityType dataEntityType;
        IDataEntityProperty property;
        DynamicObject[] queryValues = e.getQueryValues();
        if (queryValues != null && queryValues.length > 0 && (property = (IDataEntityProperty)(dataEntityType = queryValues[0].getDataEntityType()).getProperties().get((Object)"rule")) != null) {
            for (DynamicObject dynamicObject : queryValues) {
                dynamicObject.set("rule", dynamicObject.get("rule_tag"));
            }
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        String version = LicenseServiceHelper.getProductVersion();
        if (!"1.0".equals(version)) {
            LicenseCheckResult checkResult = LicenseServiceHelper.checkPerformGroup((String)"PRO_IDI");
            boolean hasLicense = checkResult.getHasLicense();
            e.setCancel(!hasLicense);
            e.setCancelMessage(checkResult.getMsg());
            e.setCancelFormShowParameter(checkResult.getCancelFormShowParameter());
        }
    }
}

