/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.CompareType;
import kd.bos.entity.filter.CompareTypeDto;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.filter.FilterObject;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.FilterGridF7ClickEvent;
import kd.bos.form.control.events.FilterGridF7ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.bos.util.StringUtils;
import kd.data.idi.data.IDICondition;
import kd.data.idi.util.CompareColumnHelper;
import kd.data.idi.util.IDIJSONUtils;

public class IDIStatisticsTargetConfigFormPlugin
extends AbstractFormPlugin
implements FilterGridF7ClickListener {
    private static final String CONTROL_BTNOK = "btnok";
    private static final String CONTROL_FILTER = "filtergridap";
    private static final String PARAM_SOURCEENTITYNUMBER = "entitynumber";
    private static final String PARAM_TARGETENTITYNUMBER = "targetEntityNumber";
    private static final String PARAM_TARGETCONDITIONCONFIG = "formula";
    public static final String PARAM_CUSTOMLAST = "customValue";
    private static final String COMPARE_TYPE_IDS = "-1,-2,-3,-4";
    public static final String FIELD_CUSTOMLAST = "customerlast";
    private static final List<CompareTypeDto> addCompareType = Arrays.asList(new CompareTypeDto("IDI_BETWEEN_1W", new LocaleString(ResManager.loadKDString((String)"1\u5468\u5185", (String)"IDIStatisticsTargetConfigFormPlugin_0", (String)"data-idi-formplugin", (Object[])new Object[0])), false, "", 5, -1, false, false, false, false), new CompareTypeDto("IDI_BETWEEN_2W", new LocaleString(ResManager.loadKDString((String)"2\u5468\u5185", (String)"IDIStatisticsTargetConfigFormPlugin_1", (String)"data-idi-formplugin", (Object[])new Object[0])), false, "", 5, -1, false, false, false, false), new CompareTypeDto("IDI_BETWEEN_1M", new LocaleString(ResManager.loadKDString((String)"1\u4e2a\u6708\u5185", (String)"IDIStatisticsTargetConfigFormPlugin_2", (String)"data-idi-formplugin", (Object[])new Object[0])), false, "", 5, -1, false, false, false, false), new CompareTypeDto("IDI_BETWEEN_2M", new LocaleString(ResManager.loadKDString((String)"2\u4e2a\u6708\u5185", (String)"IDIStatisticsTargetConfigFormPlugin_3", (String)"data-idi-formplugin", (Object[])new Object[0])), false, "", 5, -1, false, false, false, false), new CompareTypeDto("IDI_BETWEEN_3M", new LocaleString(ResManager.loadKDString((String)"3\u4e2a\u6708\u5185", (String)"IDIStatisticsTargetConfigFormPlugin_4", (String)"data-idi-formplugin", (Object[])new Object[0])), false, "", 5, -1, false, false, false, false), new CompareTypeDto("IDI_BETWEEN_1HY", new LocaleString(ResManager.loadKDString((String)"\u534a\u5e74\u5185", (String)"IDIStatisticsTargetConfigFormPlugin_5", (String)"data-idi-formplugin", (Object[])new Object[0])), false, "", 5, -1, false, false, false, false), new CompareTypeDto("IDI_BETWEEN_1Y", new LocaleString(ResManager.loadKDString((String)"1\u5e74\u5185", (String)"IDIStatisticsTargetConfigFormPlugin_6", (String)"data-idi-formplugin", (Object[])new Object[0])), false, "", 5, -1, false, false, false, false), new CompareTypeDto("IDI_BETWEEN_0M", new LocaleString(ResManager.loadKDString((String)"\u5f53\u6708\u5185", (String)"IDIStatisticsTargetConfigFormPlugin_17", (String)"data-idi-formplugin", (Object[])new Object[0])), false, "", 5, -1, false, false, false, false), new CompareTypeDto("IDI_BETWEEN_0Y", new LocaleString(ResManager.loadKDString((String)"\u5f53\u5e74\u5185", (String)"IDIStatisticsTargetConfigFormPlugin_18", (String)"data-idi-formplugin", (Object[])new Object[0])), false, "", 5, -1, false, false, false, false), new CompareTypeDto("lastTime", new LocaleString(ResManager.loadKDString((String)"\u6700\u8fd1\u4e00\u6b21", (String)"IDIStatisticsTargetConfigFormPlugin_7", (String)"data-idi-formplugin", (Object[])new Object[0])), false, "", 5, -1, false, false, false, false), new CompareTypeDto("lastThreeTimes", new LocaleString(ResManager.loadKDString((String)"\u6700\u8fd1\u4e09\u6b21", (String)"IDIStatisticsTargetConfigFormPlugin_8", (String)"data-idi-formplugin", (Object[])new Object[0])), false, "", 5, -1, false, false, false, false), new CompareTypeDto("lastCustomTimes", new LocaleString(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6700\u8fd1\u6b21\u6570", (String)"IDIStatisticsTargetConfigFormPlugin_15", (String)"data-idi-formplugin", (Object[])new Object[0])), false, "", 5, -1, false, false, false, false));

    public void initialize() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(CONTROL_FILTER);
        filterGrid.addFilterGridF7ClickEvents((FilterGridF7ClickListener)this);
        for (CompareTypeDto dto : addCompareType) {
            dto.setVisible(true);
        }
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{CONTROL_BTNOK});
    }

    public void afterCreateNewData(EventObject e) {
        String customlast;
        super.afterCreateNewData(e);
        String entityNumber = this.getTargetEntityNumber();
        if (StringUtils.isNotEmpty((String)entityNumber)) {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            EntityTypeUtil helper = new EntityTypeUtil();
            ArrayList<Map<String, Object>> cols = new ArrayList<Map<String, Object>>(10);
            List filterFields = helper.getFilterFields((IDataEntityType)entityType, false);
            Iterator filterFieldIterator = filterFields.iterator();
            HashSet entityIdSet = new HashSet(10);
            List compareTypes = CompareColumnHelper.getFieldEqualCompareType();
            while (filterFieldIterator.hasNext()) {
                FilterField filterField = (FilterField)filterFieldIterator.next();
                Map filterColumn = filterField.createFilterColumn();
                if (filterField.getLatestParent() instanceof IBasedataField) {
                    List filterList = EntityTypeUtil.setCompareTypes((List)((List)filterColumn.get("compareTypes")), (boolean)true, (boolean)true);
                    Iterator compareTypeIterator = filterList.iterator();
                    while (compareTypeIterator.hasNext()) {
                        CompareTypeDto dto;
                        Object nextObj = compareTypeIterator.next();
                        if (!(nextObj instanceof CompareTypeDto) || !COMPARE_TYPE_IDS.contains((dto = (CompareTypeDto)nextObj).getId())) continue;
                        compareTypeIterator.remove();
                    }
                    filterColumn.put("compareTypes", filterList);
                    CompareColumnHelper.baseDataTextFieldCompare((FilterField)filterField, (Map)filterColumn);
                    Map idColumn = CompareColumnHelper.genIdColumnMap((FilterField)filterField, entityIdSet, (MainEntityType)entityType, (List)compareTypes);
                    if (idColumn != null) {
                        cols.add(idColumn);
                    }
                }
                cols.add(filterColumn);
            }
            this.filterField(cols);
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl(CONTROL_FILTER);
            CompareColumnHelper.processPropertyName((String)entityNumber, cols);
            filterGrid.setFilterColumns(cols);
            filterGrid.setEntityNumber(entityNumber);
            String sourceNumber = this.getSourceEntityNumber();
            if (StringUtils.isNotEmpty((String)sourceNumber) && !sourceNumber.equalsIgnoreCase(entityNumber)) {
                MainEntityType sourceEntityType = EntityMetadataCache.getDataEntityType((String)sourceNumber);
                ArrayList<Map> sourceCols = new ArrayList<Map>(16);
                List sourceFilterFields = helper.getFilterFields((IDataEntityType)sourceEntityType, false);
                HashSet sourceIdSet = new HashSet(10);
                for (FilterField sourceFilterField : sourceFilterFields) {
                    Map sourceFilterColumn = sourceFilterField.createFilterColumn();
                    if (sourceFilterField.getLatestParent() instanceof IBasedataField) {
                        CompareColumnHelper.baseDataTextFieldCompare((FilterField)sourceFilterField, (Map)sourceFilterColumn);
                        Map idColumn = CompareColumnHelper.genIdColumnMap((FilterField)sourceFilterField, sourceIdSet, (MainEntityType)sourceEntityType, (List)compareTypes);
                        if (idColumn != null) {
                            sourceCols.add(idColumn);
                        }
                    }
                    sourceCols.add(sourceFilterColumn);
                }
                CompareColumnHelper.processPropertyName((String)sourceNumber, sourceCols);
                filterGrid.setFieldColumns(sourceCols);
            }
        }
        if (StringUtils.isNotEmpty((String)(customlast = this.getCustomlast()))) {
            this.getModel().setValue(FIELD_CUSTOMLAST, (Object)customlast);
        }
    }

    public void afterBindData(EventObject e) {
        IDICondition conditionObj;
        FilterCondition filterCondition;
        super.afterBindData(e);
        String conditionJson = this.getConditionJson();
        if (StringUtils.isNotEmpty((String)conditionJson) && (filterCondition = (conditionObj = (IDICondition)SerializationUtils.fromJsonString((String)conditionJson, IDICondition.class)).getFilterCondition()) != null) {
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl(CONTROL_FILTER);
            filterGrid.SetValue(filterCondition);
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if (CONTROL_BTNOK.equalsIgnoreCase(control.getKey())) {
            IDICondition condition = this.getCondition();
            if (condition == null) {
                return;
            }
            if (this.validate(condition)) {
                String conditionStr = IDIJSONUtils.toJsonString((Object)condition);
                HashMap<String, String> result = new HashMap<String, String>(2);
                result.put(PARAM_TARGETCONDITIONCONFIG, conditionStr);
                result.put(PARAM_CUSTOMLAST, (String)this.getModel().getValue(FIELD_CUSTOMLAST));
                this.getView().returnDataToParent(result);
                this.getView().close();
            }
        }
    }

    private boolean validate(IDICondition condition) {
        boolean hasDateTypeCondition = false;
        List rows = condition.getFilterCondition().getFilterRow();
        int lastTimeCount = 0;
        boolean hasCustom = false;
        for (SimpleFilterRow filterRow : rows) {
            if (this.parseDateTimeCondition(filterRow)) {
                hasDateTypeCondition = true;
            }
            if (!"lastTime".equals(filterRow.getCompareType()) && !"lastThreeTimes".equals(filterRow.getCompareType()) && !"lastCustomTimes".equals(filterRow.getCompareType())) continue;
            ++lastTimeCount;
            if (!"lastCustomTimes".equals(filterRow.getCompareType())) continue;
            hasCustom = true;
        }
        if (!hasDateTypeCondition) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5728\u201c\u76ee\u6807\u5355\u8fc7\u6ee4\u6761\u4ef6\u201d\u5904\u586b\u5199\u65e5\u671f\u7c7b\u8fc7\u6ee4\u6761\u4ef6\u3002", (String)"IDIStatisticsTargetConfigFormPlugin_9", (String)"data-idi-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (lastTimeCount > 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u6700\u8fd1\u4e00\u6b21\u201d\u3001\u201c\u6700\u8fd1\u4e09\u6b21\u201d\u3001\u201c\u81ea\u5b9a\u4e49\u6700\u8fd1\u6b21\u6570\u201d\u53ea\u80fd\u5355\u72ec\u51fa\u73b0\u4e00\u6b21\u3002", (String)"IDIStatisticsTargetConfigFormPlugin_10", (String)"data-idi-formplugin", (Object[])new Object[0]));
            return false;
        }
        String customLast = (String)this.getModel().getValue(FIELD_CUSTOMLAST);
        if (lastTimeCount == 1 && hasCustom) {
            if (StringUtils.isEmpty((String)customLast)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u81ea\u5b9a\u4e49\u6700\u8fd1\u6b21\u6570\u5b57\u6bb5\u503c\u3002", (String)"IDIStatisticsTargetConfigFormPlugin_16", (String)"data-idi-formplugin", (Object[])new Object[0]));
                return false;
            }
        } else if (StringUtils.isNotEmpty((String)customLast)) {
            this.getModel().setValue(FIELD_CUSTOMLAST, null);
        }
        return true;
    }

    private IDICondition getCondition() {
        String targetNumber = this.getTargetEntityNumber();
        String sourceNumber = this.getSourceEntityNumber();
        MainEntityType dataType = EntityMetadataCache.getDataEntityType((String)targetNumber);
        FilterGrid filterGrid = (FilterGrid)this.getControl(CONTROL_FILTER);
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        List<FilterField> targetFieldFilter = this.addCompareField(targetNumber);
        List<FilterField> sourceFieldFilter = this.addCompareField(sourceNumber);
        FilterBuilder filterBuilder = new FilterBuilder(dataType, filterGridState.getFilterCondition(), true, targetFieldFilter);
        filterBuilder.setTimeService((ITimeService)this.getView().getService(ITimeService.class));
        filterBuilder.setUserService((IUserService)this.getView().getService(IUserService.class));
        filterBuilder.getFilterObject().addCompareFileds(sourceFieldFilter);
        filterBuilder.buildFilter(false);
        FilterObject fo = filterBuilder.getFilterObject();
        List originalFilterRows = filterGridState.getFilterCondition().getFilterRow();
        String filterString = StringUtils.isEmpty((String)fo.getFilter()) ? "" : fo.getFilter();
        Integer countOfBracket = 0;
        ArrayList<SimpleFilterRow> deleteFilterRows = new ArrayList<SimpleFilterRow>();
        String become = ResManager.loadKDString((String)" \u4e3a ", (String)"IDIStatisticsTargetConfigFormPlugin_11", (String)"data-idi-formplugin", (Object[])new Object[0]);
        for (int i = 0; i < originalFilterRows.size(); ++i) {
            SimpleFilterRow originalFilterRow = (SimpleFilterRow)originalFilterRows.get(i);
            CompareTypeDto compareTypeDto = this.getCompareType(originalFilterRow);
            if (compareTypeDto == null && (originalFilterRow.getValue().size() == 0 || StringUtils.isEmpty((String)((String)((FilterValue)originalFilterRow.getValue().get(0)).getValue()))) && this.getDefaultCompareType(targetFieldFilter, originalFilterRow, dataType).isNeedInput()) {
                deleteFilterRows.add(originalFilterRow);
                continue;
            }
            if ((countOfBracket = this.checkBracket(countOfBracket, originalFilterRow)) == null) {
                return null;
            }
            if (compareTypeDto == null) continue;
            if (i == 0) {
                String rowString = originalFilterRow.getLeftBracket() + this.getFieldCaption(originalFilterRow.getFieldName(), targetFieldFilter) + become + compareTypeDto.getName() + originalFilterRow.getRightBracket() + " " + (StringUtils.isEmpty((String)fo.getFilter()) ? "" : this.getLogicName(originalFilterRow.getLogic()) + " ");
                filterString = rowString + filterString;
                continue;
            }
            filterString = filterString + " " + this.getLogicName(((SimpleFilterRow)originalFilterRows.get(i - 1)).getLogic()) + " " + originalFilterRow.getLeftBracket() + this.getFieldCaption(originalFilterRow.getFieldName(), targetFieldFilter) + become + compareTypeDto.getName() + originalFilterRow.getRightBracket() + " ";
        }
        if (countOfBracket != 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5de6\u62ec\u53f7\u4e0e\u53f3\u62ec\u53f7\u4e0d\u5339\u914d\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"IDIStatisticsTargetConfigFormPlugin_12", (String)"data-idi-formplugin", (Object[])new Object[0]));
            return null;
        }
        originalFilterRows.removeAll(deleteFilterRows);
        fo.setFilter(filterString);
        FilterCondition fc = filterGridState.getFilterCondition();
        fc.setFilter(fo.getFilter());
        IDICondition condition = new IDICondition();
        condition.setDescription(new LocaleString(fo.getFilter()));
        condition.setFilterCondition(fc);
        return condition;
    }

    private CompareType getDefaultCompareType(List<FilterField> fieldFilter, SimpleFilterRow filterRow, MainEntityType billEntityType) {
        for (FilterField filterField : fieldFilter) {
            if (!filterField.getFieldName().equalsIgnoreCase(filterRow.getFieldName())) continue;
            CompareType compareType = filterField.getCompareType(filterRow.getCompareType());
            if (compareType == null) {
                compareType = filterField.getCompareType(filterField.getDefaultCompareTypeId());
            }
            if (compareType == null) {
                compareType = (CompareType)filterField.getCompareTypes().get(0);
            }
            return compareType;
        }
        throw new KDBizException(BosErrorCode.fieldNotExist, new Object[]{billEntityType.getName(), filterRow.getFieldName()});
    }

    private Integer checkBracket(int countOfBracket, SimpleFilterRow row) {
        if (StringUtils.isNotEmpty((String)row.getLeftBracket())) {
            countOfBracket += row.getLeftBracket().replace(" ", "").length();
        }
        if (StringUtils.isNotEmpty((String)row.getRightBracket())) {
            countOfBracket -= row.getRightBracket().replace(" ", "").length();
        }
        if (countOfBracket < 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5de6\u62ec\u53f7\u4e0e\u53f3\u62ec\u53f7\u4e0d\u5339\u914d\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"IDIStatisticsTargetConfigFormPlugin_12", (String)"data-idi-formplugin", (Object[])new Object[0]));
            return null;
        }
        return countOfBracket;
    }

    private String getLogicName(String logic) {
        return "1".equals(logic) ? ResManager.loadKDString((String)"\u6216\u8005", (String)"IDIStatisticsTargetConfigFormPlugin_13", (String)"data-idi-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5e76\u4e14", (String)"IDIStatisticsTargetConfigFormPlugin_14", (String)"data-idi-formplugin", (Object[])new Object[0]);
    }

    private CompareTypeDto getCompareType(SimpleFilterRow originalFilterRow) {
        for (CompareTypeDto compareTypeDto : addCompareType) {
            if (!compareTypeDto.getId().equalsIgnoreCase(originalFilterRow.getCompareType())) continue;
            return compareTypeDto;
        }
        return null;
    }

    private String getFieldCaption(String fieldName, List<FilterField> targetFieldFilter) {
        for (FilterField filterField : targetFieldFilter) {
            if (!filterField.getFieldName().equalsIgnoreCase(fieldName)) continue;
            return filterField.getCaption().toString();
        }
        return "";
    }

    private void filterField(List<Map<String, Object>> fieldColumns) {
        if (fieldColumns == null) {
            return;
        }
        HashMap acceptCompareType = new HashMap();
        HashSet<String> set = new HashSet<String>();
        acceptCompareType.put(0, set);
        set.add(CompareTypeEnum.EQUAL.getId());
        set.add(CompareTypeEnum.NOTEQUAL.getId());
        set = new HashSet();
        acceptCompareType.put(5, set);
        set.add(CompareTypeEnum.TODAY.getId());
        set.add(CompareTypeEnum.YESTERDAY.getId());
        set = new HashSet();
        acceptCompareType.put(10, set);
        set.add(CompareTypeEnum.CHECKBOXIN.getId());
        set = new HashSet();
        acceptCompareType.put(9, set);
        set.add(CompareTypeEnum.FIELDEQUAL.getId());
        HashMap fieldTypeMap = new HashMap();
        Set compareTypeSet = new HashSet<Integer>();
        fieldTypeMap.put(-9, compareTypeSet);
        if (this.getTargetEntityNumber().equalsIgnoreCase(this.getSourceEntityNumber())) {
            compareTypeSet.add(0);
        } else {
            compareTypeSet.add(9);
        }
        compareTypeSet = new HashSet();
        fieldTypeMap.put(91, compareTypeSet);
        fieldTypeMap.put(93, compareTypeSet);
        compareTypeSet.add(5);
        if (!this.getTargetEntityNumber().equalsIgnoreCase(this.getSourceEntityNumber())) {
            compareTypeSet.add(9);
        }
        compareTypeSet = new HashSet();
        fieldTypeMap.put(4, compareTypeSet);
        fieldTypeMap.put(3, compareTypeSet);
        if (this.getTargetEntityNumber().equalsIgnoreCase(this.getSourceEntityNumber())) {
            compareTypeSet.add(0);
        } else {
            compareTypeSet.add(9);
        }
        compareTypeSet = new HashSet();
        fieldTypeMap.put(12, compareTypeSet);
        compareTypeSet.add(10);
        for (Map<String, Object> fieldMap : fieldColumns) {
            Object compareTypes = fieldMap.get("compareTypes");
            String entityId = (String)fieldMap.get("entityId");
            if ("bd_materialpurchaseinfo".equals(entityId)) {
                fieldMap.put("type", "text");
            }
            Integer fieldType = (Integer)fieldMap.get("fieldType");
            compareTypeSet = (Set)fieldTypeMap.get(fieldType);
            if (!(compareTypes instanceof List)) continue;
            List compareTypeList = (List)compareTypes;
            Iterator compareTypesIterator = compareTypeList.iterator();
            boolean containsDate = false;
            ArrayList<CompareTypeDto> defaultDateCompareType = new ArrayList<CompareTypeDto>();
            CompareTypeDto firstCompareType = null;
            while (compareTypesIterator.hasNext()) {
                Object obj = compareTypesIterator.next();
                if (!(obj instanceof CompareTypeDto)) continue;
                CompareTypeDto compareType = (CompareTypeDto)obj;
                int groupId = compareType.getGroupId();
                if (groupId == 5) {
                    containsDate = true;
                    if (CompareTypeEnum.TODAY.getId().equals(compareType.getId()) || CompareTypeEnum.YESTERDAY.getId().equals(compareType.getId())) {
                        compareType.setInputCtlType(-1);
                        compareType.setNeedInput(false);
                        defaultDateCompareType.add(compareType);
                        compareTypesIterator.remove();
                        continue;
                    }
                }
                if ((groupId == 7 || groupId == 8) && (CompareTypeEnum.ORGIN.getId().equals(compareType.getId()) || CompareTypeEnum.ORGNOTIN.getId().equals(compareType.getId()) || CompareTypeEnum.ITEMCLASSIN.getId().equals(compareType.getId()) || CompareTypeEnum.ITEMCLASSNOTIN.getId().equals(compareType.getId()))) {
                    compareTypesIterator.remove();
                    continue;
                }
                boolean needLimit = groupId != 6 && groupId != 7 && groupId != 8 && compareTypeSet != null;
                if (!needLimit) continue;
                Set idSet = (Set)acceptCompareType.get(groupId);
                if (!compareTypeSet.contains(groupId) || idSet == null || !idSet.contains(compareType.getId())) {
                    compareTypesIterator.remove();
                    continue;
                }
                if (!CompareTypeEnum.FIELDEQUAL.getId().equals(compareType.getId())) continue;
                firstCompareType = compareType;
                compareTypesIterator.remove();
            }
            if (containsDate) {
                compareTypeList.addAll(0, addCompareType);
                if (!defaultDateCompareType.isEmpty()) {
                    compareTypeList.addAll(0, defaultDateCompareType);
                }
            }
            if (firstCompareType == null) continue;
            compareTypeList.add(0, firstCompareType);
        }
    }

    private String getTargetEntityNumber() {
        return (String)this.getView().getFormShowParameter().getCustomParam(PARAM_TARGETENTITYNUMBER);
    }

    private String getSourceEntityNumber() {
        return (String)this.getView().getFormShowParameter().getCustomParam(PARAM_SOURCEENTITYNUMBER);
    }

    private String getConditionJson() {
        return (String)this.getView().getFormShowParameter().getCustomParam(PARAM_TARGETCONDITIONCONFIG);
    }

    private String getCustomlast() {
        return (String)this.getView().getFormShowParameter().getCustomParam(PARAM_CUSTOMLAST);
    }

    public void filterGridF7Click(FilterGridF7ClickEvent filterGridF7ClickEvent) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)this.getTargetEntityNumber());
        EntityTypeUtil helper = new EntityTypeUtil();
        List cols = helper.getFilterColumns((IDataEntityType)entityType, false);
        for (Map fieldMap : cols) {
            Integer fieldType;
            if (!filterGridF7ClickEvent.getFieldName().equals(fieldMap.get("fieldName")) || (fieldType = (Integer)fieldMap.get("fieldType")) != 91 && fieldType != 93) continue;
            filterGridF7ClickEvent.setCancel(true);
        }
    }

    private boolean parseDateTimeCondition(SimpleFilterRow filterRow) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)this.getTargetEntityNumber());
        EntityTypeUtil helper = new EntityTypeUtil();
        List cols = helper.getFilterColumns((IDataEntityType)entityType, false);
        for (Map fieldMap : cols) {
            Integer fieldType;
            if (!filterRow.getFieldName().equals(fieldMap.get("fieldName")) || (fieldType = (Integer)fieldMap.get("fieldType")) != 91 && fieldType != 93) continue;
            return true;
        }
        return false;
    }

    private List<FilterField> addCompareField(String entityNumber) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        EntityTypeUtil helper = new EntityTypeUtil();
        List fieldFilter = helper.getFilterFields((IDataEntityType)entityType, false);
        List fieldEqualCompareType = CompareColumnHelper.getFieldEqualCompareType();
        HashSet idSet = new HashSet(10);
        ArrayList<FilterField> idFieldList = new ArrayList<FilterField>(10);
        for (FilterField ff : fieldFilter) {
            if (ff.getLatestParent() instanceof IBasedataField) {
                FilterField idFilterField = CompareColumnHelper.genIdField((FilterField)ff, idSet, (MainEntityType)entityType, (List)fieldEqualCompareType);
                if (idFilterField == null) continue;
                idFieldList.add(idFilterField);
                continue;
            }
            if (!(ff.getLatestParent() instanceof DateTimeProp)) continue;
            ff.getCompareTypes().addAll(fieldEqualCompareType);
        }
        fieldFilter.addAll(idFieldList);
        for (FilterField ff : fieldFilter) {
            ff.setFieldName(ff.getFullFieldName());
        }
        return fieldFilter;
    }
}

