/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.data;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.util.CollectionUtils;
import kd.data.idi.data.Decision;

public class Area {
    private String title;
    private List<Decision> decision;
    private String pk;

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public List<Decision> getDecision() {
        return this.decision;
    }

    public void setDecision(List<Decision> decision) {
        this.decision = decision;
    }

    public boolean hasControl() {
        if (this.decision != null && !this.decision.isEmpty()) {
            for (Decision d : this.decision) {
                if (!d.hasControl()) continue;
                return true;
            }
        }
        return false;
    }

    public String getPk() {
        return this.pk;
    }

    public void setPk(String pk) {
        this.pk = pk;
    }

    public boolean hasLC() {
        if (this.decision != null && !this.decision.isEmpty()) {
            for (Decision d : this.decision) {
                if (!d.isLCAttachment()) continue;
                return true;
            }
        }
        return false;
    }

    public Map<Long, Set<String>> achieveLcTemplateField(String billType) {
        HashMap<Long, Set<String>> lcTemplateFieldMap = new HashMap<Long, Set<String>>(10);
        if (this.decision != null && !this.decision.isEmpty()) {
            for (Decision d : this.decision) {
                if (!d.isLCAttachment()) continue;
                Long templateId = d.achieveLcTemplateId();
                Set<String> lcTemplateFieldSet = (Set<String>)lcTemplateFieldMap.get(templateId);
                if (CollectionUtils.isNotEmpty((Collection)lcTemplateFieldSet)) {
                    lcTemplateFieldSet.addAll(d.achieveLcTemplateField(billType));
                    continue;
                }
                lcTemplateFieldSet = d.achieveLcTemplateField(billType);
                lcTemplateFieldMap.put(templateId, lcTemplateFieldSet);
            }
        }
        return lcTemplateFieldMap;
    }
}

