/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.data;

import com.alibaba.fastjson.annotation.JSONField;
import java.util.List;
import java.util.Set;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.data.idi.data.AlarmConfig;
import kd.data.idi.data.BillControlTypeEnum;
import kd.data.idi.data.BillFlowConfig;
import kd.data.idi.data.BillInfo;
import kd.data.idi.data.BudgetConfig;
import kd.data.idi.data.DecisionFrontEndConfig;
import kd.data.idi.data.DecisionRule;
import kd.data.idi.data.FasindexConfig;
import kd.data.idi.data.GeneralLedger;
import kd.data.idi.data.IDICondition;
import kd.data.idi.data.InvoiceConfig;
import kd.data.idi.data.KeywordConfig;
import kd.data.idi.data.LinkUpBillConfig;
import kd.data.idi.data.MatchType;
import kd.data.idi.data.NewsConfig;
import kd.data.idi.data.StatisticsConfig;
import kd.data.idi.data.TimeLine;
import kd.data.idi.data.attachment.AttachmentConfig;
import kd.data.idi.data.attachment.CheckMethodEnum;

public class Decision {
    private String name;
    private String matchType;
    private int mark;
    private List<DecisionRule> rules;
    private AlarmConfig alarm;
    private NewsConfig news;
    private BillInfo matchBill;
    private DecisionFrontEndConfig frontEndConfig;
    private GeneralLedger generalLedger;
    private TimeLine timeLine;
    private boolean isShowWithoutLUB;
    private KeywordConfig keywordConfig;
    private IDICondition startCondition;
    private InvoiceConfig invoiceConfig;
    private BudgetConfig budgetConfig;
    private LinkUpBillConfig linkUpBillConfig;
    private boolean isEnabled = true;
    private BillFlowConfig billFlowConfig;
    private StatisticsConfig statisticsConfig;
    private FasindexConfig fasindexConfig;
    private BillControlTypeEnum billControl;
    private String pk;
    private AttachmentConfig attachmentConfig;
    private String remarks;

    public boolean isShowWithoutLUB() {
        return this.isShowWithoutLUB;
    }

    public void setShowWithoutLUB(boolean showWithoutLUB) {
        this.isShowWithoutLUB = showWithoutLUB;
    }

    public DecisionFrontEndConfig getFrontEndConfig() {
        return this.frontEndConfig;
    }

    public void setFrontEndConfig(DecisionFrontEndConfig frontEndConfig) {
        this.frontEndConfig = frontEndConfig;
    }

    public TimeLine getTimeLine() {
        return this.timeLine;
    }

    public void setTimeLine(TimeLine timeLine) {
        this.timeLine = timeLine;
    }

    public GeneralLedger getGeneralLedger() {
        return this.generalLedger;
    }

    public void setGeneralLedger(GeneralLedger generalLedger) {
        this.generalLedger = generalLedger;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getMark() {
        return this.mark;
    }

    public void setMark(int mark) {
        this.mark = mark;
    }

    public BillInfo getMatchBill() {
        return this.matchBill;
    }

    public void setMatchBill(BillInfo matchBill) {
        this.matchBill = matchBill;
    }

    public String getMatchType() {
        return this.matchType;
    }

    public void setMatchType(String matchType) {
        this.matchType = matchType;
    }

    public List<DecisionRule> getRules() {
        return this.rules;
    }

    public void setRules(List<DecisionRule> rules) {
        this.rules = rules;
    }

    public AlarmConfig getAlarm() {
        return this.alarm;
    }

    public void setAlarm(AlarmConfig alarm) {
        this.alarm = alarm;
    }

    public NewsConfig getNews() {
        return this.news;
    }

    public void setNews(NewsConfig news) {
        this.news = news;
    }

    public KeywordConfig getKeywordConfig() {
        return this.keywordConfig;
    }

    public void setKeywordConfig(KeywordConfig keywordConfig) {
        this.keywordConfig = keywordConfig;
    }

    public IDICondition getStartCondition() {
        return this.startCondition;
    }

    public void setStartCondition(IDICondition startCondition) {
        this.startCondition = startCondition;
    }

    public InvoiceConfig getInvoiceConfig() {
        return this.invoiceConfig;
    }

    public void setInvoiceConfig(InvoiceConfig invoiceConfig) {
        this.invoiceConfig = invoiceConfig;
    }

    public BudgetConfig getBudgetConfig() {
        return this.budgetConfig;
    }

    public void setBudgetConfig(BudgetConfig budgetConfig) {
        this.budgetConfig = budgetConfig;
    }

    public LinkUpBillConfig getLinkUpBillConfig() {
        return this.linkUpBillConfig;
    }

    public void setLinkUpBillConfig(LinkUpBillConfig linkUpBillConfig) {
        this.linkUpBillConfig = linkUpBillConfig;
    }

    public BillFlowConfig getBillFlowConfig() {
        return this.billFlowConfig;
    }

    public void setBillFlowConfig(BillFlowConfig billFlowConfig) {
        this.billFlowConfig = billFlowConfig;
    }

    public StatisticsConfig getStatisticsConfig() {
        return this.statisticsConfig;
    }

    public void setStatisticsConfig(StatisticsConfig statisticsConfig) {
        this.statisticsConfig = statisticsConfig;
    }

    public FasindexConfig getFasindexConfig() {
        return this.fasindexConfig;
    }

    public void setFasindexConfig(FasindexConfig fasindexConfig) {
        this.fasindexConfig = fasindexConfig;
    }

    @JSONField(serialize=false, deserialize=false)
    public boolean isNull() {
        return !StringUtils.isNotEmpty((String)this.name) && !StringUtils.isNotEmpty((String)this.matchType) && this.mark <= 0 && this.matchBill == null && this.alarm == null && this.news == null && this.generalLedger == null && this.timeLine == null && this.keywordConfig == null && this.invoiceConfig == null && this.budgetConfig == null && (this.rules == null || this.rules.isEmpty()) && this.frontEndConfig == null && this.startCondition == null && this.linkUpBillConfig == null && this.billFlowConfig == null && this.statisticsConfig == null && this.fasindexConfig == null && this.attachmentConfig == null;
    }

    public boolean dataIntegrity() {
        if (StringUtils.isNotEmpty((String)this.name) && StringUtils.isNotEmpty((String)this.matchType)) {
            if (MatchType.ALARM.getType().equalsIgnoreCase(this.matchType) && this.alarm != null) {
                return true;
            }
            if (MatchType.NEWS.getType().equalsIgnoreCase(this.matchType) && this.news != null) {
                return true;
            }
            if (MatchType.GENERALLEDGER.getType().equalsIgnoreCase(this.matchType) && this.generalLedger != null) {
                return true;
            }
            if (MatchType.FUTURE.getType().equalsIgnoreCase(this.matchType) && this.timeLine != null && this.matchBill != null) {
                return true;
            }
            if (MatchType.KEYWORD.getType().equalsIgnoreCase(this.matchType) && this.keywordConfig != null) {
                return true;
            }
            if (MatchType.INVOICE.getType().equalsIgnoreCase(this.matchType) && this.invoiceConfig != null) {
                return true;
            }
            if (MatchType.BUDGET.getType().equalsIgnoreCase(this.matchType) && this.budgetConfig != null) {
                return true;
            }
            if (MatchType.BILLFLOW.getType().equalsIgnoreCase(this.matchType) && this.billFlowConfig != null) {
                return true;
            }
            if (MatchType.STATISTICS.getType().equalsIgnoreCase(this.matchType) && this.statisticsConfig != null) {
                return true;
            }
            if (MatchType.LOGISTICSINFORMATION.getType().equalsIgnoreCase(this.matchType)) {
                return true;
            }
            if (MatchType.FASINDEX.getType().equalsIgnoreCase(this.matchType) && this.fasindexConfig != null) {
                return true;
            }
            if (MatchType.ATTACHMENT.getType().equals(this.matchType) && this.attachmentConfig != null) {
                return true;
            }
            if (!MatchType.containsType(this.matchType)) {
                return true;
            }
            if (this.matchBill != null || this.rules != null && !this.rules.isEmpty() || this.frontEndConfig != null || this.startCondition != null || this.linkUpBillConfig != null) {
                return true;
            }
        }
        return false;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    public void extractProperties(Set<String> varSet, String billType) {
        List<DecisionRule> ruleList;
        String[] stringArray;
        if (this.getStartCondition() != null) {
            this.getStartCondition().extractProperties(varSet, billType, new String[]{billType});
        }
        if (this.getAlarm() != null) {
            this.getAlarm().extractProperties(varSet, billType);
        }
        if (this.getNews() != null) {
            this.getNews().extractProperties(varSet, billType);
        }
        if (this.getFrontEndConfig() != null) {
            this.getFrontEndConfig().extractProperties(varSet, billType, true);
        }
        if (this.getGeneralLedger() != null) {
            this.getGeneralLedger().extractProperties(varSet, billType);
        }
        if (this.getKeywordConfig() != null) {
            this.getKeywordConfig().extractProperties(varSet, billType);
        }
        if (this.getInvoiceConfig() != null) {
            this.getInvoiceConfig().extractProperties(varSet, billType);
        }
        if (this.getBudgetConfig() != null) {
            this.getBudgetConfig().extractProperties(varSet, billType);
        }
        if (this.matchBill != null) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = billType;
            stringArray = stringArray2;
            stringArray2[1] = this.matchBill.getEntityNumber();
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = billType;
        }
        String[] billTypes = stringArray;
        if (this.getLinkUpBillConfig() != null) {
            this.getLinkUpBillConfig().extractProperties(varSet, billType, billTypes);
        }
        if ((ruleList = this.getRules()) != null) {
            for (DecisionRule decisionRule : ruleList) {
                decisionRule.extractProperties(varSet, billType, billTypes);
            }
        }
        if (this.getStatisticsConfig() != null) {
            this.getStatisticsConfig().extractProperties(varSet, billType);
        }
        if (this.getFasindexConfig() != null) {
            this.getFasindexConfig().extractProperties(varSet, billType);
        }
        if (this.getAttachmentConfig() != null) {
            this.getAttachmentConfig().extractProperties(varSet, billType);
        }
    }

    public boolean hasControl() {
        return BillControlTypeEnum.FORCE == this.billControl || BillControlTypeEnum.CONFIREM == this.billControl;
    }

    public BillControlTypeEnum getBillControl() {
        return this.billControl;
    }

    public void setBillControl(BillControlTypeEnum billControl) {
        this.billControl = billControl;
    }

    public String getPk() {
        return this.pk;
    }

    public void setPk(String pk) {
        this.pk = pk;
    }

    public AttachmentConfig getAttachmentConfig() {
        return this.attachmentConfig;
    }

    public void setAttachmentConfig(AttachmentConfig attachmentConfig) {
        this.attachmentConfig = attachmentConfig;
    }

    public boolean isLCAttachment() {
        return this.isEnabled && MatchType.ATTACHMENT.getType().equals(this.matchType) && this.getAttachmentConfig() != null && this.getAttachmentConfig().getCheckMethod() != null && CheckMethodEnum.LC == this.getAttachmentConfig().getCheckMethod();
    }

    public long achieveLcTemplateId() {
        return this.getAttachmentConfig().getLcTemplateId();
    }

    public Set<String> achieveLcTemplateField(String billType) {
        return this.getAttachmentConfig().achieveLcTemplateFieldFromScript(billType);
    }

    public boolean needShowAllEntryCheckTrue() {
        if (MatchType.LINKUP_BILL.getType().equals(this.matchType) && LinkUpBillConfig.CheckType.CheckBillContent == this.linkUpBillConfig.getCheckType() && CollectionUtils.isNotEmpty(this.rules)) {
            for (DecisionRule rule : this.rules) {
                if (!rule.isShowAllEntryCheckTrue()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean needShowAllCheckTrue() {
        if (MatchType.LINKUP_BILL.getType().equals(this.matchType) && LinkUpBillConfig.CheckType.CheckBillContent == this.linkUpBillConfig.getCheckType() && CollectionUtils.isNotEmpty(this.rules)) {
            for (DecisionRule rule : this.rules) {
                if (!rule.isShowAllCheckTrue()) continue;
                return true;
            }
        }
        return false;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }
}

