/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.data;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.util.StringUtils;
import kd.data.idi.data.DimensionTypeEnum;
import kd.data.idi.data.NumericalUnitEnum;

public class FasindexConfig {
    private long fasindexId;
    private String fasindexNumber;
    private String fasindexName;
    private int precision;
    private ShowTypeEnum showType;
    private List<ValueTypeEnum> valueTypeList;
    private List<DimensionValue> dimensionValueList;
    private NumericalUnitEnum numericalUnit;

    public long getFasindexId() {
        return this.fasindexId;
    }

    public void setFasindexId(long fasindexId) {
        this.fasindexId = fasindexId;
    }

    public ShowTypeEnum getShowType() {
        return this.showType;
    }

    public void setShowType(ShowTypeEnum showType) {
        this.showType = showType;
    }

    public List<ValueTypeEnum> getValueTypeList() {
        return this.valueTypeList;
    }

    public void setValueTypeList(List<ValueTypeEnum> valueTypeList) {
        this.valueTypeList = valueTypeList;
    }

    public List<DimensionValue> getDimensionValueList() {
        return this.dimensionValueList;
    }

    public void setDimensionValueList(List<DimensionValue> dimensionValueList) {
        this.dimensionValueList = dimensionValueList;
    }

    public void extractProperties(Set<String> varSet, String billType) {
        if (this.dimensionValueList != null && !this.dimensionValueList.isEmpty()) {
            for (DimensionValue dimensionValue : this.dimensionValueList) {
                if (!StringUtils.isNotEmpty((String)dimensionValue.getProperty())) continue;
                varSet.add(dimensionValue.getProperty());
            }
        }
    }

    public String getFasindexNumber() {
        return this.fasindexNumber;
    }

    public void setFasindexNumber(String fasindexNumber) {
        this.fasindexNumber = fasindexNumber;
    }

    public String getFasindexName() {
        return this.fasindexName;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public void setFasindexName(String fasindexName) {
        this.fasindexName = fasindexName;
    }

    public String valueTypeListToStr() {
        if (this.valueTypeList == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (ValueTypeEnum valueTypeEnum : this.valueTypeList) {
            sb.append(valueTypeEnum.type).append(',');
        }
        return sb.length() > 0 ? sb.substring(0, sb.length() - 1) : sb.toString();
    }

    public void strToValueTypeList(String valueTypeStr) {
        if (StringUtils.isNotEmpty((String)valueTypeStr)) {
            String[] strs;
            if (this.valueTypeList == null) {
                this.valueTypeList = new ArrayList<ValueTypeEnum>(10);
            }
            for (String str : strs = valueTypeStr.split(",")) {
                ValueTypeEnum valueType = ValueTypeEnum.convert(str);
                if (valueType == null) continue;
                this.valueTypeList.add(valueType);
            }
        }
    }

    public void setNumericalUnit(NumericalUnitEnum numericalUnit) {
        this.numericalUnit = numericalUnit;
    }

    public NumericalUnitEnum getNumericalUnit() {
        return this.numericalUnit;
    }

    public static class DimensionValue {
        private long dimensionId;
        private String dimensionNumber;
        private String dimensionName;
        private boolean fix;
        private String property;
        private String propertyName;
        private String fixValue;
        private String displayFixValue;
        private boolean basedata;
        private boolean periodDimension;
        private DimensionTypeEnum dimensionType;

        public long getDimensionId() {
            return this.dimensionId;
        }

        public void setDimensionId(long dimensionId) {
            this.dimensionId = dimensionId;
        }

        public boolean isFix() {
            return this.fix;
        }

        public void setFix(boolean fix) {
            this.fix = fix;
        }

        public String getProperty() {
            return this.property;
        }

        public void setProperty(String property) {
            this.property = property;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public void setPropertyName(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getFixValue() {
            return this.fixValue;
        }

        public void setFixValue(String fixValue) {
            this.fixValue = fixValue;
        }

        public String getDisplayFixValue() {
            return this.displayFixValue;
        }

        public void setDisplayFixValue(String displayFixValue) {
            this.displayFixValue = displayFixValue;
        }

        public boolean isBasedata() {
            return this.basedata;
        }

        public void setBasedata(boolean basedata) {
            this.basedata = basedata;
        }

        public String getDimensionNumber() {
            return this.dimensionNumber;
        }

        public void setDimensionNumber(String dimensionNumber) {
            this.dimensionNumber = dimensionNumber;
        }

        public boolean isPeriodDimension() {
            return this.periodDimension;
        }

        public void setPeriodDimension(boolean periodDimension) {
            this.periodDimension = periodDimension;
        }

        public String getDimensionName() {
            return this.dimensionName;
        }

        public void setDimensionName(String dimensionName) {
            this.dimensionName = dimensionName;
        }

        public DimensionTypeEnum getDimensionType() {
            return this.dimensionType;
        }

        public void setDimensionType(DimensionTypeEnum dimensionType) {
            this.dimensionType = dimensionType;
        }
    }

    public static enum ValueTypeEnum {
        C_00("00"),
        C_01("01"),
        C_02("02"),
        C_03("03"),
        C_04("04"),
        C_05("05"),
        C_06("06");

        private String type;

        private ValueTypeEnum(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public static ValueTypeEnum convert(String type) {
            if (StringUtils.isNotEmpty((String)type)) {
                for (ValueTypeEnum e : ValueTypeEnum.values()) {
                    if (!type.equals(e.type)) continue;
                    return e;
                }
            }
            return null;
        }

        public String getAlias() {
            String alias = "";
            switch (this.type) {
                case "01": {
                    alias = ResManager.loadKDString((String)"\u540c\u6bd4\u589e\u957f\u7387", (String)"FasindexConfig_0", (String)"data-idi-core", (Object[])new Object[0]);
                    break;
                }
                case "02": {
                    alias = ResManager.loadKDString((String)"\u540c\u6bd4\u589e\u957f\u989d", (String)"FasindexConfig_1", (String)"data-idi-core", (Object[])new Object[0]);
                    break;
                }
                case "03": {
                    alias = ResManager.loadKDString((String)"\u73af\u6bd4\u589e\u957f\u7387", (String)"FasindexConfig_2", (String)"data-idi-core", (Object[])new Object[0]);
                    break;
                }
                case "04": {
                    alias = ResManager.loadKDString((String)"\u73af\u6bd4\u589e\u957f\u989d", (String)"FasindexConfig_3", (String)"data-idi-core", (Object[])new Object[0]);
                    break;
                }
                case "05": {
                    alias = ResManager.loadKDString((String)"\u4e0a\u5e74\u540c\u671f", (String)"FasindexConfig_4", (String)"data-idi-core", (Object[])new Object[0]);
                    break;
                }
                case "06": {
                    alias = ResManager.loadKDString((String)"\u4e0a\u671f", (String)"FasindexConfig_5", (String)"data-idi-core", (Object[])new Object[0]);
                    break;
                }
                default: {
                    alias = "";
                }
            }
            return alias;
        }
    }

    public static enum ShowTypeEnum {
        LIST("list");

        private String type;

        private ShowTypeEnum(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public static ShowTypeEnum convert(String type) {
            if (type != null) {
                for (ShowTypeEnum e : ShowTypeEnum.values()) {
                    if (!type.equals(e.type)) continue;
                    return e;
                }
            }
            return null;
        }
    }
}

