/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.data;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;

public class HoverContent {
    private ContentType type;
    private String content;
    private Map<String, Object> data;

    public ContentType getType() {
        return this.type;
    }

    public void setType(ContentType type) {
        this.type = type;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setData(Map<String, Object> data) {
        this.data = data;
    }

    public String getContent() {
        return this.content;
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public void addData(String key, Object value) {
        if (this.data == null) {
            this.data = new HashMap<String, Object>();
        }
        this.data.put(key, value);
    }

    public static HoverContent createHref(String content, Map<String, Object> data) {
        HoverContent hoverContent = new HoverContent();
        hoverContent.content = content;
        hoverContent.type = ContentType.HREF;
        hoverContent.data = data;
        if (hoverContent.data == null) {
            hoverContent.data = new HashMap<String, Object>();
        }
        hoverContent.data.put("action", "showBillForm");
        return hoverContent;
    }

    public static HoverContent createViewInvoice(String content, String serialNo) {
        HoverContent hoverContent = new HoverContent();
        hoverContent.content = content;
        hoverContent.type = ContentType.HREF;
        hoverContent.data = new HashMap<String, Object>();
        hoverContent.data.put("serialNo", serialNo);
        hoverContent.data.put("action", "showInvoiceForm");
        return hoverContent;
    }

    public static HoverContent createHref(String content, DynamicObject billObj) {
        HoverContent hoverContent = new HoverContent();
        hoverContent.content = content;
        hoverContent.type = ContentType.HREF;
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("billId", String.valueOf(billObj.getPkValue()));
        data.put("entityNumber", billObj.getDataEntityType().getName());
        data.put("action", "showBillForm");
        hoverContent.data = data;
        return hoverContent;
    }

    public static HoverContent createHref(String content, Object id, String entityType) {
        HoverContent hoverContent = new HoverContent();
        hoverContent.content = content;
        hoverContent.type = ContentType.HREF;
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("billId", String.valueOf(id));
        data.put("entityNumber", entityType);
        data.put("action", "showBillForm");
        hoverContent.data = data;
        return hoverContent;
    }

    public static HoverContent createChat(String content, Map<String, Object> data) {
        HoverContent hoverContent = new HoverContent();
        hoverContent.content = content;
        hoverContent.type = ContentType.CHAT;
        hoverContent.data = data;
        if (hoverContent.data == null) {
            hoverContent.data = new HashMap<String, Object>();
        }
        hoverContent.data.put("action", "chatYZJ");
        return hoverContent;
    }

    public static HoverContent createChat(String content, Object userId) {
        HoverContent hoverContent = new HoverContent();
        hoverContent.content = content;
        hoverContent.type = ContentType.HREF;
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("action", "chatYZJ");
        if (userId != null) {
            data.put("userId", String.valueOf(userId));
        } else {
            data = new HashMap();
        }
        hoverContent.data = data;
        return hoverContent;
    }

    public static HoverContent createText(String content) {
        HoverContent hoverContent = new HoverContent();
        hoverContent.content = content;
        hoverContent.type = ContentType.TEXT;
        return hoverContent;
    }

    public static HoverContent createTitle(String content) {
        HoverContent hoverContent = new HoverContent();
        hoverContent.content = content;
        hoverContent.type = ContentType.TITLE;
        return hoverContent;
    }

    public boolean showBillFormAction() {
        return this.type == ContentType.HREF && this.data != null && !this.data.isEmpty() && "showBillForm".equals(this.data.get("action"));
    }

    public static enum ContentType {
        TITLE("title"),
        TEXT("text"),
        HREF("href"),
        CHAT("chat");

        private String type;

        private ContentType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public static ContentType convertFromMatchType(String type) {
            if (type != null) {
                for (ContentType e : ContentType.values()) {
                    if (!type.equals(e.type)) continue;
                    return e;
                }
            }
            return null;
        }
    }
}

