/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.data;

import kd.data.idi.constant.MultiLangEnumBridge;

public enum MatchType {
    LINKUP_BILL("linkup_bill", new MultiLangEnumBridge("\u5355\u636e\u68c0\u67e5", "IDIMatchType_linkup_bill", "data-idi-core"), true),
    NEWS("news", new MultiLangEnumBridge("\u65b0\u95fb\u7c7b", "IDIMatchType_news", "data-idi-core"), true),
    ALARM("alarm", new MultiLangEnumBridge("\u4e8b\u4ef6\u91cd\u590d", "IDIMatchType_alarm", "data-idi-core"), true),
    GENERALLEDGER("general_ledger", new MultiLangEnumBridge("\u8d26\u8868\u67e5\u8be2\u7c7b", "IDIMatchType_general_ledger", "data-idi-core"), true),
    FUTURE("future", new MultiLangEnumBridge("\u672a\u6765\u8ba1\u5212\u5c55\u793a", "IDIMatchType_future", "data-idi-core"), true),
    KEYWORD("keyword", new MultiLangEnumBridge("\u654f\u611f\u8bcd\u68c0\u6d4b", "IDIMatchType_keyword", "data-idi-core"), true),
    INVOICE("invoice", new MultiLangEnumBridge("\u7968\u636e\u68c0\u67e5", "IDIMatchType_invoice", "data-idi-core"), true),
    BUDGET("budget", new MultiLangEnumBridge("\u9884\u7b97\u67e5\u8be2", "IDIMatchType_budget", "data-idi-core"), false),
    LOGISTICSINFORMATION("logistics_information", new MultiLangEnumBridge("\u7269\u6d41\u4fe1\u606f\u67e5\u8be2", "IDIMatchType_logistics_information", "data-idi-core"), true),
    BILLFLOW("billflow", new MultiLangEnumBridge("\u4e0a\u4e0b\u6e38\u5173\u952e\u5355\u636e\u8282\u70b9", "IDIMatchType_billflow", "data-idi-core"), true),
    STATISTICS("statistics", new MultiLangEnumBridge("\u6570\u636e\u7edf\u8ba1\u53ca\u5c55\u793a", "IDIMatchType_statistics", "data-idi-core"), true),
    FASINDEX("fasindex", new MultiLangEnumBridge("\u6307\u6807\u67e5\u8be2", "IDIMatchType_fasindex", "data-idi-core"), false),
    ATTACHMENT("attachment", new MultiLangEnumBridge("\u9644\u4ef6\u68c0\u67e5", "IDIMatchType_attachment", "data-idi-core"), true);

    private String type;
    private MultiLangEnumBridge bridge;
    private boolean enable;

    private MatchType(String type, MultiLangEnumBridge bridge, boolean enable) {
        this.type = type;
        this.bridge = bridge;
        this.enable = enable;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.bridge.loadKDString();
    }

    public boolean isEnable() {
        return this.enable;
    }

    public static MatchType convertFromMatchType(String type) {
        if (type != null) {
            for (MatchType e : MatchType.values()) {
                if (!type.equals(e.type)) continue;
                return e;
            }
        }
        return null;
    }

    public static boolean containsType(String type) {
        if (type != null) {
            for (MatchType e : MatchType.values()) {
                if (!type.equalsIgnoreCase(e.type)) continue;
                return true;
            }
        }
        return false;
    }
}

