/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.engine;

import java.math.BigDecimal;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.data.idi.data.BudgetConfig;
import kd.data.idi.data.Decision;
import kd.data.idi.data.DecisionResult;
import kd.data.idi.data.SchemaContext;
import kd.data.idi.engine.DecisionExecutor;
import kd.data.idi.engine.ExecutorHelper;
import kd.data.idi.engine.SchemaExecutorLogger;
import kd.data.idi.util.IDIJSONUtils;

public class BudgetExecutor
implements DecisionExecutor {
    @Override
    public DecisionResult execute(SchemaContext context, Decision decision) {
        BudgetConfig budgetConfig = decision.getBudgetConfig();
        if (budgetConfig == null) {
            return null;
        }
        DynamicObject billObj = ExecutorHelper.getSelfBill(context);
        Object value = ExecutorHelper.getValueAndNameByName(billObj, budgetConfig.getAmountField(), false).getValue();
        SchemaExecutorLogger.info(String.format(ResManager.loadKDString((String)"\u9884\u7b97\u68c0\u67e5\u5f00\u59cb\uff0c\u4e1a\u52a1\u5355\u636e\u6570\u636e%1$s, \u5355\u636eid%2$s\uff0c\u91d1\u989d\u5b57\u6bb5%3$s\uff0c\u6570\u636e%4$s", (String)"BudgetExecutor_4", (String)"data-idi-core", (Object[])new Object[0]), context.getEntityType(), billObj.getPkValue(), budgetConfig.getAmountField(), value == null ? "null" : value.toString()), new Object[0]);
        if (value == null) {
            String message = ResManager.loadKDString((String)"\u503c\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6bd4\u8f83", (String)"BudgetExecutor_5", (String)"data-idi-core", (Object[])new Object[0]);
            SchemaExecutorLogger.info(budgetConfig.getAmountField() + message, new Object[0]);
            throw new KDBizException(ResManager.loadKDString((String)"\u5bf9\u6bd4\u5b57\u6bb5\u503c\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6bd4\u8f83", (String)"BudgetExecutor_1", (String)"data-idi-core", (Object[])new Object[0]));
        }
        if (!(value instanceof BigDecimal)) {
            String message = ResManager.loadKDString((String)"\u503c\u4e3a\u975eBigdecimal\u7c7b\u578b\uff0c\u65e0\u6cd5\u6bd4\u8f83", (String)"BudgetExecutor_6", (String)"data-idi-core", (Object[])new Object[0]);
            SchemaExecutorLogger.info(budgetConfig.getAmountField() + message, new Object[0]);
            throw new KDBizException(ResManager.loadKDString((String)"\u5bf9\u6bd4\u5b57\u6bb5\u503c\u4e0d\u662f\u91d1\u989d\u7c7b\u578b\uff0c\u65e0\u6cd5\u6bd4\u8f83", (String)"BudgetExecutor_2", (String)"data-idi-core", (Object[])new Object[0]));
        }
        BigDecimal reqAmount = (BigDecimal)value;
        try {
            Object[] params = new Object[]{billObj};
            String retStr = (String)DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"BgControlService", (String)"queryBalance", (Object[])params);
            Map resultMap = (Map)IDIJSONUtils.cast((String)retStr, Map.class);
            BigDecimal balance = (BigDecimal)resultMap.get("balance");
            DecisionResult result = new DecisionResult();
            result.setDecision(decision);
            if (reqAmount.compareTo(balance) > 0) {
                result.setShowText(budgetConfig.getDetectedText());
                result.setStatus(budgetConfig.getDetectedIcon());
            } else {
                result.setShowText(budgetConfig.getNotDetectedText());
                result.setStatus(budgetConfig.getNotDetectedIcon());
            }
            SchemaExecutorLogger.info(String.format(ResManager.loadKDString((String)"\u9884\u7b97\u68c0\u67e5\u7ed3\u675f\uff0c\u9884\u7b97\u67e5\u8be2\u7ed3\u679c%1$s, \u68c0\u6d4b\u7ed3\u679c%2$s", (String)"BudgetExecutor_7", (String)"data-idi-core", (Object[])new Object[0]), retStr, IDIJSONUtils.toJsonString((Object)result)), new Object[0]);
            return result;
        }
        catch (Exception ex) {
            SchemaExecutorLogger.error(ex);
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u52a0\u8f7d\u5f02\u5e38\uff0c\u8bf7\u5237\u65b0\u6d1e\u5bdf\u9762\u677f", (String)"BudgetExecutor_3", (String)"data-idi-core", (Object[])new Object[0]));
        }
    }
}

