/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.engine;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.ext.data.idi.model.BaseHighLight;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.data.idi.api.external.impl.AdditionalConfig;
import kd.data.idi.api.external.impl.InvoicePiaoZoneApiAbutmentImpl;
import kd.data.idi.api.external.impl.InvoicePiaoZoneParam;
import kd.data.idi.api.external.impl.UrlParam;
import kd.data.idi.data.CustomInvoiceParam;
import kd.data.idi.data.CustomInvoiceParamValue;
import kd.data.idi.data.Decision;
import kd.data.idi.data.DecisionResult;
import kd.data.idi.data.DeductionGradeConfig;
import kd.data.idi.data.IDICondition;
import kd.data.idi.data.InvoiceCloudCodeType;
import kd.data.idi.data.InvoiceConfig;
import kd.data.idi.data.InvoiceConfigCustom;
import kd.data.idi.data.InvoiceDecisionRule;
import kd.data.idi.data.InvoiceFailureEntity;
import kd.data.idi.data.InvoiceImageResult;
import kd.data.idi.data.InvoiceImageRuleResult;
import kd.data.idi.data.SchemaContext;
import kd.data.idi.engine.DecisionExecutor;
import kd.data.idi.engine.DeductionGrade;
import kd.data.idi.engine.ExecutorHelper;
import kd.data.idi.engine.IDIInvoiceCloudHelper;
import kd.data.idi.engine.ParamFactory;
import kd.data.idi.engine.SchemaExecutorLogger;
import kd.data.idi.engine.ScriptFormIdHandler;
import kd.data.idi.engine.ScriptUtils;
import kd.data.idi.mq.IDIMqMessagePublisher;
import kd.data.idi.util.HighLightBuilder;
import kd.data.idi.util.IDIJSONUtils;
import kd.data.idi.util.InvoiceParser;

public class InvoiceExecutor
implements DecisionExecutor {
    private static final String INVOICE_NO = "invoiceno";
    private static final String INVOICE_CODE = "invoicecode";
    private static final String INVOICE_TYPE = "invoicetype";
    private static final String IMAGE_NO = "imagenumber";
    private static final String IMAGE_PAGE = "imagepage";
    private static final String INVOICE_ID = "invoiceid";
    private static final String ELECTRONICTICKETNUM = "electronicticketnum";
    private static final String CUSTOMERIDENTITYNUM = "customeridentitynum";
    private static final String PRINTNUM = "printnum";
    private static final String PRINTINGSEQUENCENO = "printingsequenceno";
    private static final String TRAINNUM = "trainnum";
    private static final String INVOICEDATE = "invoicedate";
    private static final String BILLID = "billid";
    private static final String ALL_INVOICE_TYPE = "ALL";
    private static final String ALLINVOICETOTALAMOUNT = "allinvoicetotalamount";
    private static final String ALLTYPETOTALAMOUNT = "alltypetotalamount";
    private static final String TOTALAMOUNT = "totalamount";
    private static final String KEYSPLITOR = ",";
    private DeductionGrade deductionGrade = null;
    private static final int INDEX_IMAGEPAGE = 0;
    private static final int INDEX_IMAGENO = 1;
    private static final int INDEX_INVOICENO = 2;
    private static final int INDEX_BILLID = 3;
    private static final int INDEX_INVOICETYPE = 4;
    private static final int INDEX_INVOICECODE = 5;
    private Map<String, List<IDIInvoiceCloudHelper.RepeatInvoiceInfo>> repeatInvoiceList = null;
    private static final String PARAM_ISUSEINVOICECLOUD = "isUseInvoiceCloud";
    private boolean useInvoiceCloud;
    private static String DUPLICATEFIELD = "indexfield";
    private static final String DETAILITEM = "items";

    @Override
    public DecisionResult execute(SchemaContext context, Decision decision) {
        FilterCondition filterCondition;
        FilterCondition filterCondition2;
        if (decision == null || decision.getInvoiceConfig() == null) {
            return null;
        }
        this.deductionGrade = new DeductionGrade(context);
        this.useInvoiceCloud = ParamFactory.getBoolean(PARAM_ISUSEINVOICECLOUD, false);
        DecisionResult decisionResult = new DecisionResult();
        decisionResult.setDecision(decision);
        DynamicObject billObj = ExecutorHelper.getSelfBill(context);
        String billTypeName = billObj.getDynamicObjectType().getName();
        IDICondition startCondition = decision.getInvoiceConfig().getStartCondition();
        if (startCondition != null && (filterCondition2 = startCondition.getFilterCondition()) != null) {
            MainEntityType billType = EntityMetadataCache.getDataEntityType((String)billTypeName);
            FilterBuilder filterBuilder = new FilterBuilder(billType, filterCondition2);
            try {
                filterBuilder.buildFilter(false);
            }
            catch (Exception ex) {
                SchemaExecutorLogger.error(IDIJSONUtils.toJsonString((Object)filterCondition2), ex);
                throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u627e\u542f\u52a8\u6761\u4ef6\u9519\u8bef", (String)"InvoiceExecutor_45", (String)"data-idi-core", (Object[])new Object[0]));
            }
            QFilter startConditionFilter = filterBuilder.getQFilter();
            boolean match = this.checkStartCondition(billObj, startConditionFilter, billTypeName);
            if (!match) {
                this.deductionGrade.deduct(decision.getInvoiceConfig().getDeductionGradeConfigList(), DeductionGradeConfig.DeductionGradeItem.STARTCONDITION_NOTMATCH);
                DecisionResult result = new DecisionResult();
                result.setDeductPercent(this.deductionGrade.getValue());
                boolean isPass = this.findDeductionGradeConfigPass(decision.getInvoiceConfig().getDeductionGradeConfigList(), DeductionGradeConfig.DeductionGradeItem.STARTCONDITION_NOTMATCH);
                result.setStatus(isPass ? "empty" : "alarming");
                result.setDecision(decision);
                result.setShowText(ResManager.loadKDString((String)"\u542f\u52a8\u6761\u4ef6\u4e0d\u6ee1\u8db3", (String)"IDIGeneralPointDeductFormPlugin_0", (String)"data-idi-formplugin", (Object[])new Object[0]));
                return result;
            }
        }
        QFilter ocrInvoiceFilter = null;
        IDICondition idiCondition = decision.getInvoiceConfig().getIdiCondition();
        if (idiCondition != null && (filterCondition = idiCondition.getFilterCondition()) != null) {
            MainEntityType billType = EntityMetadataCache.getDataEntityType((String)"bos_invoice");
            FilterBuilder filterBuilder = new FilterBuilder(billType, filterCondition);
            try {
                filterBuilder.buildFilter(false);
            }
            catch (Exception ex) {
                SchemaExecutorLogger.error(IDIJSONUtils.toJsonString((Object)filterCondition), ex);
                throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u627e\u89c4\u5219\u6709\u9519\u8bef", (String)"InvoiceExecutor_21", (String)"data-idi-core", (Object[])new Object[0]));
            }
            ocrInvoiceFilter = filterBuilder.getQFilter();
        }
        List<Map<String, Object>> invoiceData = this.queryInvoiceData(billObj, ocrInvoiceFilter, decision.getInvoiceConfig().getCompanyFieldName(), context, decision.getInvoiceConfig().isUseCustomInvoiceParam(), decision.getInvoiceConfig().getCustomInvoiceParam());
        Map<String, List<InvoiceFailureEntity>> failureInvoiceMap = this.getFailureInvoiceData(billObj.getPkValue().toString());
        SchemaExecutorLogger.info(String.format(ResManager.loadKDString((String)"\u6267\u884c\u7968\u636e\u68c0\u6d4b\uff0c\u5355\u636e\u7c7b\u578b%1$s\uff0c\u5355\u636eid%2$s\uff0c\u53d1\u7968\u4fe1\u606f%3$s", (String)"InvoiceExecutor_22", (String)"data-idi-core", (Object[])new Object[0]), billTypeName, billObj.getPkValue(), IDIJSONUtils.toJsonString(invoiceData)), new Object[0]);
        if (invoiceData.isEmpty()) {
            this.deductionGrade.deduct(decision.getInvoiceConfig().getDeductionGradeConfigList(), DeductionGradeConfig.DeductionGradeItem.NO_INVOICE);
            DecisionResult result = new DecisionResult();
            result.setDeductPercent(this.deductionGrade.getValue());
            boolean isPass = this.findDeductionGradeConfigPass(decision.getInvoiceConfig().getDeductionGradeConfigList(), DeductionGradeConfig.DeductionGradeItem.NO_INVOICE);
            result.setStatus(isPass ? "empty" : "alarming");
            result.setDecision(decision);
            String matchTypeMessage = decision.getInvoiceConfig().getNoInvoiceTip();
            result.setShowText(matchTypeMessage);
            return result;
        }
        List<InvoiceImageResult> invoiceImageResults = this.initResult(invoiceData);
        this.addRuleResult(decisionResult, this.checkCrossOneYear(decision, billObj, invoiceData, invoiceImageResults));
        this.addRuleResult(decisionResult, this.checkCertifiedOfInvoice(decision, billObj, invoiceData, invoiceImageResults));
        this.addRuleResult(decisionResult, this.checkDuplicate(decision, billObj, invoiceData, invoiceImageResults, ocrInvoiceFilter, context));
        this.addRuleResult(decisionResult, this.checkInvoiceHeader(decision, billObj, invoiceData, invoiceImageResults));
        this.addRuleResult(decisionResult, this.checkBuyerTaxCode(decision, billObj, invoiceData, invoiceImageResults));
        this.addRuleResult(decisionResult, this.checkCompletedOfSalerInfo(decision, billObj, invoiceData, invoiceImageResults));
        this.addRuleResult(decisionResult, this.checkCompletedOfBuyerInfo(decision, billObj, invoiceData, invoiceImageResults));
        this.addRuleResult(decisionResult, this.checkCompletedOfStamp(decision, billObj, invoiceData, invoiceImageResults));
        if (CollectionUtils.isEmpty(failureInvoiceMap)) {
            this.addRuleResult(decisionResult, this.isFullAmountOfAllInvoices(decision, billObj, invoiceData, invoiceImageResults));
        } else {
            decisionResult.setFailureInvoiceMap(failureInvoiceMap);
            this.addRuleResult(decisionResult, this.createFailureInvoiceMessage());
        }
        this.addRuleResult(decisionResult, this.checkContinuousNumber(decision, invoiceData, invoiceImageResults));
        this.addRuleResult(decisionResult, this.customCheck(decision, billObj, billTypeName, invoiceData, invoiceImageResults, context, decisionResult));
        Optional<InvoiceImageResult> hasRuleResult = invoiceImageResults.stream().filter(iir -> !CollectionUtils.isEmpty(iir.getRuleResults())).findAny();
        if (!hasRuleResult.isPresent()) {
            decisionResult.setStatus("empty");
        }
        decisionResult.setInvoiceImageResults(invoiceImageResults);
        decisionResult.setDeductPercent(this.deductionGrade.getValue());
        SchemaExecutorLogger.info(String.format(ResManager.loadKDString((String)"\u6267\u884c\u7968\u636e\u68c0\u6d4b\u5b8c\u6210\uff0c\u68c0\u6d4b\u7ed3\u679c%s", (String)"InvoiceExecutor_23", (String)"data-idi-core", (Object[])new Object[0]), IDIJSONUtils.toJsonString((Object)decisionResult)), new Object[0]);
        return decisionResult;
    }

    private InvoiceImageRuleResult checkContinuousNumber(Decision decision, List<Map<String, Object>> invoiceList, List<InvoiceImageResult> invoiceImageResults) {
        InvoiceConfig invoiceConfig = decision.getInvoiceConfig();
        if (!invoiceConfig.isContinuousNumber()) {
            return null;
        }
        int numRange = invoiceConfig.getNumberRange() == null ? 1 : invoiceConfig.getNumberRange();
        InvoiceImageRuleResult ruleResultPass = new InvoiceImageRuleResult();
        ruleResultPass.setRuleNo("A011");
        ruleResultPass.setPass(true);
        ruleResultPass.setStatus("green");
        ruleResultPass.setText(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u8fde\u53f7\u53d1\u7968", (String)"InvoiceExecutor_42", (String)"data-idi-core", (Object[])new Object[0]));
        InvoiceImageRuleResult ruleResultFailed = new InvoiceImageRuleResult();
        ruleResultFailed.setRuleNo("A011");
        ruleResultFailed.setPass(false);
        ruleResultFailed.setStatus("alarming");
        ruleResultFailed.setText(ResManager.loadKDString((String)"\u5b58\u5728\u8fde\u53f7\u53d1\u7968", (String)"InvoiceExecutor_43", (String)"data-idi-core", (Object[])new Object[0]));
        InvoiceImageRuleResult ruleResult = ruleResultPass;
        boolean isRulePass = true;
        HashSet<String> invoiceNoFilterSet = new HashSet<String>(invoiceList.size());
        for (Map<String, Object> invoiceData : invoiceList) {
            String invoiceNo = (String)invoiceData.get(INVOICE_NO);
            SchemaExecutorLogger.info(String.format("checkContinuousNumber current invoiceNo : %s", invoiceNo), new Object[0]);
            String invoiceType = (String)invoiceData.get(INVOICE_TYPE);
            if (StringUtils.isEmpty((String)invoiceNo) || "9".equals(invoiceType) || "09".equals(invoiceType)) continue;
            int invoiceNumberLength = invoiceNo.length();
            BigDecimal invoiceNoValueBig = new BigDecimal(invoiceNo);
            for (int i = numRange; i > 0; --i) {
                BigDecimal addVal;
                BigDecimal factors = new BigDecimal(i);
                BigDecimal subtractVal = invoiceNoValueBig.subtract(factors);
                if (subtractVal.compareTo(BigDecimal.ZERO) >= 0) {
                    invoiceNoFilterSet.add(this.getInvoiceNumber(invoiceNumberLength, subtractVal));
                }
                if ((addVal = invoiceNoValueBig.add(factors)).compareTo(BigDecimal.ZERO) < 0) continue;
                invoiceNoFilterSet.add(this.getInvoiceNumber(invoiceNumberLength, addVal));
            }
        }
        SchemaExecutorLogger.info(String.format("checkContinuousNumber invoiceNoFilterSet : %s", IDIJSONUtils.toJsonString(invoiceNoFilterSet)), new Object[0]);
        DynamicObjectCollection continuousCol = QueryServiceHelper.query((String)"idi_invoice", (String)"id,imagepage,imagenumber,invoiceno", (QFilter[])new QFilter(INVOICE_NO, "in", invoiceNoFilterSet).toArray());
        if (continuousCol.isEmpty()) {
            return ruleResultPass;
        }
        for (Map<String, Object> invoiceData : invoiceList) {
            String invoiceNo = (String)invoiceData.get(INVOICE_NO);
            String invoiceType = (String)invoiceData.get(INVOICE_TYPE);
            if (StringUtils.isEmpty((String)invoiceNo) || "9".equals(invoiceType) || "09".equals(invoiceType)) continue;
            Long invoiceId = (Long)invoiceData.get(INVOICE_ID);
            InvoiceImageResult invoiceImageResult = InvoiceExecutor.getInvoiceImageResult(invoiceId, invoiceImageResults);
            Map<Long, List<String>> continuousInvoiceListMap = this.isContinuous(continuousCol, invoiceData, numRange);
            if (continuousInvoiceListMap.isEmpty()) {
                invoiceImageResult.getRuleResults().add(ruleResultPass);
                continue;
            }
            isRulePass = false;
            invoiceImageResult.getRuleResults().add(ruleResultFailed);
            invoiceImageResult.addContinuousListMap(continuousInvoiceListMap);
        }
        if (!isRulePass) {
            ruleResult = ruleResultFailed;
            this.deductionGrade.deduct(invoiceConfig.getContinuousNumberGradePercent());
            ruleResult.deductPercentFromInt(invoiceConfig.getContinuousNumberGradePercent());
        }
        return ruleResult;
    }

    private String getInvoiceNumber(int invoiceNumberLength, BigDecimal val) {
        int len = invoiceNumberLength - val.toString().length();
        if (len > 0) {
            StringBuilder sbd = new StringBuilder();
            for (int j = len; j > 0; --j) {
                sbd.append("0");
            }
            sbd.append(val);
            return sbd.toString();
        }
        return val.toString();
    }

    private Map<Long, List<String>> isContinuous(DynamicObjectCollection continuousCol, Map<String, Object> invoiceData, int numRange) {
        String invoiceNo = (String)invoiceData.get(INVOICE_NO);
        BigDecimal invoiceNoValue = new BigDecimal(invoiceNo);
        HashMap<Long, List<String>> continuousInvoiceListMap = new HashMap<Long, List<String>>(numRange);
        for (int i = numRange; i > 0; --i) {
            for (DynamicObject dyo : continuousCol) {
                boolean addValContinuous;
                String invoiceNoFromData = dyo.getString(INVOICE_NO);
                int invoiceNumberLength = invoiceNoFromData.length();
                BigDecimal factors = new BigDecimal(i);
                BigDecimal subtractVal = invoiceNoValue.subtract(factors);
                BigDecimal addVal = invoiceNoValue.add(factors);
                boolean subtractContinuous = subtractVal.compareTo(BigDecimal.ZERO) >= 0 && invoiceNoFromData.equals(this.getInvoiceNumber(invoiceNumberLength, subtractVal));
                boolean bl = addValContinuous = addVal.compareTo(BigDecimal.ZERO) >= 0 && invoiceNoFromData.equals(this.getInvoiceNumber(invoiceNumberLength, addVal));
                if (!subtractContinuous && !addValContinuous) continue;
                ArrayList<String> continuousInvoice = new ArrayList<String>(3);
                String imagePage = dyo.getString(IMAGE_PAGE);
                continuousInvoice.add(StringUtils.isEmpty((String)imagePage) ? "" : String.valueOf(Integer.parseInt(imagePage) + 1));
                continuousInvoice.add(dyo.getString(IMAGE_NO));
                continuousInvoice.add(invoiceNoFromData);
                continuousInvoiceListMap.put(dyo.getLong("id"), continuousInvoice);
            }
        }
        if (!continuousInvoiceListMap.isEmpty()) {
            ArrayList<String> continuousInvoice = new ArrayList<String>(3);
            continuousInvoice.add((String)invoiceData.get(IMAGE_PAGE));
            continuousInvoice.add((String)invoiceData.get(IMAGE_NO));
            continuousInvoice.add(invoiceNo);
            continuousInvoiceListMap.put((Long)invoiceData.get(INVOICE_ID), continuousInvoice);
        }
        return continuousInvoiceListMap;
    }

    private void addRuleResult(DecisionResult decisionResult, InvoiceImageRuleResult ... ruleResults) {
        List<InvoiceImageRuleResult> ruleResultList = decisionResult.getInvoiceImageRuleResults();
        if (ruleResultList == null) {
            ruleResultList = new ArrayList<InvoiceImageRuleResult>();
            decisionResult.setInvoiceImageRuleResults(ruleResultList);
        }
        if (ruleResults != null) {
            for (InvoiceImageRuleResult ruleResult : ruleResults) {
                ruleResultList.add(ruleResult);
            }
        }
    }

    private List<InvoiceImageResult> initResult(List<Map<String, Object>> invoiceList) {
        ArrayList<InvoiceImageResult> results = new ArrayList<InvoiceImageResult>(invoiceList.size());
        for (Map<String, Object> invoice : invoiceList) {
            InvoiceImageResult result = new InvoiceImageResult();
            if (invoice.get(INVOICE_ID) != null) {
                result.setInvoiceId((Long)invoice.get(INVOICE_ID));
            }
            if (invoice.get(IMAGE_NO) != null) {
                result.setImageNo((String)invoice.get(IMAGE_NO));
            }
            if (invoice.get(INVOICE_NO) != null) {
                result.setInvoiceNo((String)invoice.get(INVOICE_NO));
            }
            if (invoice.get(INVOICE_TYPE) != null) {
                result.setInvoiceType((String)invoice.get(INVOICE_TYPE));
            }
            if (invoice.get(IMAGE_PAGE) != null) {
                result.setImagePage((String)invoice.get(IMAGE_PAGE));
            }
            result.setPass(true);
            result.setRuleResults(new ArrayList<InvoiceImageRuleResult>());
            results.add(result);
        }
        return results;
    }

    private InvoiceImageRuleResult checkCrossOneYear(Decision decision, DynamicObject billObj, List<Map<String, Object>> invoiceList, List<InvoiceImageResult> invoiceImageResults) {
        InvoiceConfig invoiceConfig = decision.getInvoiceConfig();
        if (!invoiceConfig.isCrossOneYear()) {
            return null;
        }
        InvoiceImageRuleResult ruleResultPass = new InvoiceImageRuleResult();
        ruleResultPass.setRuleNo("A001");
        ruleResultPass.setPass(true);
        ruleResultPass.setStatus("green");
        ruleResultPass.setText(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u8fdd\u89c4\u8de8\u5e74\u62a5\u9500\u98ce\u9669", (String)"InvoiceExecutor_1", (String)"data-idi-core", (Object[])new Object[0]));
        InvoiceImageRuleResult ruleResultFailed = new InvoiceImageRuleResult();
        ruleResultFailed.setRuleNo("A001");
        ruleResultFailed.setPass(false);
        ruleResultFailed.setStatus("alarming");
        ruleResultFailed.setText(ResManager.loadKDString((String)"\u5b58\u5728\u8fdd\u89c4\u8de8\u5e74\u62a5\u9500\u98ce\u9669", (String)"InvoiceExecutor_2", (String)"data-idi-core", (Object[])new Object[0]));
        InvoiceImageRuleResult ruleResult = null;
        Object value = ExecutorHelper.getValueAndNameByName(billObj, invoiceConfig.getRequestDateField(), false).getValue();
        Date requestDate1 = (Date)value;
        if (requestDate1 == null) {
            return ruleResultPass;
        }
        Calendar requestDate = Calendar.getInstance();
        requestDate.setTime(requestDate1);
        int theYear = requestDate.get(1);
        SimpleDateFormat dateFormat0 = new SimpleDateFormat("MM-dd");
        SchemaExecutorLogger.info(String.format(ResManager.loadKDString((String)"\u8fdd\u89c4\u8de8\u5e74\u62a5\u9500\u98ce\u9669\u6821\u9a8c\uff0c\u5355\u636e\u65e5\u671f\u5b57\u6bb5%1$s\uff0c\u5355\u636e\u65f6\u95f4\u5b57\u6bb5\u503c%2$s\uff0c\u65f6\u95f4\u8282\u70b9\u503c%3$s", (String)"InvoiceExecutor_24", (String)"data-idi-core", (Object[])new Object[0]), invoiceConfig.getRequestDateField(), requestDate.toString(), dateFormat0.format(invoiceConfig.getFromDate())), new Object[0]);
        SimpleDateFormat dateFormat1 = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat dateFormat2 = new SimpleDateFormat("yyyyMMdd");
        Calendar endDate = Calendar.getInstance();
        endDate.setTime(invoiceConfig.getFromDate());
        endDate.set(1, theYear);
        int endYear = requestDate.compareTo(endDate) > 0 ? theYear : theYear - 1;
        Boolean isRulePass = null;
        for (Map<String, Object> invoiceData : invoiceList) {
            String dataStr = (String)invoiceData.get(INVOICEDATE);
            boolean invoicePass = true;
            Long invoiceId = (Long)invoiceData.get(INVOICE_ID);
            if (StringUtils.isEmpty((String)dataStr)) {
                invoicePass = false;
            } else {
                Date invoiceDate = null;
                SchemaExecutorLogger.info(String.format(ResManager.loadKDString((String)"\u8fdd\u89c4\u8de8\u5e74\u62a5\u9500\u98ce\u9669\u6821\u9a8c\uff0c\u53d1\u7968id%d\uff0c \u53d1\u7968\u65e5\u671f%s", (String)"InvoiceExecutor_25", (String)"data-idi-core", (Object[])new Object[0]), invoiceId, dataStr), new Object[0]);
                try {
                    invoiceDate = dataStr.contains("-") ? dateFormat1.parse(dataStr) : dateFormat2.parse(dataStr);
                    Calendar c1 = Calendar.getInstance();
                    c1.setTime(invoiceDate);
                    invoicePass = c1.get(1) >= endYear;
                }
                catch (ParseException e) {
                    SchemaExecutorLogger.info(String.format(ResManager.loadKDString((String)"\u89e3\u6790\u5f00\u7968\u65e5\u671f\u51fa\u9519,\u53d1\u7968\u53f7%1$s,\u9519\u8bef:%2$s", (String)"InvoiceExecutor_26", (String)"data-idi-core", (Object[])new Object[0]), invoiceId, e.getMessage()), new Object[0]);
                    invoicePass = false;
                }
            }
            InvoiceImageResult invoiceImageResult = InvoiceExecutor.getInvoiceImageResult(invoiceId, invoiceImageResults);
            if (invoicePass) {
                if (isRulePass == null) {
                    isRulePass = Boolean.TRUE;
                }
                invoiceImageResult.getRuleResults().add(ruleResultPass);
                continue;
            }
            isRulePass = Boolean.FALSE;
            invoiceImageResult.getRuleResults().add(ruleResultFailed);
        }
        if (isRulePass != null) {
            InvoiceImageRuleResult invoiceImageRuleResult = ruleResult = isRulePass != false ? ruleResultPass : ruleResultFailed;
            if (!isRulePass.booleanValue()) {
                this.deductionGrade.deduct(invoiceConfig.getCrossOneYearDeductionGradePercent());
                ruleResult.deductPercentFromInt(invoiceConfig.getCrossOneYearDeductionGradePercent());
            }
        } else {
            ruleResult = ruleResultPass;
        }
        return ruleResult;
    }

    private static InvoiceImageResult getInvoiceImageResult(Long invoiceId, List<InvoiceImageResult> invoiceImageResults) {
        for (InvoiceImageResult result : invoiceImageResults) {
            if (result.getInvoiceId() != invoiceId.longValue()) continue;
            return result;
        }
        throw new KDBizException("invoice id " + invoiceId + " error.");
    }

    private InvoiceImageRuleResult checkCertifiedOfInvoice(Decision decision, DynamicObject billObj, List<Map<String, Object>> invoiceList, List<InvoiceImageResult> invoiceImageResults) {
        if (!decision.getInvoiceConfig().isCertifiedOfInvoice()) {
            return null;
        }
        InvoiceImageRuleResult ruleResultPass = new InvoiceImageRuleResult();
        ruleResultPass.setRuleNo("A002");
        ruleResultPass.setPass(true);
        ruleResultPass.setStatus("green");
        ruleResultPass.setText(ResManager.loadKDString((String)"\u53d1\u7968\u771f\u4f2a\u6821\u9a8c\u901a\u8fc7", (String)"InvoiceExecutor_4", (String)"data-idi-core", (Object[])new Object[0]));
        InvoiceImageRuleResult ruleResultFailed = new InvoiceImageRuleResult();
        ruleResultFailed.setRuleNo("A002");
        ruleResultFailed.setPass(false);
        ruleResultFailed.setStatus("alarming");
        ruleResultFailed.setText(ResManager.loadKDString((String)"\u53d1\u7968\u771f\u4f2a\u6821\u9a8c\u4e0d\u901a\u8fc7", (String)"InvoiceExecutor_3", (String)"data-idi-core", (Object[])new Object[0]));
        InvoiceImageRuleResult ruleResult = null;
        Boolean isRulePass = null;
        for (Map<String, Object> invoiceData : invoiceList) {
            String invoiceType = (String)invoiceData.get(INVOICE_TYPE);
            if (!"1".equals(invoiceType) && !"2".equals(invoiceType) && !"3".equals(invoiceType) && !"4".equals(invoiceType) && !"5".equals(invoiceType) && !"12".equals(invoiceType) && !"13".equals(invoiceType) && !"15".equals(invoiceType) && !"26".equals(invoiceType) && !"27".equals(invoiceType)) continue;
            Long invoiceId = (Long)invoiceData.get(INVOICE_ID);
            String isTrue = (String)invoiceData.get("istrue");
            boolean invoicePass = "1".equals(isTrue);
            SchemaExecutorLogger.info(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u771f\u4f2a\u67e5\u9a8c\uff0c\u53d1\u7968id%1$s, \u771f\u4f2a\u6807\u8bb0%2$s", (String)"InvoiceExecutor_27", (String)"data-idi-core", (Object[])new Object[0]), invoiceId, isTrue), new Object[0]);
            InvoiceImageResult invoiceImageResult = InvoiceExecutor.getInvoiceImageResult(invoiceId, invoiceImageResults);
            if (invoicePass) {
                if (isRulePass == null) {
                    isRulePass = Boolean.TRUE;
                }
                invoiceImageResult.getRuleResults().add(ruleResultPass);
                continue;
            }
            isRulePass = Boolean.FALSE;
            invoiceImageResult.getRuleResults().add(ruleResultFailed);
        }
        if (isRulePass != null) {
            InvoiceImageRuleResult invoiceImageRuleResult = ruleResult = isRulePass != false ? ruleResultPass : ruleResultFailed;
            if (!isRulePass.booleanValue()) {
                this.deductionGrade.deduct(decision.getInvoiceConfig().getCertifiedOfInvoiceDeductionGradePercent());
                ruleResult.deductPercentFromInt(decision.getInvoiceConfig().getCertifiedOfInvoiceDeductionGradePercent());
            }
        }
        return ruleResult;
    }

    private InvoiceImageRuleResult checkDuplicate(Decision decision, DynamicObject billObj, List<Map<String, Object>> invoiceList, List<InvoiceImageResult> invoiceImageResults, QFilter ocrInvoiceFilter, SchemaContext schemaContext) {
        if (!decision.getInvoiceConfig().isDuplicate()) {
            return null;
        }
        DuplicateInvoiceValidator validator = new DuplicateInvoiceValidator(decision, billObj, invoiceList, invoiceImageResults, ocrInvoiceFilter, schemaContext, this.deductionGrade, this.repeatInvoiceList);
        return validator.validate();
    }

    private InvoiceImageRuleResult checkInvoiceHeader(Decision decision, DynamicObject billObj, List<Map<String, Object>> invoiceList, List<InvoiceImageResult> invoiceImageResults) {
        String orgName;
        List objs;
        if (!decision.getInvoiceConfig().isCheckInvoiceHeader()) {
            return null;
        }
        InvoiceImageRuleResult ruleResultPass = new InvoiceImageRuleResult();
        ruleResultPass.setRuleNo("A004");
        ruleResultPass.setPass(true);
        ruleResultPass.setStatus("green");
        ruleResultPass.setText(ResManager.loadKDString((String)"\u53d1\u7968\u62ac\u5934\u67e5\u9a8c\u901a\u8fc7", (String)"InvoiceExecutor_7", (String)"data-idi-core", (Object[])new Object[0]));
        InvoiceImageRuleResult ruleResultFailed = new InvoiceImageRuleResult();
        ruleResultFailed.setRuleNo("A004");
        ruleResultFailed.setPass(false);
        ruleResultFailed.setStatus("alarming");
        ruleResultFailed.setText(ResManager.loadKDString((String)"\u5b58\u5728\u53d1\u7968\u62ac\u5934\u67e5\u9a8c\u4e0d\u901a\u8fc7", (String)"InvoiceExecutor_8", (String)"data-idi-core", (Object[])new Object[0]));
        InvoiceImageRuleResult ruleResult = null;
        String companyField = decision.getInvoiceConfig().getCompanyFieldName();
        Object value = ExecutorHelper.getValueAndNameByName(billObj, companyField, false).getValue();
        Object orgId = value instanceof DynamicObject ? ((DynamicObject)value).getPkValue() : (value instanceof List ? ((objs = (List)value).size() > 0 ? (objs.get(0) instanceof DynamicObject ? ((DynamicObject)objs.get(0)).getPkValue() : (Object)objs.get(0)) : null) : value);
        if (orgId == null) {
            SchemaExecutorLogger.info(ResManager.loadKDString((String)"\u53d1\u7968\u62ac\u5934\u67e5\u9a8c\u83b7\u53d6\u5355\u636e\u7ec4\u7ec7null", (String)"InvoiceExecutor_29", (String)"data-idi-core", (Object[])new Object[0]), new Object[0]);
            orgName = "";
        } else {
            orgName = this.getOrgName(orgId);
        }
        if (StringUtils.isNotEmpty((String)orgName)) {
            orgName = orgName.replace('\uff08', '(');
            orgName = orgName.replace('\uff09', ')');
        }
        Boolean isRulePass = null;
        for (Map<String, Object> invoiceData : invoiceList) {
            String invoiceType = (String)invoiceData.get(INVOICE_TYPE);
            if ("14".equals(invoiceType) || "8".equals(invoiceType) || "17".equals(invoiceType) || "10".equals(invoiceType) || "9".equals(invoiceType) || "16".equals(invoiceType) || "20".equals(invoiceType) || "15".equals(invoiceType) || "21".equals(invoiceType)) continue;
            Long invoiceId = (Long)invoiceData.get(INVOICE_ID);
            String buyerName = (String)invoiceData.get("buyername");
            SchemaExecutorLogger.info(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u62ac\u5934\u67e5\u9a8c\uff0c\u53d1\u7968id%1$s\uff0c\u53d1\u7968\u62ac\u5934%2$s, \u5355\u636e\u7ec4\u7ec7\u5b57\u6bb5%3$s, \u5355\u636e\u7ec4\u7ec7%4$s", (String)"InvoiceExecutor_30", (String)"data-idi-core", (Object[])new Object[0]), invoiceId, buyerName, companyField, orgName), new Object[0]);
            InvoiceImageResult invoiceImageResult = InvoiceExecutor.getInvoiceImageResult(invoiceId, invoiceImageResults);
            if (StringUtils.isNotEmpty((String)buyerName)) {
                buyerName = buyerName.replace('\uff08', '(');
                boolean invoicePass = (buyerName = buyerName.replace('\uff09', ')')).equals(orgName);
                if (invoicePass) {
                    if (isRulePass == null) {
                        isRulePass = Boolean.TRUE;
                    }
                    invoiceImageResult.getRuleResults().add(ruleResultPass);
                    continue;
                }
                isRulePass = Boolean.FALSE;
                invoiceImageResult.getRuleResults().add(ruleResultFailed);
                continue;
            }
            ruleResult = new InvoiceImageRuleResult();
            ruleResult.setRuleNo("A004");
            ruleResult.setPass(false);
            ruleResult.setStatus("alarming");
            ruleResult.setText(ResManager.loadKDString((String)"\u6ca1\u6709\u53d1\u7968\u62ac\u5934\u4fe1\u606f", (String)"InvoiceExecutor_9", (String)"data-idi-core", (Object[])new Object[0]));
            invoiceImageResult.getRuleResults().add(ruleResult);
        }
        if (isRulePass != null) {
            InvoiceImageRuleResult invoiceImageRuleResult = ruleResult = isRulePass != false ? ruleResultPass : ruleResultFailed;
            if (!isRulePass.booleanValue()) {
                this.deductionGrade.deduct(decision.getInvoiceConfig().getCheckInvoiceHeaderDeductionGradePercent());
                ruleResult.deductPercentFromInt(decision.getInvoiceConfig().getCheckInvoiceHeaderDeductionGradePercent());
            }
        }
        return ruleResult;
    }

    private InvoiceImageRuleResult checkBuyerTaxCode(Decision decision, DynamicObject billObj, List<Map<String, Object>> invoiceList, List<InvoiceImageResult> invoiceImageResults) {
        String orgTaxRegNum;
        List objs;
        if (!decision.getInvoiceConfig().isBuyerTaxCode()) {
            return null;
        }
        InvoiceImageRuleResult ruleResultPass = new InvoiceImageRuleResult();
        ruleResultPass.setRuleNo("A005");
        ruleResultPass.setPass(true);
        ruleResultPass.setStatus("green");
        ruleResultPass.setText(ResManager.loadKDString((String)"\u53d1\u7968\u8d2d\u65b9\u7eb3\u7a0e\u8bc6\u522b\u7801\u67e5\u9a8c\u901a\u8fc7", (String)"InvoiceExecutor_10", (String)"data-idi-core", (Object[])new Object[0]));
        InvoiceImageRuleResult ruleResultFailed = new InvoiceImageRuleResult();
        ruleResultFailed.setRuleNo("A005");
        ruleResultFailed.setPass(false);
        ruleResultFailed.setStatus("alarming");
        ruleResultFailed.setText(ResManager.loadKDString((String)"\u5b58\u5728\u53d1\u7968\u8d2d\u65b9\u7eb3\u7a0e\u8bc6\u522b\u7801\u67e5\u9a8c\u4e0d\u901a\u8fc7", (String)"InvoiceExecutor_11", (String)"data-idi-core", (Object[])new Object[0]));
        InvoiceImageRuleResult ruleResult = null;
        String companyField = decision.getInvoiceConfig().getCompanyFieldName();
        Object value = ExecutorHelper.getValueAndNameByName(billObj, companyField, false).getValue();
        Object orgId = value instanceof DynamicObject ? ((DynamicObject)value).getPkValue() : (value instanceof List ? ((objs = (List)value).size() > 0 ? (objs.get(0) instanceof DynamicObject ? ((DynamicObject)objs.get(0)).getPkValue() : (Object)objs.get(0)) : null) : value);
        if (orgId == null) {
            SchemaExecutorLogger.info(ResManager.loadKDString((String)"\u53d1\u7968\u8d2d\u65b9\u7eb3\u7a0e\u8bc6\u522b\u7801\u67e5\u9a8c\u83b7\u53d6\u5355\u636e\u7ec4\u7ec7null", (String)"InvoiceExecutor_31", (String)"data-idi-core", (Object[])new Object[0]), new Object[0]);
            orgTaxRegNum = "";
        } else {
            orgTaxRegNum = this.getOrgData(orgId);
        }
        Boolean isRulePass = null;
        for (Map<String, Object> invoiceData : invoiceList) {
            String invoiceType = (String)invoiceData.get(INVOICE_TYPE);
            if ("14".equals(invoiceType) || "8".equals(invoiceType) || "17".equals(invoiceType) || "10".equals(invoiceType) || "9".equals(invoiceType) || "16".equals(invoiceType) || "20".equals(invoiceType) || "15".equals(invoiceType) || "21".equals(invoiceType)) continue;
            Long invoiceId = (Long)invoiceData.get(INVOICE_ID);
            String buyerTaxNo = (String)invoiceData.get("buyertaxno");
            SchemaExecutorLogger.info(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u8d2d\u65b9\u7eb3\u7a0e\u8bc6\u522b\u7801\u67e5\u9a8c\uff0c\u53d1\u7968id%1$s\uff0c\u8d2d\u65b9\u7eb3\u7a0e\u8bc6\u522b\u7801%2$s, \u5355\u636e\u7ec4\u7ec7\u5b57\u6bb5%3$s, \u5355\u636e\u8d39\u7528\u627f\u62c5\u516c\u53f8\u7684\u7eb3\u7a0e\u8bc6\u522b\u7801%4$s", (String)"InvoiceExecutor_32", (String)"data-idi-core", (Object[])new Object[0]), invoiceId, buyerTaxNo, companyField, orgTaxRegNum), new Object[0]);
            InvoiceImageResult invoiceImageResult = InvoiceExecutor.getInvoiceImageResult(invoiceId, invoiceImageResults);
            if (StringUtils.isNotEmpty((String)buyerTaxNo)) {
                boolean invoicePass = buyerTaxNo.equals(orgTaxRegNum);
                if (invoicePass) {
                    if (isRulePass == null) {
                        isRulePass = Boolean.TRUE;
                    }
                    invoiceImageResult.getRuleResults().add(ruleResultPass);
                    continue;
                }
                isRulePass = Boolean.FALSE;
                invoiceImageResult.getRuleResults().add(ruleResultFailed);
                continue;
            }
            ruleResult = new InvoiceImageRuleResult();
            ruleResult.setRuleNo("A005");
            ruleResult.setPass(false);
            ruleResult.setStatus("alarming");
            ruleResult.setText(ResManager.loadKDString((String)"\u6ca1\u6709\u53d1\u7968\u7eb3\u7a0e\u8bc6\u522b\u7801", (String)"InvoiceExecutor_12", (String)"data-idi-core", (Object[])new Object[0]));
            invoiceImageResult.getRuleResults().add(ruleResult);
        }
        if (isRulePass != null) {
            InvoiceImageRuleResult invoiceImageRuleResult = ruleResult = isRulePass != false ? ruleResultPass : ruleResultFailed;
            if (!isRulePass.booleanValue()) {
                this.deductionGrade.deduct(decision.getInvoiceConfig().getBuyerTaxCodeDeductionGradePercent());
                ruleResult.deductPercentFromInt(decision.getInvoiceConfig().getBuyerTaxCodeDeductionGradePercent());
            }
        }
        return ruleResult;
    }

    private InvoiceImageRuleResult checkCompletedOfSalerInfo(Decision decision, DynamicObject billObj, List<Map<String, Object>> invoiceList, List<InvoiceImageResult> invoiceImageResults) {
        if (!decision.getInvoiceConfig().isCompletedOfSalerInfo()) {
            return null;
        }
        InvoiceImageRuleResult ruleResultPass = new InvoiceImageRuleResult();
        ruleResultPass.setRuleNo("A006");
        ruleResultPass.setPass(true);
        ruleResultPass.setStatus("green");
        ruleResultPass.setText(ResManager.loadKDString((String)"\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\u9500\u65b9\u53d1\u7968\u4fe1\u606f\u5b8c\u6574", (String)"InvoiceExecutor_13", (String)"data-idi-core", (Object[])new Object[0]));
        InvoiceImageRuleResult ruleResultFailed = new InvoiceImageRuleResult();
        ruleResultFailed.setRuleNo("A006");
        ruleResultFailed.setPass(false);
        ruleResultFailed.setStatus("alarming");
        ruleResultFailed.setText(ResManager.loadKDString((String)"\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\u9500\u65b9\u53d1\u7968\u4fe1\u606f\u4e0d\u5b8c\u6574", (String)"InvoiceExecutor_14", (String)"data-idi-core", (Object[])new Object[0]));
        InvoiceImageRuleResult ruleResult = null;
        Boolean isRulePass = null;
        for (Map<String, Object> invoiceData : invoiceList) {
            String invoiceType = (String)invoiceData.get(INVOICE_TYPE);
            if (!"02".equals(invoiceType) && !"2".equals(invoiceType) && !"04".equals(invoiceType) && !"4".equals(invoiceType)) continue;
            Long invoiceId = (Long)invoiceData.get(INVOICE_ID);
            String salerName = (String)invoiceData.get("salername");
            String salerTaxNo = (String)invoiceData.get("salertaxno");
            String salerAddressPhone = (String)invoiceData.get("saleraddressphone");
            String salerAccount = (String)invoiceData.get("saleraccount");
            SchemaExecutorLogger.info(String.format(ResManager.loadKDString((String)"\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\u9500\u65b9\u4fe1\u606f\u662f\u5426\u5b8c\u6574, \u53d1\u7968id%1$s\u3001\u53d1\u7968\u4e0a\u9500\u552e\u65b9\u540d\u79f0%2$s\u3001\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7%3$s\u3001\u5730\u5740\u7535\u8bdd%4$s\u3001\u5f00\u6237\u884c\u53ca\u8d26\u53f7%5$s", (String)"InvoiceExecutor_33", (String)"data-idi-core", (Object[])new Object[0]), invoiceId, salerName, salerTaxNo, salerAddressPhone, salerAccount), new Object[0]);
            boolean invoicePass = StringUtils.isNotEmpty((String)salerName) && StringUtils.isNotEmpty((String)salerTaxNo) && StringUtils.isNotEmpty((String)salerAddressPhone) && StringUtils.isNotEmpty((String)salerAccount);
            InvoiceImageResult invoiceImageResult = InvoiceExecutor.getInvoiceImageResult(invoiceId, invoiceImageResults);
            if (invoicePass) {
                if (isRulePass == null) {
                    isRulePass = Boolean.TRUE;
                }
                invoiceImageResult.getRuleResults().add(ruleResultPass);
                continue;
            }
            isRulePass = Boolean.FALSE;
            invoiceImageResult.getRuleResults().add(ruleResultFailed);
        }
        if (isRulePass != null) {
            InvoiceImageRuleResult invoiceImageRuleResult = ruleResult = isRulePass != false ? ruleResultPass : ruleResultFailed;
            if (!isRulePass.booleanValue()) {
                this.deductionGrade.deduct(decision.getInvoiceConfig().getCompletedOfSalerInfoDeductionGradePercent());
                ruleResult.deductPercentFromInt(decision.getInvoiceConfig().getCompletedOfSalerInfoDeductionGradePercent());
            }
        }
        return ruleResult;
    }

    private InvoiceImageRuleResult checkCompletedOfBuyerInfo(Decision decision, DynamicObject billObj, List<Map<String, Object>> invoiceList, List<InvoiceImageResult> invoiceImageResults) {
        if (!decision.getInvoiceConfig().isCompletedOfBuyerInfo()) {
            return null;
        }
        InvoiceImageRuleResult ruleResultPass = new InvoiceImageRuleResult();
        ruleResultPass.setRuleNo("A007");
        ruleResultPass.setPass(true);
        ruleResultPass.setStatus("green");
        ruleResultPass.setText(ResManager.loadKDString((String)"\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\u8d2d\u65b9\u53d1\u7968\u4fe1\u606f\u5b8c\u6574", (String)"InvoiceExecutor_16", (String)"data-idi-core", (Object[])new Object[0]));
        InvoiceImageRuleResult ruleResultFailed = new InvoiceImageRuleResult();
        ruleResultFailed.setRuleNo("A007");
        ruleResultFailed.setPass(false);
        ruleResultFailed.setStatus("alarming");
        ruleResultFailed.setText(ResManager.loadKDString((String)"\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\u8d2d\u65b9\u53d1\u7968\u4fe1\u606f\u4e0d\u5b8c\u6574", (String)"InvoiceExecutor_15", (String)"data-idi-core", (Object[])new Object[0]));
        InvoiceImageRuleResult ruleResult = null;
        Boolean isRulePass = null;
        for (Map<String, Object> invoiceData : invoiceList) {
            String invoiceType = (String)invoiceData.get(INVOICE_TYPE);
            if (!"02".equals(invoiceType) && !"2".equals(invoiceType) && !"04".equals(invoiceType) && !"4".equals(invoiceType)) continue;
            Long invoiceId = (Long)invoiceData.get(INVOICE_ID);
            String buyerName = (String)invoiceData.get("buyername");
            String buyerTaxNo = (String)invoiceData.get("buyertaxno");
            String buyerAddressPhone = (String)invoiceData.get("buyeraddressphone");
            String buyerAccount = (String)invoiceData.get("buyeraccount");
            SchemaExecutorLogger.info(String.format(ResManager.loadKDString((String)"\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\u8d2d\u65b9\u4fe1\u606f\u662f\u5426\u5b8c\u6574, \u53d1\u7968id%1$s\u3001\u53d1\u7968\u4e0a\u8d2d\u65b9\u540d\u79f0%2$s\u3001\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7%3$s\u3001\u5730\u5740\u7535\u8bdd%4$s\u3001\u5f00\u6237\u884c\u53ca\u8d26\u53f7%5$s", (String)"InvoiceExecutor_34", (String)"data-idi-core", (Object[])new Object[0]), invoiceId, buyerName, buyerTaxNo, buyerAddressPhone, buyerAccount), new Object[0]);
            boolean invoicePass = StringUtils.isNotEmpty((String)buyerName) && StringUtils.isNotEmpty((String)buyerTaxNo) && StringUtils.isNotEmpty((String)buyerAddressPhone) && StringUtils.isNotEmpty((String)buyerAccount);
            InvoiceImageResult invoiceImageResult = InvoiceExecutor.getInvoiceImageResult(invoiceId, invoiceImageResults);
            if (invoicePass) {
                if (isRulePass == null) {
                    isRulePass = Boolean.TRUE;
                }
                invoiceImageResult.getRuleResults().add(ruleResultPass);
                continue;
            }
            isRulePass = Boolean.FALSE;
            invoiceImageResult.getRuleResults().add(ruleResultFailed);
        }
        if (isRulePass != null) {
            InvoiceImageRuleResult invoiceImageRuleResult = ruleResult = isRulePass != false ? ruleResultPass : ruleResultFailed;
            if (!isRulePass.booleanValue()) {
                this.deductionGrade.deduct(decision.getInvoiceConfig().getCompletedOfBuyerInfoDeductionGradePercent());
                ruleResult.deductPercentFromInt(decision.getInvoiceConfig().getCompletedOfBuyerInfoDeductionGradePercent());
            }
        }
        return ruleResult;
    }

    private InvoiceImageRuleResult checkCompletedOfStamp(Decision decision, DynamicObject billObj, List<Map<String, Object>> invoiceList, List<InvoiceImageResult> invoiceImageResults) {
        if (!decision.getInvoiceConfig().isCompletedOfStamp()) {
            return null;
        }
        return null;
    }

    private InvoiceImageRuleResult isFullAmountOfAllInvoices(Decision decision, DynamicObject billObj, List<Map<String, Object>> invoiceList, List<InvoiceImageResult> invoiceImageResults) {
        if (!decision.getInvoiceConfig().isFullAmountOfAllInvoices() || StringUtils.isEmpty((String)decision.getInvoiceConfig().getAmountFieldName())) {
            return null;
        }
        Object value = ExecutorHelper.getValueAndNameByName(billObj, decision.getInvoiceConfig().getAmountFieldName(), false).getValue();
        if (value == null) {
            String errorMessage = ResManager.loadKDString((String)"\u503c\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6bd4\u8f83", (String)"InvoiceExecutor_35", (String)"data-idi-core", (Object[])new Object[0]);
            SchemaExecutorLogger.info(decision.getInvoiceConfig().getAmountFieldName() + errorMessage, new Object[0]);
            return null;
        }
        if (value instanceof List) {
            List values = (List)value;
            if (values.isEmpty()) {
                String errorMessage = ResManager.loadKDString((String)"\u503c\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6bd4\u8f83", (String)"InvoiceExecutor_35", (String)"data-idi-core", (Object[])new Object[0]);
                SchemaExecutorLogger.info(decision.getInvoiceConfig().getAmountFieldName() + errorMessage, new Object[0]);
                return null;
            }
            value = values.get(0);
        }
        if (!(value instanceof BigDecimal)) {
            String errorMessage = ResManager.loadKDString((String)"\u503c\u4e3a\u975eBigdecimal\u7c7b\u578b\uff0c\u65e0\u6cd5\u6bd4\u8f83", (String)"InvoiceExecutor_36", (String)"data-idi-core", (Object[])new Object[0]);
            SchemaExecutorLogger.info(decision.getInvoiceConfig().getAmountFieldName() + errorMessage, new Object[0]);
            return null;
        }
        BigDecimal amount = (BigDecimal)value;
        InvoiceImageRuleResult ruleResultPass = new InvoiceImageRuleResult();
        ruleResultPass.setRuleNo("A009");
        ruleResultPass.setPass(true);
        ruleResultPass.setStatus("green");
        ruleResultPass.setText(ResManager.loadKDString((String)"\u53d1\u7968\u91d1\u989d\u5927\u4e8e\u7b49\u4e8e\u6e90\u5355\u91d1\u989d", (String)"InvoiceExecutor_17", (String)"data-idi-core", (Object[])new Object[0]));
        InvoiceImageRuleResult ruleResultFailed = new InvoiceImageRuleResult();
        ruleResultFailed.setRuleNo("A009");
        ruleResultFailed.setPass(false);
        ruleResultFailed.setStatus("alarming");
        ruleResultFailed.setText(ResManager.loadKDString((String)"\u53d1\u7968\u91d1\u989d\u5c0f\u4e8e\u6e90\u5355\u91d1\u989d", (String)"InvoiceExecutor_18", (String)"data-idi-core", (Object[])new Object[0]));
        InvoiceImageRuleResult ruleResult = ruleResultPass;
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (Map<String, Object> invoiceData : invoiceList) {
            String valString;
            BigDecimal invoiceAmount = BigDecimal.ZERO;
            if (invoiceData.get(TOTALAMOUNT) != null && StringUtils.isNotEmpty((String)(valString = (String)invoiceData.get(TOTALAMOUNT)))) {
                invoiceAmount = new BigDecimal(valString);
            }
            totalAmount = totalAmount.add(invoiceAmount);
        }
        SchemaExecutorLogger.info(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u91d1\u989d\u8db3\u989d\u68c0\u67e5\uff0c\u5355\u636e\u5b57\u6bb5%1$s\uff0c\u5355\u636e\u5b57\u6bb5\u91d1\u989d%2$s, \u53d1\u7968\u4ef7\u7a0e\u5408\u8ba1\u603b\u989d%3$s", (String)"InvoiceExecutor_37", (String)"data-idi-core", (Object[])new Object[0]), decision.getInvoiceConfig().getAmountFieldName(), amount.toString(), totalAmount.toString()), new Object[0]);
        if (amount.compareTo(totalAmount) > 0) {
            ruleResult = ruleResultFailed;
            this.deductionGrade.deduct(decision.getInvoiceConfig().getFullAmountOfAllInvoicesDeductionGradePercent());
            ruleResult.deductPercentFromInt(decision.getInvoiceConfig().getFullAmountOfAllInvoicesDeductionGradePercent());
        }
        String[] amounts = new String[]{ExecutorHelper.currencyToString(totalAmount), ExecutorHelper.currencyToString(amount)};
        ruleResult.setFullAmounts(amounts);
        return ruleResult;
    }

    private InvoiceImageRuleResult[] customCheck(Decision decision, DynamicObject billObj, String billTypeName, List<Map<String, Object>> invoiceList, List<InvoiceImageResult> invoiceImageResults, SchemaContext context, DecisionResult decisionResult) {
        List<InvoiceConfigCustom> customs = decision.getInvoiceConfig().getCustomList();
        if (customs == null || customs.size() == 0) {
            return null;
        }
        ArrayList<InvoiceImageRuleResult> results = new ArrayList<InvoiceImageRuleResult>();
        MainEntityType billObjectType = EntityMetadataCache.getDataEntityType((String)billTypeName);
        HashMap<String, BigDecimal> propSumMap = new HashMap<String, BigDecimal>();
        HighLightBuilder highLightBuilder = new HighLightBuilder();
        ArrayList<BaseHighLight> highLightList = new ArrayList<BaseHighLight>(5);
        int index = 0;
        for (InvoiceConfigCustom custom : customs) {
            if (custom.getRuleList() == null || custom.getRuleList().isEmpty()) continue;
            MainEntityType invoiceObjectType = EntityMetadataCache.getDataEntityType((String)custom.getInvoiceType());
            for (InvoiceDecisionRule rule : custom.getRuleList()) {
                InvoiceImageRuleResult ruleResult;
                String script = "1 == 1";
                if (rule.getCondition() != null) {
                    script = rule.getCondition().getScript();
                }
                String ruleNo = "C00" + index++;
                InvoiceImageRuleResult ruleResultPass = new InvoiceImageRuleResult();
                ruleResultPass.setRuleNo(ruleNo);
                ruleResultPass.setPass(true);
                ruleResultPass.setStatus(rule.getDecisionStatus());
                ruleResultPass.setText(rule.getShowWords());
                InvoiceImageRuleResult ruleResultFailed = new InvoiceImageRuleResult();
                ruleResultFailed.setRuleNo(ruleNo);
                ruleResultFailed.setPass(false);
                ruleResultFailed.setStatus(rule.getDecisionStatus());
                ruleResultFailed.setText(rule.getShowWords());
                if (!StringUtils.isNotEmpty((String)script)) continue;
                Set<String> billPropSet = this.extractKeys(script, billTypeName, billTypeName);
                int entrySize = 1;
                HashSet<String> entryVars = new HashSet<String>();
                for (String propName : billPropSet) {
                    String billEntryName;
                    DynamicProperty property;
                    String[] props = propName.split("\\.");
                    if (props.length < 2 || !((property = billObjectType.getProperty(billEntryName = props[0])) instanceof ICollectionProperty)) continue;
                    if (!entryVars.contains(billEntryName) && entryVars.size() > 0) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u4e2d\u5305\u62ec\u591a\u4e2a\u5206\u5f55\u5b57\u6bb5", (String)"InvoiceExecutor_38", (String)"data-idi-core", (Object[])new Object[0]));
                    }
                    if (!entryVars.add(billEntryName)) continue;
                    entrySize = billObj.getDynamicObjectCollection(billEntryName).size();
                }
                Boolean isRulePass = null;
                Set<String> invoiceKeys = this.extractKeys(script, custom.getInvoiceType(), billTypeName);
                HashMap<String, String> invoicePropTypeMap = new HashMap<String, String>(invoiceKeys.size());
                HashMap<String, String> invoiceEntryPropTypeMap = new HashMap<String, String>(invoiceKeys.size());
                Iterator<String> iterator = invoiceKeys.iterator();
                while (iterator.hasNext()) {
                    HashMap<String, String> propTypeMap;
                    DynamicProperty property;
                    String propName;
                    String fieldName = propName = iterator.next();
                    if (propName.contains("items.")) {
                        fieldName = propName.substring(DETAILITEM.length() + 1);
                        EntryProp entryType = (EntryProp)invoiceObjectType.getProperty(DETAILITEM);
                        property = entryType._collectionItemPropertyType.getProperty(fieldName);
                        propTypeMap = invoiceEntryPropTypeMap;
                    } else {
                        property = invoiceObjectType.getProperty(propName);
                        propTypeMap = invoicePropTypeMap;
                    }
                    if (property instanceof DecimalProp) {
                        propTypeMap.put(fieldName, "N");
                        continue;
                    }
                    if (property instanceof DateTimeProp) {
                        propTypeMap.put(fieldName, "D");
                        continue;
                    }
                    propTypeMap.put(fieldName, "S");
                }
                boolean allCheckTrue = true;
                Integer interruptIndex = -1;
                for (Map<String, Object> invoiceData : invoiceList) {
                    boolean subAllCheckTrue;
                    String invoiceType = (String)invoiceData.get(INVOICE_TYPE);
                    boolean isTrue = this.isEqualInvoiceType(custom.getInvoiceType(), invoiceType);
                    if (!isTrue) continue;
                    Long invoiceId = (Long)invoiceData.get(INVOICE_ID);
                    HashMap<String, Object> ctx = new HashMap<String, Object>(2);
                    DynamicObject invoiceObj = new DynamicObject((DynamicObjectType)invoiceObjectType);
                    ctx.put(billTypeName + "_billObj", billObj);
                    int invoiceEntrySize = 0;
                    if (!invoiceKeys.isEmpty()) {
                        List itemList;
                        Set headInvoiceKeys = invoicePropTypeMap.keySet();
                        for (String key : headInvoiceKeys) {
                            if (ALLINVOICETOTALAMOUNT.equals(key) || ALLTYPETOTALAMOUNT.equals(key)) {
                                invoiceObj.set(key, (Object)this.calculateAndStoreSum(custom.getInvoiceType(), key, invoiceList, propSumMap));
                                continue;
                            }
                            Object value = invoiceData.get(key);
                            if (value == null) continue;
                            invoiceObj.set(key, this.convertData(value, key, invoicePropTypeMap));
                        }
                        if (!invoiceEntryPropTypeMap.isEmpty() && !CollectionUtils.isEmpty((Collection)(itemList = (List)invoiceData.get(DETAILITEM)))) {
                            Set entryInvoiceKeys = invoiceEntryPropTypeMap.keySet();
                            invoiceEntrySize = itemList.size();
                            DynamicObjectCollection itemEntry = invoiceObj.getDynamicObjectCollection(DETAILITEM);
                            for (Map entryRowMap : itemList) {
                                DynamicObject entryObj = itemEntry.addNew();
                                for (String entryInvoiceKey : entryInvoiceKeys) {
                                    entryObj.set(entryInvoiceKey, this.convertData(entryRowMap.get(entryInvoiceKey), entryInvoiceKey, invoiceEntryPropTypeMap));
                                }
                            }
                        }
                        ctx.put(custom.getInvoiceType() + "_billObj", invoiceObj);
                    }
                    InvoiceImageResult invoiceImageResult = InvoiceExecutor.getInvoiceImageResult(invoiceId, invoiceImageResults);
                    boolean scriptPass = false;
                    BatchScriptHandle batchScriptHandle = new BatchScriptHandle(ctx, entrySize, script, billTypeName, entryVars, invoiceEntrySize, custom.getInvoiceType(), rule.isShowAllCheckTrue(), invoiceEntryPropTypeMap);
                    String executeScript = batchScriptHandle.handleScript();
                    long startTime = System.currentTimeMillis();
                    ScriptFormIdHandler.runScript(billTypeName, custom.getInvoiceType(), ctx, executeScript);
                    SchemaExecutorLogger.info(String.format(ResManager.loadKDString((String)"\u6267\u884c\u7968\u636e\u68c0\u6d4b\u81ea\u5b9a\u4e49\u9879%1$s, \u53d1id%2$s,\u811a\u672c%3$s, \u7ed3\u679c%4$s", (String)"InvoiceExecutor_40", (String)"data-idi-core", (Object[])new Object[0]), custom.getInvoiceType(), invoiceId, executeScript, "not have result on batch script, cost(ms):" + (System.currentTimeMillis() - startTime)), new Object[0]);
                    scriptPass = (Boolean)ctx.get("scriptPass");
                    if (rule.isShowAllCheckTrue() && !(subAllCheckTrue = ((Boolean)ctx.get("allCheckTrue")).booleanValue())) {
                        allCheckTrue = false;
                    }
                    if (!scriptPass) continue;
                    invoiceImageResult.getRuleResults().add(rule.isPass() ? ruleResultPass : ruleResultFailed);
                    isRulePass = Boolean.TRUE;
                    if (interruptIndex >= 0) continue;
                    interruptIndex = (Integer)ctx.get("entryRowIndex");
                }
                if (isRulePass == null || !isRulePass.booleanValue()) continue;
                InvoiceImageRuleResult invoiceImageRuleResult = ruleResult = rule.isPass() ? ruleResultPass : ruleResultFailed;
                if (rule.isShowAllCheckTrue() && allCheckTrue || !rule.isShowAllCheckTrue()) {
                    if (context.isNeedHighLight()) {
                        highLightBuilder.buildInvoiceHighLight(script, billTypeName, context.getSrcEntityType(), billObj, ruleResult, highLightList, rule.isShowAllCheckTrue() && allCheckTrue ? -2 : interruptIndex);
                    }
                    results.add(ruleResult);
                }
                this.deductionGrade.deduct(rule.getDeductionGradePercent());
                ruleResult.deductPercentFromInt(rule.getDeductionGradePercent());
            }
        }
        if (!CollectionUtils.isEmpty(highLightList)) {
            decisionResult.setHighLightList(highLightList);
        }
        return results.toArray(new InvoiceImageRuleResult[0]);
    }

    private Object convertData(Object value, String key, Map<String, String> propTypeMap) {
        if (value != null) {
            switch (propTypeMap.get(key)) {
                case "N": {
                    return InvoiceExecutor.convertToBigDecimal(value);
                }
                case "D": {
                    return InvoiceExecutor.convertToDate((String)value);
                }
            }
            return value;
        }
        return null;
    }

    private BigDecimal calculateAndStoreSum(String ruleInvoiceType, String propName, List<Map<String, Object>> invoiceList, Map<String, BigDecimal> propSumMap) {
        String key;
        if (ALLINVOICETOTALAMOUNT.equals(propName)) {
            ruleInvoiceType = ALL_INVOICE_TYPE;
        }
        if (!propSumMap.containsKey(key = ruleInvoiceType + "_" + propName)) {
            BigDecimal sum = BigDecimal.ZERO;
            boolean isTrue = true;
            for (Map<String, Object> invoiceData : invoiceList) {
                if (!ALL_INVOICE_TYPE.equals(ruleInvoiceType)) {
                    String invoiceTypeData = (String)invoiceData.get(INVOICE_TYPE);
                    isTrue = this.isEqualInvoiceType(ruleInvoiceType, invoiceTypeData);
                }
                if (!isTrue) continue;
                BigDecimal totalAmount = InvoiceExecutor.convertToBigDecimal(invoiceData.get(TOTALAMOUNT));
                sum = sum.add(totalAmount);
            }
            propSumMap.put(key, sum);
        }
        return propSumMap.get(key);
    }

    private static Date convertToDate(String dateStr) {
        Date date1 = null;
        SimpleDateFormat dateformat = new SimpleDateFormat("yyyyMMdd");
        try {
            date1 = dateformat.parse(dateStr);
        }
        catch (ParseException ignore) {
            dateStr = dateStr.replaceAll("/", "-");
            dateformat = new SimpleDateFormat("yyyy-MM-dd");
            try {
                date1 = dateformat.parse(dateStr);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return date1;
    }

    private static BigDecimal convertToBigDecimal(Object param) {
        if (param == null) {
            return BigDecimal.ZERO;
        }
        if (param instanceof BigDecimal) {
            return (BigDecimal)param;
        }
        if (param instanceof String) {
            return new BigDecimal((String)param);
        }
        return new BigDecimal(param.toString());
    }

    private boolean isEqualInvoiceType(String ruleInvoiceType, String invoiceType) {
        if (StringUtils.isEmpty((String)invoiceType)) {
            return false;
        }
        switch (ruleInvoiceType) {
            case "idi_aircraftinvoice": {
                return "10".equals(invoiceType);
            }
            case "idi_commonprintedinvoic": {
                return "07".equals(invoiceType) || "7".equals(invoiceType);
            }
            case "idi_otherinvoice": {
                return "11".equals(invoiceType);
            }
            case "idi_passengerinvoice": {
                return "16".equals(invoiceType);
            }
            case "idi_quotainvoice": {
                return "14".equals(invoiceType);
            }
            case "idi_shippinginvoice": {
                return "20".equals(invoiceType);
            }
            case "idi_taxiinvoice": {
                return "08".equals(invoiceType) || "8".equals(invoiceType);
            }
            case "idi_traininvoice": {
                return "09".equals(invoiceType) || "9".equals(invoiceType);
            }
            case "idi_usedcarinvoice": {
                return "13".equals(invoiceType);
            }
            case "idi_vatinvoice_com": {
                return "01".equals(invoiceType) || "03".equals(invoiceType) || "05".equals(invoiceType) || "1".equals(invoiceType) || "3".equals(invoiceType) || "5".equals(invoiceType);
            }
            case "idi_vatinvoice_spe": {
                return "02".equals(invoiceType) || "04".equals(invoiceType) || "2".equals(invoiceType) || "4".equals(invoiceType);
            }
            case "idi_vehicleinvoice": {
                return "12".equals(invoiceType);
            }
            case "idi_passinginvoice": {
                return "17".equals(invoiceType);
            }
            case "idi_eleinvoice_com": {
                return "26".equals(invoiceType);
            }
            case "idi_eleinvoice_spe": {
                return "27".equals(invoiceType);
            }
        }
        return false;
    }

    private Set<String> extractKeys(String script, String invoiceType, String billEntity) {
        invoiceType = invoiceType + "_billObj.";
        Set<String> vars = ScriptFormIdHandler.extractVariables(script, new String[]{billEntity});
        HashSet<String> invoiceKeys = new HashSet<String>();
        for (String var : vars) {
            if (!var.startsWith(invoiceType)) continue;
            invoiceKeys.add(var.substring(invoiceType.length()));
        }
        return invoiceKeys;
    }

    public String getOrgData(Object orgId) {
        QFilter qfilter = new QFilter("id", "=", orgId);
        DynamicObjectCollection col = QueryServiceHelper.query((String)"bos_org", (String)"ffirmname,ftaxregnum", (QFilter[])new QFilter[]{qfilter});
        return ((DynamicObject)col.get(0)).getString("ftaxregnum");
    }

    public String getOrgName(Object orgId) {
        QFilter qfilter = new QFilter("id", "=", orgId);
        DynamicObjectCollection col = QueryServiceHelper.query((String)"bos_org", (String)"ffirmname,ftaxregnum", (QFilter[])new QFilter[]{qfilter});
        return ((DynamicObject)col.get(0)).getString("ffirmname");
    }

    private boolean checkStartCondition(DynamicObject dynamicObjBill, QFilter startConditionFilter, String entityNumber) {
        boolean match = true;
        if (startConditionFilter == null) {
            return match;
        }
        Object pkValue = dynamicObjBill.getPkValue();
        QFilter filter = new QFilter("id", "=", pkValue);
        QFilter[] qFilters = new QFilter[]{filter, startConditionFilter};
        if (!QueryServiceHelper.exists((String)entityNumber, (QFilter[])qFilters)) {
            match = false;
        }
        return match;
    }

    private List<Map<String, Object>> queryInvoiceData(DynamicObject dynamicObjBill, QFilter ocrInvoiceFilter, String costCompanyField, SchemaContext context, boolean useCustomInvoiceParam, CustomInvoiceParam cip) {
        QFilter[] qFilterArray;
        List<Map<String, Object>> values = new ArrayList<Map<String, Object>>();
        String billIdStr = String.valueOf(dynamicObjBill.getPkValue());
        QFilter filter = new QFilter(BILLID, "=", (Object)billIdStr);
        String entityNumber = "";
        if (ocrInvoiceFilter != null) {
            QFilter[] qFilterArray2 = new QFilter[2];
            qFilterArray2[0] = filter;
            qFilterArray = qFilterArray2;
            qFilterArray2[1] = ocrInvoiceFilter;
        } else {
            QFilter[] qFilterArray3 = new QFilter[1];
            qFilterArray = qFilterArray3;
            qFilterArray3[0] = filter;
        }
        QFilter[] bosFilter = qFilterArray;
        if (QueryServiceHelper.exists((String)"bos_invoice", (QFilter[])bosFilter)) {
            entityNumber = "bos_invoice";
        }
        if (StringUtils.isNotEmpty((String)entityNumber)) {
            QFilter[] qFilterArray4;
            QFilter typeFilter = new QFilter(INVOICE_TYPE, "!=", (Object)"11");
            if ("bos_invoice".equalsIgnoreCase(entityNumber) && ocrInvoiceFilter != null) {
                QFilter[] qFilterArray5 = new QFilter[3];
                qFilterArray5[0] = filter;
                qFilterArray5[1] = typeFilter;
                qFilterArray4 = qFilterArray5;
                qFilterArray5[2] = ocrInvoiceFilter;
            } else {
                QFilter[] qFilterArray6 = new QFilter[2];
                qFilterArray6[0] = filter;
                qFilterArray4 = qFilterArray6;
                qFilterArray6[1] = typeFilter;
            }
            QFilter[] qFilters = qFilterArray4;
            this.queryBillInvoice(entityNumber, qFilters, values);
            this.queryInvoiceItems(entityNumber, values);
        } else if (this.useInvoiceCloud) {
            Map<String, Object> dataMap = IDIInvoiceCloudHelper.queryInvoice(dynamicObjBill);
            List successInvoiceList = (List)dataMap.get("invoiceData");
            this.repeatInvoiceList = (Map)dataMap.get("repeatData");
            if (!CollectionUtils.isEmpty((Collection)successInvoiceList)) {
                values = InvoiceParser.convertInvoiceMap(successInvoiceList);
            }
        } else {
            try {
                InvoicePiaoZoneApiAbutmentImpl invoicePiaoZoneApiAbutment = new InvoicePiaoZoneApiAbutmentImpl();
                List<CustomInvoiceParamValue> expenseIdList = InvoiceExecutor.achieveExpense(dynamicObjBill, cip);
                ArrayList<DynamicObject> invoiceList = new ArrayList<DynamicObject>(5);
                ArrayList<String> invoiceResultStrList = new ArrayList<String>(5);
                String clientId = null;
                String secret = null;
                if (!expenseIdList.isEmpty()) {
                    long startTime = System.currentTimeMillis();
                    for (CustomInvoiceParamValue customInvoiceParamValue : expenseIdList) {
                        AdditionalConfig config = new AdditionalConfig(dynamicObjBill, costCompanyField, useCustomInvoiceParam && customInvoiceParamValue.getEntryRowIndex() >= -1, customInvoiceParamValue);
                        UrlParam urlParam = invoicePiaoZoneApiAbutment.getUrlParam("FPY_URL", config);
                        clientId = urlParam.getCustomerKey();
                        secret = urlParam.getSecret();
                        InvoicePiaoZoneParam invoicePiaoZoneParam = new InvoicePiaoZoneParam(dynamicObjBill, context.getEntityType(), useCustomInvoiceParam && customInvoiceParamValue.getEntryRowIndex() >= -1, customInvoiceParamValue.getBxdKeyValue());
                        invoicePiaoZoneApiAbutment.validate(urlParam, invoicePiaoZoneParam);
                        String invoiceResultStr = invoicePiaoZoneApiAbutment.apiAction(urlParam, invoicePiaoZoneParam);
                        List subInvoiceDataList = (List)invoicePiaoZoneApiAbutment.parseResult(invoiceResultStr, invoicePiaoZoneParam);
                        if (subInvoiceDataList.isEmpty()) continue;
                        for (DynamicObject invoiceDynamicObject : subInvoiceDataList) {
                            invoiceDynamicObject.set("clientid", (Object)clientId);
                            invoiceDynamicObject.set("secret", (Object)secret);
                            invoiceDynamicObject.set("billtype", (Object)dynamicObjBill.getDataEntityType().getName());
                        }
                        invoiceList.addAll(subInvoiceDataList);
                        invoiceResultStrList.add(invoiceResultStr);
                    }
                    SchemaExecutorLogger.info("use invoice piao zone  query :%d, cost: %d (ms)", expenseIdList.size(), System.currentTimeMillis() - startTime);
                }
                if (!CollectionUtils.isEmpty(invoiceList)) {
                    if (!context.isBillControl()) {
                        DeleteServiceHelper.delete((String)"idi_invoice", (QFilter[])new QFilter[]{new QFilter(BILLID, "in", (Object)billIdStr)});
                        SaveServiceHelper.save((DynamicObject[])invoiceList.toArray(new DynamicObject[0]));
                    } else if (dynamicObjBill.getPkValue() != null && QueryServiceHelper.exists((String)context.getEntityType(), (Object)dynamicObjBill.getPkValue())) {
                        int index = 0;
                        for (String invoiceResultStr : invoiceResultStrList) {
                            IDIMqMessagePublisher.sendSaveInvoiceAction(context.getEntityType(), billIdStr, invoiceResultStr, clientId, secret, index == invoiceResultStrList.size() - 1);
                            ++index;
                        }
                    }
                    values = InvoiceParser.convertInvoiceMap(invoiceList);
                }
                return values;
            }
            catch (Exception e) {
                SchemaExecutorLogger.error(ResManager.loadKDString((String)"\u53d1\u7968\u4fe1\u606f\u89e3\u6790\u5931\u8d25", (String)"InvoiceExecutor_0", (String)"data-idi-core", (Object[])new Object[0]), e);
                String message = ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u8d39\u7528\u627f\u62c5\u516c\u53f8\u4fe1\u606f", (String)"IDIInvoicePiaoZoneHelper_16", (String)"data-idi-core", (Object[])new Object[0]);
                if (!message.equals(e.getMessage())) {
                    message = ResManager.loadKDString((String)"\u53d1\u7968\u4fe1\u606f\u89e3\u6790\u5931\u8d25", (String)"InvoiceExecutor_0", (String)"data-idi-core", (Object[])new Object[0]);
                }
                throw new KDBizException(message);
            }
        }
        return values;
    }

    private void queryInvoiceItems(String entityNumber, List<Map<String, Object>> values) {
        if (CollectionUtils.isEmpty(values)) {
            return;
        }
        ArrayList<Object> invoiceIdList = new ArrayList<Object>(values.size());
        HashMap<Long, Map> invoiceIdToMap = new HashMap<Long, Map>(values.size());
        for (Map<String, Object> valueMap : values) {
            invoiceIdList.add(valueMap.get(INVOICE_ID));
            invoiceIdToMap.put((Long)valueMap.get(INVOICE_ID), valueMap);
        }
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.data.idi.engine.InvoiceExecutor.queryInvoiceItems", (String)entityNumber, (String)"id,entryentity.invoiceentryindex,entryentity.invoiceentrykey,entryentity.invoiceentryvalue", (QFilter[])new QFilter[]{new QFilter("id", "in", invoiceIdList)}, (String)"id,entryentity.invoiceentryindex");){
            if (dataSet != null) {
                long invoiceId2 = 0L;
                int rowIndex = -1;
                ArrayList itemList = new ArrayList(3);
                HashMap<String, Object> rowMap = new HashMap<String, Object>(15);
                for (Row row : dataSet) {
                    int index;
                    if (invoiceId2 == 0L || row.getLong("id") != invoiceId2) {
                        invoiceId2 = row.getLong("id");
                        Map invoiceMap = (Map)invoiceIdToMap.get(invoiceId2);
                        itemList = new ArrayList(3);
                        invoiceMap.put(DETAILITEM, itemList);
                        rowIndex = -1;
                    }
                    if (rowIndex != (index = row.getInteger("entryentity.invoiceentryindex").intValue())) {
                        rowMap = new HashMap(15);
                        itemList.add(rowMap);
                        rowIndex = index;
                    }
                    String key = row.getString("entryentity.invoiceentrykey");
                    Object value = row.get("entryentity.invoiceentryvalue");
                    if (null == key) continue;
                    if ("taxamount".equals(key = key.toLowerCase(Locale.ENGLISH))) {
                        key = "itemtaxamount";
                    }
                    rowMap.put(key, value);
                }
            }
        }
        invoiceIdToMap.forEach((invoiceId, invoiceDataMap) -> {
            List itemList = (List)invoiceDataMap.get(DETAILITEM);
            if (!CollectionUtils.isEmpty((Collection)itemList) && itemList.size() == 1 && CollectionUtils.isEmpty((Map)((Map)itemList.get(0)))) {
                itemList.clear();
            }
        });
    }

    private void queryBillInvoice(String entityNumber, QFilter[] qFilters, List<Map<String, Object>> values) {
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.data.idi.engine.InvoiceExecutor", (String)entityNumber, (String)"id,invoicecode,invoiceno,invoicetype,imagenumber,imagepage,indexfield,entrykeyvalue.invoicekey,entrykeyvalue.invoicevalue", (QFilter[])qFilters, (String)"id");){
            if (dataSet != null) {
                long invoiceId = 0L;
                HashMap<String, Object> invoiceMap = new HashMap<String, Object>();
                for (Row row : dataSet) {
                    if (invoiceId == 0L || row.getLong("id") != invoiceId) {
                        invoiceMap = new HashMap();
                        invoiceId = row.getLong("id");
                        invoiceMap.put(INVOICE_ID, invoiceId);
                        invoiceMap.put(INVOICE_NO, row.getString(INVOICE_NO));
                        invoiceMap.put(IMAGE_NO, row.getString(IMAGE_NO));
                        if (StringUtils.isNotEmpty((String)row.getString(IMAGE_PAGE))) {
                            invoiceMap.put(IMAGE_PAGE, String.valueOf(Integer.parseInt(row.getString(IMAGE_PAGE)) + 1));
                        } else {
                            invoiceMap.put(IMAGE_PAGE, "");
                        }
                        invoiceMap.put(INVOICE_TYPE, row.getString(INVOICE_TYPE));
                        invoiceMap.put(INVOICE_CODE, row.getString(INVOICE_CODE));
                        invoiceMap.put(DUPLICATEFIELD, row.getString(DUPLICATEFIELD));
                        values.add(invoiceMap);
                    }
                    String invoiceKey = row.getString("entrykeyvalue.invoicekey");
                    Object invoiceValue = row.get("entrykeyvalue.invoicevalue");
                    if (invoiceKey == null || invoiceValue == null || INVOICE_TYPE.equals(invoiceKey.toLowerCase(Locale.ENGLISH))) continue;
                    invoiceMap.put(invoiceKey.toLowerCase(Locale.ENGLISH), invoiceValue);
                }
            }
        }
    }

    private Map<String, List<InvoiceFailureEntity>> getFailureInvoiceData(String billId) {
        HashMap<String, List<InvoiceFailureEntity>> resultMap = new HashMap<String, List<InvoiceFailureEntity>>();
        QFilter filter = new QFilter(BILLID, "=", (Object)Long.valueOf(billId));
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.data.idi.engine.InvoiceExecutor", (String)"task_invoicemaintain", (String)"imagenumber,invoiceno,errorcode", (QFilter[])new QFilter[]{filter}, (String)"id desc");){
            if (dataSet != null) {
                for (Row row : dataSet) {
                    String errorCode = row.getString("errorcode");
                    InvoiceFailureEntity invoiceFailureEntity = new InvoiceFailureEntity();
                    invoiceFailureEntity.setImageNumber(row.getString(IMAGE_NO));
                    invoiceFailureEntity.setInvoiceNo(row.getString(INVOICE_NO));
                    List<InvoiceFailureEntity> invoiceFailureEntityList = null;
                    String enumErrorCodeKey = InvoiceCloudCodeType.typeToCloudCodeType(errorCode).getErrorCode();
                    if (resultMap.get(enumErrorCodeKey) != null) {
                        invoiceFailureEntityList = (List)resultMap.get(enumErrorCodeKey);
                        boolean existFlag = false;
                        for (InvoiceFailureEntity entity : invoiceFailureEntityList) {
                            if (!entity.getInvoiceNo().equals(row.getString(INVOICE_NO))) continue;
                            existFlag = true;
                        }
                        if (!existFlag) {
                            invoiceFailureEntityList.add(invoiceFailureEntity);
                        }
                    } else {
                        invoiceFailureEntityList = new ArrayList();
                        invoiceFailureEntityList.add(invoiceFailureEntity);
                    }
                    resultMap.put(enumErrorCodeKey, invoiceFailureEntityList);
                }
            }
        }
        return resultMap;
    }

    private InvoiceImageRuleResult createFailureInvoiceMessage() {
        InvoiceImageRuleResult ruleResultFailed = new InvoiceImageRuleResult();
        ruleResultFailed.setRuleNo("A010");
        ruleResultFailed.setPass(false);
        ruleResultFailed.setStatus("none");
        ruleResultFailed.setText(ResManager.loadKDString((String)"\u8bc6\u522b\u5931\u8d25\u7684\u53d1\u7968\u4fe1\u606f", (String)"InvoiceExecutor_20", (String)"data-idi-core", (Object[])new Object[0]));
        return ruleResultFailed;
    }

    private static List<CustomInvoiceParamValue> achieveExpense(DynamicObject dynamicBillObj, CustomInvoiceParam cip) {
        Serializable clientIdList;
        ArrayList<CustomInvoiceParamValue> list = new ArrayList<CustomInvoiceParamValue>(2);
        String entityNumber = dynamicBillObj.getDynamicObjectType().getName();
        SchemaExecutorLogger.info("bill type is  " + entityNumber, new Object[0]);
        if (cip != null) {
            ArrayList<String> bxdKeyList;
            ArrayList<String> secretList;
            Object clientId = ExecutorHelper.getValueAndNameByName(dynamicBillObj, cip.getClientId(), true).getValue();
            if (clientId instanceof List) {
                clientIdList = (ArrayList<String>)clientId;
            } else {
                clientIdList = new ArrayList<String>(2);
                clientIdList.add(clientId == null ? null : clientId.toString());
            }
            Object secret = ExecutorHelper.getValueAndNameByName(dynamicBillObj, cip.getSecret(), true).getValue();
            if (secret instanceof List) {
                secretList = (ArrayList<String>)secret;
            } else {
                secretList = new ArrayList<String>(2);
                secretList.add(secret == null ? null : secret.toString());
            }
            Object bxdKey = ExecutorHelper.getValueAndNameByName(dynamicBillObj, cip.getBxdKey(), true).getValue();
            if (bxdKey instanceof List) {
                bxdKeyList = (ArrayList<String>)bxdKey;
            } else {
                bxdKeyList = new ArrayList<String>(2);
                bxdKeyList.add(bxdKey == null ? null : bxdKey.toString());
            }
            int count = 1;
            count = Math.max(count, clientIdList.size());
            count = Math.max(count, secretList.size());
            count = Math.max(count, bxdKeyList.size());
            String entryName = cip.achieveEntry(EntityMetadataCache.getDataEntityType((String)entityNumber));
            if (count == 1) {
                CustomInvoiceParamValue cipv = new CustomInvoiceParamValue(StringUtils.isNotEmpty((String)entryName) ? 0 : -1, (String)clientIdList.get(0), (String)secretList.get(0), (String)bxdKeyList.get(0));
                if (!cipv.isEmpty()) {
                    list.add(cipv);
                }
            } else {
                for (int entryIndex = 0; entryIndex < count; ++entryIndex) {
                    String bxdKeyValue;
                    String secretValue;
                    String clientIdValue = entryIndex >= clientIdList.size() ? (String)clientIdList.get(clientIdList.size() - 1) : (String)clientIdList.get(entryIndex);
                    CustomInvoiceParamValue entryCipv = new CustomInvoiceParamValue(entryIndex, clientIdValue, secretValue = entryIndex >= secretList.size() ? (String)secretList.get(secretList.size() - 1) : (String)secretList.get(entryIndex), bxdKeyValue = entryIndex >= bxdKeyList.size() ? (String)bxdKeyList.get(bxdKeyList.size() - 1) : (String)bxdKeyList.get(entryIndex));
                    if (entryCipv.isEmpty()) continue;
                    list.add(entryCipv);
                }
            }
            SchemaExecutorLogger.info("CustomInvoiceParam expenseId has %s", ((Object)list).toString());
        }
        if ("ap_finapbill".equals(entityNumber)) {
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)"IDIInvoicePiaoZoneHelper.achieveExpense", (String)"ap_finapbill", (String)"inventry.invid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)dynamicBillObj.getLong("id"))}, null);
            clientIdList = null;
            try {
                for (Row row : dataSet) {
                    long invoiceId = row.getLong("inventry.invid");
                    if (invoiceId <= 0L) continue;
                    StringBuilder stringBuilder = new StringBuilder();
                    String reimbursementId = stringBuilder.append("ap_invoice").append('_').append(invoiceId).toString();
                    CustomInvoiceParamValue paramValue = new CustomInvoiceParamValue(-2, null, null, reimbursementId);
                    list.add(paramValue);
                }
            }
            catch (Throwable secret) {
                clientIdList = secret;
                throw secret;
            }
            finally {
                if (dataSet != null) {
                    if (clientIdList != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable secret) {
                            ((Throwable)clientIdList).addSuppressed(secret);
                        }
                    } else {
                        dataSet.close();
                    }
                }
            }
            SchemaExecutorLogger.info("ap_finapbill expenseId has %s", ((Object)list).toString());
        }
        StringBuilder stringBuilder = new StringBuilder();
        String reimbursementId = stringBuilder.append(entityNumber).append('_').append(dynamicBillObj.getPkValue()).toString();
        CustomInvoiceParamValue paramValue = new CustomInvoiceParamValue(-2, null, null, reimbursementId);
        list.add(paramValue);
        SchemaExecutorLogger.info("other expenseId has %s", ((Object)list).toString());
        return list;
    }

    private boolean findDeductionGradeConfigPass(List<DeductionGradeConfig> deductionGradeConfigList, DeductionGradeConfig.DeductionGradeItem item) {
        if (kd.bos.util.CollectionUtils.isNotEmpty(deductionGradeConfigList)) {
            for (DeductionGradeConfig config : deductionGradeConfigList) {
                if (!config.getItem().getType().equals(item.getType())) continue;
                return config.isPass();
            }
        }
        return DeductionGradeConfig.DeductionGradeItem.STARTCONDITION_NOTMATCH == item;
    }

    private static class DuplicateInvoiceValidator
    extends BaseInvoiceValidator
    implements IInvoiceValidator {
        private static final String ruleNo = "A003";
        private Decision decision;
        private DynamicObject billObj;
        private List<Map<String, Object>> invoiceList;
        private List<InvoiceImageResult> invoiceImageResults;
        private QFilter ocrInvoiceFilter;
        private SchemaContext schemaContext;
        private DeductionGrade deductionGrade;
        private boolean useInvoiceCloud;
        private Map<String, List<IDIInvoiceCloudHelper.RepeatInvoiceInfo>> repeatInvoiceList;

        public DuplicateInvoiceValidator(Decision decision, DynamicObject billObj, List<Map<String, Object>> invoiceList, List<InvoiceImageResult> invoiceImageResults, QFilter ocrInvoiceFilter, SchemaContext schemaContext, DeductionGrade deductionGrade, Map<String, List<IDIInvoiceCloudHelper.RepeatInvoiceInfo>> repeatInvoiceList) {
            this.decision = decision;
            this.billObj = billObj;
            this.invoiceList = invoiceList;
            this.invoiceImageResults = invoiceImageResults;
            this.ocrInvoiceFilter = ocrInvoiceFilter;
            this.schemaContext = schemaContext;
            this.deductionGrade = deductionGrade;
            this.repeatInvoiceList = repeatInvoiceList;
            this.useInvoiceCloud = ParamFactory.getBoolean(InvoiceExecutor.PARAM_ISUSEINVOICECLOUD, false);
        }

        @Override
        public InvoiceImageRuleResult validate() {
            boolean isPass;
            if (!this.decision.getInvoiceConfig().isDuplicate()) {
                return null;
            }
            InvoiceImageRuleResult ruleResultPass = this.createRuleResult(ruleNo, true, "green", ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u91cd\u590d\u4f7f\u7528\u7684\u53d1\u7968", (String)"InvoiceExecutor_5", (String)"data-idi-core", (Object[])new Object[0]));
            InvoiceImageRuleResult ruleResultFailed = this.createRuleResult(ruleNo, false, "alarming", ResManager.loadKDString((String)"\u5b58\u5728\u91cd\u590d\u4f7f\u7528\u7684\u53d1\u7968", (String)"InvoiceExecutor_6", (String)"data-idi-core", (Object[])new Object[0]));
            if (this.useInvoiceCloud) {
                return this.invoiceCloudDuplicate(ruleResultPass, ruleResultFailed);
            }
            InvoiceImageRuleResult ruleResult = ruleResultPass;
            boolean isRulePass = true;
            HashSet<String> invoiceNoSet = new HashSet<String>(this.invoiceList.size());
            HashSet<String> invoiceCodeSet = new HashSet<String>(this.invoiceList.size());
            ArrayList<Map<String, Object>> invoiceDataList = new ArrayList<Map<String, Object>>(this.invoiceList.size());
            HashSet<String> planeInvoiceSet = new HashSet<String>(this.invoiceList.size());
            HashSet<String> trainInvoiceSet = new HashSet<String>(this.invoiceList.size());
            HashMap<String, Long> planeInvoiceMap = new HashMap<String, Long>(this.invoiceList.size());
            HashMap<String, Long> trainInvoiceMap = new HashMap<String, Long>(this.invoiceList.size());
            this.separateInvoice(invoiceNoSet, invoiceCodeSet, invoiceDataList, planeInvoiceSet, planeInvoiceMap, trainInvoiceSet, trainInvoiceMap);
            HashMap<String, List<String[]>> duplicatedBillInvoiceMap = new HashMap<String, List<String[]>>(10);
            HashMap<String, List<Long>> billMap = new HashMap<String, List<Long>>(10);
            Map<String, List<String[]>> invoiceNoDataMap = this.getDuplicateInvoiceList("bos_invoice", invoiceNoSet, invoiceCodeSet, duplicatedBillInvoiceMap, billMap);
            Map<String, List<String[]>> invoiceNoDataMapTwo = this.getDuplicateInvoiceList("idi_invoice", invoiceNoSet, invoiceCodeSet, duplicatedBillInvoiceMap, billMap);
            invoiceNoDataMap.putAll(invoiceNoDataMapTwo);
            HashMap<String, List<List<String>>> planeAndTrainInvoiceNoDataMap = new HashMap(0);
            if (!planeInvoiceMap.isEmpty() || !trainInvoiceMap.isEmpty()) {
                planeAndTrainInvoiceNoDataMap = this.getDuplicateInvoiceListByTrainAndPlane("bos_invoice", planeInvoiceMap, planeInvoiceSet, trainInvoiceMap, trainInvoiceSet, duplicatedBillInvoiceMap, billMap);
                Map<String, List<List<String>>> planeAndTrainInvoiceNoDataMapTwo = this.getDuplicateInvoiceListByTrainAndPlane("idi_invoice", planeInvoiceMap, planeInvoiceSet, trainInvoiceMap, trainInvoiceSet, duplicatedBillInvoiceMap, billMap);
                planeAndTrainInvoiceNoDataMap.putAll(planeAndTrainInvoiceNoDataMapTwo);
            }
            if (!duplicatedBillInvoiceMap.isEmpty()) {
                List<DynamicObject> reloadInvoiceList = this.reloadInvoice(duplicatedBillInvoiceMap, billMap);
                this.separateDuplicatedInvoice(reloadInvoiceList, invoiceNoDataMap, invoiceNoSet, invoiceCodeSet, planeAndTrainInvoiceNoDataMap, planeInvoiceSet, trainInvoiceSet);
            }
            if (!invoiceDataList.isEmpty() && !(isPass = this.checkInvoice(invoiceDataList, invoiceNoDataMap, ruleResultPass, ruleResultFailed))) {
                isRulePass = false;
            }
            if (!planeInvoiceMap.isEmpty() && !(isPass = this.checkTrainAndPlane(planeAndTrainInvoiceNoDataMap, planeInvoiceMap, ruleResultPass, ruleResultFailed))) {
                isRulePass = false;
            }
            if (!trainInvoiceMap.isEmpty() && !(isPass = this.checkTrainAndPlane(planeAndTrainInvoiceNoDataMap, trainInvoiceMap, ruleResultPass, ruleResultFailed))) {
                isRulePass = false;
            }
            if (!isRulePass) {
                ruleResult = ruleResultFailed;
                this.deductionGrade.deduct(this.decision.getInvoiceConfig().getDuplicateDeductionGradePercent());
                ruleResult.deductPercentFromInt(this.decision.getInvoiceConfig().getDuplicateDeductionGradePercent());
            }
            return ruleResult;
        }

        private boolean checkInvoice(List<Map<String, Object>> invoiceDataList, Map<String, List<String[]>> invoiceNoDataMap, InvoiceImageRuleResult ruleResultPass, InvoiceImageRuleResult ruleResultFailed) {
            boolean isRulePass = true;
            for (Map<String, Object> invoiceData : invoiceDataList) {
                Long invoiceId = (Long)invoiceData.get(InvoiceExecutor.INVOICE_ID);
                String invoiceNo = (String)invoiceData.get(InvoiceExecutor.INVOICE_NO);
                String invoiceCode = (String)invoiceData.get(InvoiceExecutor.INVOICE_CODE);
                String invoiceType = (String)invoiceData.get(InvoiceExecutor.INVOICE_TYPE);
                List<List<String>> duplicatedList = this.isDuplicated(invoiceNoDataMap, this.billObj.getString("id"), invoiceNo, invoiceCode, invoiceType);
                boolean invoicePass = duplicatedList.isEmpty();
                InvoiceImageResult invoiceImageResult = InvoiceExecutor.getInvoiceImageResult(invoiceId, this.invoiceImageResults);
                if (invoicePass) {
                    invoiceImageResult.getRuleResults().add(ruleResultPass);
                    continue;
                }
                isRulePass = false;
                invoiceImageResult.getRuleResults().add(ruleResultFailed);
                invoiceImageResult.addDuplicatedList(duplicatedList);
            }
            return isRulePass;
        }

        private boolean checkTrainAndPlane(Map<String, List<List<String>>> planeAndTrainInvoiceNoDataMap, Map<String, Long> planeOrTrainInvoiceMap, InvoiceImageRuleResult ruleResultPass, InvoiceImageRuleResult ruleResultFailed) {
            Set<Map.Entry<String, Long>> planeInvoiceEntrySet = planeOrTrainInvoiceMap.entrySet();
            boolean isRulePass = true;
            for (Map.Entry<String, Long> stringLongEntry : planeInvoiceEntrySet) {
                String duplicatedKey = stringLongEntry.getKey();
                Long invoiceId = stringLongEntry.getValue();
                ArrayList<List<String>> duplicatedList = StringUtils.isEmpty((String)duplicatedKey) ? new ArrayList() : planeAndTrainInvoiceNoDataMap.get(duplicatedKey);
                InvoiceImageResult invoiceImageResult = InvoiceExecutor.getInvoiceImageResult(invoiceId, this.invoiceImageResults);
                boolean invoicePass = CollectionUtils.isEmpty(duplicatedList);
                if (invoicePass) {
                    invoiceImageResult.getRuleResults().add(ruleResultPass);
                    continue;
                }
                isRulePass = false;
                invoiceImageResult.getRuleResults().add(ruleResultFailed);
                invoiceImageResult.addDuplicatedList(duplicatedList);
            }
            return isRulePass;
        }

        private List<List<String>> isDuplicated(Map<String, List<String[]>> invoiceNoDataMap, String billId, String invoiceNo, String invoiceCode, String invoiceType) {
            if (StringUtils.isEmpty((String)invoiceNo)) {
                return new ArrayList<List<String>>();
            }
            String key = this.buildDuplicateKey(invoiceNo, invoiceCode);
            List<String[]> invoiceList = invoiceNoDataMap.get(key);
            if (invoiceList == null || invoiceList.isEmpty()) {
                return new ArrayList<List<String>>();
            }
            ArrayList<List<String>> duplicateInvoiceList = new ArrayList<List<String>>();
            HashSet<String> duplicateSet = new HashSet<String>();
            for (String[] invoiceData : invoiceList) {
                String showKey = String.format("%s_%s_%s", invoiceData[2], invoiceData[1], invoiceData[0]);
                if (invoiceData[3].equals(billId) || !invoiceType.equals(invoiceData[4]) || !invoiceCode.equals(invoiceData[5]) || !duplicateSet.add(showKey)) continue;
                ArrayList<String> duplicateInvoice = new ArrayList<String>(3);
                duplicateInvoice.add(invoiceData[0]);
                duplicateInvoice.add(invoiceData[1]);
                duplicateInvoice.add(invoiceData[2]);
                duplicateInvoiceList.add(duplicateInvoice);
            }
            return duplicateInvoiceList;
        }

        private void separateDuplicatedInvoice(List<DynamicObject> reloadInvoiceList, Map<String, List<String[]>> invoiceNoDataMap, Set<String> invoiceNoSet, Set<String> invoiceCodeSet, Map<String, List<List<String>>> planeAndTrainInvoiceNoDataMap, Set<String> planeInvoiceSet, Set<String> trainInvoiceSet) {
            if (CollectionUtils.isEmpty(reloadInvoiceList)) {
                return;
            }
            block8: for (DynamicObject invoiceDynamicObject : reloadInvoiceList) {
                String invoiceType;
                switch (invoiceType = invoiceDynamicObject.getString(InvoiceExecutor.INVOICE_TYPE)) {
                    case "9": {
                        String trainDuplicate = invoiceDynamicObject.getString(DUPLICATEFIELD);
                        if (!trainInvoiceSet.contains(trainDuplicate)) continue block8;
                        this.createDuplicateInvoiceByTrainAndPlane(invoiceDynamicObject, false, planeAndTrainInvoiceNoDataMap);
                        continue block8;
                    }
                    case "10": {
                        String planeDuplicate = invoiceDynamicObject.getString(DUPLICATEFIELD);
                        if (!planeInvoiceSet.contains(planeDuplicate)) continue block8;
                        this.createDuplicateInvoiceByTrainAndPlane(invoiceDynamicObject, true, planeAndTrainInvoiceNoDataMap);
                        continue block8;
                    }
                }
                String invoiceNo = invoiceDynamicObject.getString(InvoiceExecutor.INVOICE_NO);
                String invoiceCode = invoiceDynamicObject.getString(InvoiceExecutor.INVOICE_CODE);
                if (!invoiceNoSet.contains(invoiceNo) || !invoiceCodeSet.contains(invoiceCode)) continue;
                this.collectDuplicateInvoiceData(invoiceDynamicObject, invoiceNoDataMap);
            }
        }

        private List<DynamicObject> reloadInvoice(Map<String, List<String[]>> duplicatedBillInvoiceMap, Map<String, List<Long>> billMap) {
            InvoiceConfig invoiceConfig = this.decision.getInvoiceConfig();
            ArrayList<DynamicObject> invoiceList = new ArrayList<DynamicObject>(5);
            if (!duplicatedBillInvoiceMap.isEmpty()) {
                HashMap<String, DynamicObject> billObjMap = new HashMap<String, DynamicObject>(billMap.size());
                billMap.forEach((billType, billIdList) -> {
                    if (!CollectionUtils.isEmpty((Collection)billIdList)) {
                        DynamicObject[] billObjs;
                        for (Long aLong : billIdList) {
                            billObjMap.put(String.valueOf(aLong), null);
                        }
                        MainEntityType billMainType = EntityMetadataCache.getDataEntityType((String)billType);
                        for (DynamicObject dynamicObject : billObjs = BusinessDataServiceHelper.load((Object[])billIdList.toArray(new Long[0]), (DynamicObjectType)billMainType)) {
                            billObjMap.put(String.valueOf(dynamicObject.get("id")), dynamicObject);
                        }
                    }
                });
                ArrayList billIdList2 = new ArrayList(10);
                ArrayList<IDIMqMessagePublisher.BatchInvoiceParam> batchInvoiceParamList = new ArrayList<IDIMqMessagePublisher.BatchInvoiceParam>(10);
                billObjMap.forEach((billIdStr, dynamicObjBill) -> {
                    List duplicatedInvoiceMesgList = (List)duplicatedBillInvoiceMap.get(billIdStr);
                    if (!CollectionUtils.isEmpty((Collection)duplicatedInvoiceMesgList)) {
                        billIdList2.add(billIdStr);
                        if (dynamicObjBill == null) {
                            IDIMqMessagePublisher.BatchInvoiceParam batchInvoiceParam = IDIMqMessagePublisher.createOf(billIdStr, "", "", "", null);
                            batchInvoiceParamList.add(batchInvoiceParam);
                        } else {
                            String[] duplicatedInvoiceMesg = (String[])duplicatedInvoiceMesgList.get(0);
                            try {
                                InvoicePiaoZoneApiAbutmentImpl invoicePiaoZoneApiAbutment = new InvoicePiaoZoneApiAbutmentImpl();
                                List expenseIdList = InvoiceExecutor.achieveExpense(dynamicObjBill, invoiceConfig.getCustomInvoiceParam());
                                ArrayList<String> invoiceResultStrList = new ArrayList<String>(5);
                                if (!expenseIdList.isEmpty()) {
                                    long startTime = System.currentTimeMillis();
                                    for (CustomInvoiceParamValue customInvoiceParamValue : expenseIdList) {
                                        UrlParam urlParam = new UrlParam();
                                        String url = ParamFactory.getString("FPY_URL");
                                        urlParam.setUrl(url);
                                        urlParam.setCustomerKey(duplicatedInvoiceMesg[1]);
                                        urlParam.setSecret(duplicatedInvoiceMesg[2]);
                                        InvoicePiaoZoneParam invoicePiaoZoneParam = new InvoicePiaoZoneParam((DynamicObject)dynamicObjBill, duplicatedInvoiceMesg[0], invoiceConfig.isUseCustomInvoiceParam() && customInvoiceParamValue.getEntryRowIndex() >= -1, customInvoiceParamValue.getBxdKeyValue());
                                        invoicePiaoZoneApiAbutment.validate(urlParam, invoicePiaoZoneParam);
                                        String invoiceResultStr = invoicePiaoZoneApiAbutment.apiAction(urlParam, invoicePiaoZoneParam);
                                        List subInvoiceDataList = (List)invoicePiaoZoneApiAbutment.parseResult(invoiceResultStr, invoicePiaoZoneParam);
                                        if (subInvoiceDataList.isEmpty()) continue;
                                        for (DynamicObject invoiceDynamicObject : subInvoiceDataList) {
                                            invoiceDynamicObject.set("clientid", (Object)urlParam.getCustomerKey());
                                            invoiceDynamicObject.set("secret", (Object)urlParam.getSecret());
                                            invoiceDynamicObject.set("billtype", (Object)duplicatedInvoiceMesg[0]);
                                        }
                                        invoiceList.addAll(subInvoiceDataList);
                                        invoiceResultStrList.add(invoiceResultStr);
                                    }
                                    SchemaExecutorLogger.info("use invoice piao zone  query :%d, cost: %d (ms)", expenseIdList.size(), System.currentTimeMillis() - startTime);
                                }
                                IDIMqMessagePublisher.BatchInvoiceParam batchInvoiceParam = IDIMqMessagePublisher.createOf(billIdStr, duplicatedInvoiceMesg[0], duplicatedInvoiceMesg[1], duplicatedInvoiceMesg[2], invoiceResultStrList);
                                batchInvoiceParamList.add(batchInvoiceParam);
                            }
                            catch (Exception e) {
                                SchemaExecutorLogger.error(ResManager.loadKDString((String)"\u53d1\u7968\u4fe1\u606f\u89e3\u6790\u5931\u8d25", (String)"InvoiceExecutor_0", (String)"data-idi-core", (Object[])new Object[0]), e);
                                String message = ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u8d39\u7528\u627f\u62c5\u516c\u53f8\u4fe1\u606f", (String)"IDIInvoicePiaoZoneHelper_16", (String)"data-idi-core", (Object[])new Object[0]);
                                if (!message.equals(e.getMessage())) {
                                    message = ResManager.loadKDString((String)"\u53d1\u7968\u4fe1\u606f\u89e3\u6790\u5931\u8d25", (String)"InvoiceExecutor_0", (String)"data-idi-core", (Object[])new Object[0]);
                                }
                                throw new KDBizException(message);
                            }
                        }
                    }
                });
                if (!this.schemaContext.isBillControl()) {
                    if (!CollectionUtils.isEmpty(billIdList2)) {
                        DeleteServiceHelper.delete((String)"idi_invoice", (QFilter[])new QFilter[]{new QFilter(InvoiceExecutor.BILLID, "in", billIdList2)});
                    }
                    if (!CollectionUtils.isEmpty(invoiceList)) {
                        SaveServiceHelper.save((DynamicObject[])invoiceList.toArray(new DynamicObject[0]));
                    }
                } else if (!CollectionUtils.isEmpty(batchInvoiceParamList)) {
                    IDIMqMessagePublisher.sendBatSaveInvoiceAction(batchInvoiceParamList);
                }
            }
            return invoiceList;
        }

        private Map<String, List<List<String>>> getDuplicateInvoiceListByTrainAndPlane(String entityNumber, Map<String, Long> planeInvoiceMap, Set<String> planeInvoiceSet, Map<String, Long> trainInvoiceMap, Set<String> trainInvoiceSet, Map<String, List<String[]>> duplicatedBillInvoiceMap, Map<String, List<Long>> billMap) {
            QFilter[] qFilterArray;
            HashMap<String, List<List<String>>> result = new HashMap<String, List<List<String>>>();
            ArrayList<String> typeList = new ArrayList<String>();
            if (!planeInvoiceMap.isEmpty()) {
                typeList.add("10");
            }
            if (!trainInvoiceMap.isEmpty()) {
                typeList.add("9");
            }
            QFilter filter = new QFilter(InvoiceExecutor.INVOICE_TYPE, "in", typeList);
            String billStr = String.valueOf(this.billObj.getString("id"));
            QFilter idFilter = new QFilter(InvoiceExecutor.BILLID, "!=", (Object)billStr);
            HashSet<String> keySet = new HashSet<String>(planeInvoiceSet.size() + trainInvoiceSet.size());
            keySet.addAll(planeInvoiceSet);
            keySet.addAll(trainInvoiceSet);
            QFilter duplicateKeyFilter = new QFilter(DUPLICATEFIELD, "in", keySet);
            boolean isSscImg = "bos_invoice".equalsIgnoreCase(entityNumber);
            if (isSscImg && this.ocrInvoiceFilter != null) {
                QFilter[] qFilterArray2 = new QFilter[4];
                qFilterArray2[0] = duplicateKeyFilter;
                qFilterArray2[1] = idFilter;
                qFilterArray2[2] = filter;
                qFilterArray = qFilterArray2;
                qFilterArray2[3] = this.ocrInvoiceFilter;
            } else {
                QFilter[] qFilterArray3 = new QFilter[3];
                qFilterArray3[0] = duplicateKeyFilter;
                qFilterArray3[1] = idFilter;
                qFilterArray = qFilterArray3;
                qFilterArray3[2] = filter;
            }
            QFilter[] totalFilter = qFilterArray;
            long startTime = System.currentTimeMillis();
            String selectFields = isSscImg ? "id,billid,invoicetype,imagenumber,imagepage,indexfield" : "id,billid,invoicetype,imagenumber,imagepage,indexfield,clientid,secret,billtype";
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"InvoiceExecutor.checkDuplicate", (String)entityNumber, (String)selectFields, (QFilter[])totalFilter, null);){
                int count = 0;
                for (Row row : dataSet) {
                    ++count;
                    if (!isSscImg) {
                        String billId = row.getString(InvoiceExecutor.BILLID);
                        String[] billMesg = new String[]{row.getString("billtype"), row.getString("clientid"), row.getString("secret")};
                        if (StringUtils.isNotEmpty((String)billMesg[0]) && StringUtils.isNotEmpty((String)billMesg[1]) && StringUtils.isNotEmpty((String)billMesg[2])) {
                            List duplicatedInvoiceList = duplicatedBillInvoiceMap.computeIfAbsent(billId, k -> new ArrayList());
                            duplicatedInvoiceList.add(billMesg);
                            List billIdList = billMap.computeIfAbsent(billMesg[0], k -> new ArrayList());
                            billIdList.add(Long.valueOf(billId));
                            continue;
                        }
                        this.createDuplicateInvoiceByTrainAndPlane(row, result);
                        continue;
                    }
                    this.createDuplicateInvoiceByTrainAndPlane(row, result);
                }
                SchemaExecutorLogger.info("cost time for checkTrainAndPlane (ms):%s, entityNumber: %s, count of data: %s", entityNumber, String.valueOf(System.currentTimeMillis() - startTime), String.valueOf(count));
            }
            return result;
        }

        private void createDuplicateInvoiceByTrainAndPlane(DynamicObject invoiceData, boolean isPlan, Map<String, List<List<String>>> result) {
            this.createDuplicateInvoiceByTrainAndPlaneCore(invoiceData.getString(DUPLICATEFIELD), isPlan, invoiceData.getString(InvoiceExecutor.IMAGE_PAGE), invoiceData.getString(InvoiceExecutor.IMAGE_NO), result);
        }

        private void createDuplicateInvoiceByTrainAndPlane(Row row, Map<String, List<List<String>>> result) {
            String key = row.getString(DUPLICATEFIELD);
            String invoiceType = row.getString(InvoiceExecutor.INVOICE_TYPE);
            boolean isPlan = "10".equals(invoiceType);
            this.createDuplicateInvoiceByTrainAndPlaneCore(key, isPlan, (String)row.get(InvoiceExecutor.IMAGE_PAGE), (String)row.get(InvoiceExecutor.IMAGE_NO), result);
        }

        private void createDuplicateInvoiceByTrainAndPlaneCore(String key, boolean isPlan, String imagePage, String imageNo, Map<String, List<List<String>>> result) {
            List messageList = result.computeIfAbsent(key, k -> new ArrayList(3));
            ArrayList<String> mesg = new ArrayList<String>(5);
            mesg.add(imagePage);
            mesg.add(imageNo);
            mesg.add(this.getPrintNumOrPrintingSequenceNo(key, isPlan ? "printNum" : "printingSequenceNo"));
            messageList.add(mesg);
        }

        private String getPrintNumOrPrintingSequenceNo(String key, String field) {
            String[] keyvalues;
            if (StringUtils.isNotEmpty((String)key) && (keyvalues = key.split("\\|")) != null) {
                for (String keyvalue : keyvalues) {
                    if (!StringUtils.isNotEmpty((String)keyvalue) || !keyvalue.contains(field)) continue;
                    return keyvalue.substring(field.length() + 1);
                }
            }
            return "";
        }

        private Map<String, List<String[]>> getDuplicateInvoiceList(String entityNumber, Set<String> invoiceNoSet, Set<String> invoiceCodeSet, Map<String, List<String[]>> duplicatedBillInvoiceMap, Map<String, List<Long>> billMap) {
            Object[] objectArray;
            HashMap<String, List<String[]>> result = new HashMap<String, List<String[]>>();
            String billStr = String.valueOf(this.billObj.getString("id"));
            QFilter idFilter = new QFilter(InvoiceExecutor.BILLID, "!=", (Object)billStr);
            QFilter filter = new QFilter(InvoiceExecutor.INVOICE_NO, "in", invoiceNoSet);
            QFilter codefilter = new QFilter(InvoiceExecutor.INVOICE_CODE, "in", invoiceCodeSet);
            boolean isSscImg = "bos_invoice".equalsIgnoreCase(entityNumber);
            if (isSscImg && this.ocrInvoiceFilter != null) {
                QFilter[] qFilterArray = new QFilter[4];
                qFilterArray[0] = idFilter;
                qFilterArray[1] = filter;
                qFilterArray[2] = codefilter;
                objectArray = qFilterArray;
                qFilterArray[3] = this.ocrInvoiceFilter;
            } else {
                Object[] objectArray2 = new QFilter[3];
                objectArray2[0] = idFilter;
                objectArray2[1] = filter;
                objectArray = objectArray2;
                objectArray2[2] = codefilter;
            }
            Object[] totalFilter = objectArray;
            SchemaExecutorLogger.info(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u91cd\u590d\uff0c\u8fc7\u6ee4\u6761\u4ef6%s", (String)"InvoiceExecutor_28", (String)"data-idi-core", (Object[])new Object[0]), Arrays.toString(totalFilter)), new Object[0]);
            String selectField = isSscImg ? "imagenumber,invoicecode,invoiceno,imagepage,billid,invoicetype" : "imagenumber,invoicecode,invoiceno,imagepage,billid,invoicetype,clientid,secret,billtype";
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"InvoiceExecutor.isDuplicated", (String)entityNumber, (String)selectField, (QFilter[])totalFilter, (String)"invoicecode,invoiceno");){
                if (dataSet != null) {
                    for (Row row : dataSet) {
                        if (!isSscImg) {
                            String billId = row.getString(InvoiceExecutor.BILLID);
                            String[] billMesg = new String[]{row.getString("billtype"), row.getString("clientid"), row.getString("secret")};
                            if (StringUtils.isNotEmpty((String)billMesg[0]) && StringUtils.isNotEmpty((String)billMesg[1]) && StringUtils.isNotEmpty((String)billMesg[2])) {
                                List duplicatedInvoiceList = duplicatedBillInvoiceMap.computeIfAbsent(billId, k -> new ArrayList());
                                duplicatedInvoiceList.add(billMesg);
                                List billIdList = billMap.computeIfAbsent(billMesg[0], k -> new ArrayList());
                                billIdList.add(Long.valueOf(billId));
                                continue;
                            }
                            this.collectDuplicateInvoiceData(row, result);
                            continue;
                        }
                        this.collectDuplicateInvoiceData(row, result);
                    }
                }
            }
            return result;
        }

        private void collectDuplicateInvoiceData(DynamicObject inoviceDynamicObject, Map<String, List<String[]>> result) {
            this.collectDuplicateInvoiceData(inoviceDynamicObject.getString(InvoiceExecutor.INVOICE_NO), inoviceDynamicObject.getString(InvoiceExecutor.INVOICE_CODE), inoviceDynamicObject.getString(InvoiceExecutor.IMAGE_PAGE), inoviceDynamicObject.getString(InvoiceExecutor.IMAGE_NO), inoviceDynamicObject.getString(InvoiceExecutor.BILLID), inoviceDynamicObject.getString(InvoiceExecutor.INVOICE_TYPE), result);
        }

        private void collectDuplicateInvoiceData(Row row, Map<String, List<String[]>> result) {
            this.collectDuplicateInvoiceData(row.getString(InvoiceExecutor.INVOICE_NO), row.getString(InvoiceExecutor.INVOICE_CODE), row.getString(InvoiceExecutor.IMAGE_PAGE), row.getString(InvoiceExecutor.IMAGE_NO), row.getString(InvoiceExecutor.BILLID), row.getString(InvoiceExecutor.INVOICE_TYPE), result);
        }

        private void collectDuplicateInvoiceData(String invoiceNo, String invoiceCode, String imagePage, String imageNo, String billIdStr, String invoiceType, Map<String, List<String[]>> result) {
            String key = this.buildDuplicateKey(invoiceNo, invoiceCode);
            List duplicatedList = result.computeIfAbsent(key, k -> new ArrayList());
            String[] messageList = new String[]{StringUtils.isNotEmpty((String)imagePage) ? String.valueOf(Integer.parseInt(imagePage) + 1) : "", imageNo, invoiceNo, billIdStr, invoiceType, invoiceCode};
            duplicatedList.add(messageList);
        }

        private String buildDuplicateKey(String invoiceno, String invoicecode) {
            return invoiceno + "_" + invoicecode;
        }

        private void separateInvoice(Set<String> invoiceNoSet, Set<String> invoiceCodeSet, List<Map<String, Object>> invoiceDataList, Set<String> planeInvoiceSet, Map<String, Long> planeInvoiceMap, Set<String> trainInvoiceSet, Map<String, Long> trainInvoiceMap) {
            for (Map<String, Object> invoiceData : this.invoiceList) {
                String key;
                Long invoiceId;
                String invoiceType = (String)invoiceData.get(InvoiceExecutor.INVOICE_TYPE);
                if ("10".equals(invoiceType)) {
                    invoiceId = (Long)invoiceData.get(InvoiceExecutor.INVOICE_ID);
                    key = (String)invoiceData.get(DUPLICATEFIELD);
                    planeInvoiceSet.add(key);
                    planeInvoiceMap.put(key, invoiceId);
                    continue;
                }
                if ("9".equals(invoiceType)) {
                    invoiceId = (Long)invoiceData.get(InvoiceExecutor.INVOICE_ID);
                    key = (String)invoiceData.get(DUPLICATEFIELD);
                    trainInvoiceSet.add(key);
                    trainInvoiceMap.put(key, invoiceId);
                    continue;
                }
                invoiceNoSet.add((String)invoiceData.get(InvoiceExecutor.INVOICE_NO));
                invoiceCodeSet.add((String)invoiceData.get(InvoiceExecutor.INVOICE_CODE));
                invoiceDataList.add(invoiceData);
            }
        }

        private InvoiceImageRuleResult invoiceCloudDuplicate(InvoiceImageRuleResult ruleResultPass, InvoiceImageRuleResult ruleResultFailed) {
            InvoiceImageRuleResult ruleResult = ruleResultPass;
            boolean isRulePass = true;
            for (Map<String, Object> invoiceData : this.invoiceList) {
                List<IDIInvoiceCloudHelper.RepeatInvoiceInfo> repeatInfoList;
                Long invoiceId = (Long)invoiceData.get(InvoiceExecutor.INVOICE_ID);
                String serialNo = (String)invoiceData.get("serialNo".toLowerCase(Locale.ENGLISH));
                InvoiceImageResult invoiceImageResult = InvoiceExecutor.getInvoiceImageResult(invoiceId, this.invoiceImageResults);
                if (this.repeatInvoiceList != null && (repeatInfoList = this.repeatInvoiceList.get(serialNo)) != null && !repeatInfoList.isEmpty()) {
                    isRulePass = false;
                    invoiceImageResult.getRuleResults().add(ruleResultFailed);
                    ArrayList<List<String>> duplicatedList = new ArrayList<List<String>>(this.repeatInvoiceList.size());
                    for (IDIInvoiceCloudHelper.RepeatInvoiceInfo repeatInfo : repeatInfoList) {
                        ArrayList<String> messgeList = new ArrayList<String>(4);
                        messgeList.add("");
                        messgeList.add(repeatInfo.getExpenseNum());
                        messgeList.add((String)invoiceData.get(InvoiceExecutor.INVOICE_NO));
                        messgeList.add(serialNo);
                        duplicatedList.add(messgeList);
                    }
                    invoiceImageResult.addDuplicatedList(duplicatedList);
                    continue;
                }
                invoiceImageResult.getRuleResults().add(ruleResultPass);
            }
            if (!isRulePass) {
                ruleResult = ruleResultFailed;
                this.deductionGrade.deduct(this.decision.getInvoiceConfig().getDuplicateDeductionGradePercent());
                ruleResult.deductPercentFromInt(this.decision.getInvoiceConfig().getDuplicateDeductionGradePercent());
            }
            return ruleResult;
        }

        public Decision getDecision() {
            return this.decision;
        }

        public void setDecision(Decision decision) {
            this.decision = decision;
        }

        public DynamicObject getBillObj() {
            return this.billObj;
        }

        public void setBillObj(DynamicObject billObj) {
            this.billObj = billObj;
        }

        public List<Map<String, Object>> getInvoiceList() {
            return this.invoiceList;
        }

        public void setInvoiceList(List<Map<String, Object>> invoiceList) {
            this.invoiceList = invoiceList;
        }

        public List<InvoiceImageResult> getInvoiceImageResults() {
            return this.invoiceImageResults;
        }

        public void setInvoiceImageResults(List<InvoiceImageResult> invoiceImageResults) {
            this.invoiceImageResults = invoiceImageResults;
        }

        public QFilter getOcrInvoiceFilter() {
            return this.ocrInvoiceFilter;
        }

        public void setOcrInvoiceFilter(QFilter ocrInvoiceFilter) {
            this.ocrInvoiceFilter = ocrInvoiceFilter;
        }

        public SchemaContext getSchemaContext() {
            return this.schemaContext;
        }

        public void setSchemaContext(SchemaContext schemaContext) {
            this.schemaContext = schemaContext;
        }

        public DeductionGrade getDeductionGrade() {
            return this.deductionGrade;
        }

        public void setDeductionGrade(DeductionGrade deductionGrade) {
            this.deductionGrade = deductionGrade;
        }

        public Map<String, List<IDIInvoiceCloudHelper.RepeatInvoiceInfo>> getRepeatInvoiceList() {
            return this.repeatInvoiceList;
        }

        public void setRepeatInvoiceList(Map<String, List<IDIInvoiceCloudHelper.RepeatInvoiceInfo>> repeatInvoiceList) {
            this.repeatInvoiceList = repeatInvoiceList;
        }
    }

    private static class BaseInvoiceValidator {
        private BaseInvoiceValidator() {
        }

        protected InvoiceImageRuleResult createRuleResult(String ruleNo, boolean isPass, String status, String mesg) {
            InvoiceImageRuleResult ruleResult = new InvoiceImageRuleResult();
            ruleResult.setRuleNo(ruleNo);
            ruleResult.setPass(isPass);
            ruleResult.setStatus(status);
            ruleResult.setText(mesg);
            return ruleResult;
        }
    }

    private static interface IInvoiceValidator {
        public InvoiceImageRuleResult validate();
    }

    private static class BatchScriptHandle {
        private Map<String, Object> ctxMap;
        private int entrySize;
        private String script;
        private String billTypeName;
        private Set<String> entryVars;
        private int invoiceEntrySize;
        private String invoiceEntityType;
        private boolean showAllCheckTrue;
        private Map<String, String> invoiceEntryPropTypeMap;

        public BatchScriptHandle(Map<String, Object> ctxMap, int entrySize, String script, String billTypeName, Set<String> entryVars, int invoiceEntrySize, String invoiceEntityType, boolean showAllCheckTrue, Map<String, String> invoiceEntryPropTypeMap) {
            this.ctxMap = ctxMap;
            this.entrySize = entrySize;
            this.script = script;
            this.billTypeName = billTypeName;
            this.entryVars = entryVars;
            this.invoiceEntrySize = invoiceEntrySize;
            this.invoiceEntityType = invoiceEntityType;
            this.showAllCheckTrue = showAllCheckTrue;
            this.invoiceEntryPropTypeMap = invoiceEntryPropTypeMap;
        }

        protected String handleScript() {
            String scrEntryScript = this.script;
            if (this.entryVars.size() > 0) {
                String entryName = this.entryVars.iterator().next();
                scrEntryScript = ScriptUtils.setEntryIndexSingle(this.script, this.billTypeName, entryName, "entryRowIndex", false);
            }
            boolean hasItem = false;
            String invoiceItemScript = scrEntryScript;
            if (!this.invoiceEntryPropTypeMap.isEmpty()) {
                hasItem = true;
                invoiceItemScript = ScriptUtils.setEntryIndexSingle(scrEntryScript, this.invoiceEntityType, InvoiceExecutor.DETAILITEM, "invoiceItemIndex", false);
            }
            StringBuilder forScript = new StringBuilder();
            this.ctxMap.put("scriptPass", Boolean.FALSE);
            if (this.showAllCheckTrue) {
                this.ctxMap.put("allCheckTrue", Boolean.TRUE);
            }
            this.ctxMap.put("entryRowIndex", 0);
            forScript.append("for( ; entryRowIndex<entrySize; entryRowIndex++){\n");
            this.ctxMap.put("entrySize", this.entrySize);
            if (hasItem) {
                forScript.append("for(var invoiceItemIndex=0; invoiceItemIndex<invoiceEntrySize; invoiceItemIndex++){\n");
                this.ctxMap.put("invoiceEntrySize", this.invoiceEntrySize);
            }
            if (this.showAllCheckTrue) {
                forScript.append("if(").append(invoiceItemScript).append("){\nscriptPass = true;\n}else{\nallCheckTrue = false;\n}");
            } else {
                forScript.append("if(").append(invoiceItemScript).append("){\nscriptPass = true;\nbreak;\n}");
            }
            if (hasItem) {
                forScript.append("}\n");
            }
            if (hasItem && !this.showAllCheckTrue) {
                forScript.append("if(scriptPass){\nbreak;\n}");
            }
            forScript.append("}\n");
            if (this.showAllCheckTrue) {
                forScript.append("if(!scriptPass && allCheckTrue){\nallCheckTrue = false;\n}");
            }
            return forScript.toString();
        }
    }
}

