/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.engine;

import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.data.idi.data.SchemaContext;
import kd.data.idi.data.SchemaParallelContext;

public class SchemaExecutorLogger {
    protected static boolean isDebug = false;
    private static Log logger = LogFactory.getLog(SchemaExecutorLogger.class);
    private static final String traceMsg = "----traceId=%s----";

    public static void info(String s, Object ... param) {
        if (isDebug) {
            String newMesg = SchemaExecutorLogger.appendTraceId(s);
            if (param != null && param.length > 0) {
                logger.info(String.format("\n" + newMesg, param));
            } else {
                logger.info("\n" + newMesg);
            }
        }
    }

    public static String getTraceId() {
        SchemaContext sc = SchemaContext.get();
        if (sc instanceof SchemaParallelContext) {
            return ((SchemaParallelContext)sc).getTraceId();
        }
        return null;
    }

    private static String appendTraceId(String s) {
        String traceId = SchemaExecutorLogger.getTraceId();
        return StringUtils.isEmpty((String)traceId) ? s : s + String.format(traceMsg, traceId);
    }

    public static void error(String message) {
        logger.error(message);
    }

    public static void error(Throwable ex) {
        logger.error(ex.getMessage(), ex);
    }

    public static void error(String message, Throwable ex) {
        logger.error(message, ex);
    }

    public static void error(String message, Object ... other) {
        logger.error(message, other);
    }
}

