/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.engine;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.CompareType;
import kd.bos.entity.filter.DefaultFilterValueSetter;
import kd.bos.entity.filter.FieldName;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.filter.IFilterValueSetter;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.data.idi.engine.SchemaExecutorLogger;

public class ScriptBuilder {
    private static String marks = "\"";
    private FilterCondition filterCondition;
    private MainEntityType billEntityType;
    private IFilterValueSetter filterValueSetter = new DefaultFilterValueSetter();
    private Map<String, FilterField> allFilterFields = new HashMap<String, FilterField>();
    private Map<String, MainEntityType> cachedDataTypes = new HashMap<String, MainEntityType>();
    private static final Date MinSystemDateTime;
    private String billPrefix = "";

    public ScriptBuilder(MainEntityType billType, FilterCondition filterCondition) {
        this.filterCondition = filterCondition;
        this.billEntityType = billType;
    }

    private FilterField getFilterField(String fieldName, String entityNumber) {
        FilterField filterField = this.allFilterFields.get(fieldName);
        if (filterField != null) {
            return filterField;
        }
        MainEntityType fieldEntityType = this.billEntityType;
        if (StringUtils.isNotEmpty((CharSequence)entityNumber)) {
            if (this.cachedDataTypes.get(entityNumber) == null) {
                fieldEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
                this.cachedDataTypes.put(entityNumber, fieldEntityType);
            } else {
                fieldEntityType = this.cachedDataTypes.get(entityNumber);
            }
        }
        if ((filterField = this.getFilterField(fieldEntityType, fieldName)) == null) {
            throw new KDBizException(BosErrorCode.fieldNotExist, new Object[]{this.billEntityType.getName(), fieldName});
        }
        this.allFilterFields.put(fieldName, filterField);
        return filterField;
    }

    private String getFilterFieldScriptVarName(FilterField filterField) {
        return this.billPrefix + this.billEntityType.getName() + "_billObj." + filterField.getFullFieldName();
    }

    private FilterField getFilterField(MainEntityType dataType, String fieldName) {
        return FilterField.create((MainEntityType)dataType, (String)fieldName);
    }

    private boolean isNumberField(int fieldType) {
        return fieldType == -7 || fieldType == -5 || fieldType == 3 || fieldType == 6 || fieldType == 4 || fieldType == 2 || fieldType == 7 || fieldType == 5 || fieldType == -6 || fieldType == 8;
    }

    private CompareType getCompareType(FilterField filterField, String compare) {
        CompareType compareType = filterField.getCompareType(compare);
        if (compareType == null) {
            compareType = filterField.getCompareType(filterField.getDefaultCompareTypeId());
        }
        if (compareType == null) {
            compareType = (CompareType)filterField.getCompareTypes().get(0);
        }
        return compareType;
    }

    private boolean isCompareConstValue(CompareType compareType) {
        if (!compareType.isNeedInput()) {
            return true;
        }
        if (StringUtils.isNotBlank((CharSequence)compareType.getClassName())) {
            return compareType.getGroupId() != 8;
        }
        String compareValue = compareType.getValue();
        return "TODAYBEFORE".equalsIgnoreCase(compareValue) || "TODAYAFTER".equalsIgnoreCase(compareValue);
    }

    public ValueAndDesc buildScript() {
        int countOfBracket = 0;
        StringBuilder script = new StringBuilder();
        StringBuilder scriptDesc = new StringBuilder();
        SimpleFilterRow lastFilterRow = null;
        for (SimpleFilterRow filterRow : this.filterCondition.getFilterRow()) {
            ValueAndDesc str;
            FilterField filterField = this.getFilterField(filterRow.getFieldName(), filterRow.getEntityNumber());
            CompareType compareType = this.getCompareType(filterField, filterRow.getCompareType());
            if (StringUtils.isBlank((CharSequence)filterField.getFieldName()) || (filterRow.getValue().size() == 0 || StringUtils.isBlank(filterRow.getValue().get(0))) && compareType.isNeedInput()) continue;
            countOfBracket = this.checkBracket(countOfBracket, filterRow);
            String rowScript = null;
            String rowScriptDesc = null;
            if (this.isCompareConstValue(compareType)) {
                str = this.getConstValue(filterRow, filterField, compareType);
                rowScript = str.getValue();
                rowScriptDesc = str.getDesc();
            } else {
                switch (compareType.getInputCtlType()) {
                    case 0: {
                        str = this.getManuInputFilterString(filterRow, filterField, compareType);
                        rowScript = str.getValue();
                        rowScriptDesc = str.getDesc();
                        break;
                    }
                    case 1: {
                        str = this.getComboxFilterString(filterRow, filterField, compareType);
                        rowScript = str.getValue();
                        rowScriptDesc = str.getDesc();
                        break;
                    }
                }
            }
            if (StringUtils.isEmpty(rowScript)) continue;
            if (lastFilterRow != null) {
                String logic = lastFilterRow.getLogic().trim().toUpperCase();
                String logicDesc = "";
                if ("1".equals(logic)) {
                    logic = " || ";
                    logicDesc = " OR ";
                } else if ("0".equals(logic)) {
                    logic = " && ";
                    logicDesc = " AND ";
                }
                if (StringUtils.isBlank((CharSequence)logic)) {
                    logic = " && ";
                    logicDesc = " AND ";
                }
                script.append(logic);
                scriptDesc.append(logicDesc);
            }
            lastFilterRow = filterRow;
            script.append(filterRow.getLeftBracket()).append(rowScript).append(filterRow.getRightBracket());
            scriptDesc.append(filterRow.getLeftBracket()).append(rowScriptDesc).append(filterRow.getRightBracket());
        }
        if (countOfBracket != 0) {
            throw new KDException(ResManager.loadKDString((String)"\u5de6\u62ec\u53f7\u4e0e\u53f3\u62ec\u53f7\u4e0d\u5339\u914d\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"ScriptBuilder_0", (String)"data-idi-core", (Object[])new Object[0]));
        }
        ValueAndDesc valueAndDesc = new ValueAndDesc();
        valueAndDesc.setValue(script.toString());
        valueAndDesc.setDesc(scriptDesc.toString());
        return valueAndDesc;
    }

    private int checkBracket(int countOfBracket, SimpleFilterRow row) {
        if (StringUtils.isNotBlank((CharSequence)row.getLeftBracket())) {
            countOfBracket += row.getLeftBracket().replace(" ", "").length();
        }
        if (StringUtils.isNotBlank((CharSequence)row.getRightBracket())) {
            countOfBracket -= row.getRightBracket().replace(" ", "").length();
        }
        if (countOfBracket < 0) {
            throw new KDException(BosErrorCode.filterSqlBuilder, new Object[]{ResManager.loadKDString((String)"\u5de6\u62ec\u53f7\u4e0e\u53f3\u62ec\u53f7\u4e0d\u5339\u914d\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"ScriptBuilder_0", (String)"data-idi-core", (Object[])new Object[0])});
        }
        return countOfBracket;
    }

    private List<String> getFieldValue(SimpleFilterRow simpleFilterRow) {
        List fieldValue = this.filterValueSetter.getFieldValue(simpleFilterRow);
        ArrayList<String> rtn = new ArrayList<String>(fieldValue.size());
        for (Object obj : fieldValue) {
            if (obj == null) {
                rtn.add(null);
                continue;
            }
            rtn.add(obj.toString());
        }
        return rtn;
    }

    private ValueAndDesc getConstValue(SimpleFilterRow filterRow, FilterField filterField, CompareType compareType) {
        ValueAndDesc scripts;
        List<String> fieldValue = this.getFieldValue(filterRow);
        String value = "";
        if (fieldValue.size() > 0) {
            value = fieldValue.get(0);
        }
        if (StringUtils.isNotBlank((CharSequence)value) && this.isNumeric(value, false)) {
            int val = 0;
            try {
                val = Integer.parseInt(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
            scripts = this.getConstValue(filterRow, filterField, compareType, val);
        } else {
            String compareValue = compareType.getValue().toUpperCase();
            if (compareValue.equals("TODAYBEFORE") || compareValue.equals("TODAYAFTER") || compareValue.equals("TODAYIN")) {
                throw new KDException(BosErrorCode.filterSqlBuilder, new Object[]{ResManager.loadKDString((String)"\u65e0\u6548\u7684\u8f93\u5165\u503c", (String)"ScriptBuilder_1", (String)"data-idi-core", (Object[])new Object[0])});
            }
            scripts = this.getConstValue(filterRow, filterField, compareType, 0);
        }
        return scripts;
    }

    private ValueAndDesc getConstValue(SimpleFilterRow filterRow, FilterField filterField, CompareType compareType, int constantValue) {
        if (compareType.getGroupId() == 5) {
            String compareValue;
            String script = "";
            String scriptDesc = String.format("%s %s", this.getFieldCaption(filterField.getFieldName()), compareType.getName().toString());
            String fieldScriptVarName = this.getFilterFieldScriptVarName(filterField);
            switch (compareValue = compareType.getValue().toUpperCase()) {
                case "TODAY": {
                    script = String.format("isToday(%s)", fieldScriptVarName);
                    break;
                }
                case "YESTERDAY": {
                    script = String.format("isYesterday(%s)", fieldScriptVarName);
                    break;
                }
                case "TOMORROW": {
                    script = String.format("isTomorrow(%s)", fieldScriptVarName);
                    break;
                }
                case "THISWEEK": {
                    script = String.format("isThisWeek(%s)", fieldScriptVarName);
                    break;
                }
                case "LASTWEEK": {
                    script = String.format("isLastWeek(%s)", fieldScriptVarName);
                    break;
                }
                case "THISMONTH": {
                    script = String.format("isThisMonth(%s)", fieldScriptVarName);
                    break;
                }
                case "LASTMONTH": {
                    script = String.format("isLastMonth(%s)", fieldScriptVarName);
                    break;
                }
                case "NEXTWEEK": {
                    script = String.format("isNextWeek(%s)", fieldScriptVarName);
                    break;
                }
                case "NEXTMONTH": {
                    script = String.format("isNextMonth(%s)", fieldScriptVarName);
                    break;
                }
            }
            if (!StringUtils.isEmpty((CharSequence)script)) {
                ValueAndDesc valueAndDesc = new ValueAndDesc();
                valueAndDesc.setValue(script);
                valueAndDesc.setDesc(scriptDesc);
                return valueAndDesc;
            }
        } else {
            String script = "";
            String scriptDesc = String.format("%s %s", this.getFieldCaption(filterField.getFieldName()), compareType.getName().toString());
            String fieldScriptVarName = this.getFilterFieldScriptVarName(filterField);
            String compareValue = compareType.getValue().toUpperCase();
            if ("ISNULL".equals(compareValue)) {
                script = String.format("isNull(%s)", fieldScriptVarName);
            } else if ("NOTISNULL".equals(compareValue)) {
                script = String.format("!isNull(%s)", fieldScriptVarName);
            }
            if (!StringUtils.isEmpty((CharSequence)script)) {
                ValueAndDesc valueAndDesc = new ValueAndDesc();
                valueAndDesc.setValue(script);
                valueAndDesc.setDesc(scriptDesc);
                return valueAndDesc;
            }
        }
        throw new KDException(BosErrorCode.filterSqlBuilder, new Object[]{String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u89e3\u6790\u53d8\u91cf\u7684\u503c:%s", (String)"ScriptBuilder_2", (String)"data-idi-core", (Object[])new Object[0]), compareType.getValue().toUpperCase())});
    }

    private ValueAndDesc getManuInputFilterString(SimpleFilterRow filterRow, FilterField filterField, CompareType compareType) {
        List<String> fieldValue = this.getFieldValue(filterRow);
        ValueAndDesc values = this.checkInputValue(filterField, compareType, fieldValue);
        String value = values.getValue();
        String valueDesc = values.getDesc();
        String fieldScriptVarName = this.getFilterFieldScriptVarName(filterField);
        String operateStr = compareType.getOperate();
        int fieldType = filterField.getFieldType();
        String fieldCaption = this.getFieldCaption(filterField.getFieldName());
        if ("=".equals(operateStr)) {
            operateStr = "==";
        } else if ("<>".equalsIgnoreCase(operateStr)) {
            operateStr = "!=";
        }
        String script = this.isNumberField(fieldType) ? ("IN".equals(operateStr) ? String.format("arrayIn(%s, %s)", fieldScriptVarName, value) : ("NOT IN".equals(operateStr) ? String.format("!arrayIn(%s, %s)", fieldScriptVarName, value) : String.format("%s %s %s", fieldScriptVarName, operateStr, value))) : (fieldType == 91 ? this.getDateFilterString(operateStr, fieldScriptVarName, value) : (fieldType == 92 || fieldType == 93 ? this.getTimeFilterString(operateStr, fieldScriptVarName, value) : ("IN".equals(operateStr) ? String.format("arrayIn(%s, %s)", fieldScriptVarName, value) : (operateStr.equalsIgnoreCase("NOT IN") ? String.format("!arrayIn(%s, %s)", fieldScriptVarName, value) : (operateStr.equalsIgnoreCase("like") ? String.format("%s.contains(%s)", fieldScriptVarName, value) : (operateStr.equalsIgnoreCase("not like") ? String.format("!(%s.contains(%s))", fieldScriptVarName, value) : (operateStr.equals("=") ? String.format("%s == %s", fieldScriptVarName, value) : String.format("%s %s %s", fieldScriptVarName, operateStr, value))))))));
        String scriptDesc = String.format("%s %s %s", fieldCaption, compareType.getName().toString(), valueDesc);
        ValueAndDesc valueAndDesc = new ValueAndDesc();
        valueAndDesc.setValue(script);
        valueAndDesc.setDesc(scriptDesc);
        return valueAndDesc;
    }

    private ValueAndDesc getComboxFilterString(SimpleFilterRow filterRow, FilterField filterField, CompareType compareType) {
        String script;
        List<String> fieldValue = this.getFieldValue(filterRow);
        String value = fieldValue.get(0);
        if (StringUtils.isBlank((CharSequence)value)) {
            throw new KDException(BosErrorCode.filterSqlBuilder, new Object[]{ResManager.loadKDString((String)"\u65e0\u6548\u7684\u8f93\u5165\u503c", (String)"ScriptBuilder_1", (String)"data-idi-core", (Object[])new Object[0])});
        }
        List<DynamicProperty> props = this.findProperties(filterField.getFieldName());
        DynamicProperty fieldProp = props.get(props.size() - 1);
        int fieldType = filterField.getFieldType();
        String operateStr = compareType.getOperate();
        if ("=".equals(operateStr)) {
            operateStr = "==";
        } else if ("<>".equalsIgnoreCase(operateStr)) {
            operateStr = "!=";
        }
        String fieldScriptVarName = this.getFilterFieldScriptVarName(filterField);
        if (this.isNumberField(fieldType)) {
            script = String.format("%s %s %s", fieldScriptVarName, operateStr, value);
        } else if (compareType.isFieldCompare()) {
            script = String.format("%s %s %s", fieldScriptVarName, operateStr, value);
        } else if (fieldProp instanceof BooleanProp) {
            if ("IN".equalsIgnoreCase(operateStr) || "NOT IN".equalsIgnoreCase(operateStr)) {
                StringBuilder builder = new StringBuilder();
                for (String rowValue : fieldValue) {
                    if (StringUtils.isBlank((CharSequence)rowValue)) {
                        throw new KDException(BosErrorCode.filterSqlBuilder, new Object[]{ResManager.loadKDString((String)"\u65e0\u6548\u7684\u8f93\u5165\u503c", (String)"ScriptBuilder_1", (String)"data-idi-core", (Object[])new Object[0])});
                    }
                    if (builder.length() > 0) {
                        builder.append(',');
                    }
                    builder.append(Integer.valueOf(value.trim()).compareTo(1) == 0 ? "true" : "false");
                }
                String v = builder.toString();
                script = String.format("arrayIn(%s, newArray(\"%s\"))", fieldScriptVarName, v);
                if ("NOT IN".equalsIgnoreCase(operateStr)) {
                    script = "!" + script;
                }
            } else {
                script = String.format("%s %s %s", fieldScriptVarName, operateStr, Integer.valueOf(value.trim()).compareTo(1) == 0 ? "true" : "false");
            }
        } else if ("IN".equalsIgnoreCase(operateStr) || "NOT IN".equalsIgnoreCase(operateStr)) {
            script = String.format("arrayIn(%s, newArray(\"%s\"))", fieldScriptVarName, StringUtils.join((Object[])fieldValue.toArray(), (String)"\",\""));
            if ("NOT IN".equalsIgnoreCase(operateStr)) {
                script = "!" + script;
            }
        } else {
            script = String.format("%s %s \"%s\"", fieldScriptVarName, operateStr, value.trim());
        }
        String fieldCaption = this.getFieldCaption(filterField.getFieldName());
        String scriptDesc = "IN".equalsIgnoreCase(compareType.getOperate()) || "NOT IN".equalsIgnoreCase(compareType.getOperate()) ? String.format("%s %s (%s)", fieldCaption, compareType.getName().toString(), this.getComboxItemCaption(fieldValue, compareType, fieldProp)) : String.format("%s %s %s", fieldCaption, compareType.getName().toString(), this.getComboxItemCaption(fieldValue, compareType, fieldProp));
        ValueAndDesc valueAndDesc = new ValueAndDesc();
        valueAndDesc.setValue(script);
        valueAndDesc.setDesc(scriptDesc);
        return valueAndDesc;
    }

    private List<DynamicProperty> findProperties(String var) {
        ArrayList<DynamicProperty> props = new ArrayList<DynamicProperty>();
        String[] keys = var.split("\\.");
        MainEntityType parentType = this.billEntityType;
        for (String key : keys) {
            DynamicProperty prop = (DynamicProperty)parentType.findProperty(key);
            if (prop == null && "id".equalsIgnoreCase(key)) {
                prop = (DynamicProperty)parentType.getPrimaryKey();
            }
            if (prop == null) break;
            props.add(prop);
            if (prop instanceof EntryProp) {
                parentType = (EntityType)((EntryProp)prop).getItemType();
                continue;
            }
            if (!(prop instanceof BasedataProp)) break;
            parentType = (EntityType)((BasedataProp)prop).getComplexType();
        }
        if (props.size() < keys.length) {
            throw new KDException(String.format(ResManager.loadKDString((String)"\u53d8\u91cf%s\u89e3\u6790\u5931\u8d25\uff0c\u5728\u5355\u636e\u4e0a\u627e\u4e0d\u5230", (String)"ScriptBuilder_3", (String)"data-idi-core", (Object[])new Object[0]), var));
        }
        return props;
    }

    private String getComboxItemCaption(List<String> fieldValue, CompareType compareType, DynamicProperty fieldProp) {
        ArrayList<String> captions = new ArrayList<String>(fieldValue.size());
        for (String itemValue : fieldValue) {
            String itemCaption = "";
            itemCaption = compareType.isFieldCompare() ? this.getFieldCaption(itemValue) : (fieldProp instanceof ComboProp ? ((ComboProp)fieldProp).getItemByName(itemValue) : (fieldProp instanceof BooleanProp ? (Integer.valueOf(itemValue).compareTo(1) == 0 ? ResManager.loadKDString((String)"\u662f", (String)"ScriptBuilder_4", (String)"data-idi-core", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"ScriptBuilder_5", (String)"data-idi-core", (Object[])new Object[0])) : itemValue));
            captions.add(itemCaption);
        }
        return StringUtils.join((Object[])captions.toArray(), (String)",");
    }

    private String getDateFilterString(String operateStr, String fieldName, String sValue) {
        String script = "";
        SchemaExecutorLogger.info("date range %s ", sValue);
        String[] values = sValue.split(",");
        String dateScriptFormat = "parseDate(%s)";
        if (operateStr.equals("=") || operateStr.equals("==")) {
            String beginTime = String.format(dateScriptFormat, ScriptBuilder.appendQuotes(values[0]));
            String endTime = String.format(dateScriptFormat, ScriptBuilder.appendQuotes(values[1]));
            script = String.format("%s >= %s && %s <= %s ", fieldName, beginTime, fieldName, endTime);
        } else if (operateStr.equals("!=") || operateStr.equals("<>")) {
            String beginTime = String.format(dateScriptFormat, ScriptBuilder.appendQuotes(values[0]));
            String endTime = String.format(dateScriptFormat, ScriptBuilder.appendQuotes(values[1]));
            script = String.format("%s < %s || %s > %s ", fieldName, beginTime, fieldName, endTime);
        } else if (operateStr.equals("<")) {
            String beginTime = String.format(dateScriptFormat, ScriptBuilder.appendQuotes(values[0]));
            script = String.format("%s < %s ", fieldName, beginTime);
        } else if (operateStr.equals("<=")) {
            String endTime = String.format(dateScriptFormat, ScriptBuilder.appendQuotes(values[0]));
            script = String.format("%s <= %s ", fieldName, endTime);
        } else if (operateStr.equals(">")) {
            String endTime = String.format(dateScriptFormat, ScriptBuilder.appendQuotes(values[0]));
            script = String.format("%s > %s ", fieldName, endTime);
        } else if (operateStr.equals(">=")) {
            String beginTime = String.format(dateScriptFormat, ScriptBuilder.appendQuotes(values[0]));
            script = String.format("%s >= %s ", fieldName, beginTime);
        } else if (operateStr.equals("between")) {
            String beginTime = String.format(dateScriptFormat, ScriptBuilder.appendQuotes(values[0]));
            String endTime = String.format(dateScriptFormat, ScriptBuilder.appendQuotes(values[1]));
            script = String.format("%s >= %s && %s <= %s ", fieldName, beginTime, fieldName, endTime);
        } else {
            String time = String.format(dateScriptFormat, ScriptBuilder.appendQuotes(values[0]));
            script = String.format("%s %s %s ", fieldName, operateStr, time);
        }
        return script;
    }

    private String getTimeFilterString(String operateStr, String fieldName, String sValue) {
        String script;
        String scriptDateTimeFormat = "parseDateTime(%s)";
        if (operateStr.trim().toLowerCase(Locale.ENGLISH).equals("between")) {
            String[] times = sValue.split(",");
            String beginTime = String.format(scriptDateTimeFormat, ScriptBuilder.appendQuotes(times[0]));
            String endTime = String.format(scriptDateTimeFormat, ScriptBuilder.appendQuotes(times[1]));
            script = String.format("%s >= %s && %s <= %s ", fieldName, beginTime, fieldName, endTime);
        } else {
            String time = String.format(scriptDateTimeFormat, ScriptBuilder.appendQuotes(sValue));
            script = String.format("%s %s %s", fieldName, operateStr, time);
        }
        return script;
    }

    private boolean isNumeric(String value, boolean bThrowErr) {
        boolean isOk = true;
        if (StringUtils.isEmpty((CharSequence)value)) {
            isOk = false;
        }
        if (isOk) {
            Pattern pattern = Pattern.compile("^[+-]?\\d*[.]?\\d*$");
            Matcher matcher = pattern.matcher(value.trim());
            isOk = matcher.matches();
        }
        if (bThrowErr && !isOk) {
            throw new KDException(BosErrorCode.filterSqlBuilder, new Object[]{ResManager.loadKDString((String)"\u65e0\u6548\u7684\u8f93\u5165\u503c", (String)"ScriptBuilder_1", (String)"data-idi-core", (Object[])new Object[0])});
        }
        return isOk;
    }

    private boolean isUint(String value, boolean bThrowErr) {
        boolean isOk = true;
        if (StringUtils.isEmpty((CharSequence)value)) {
            isOk = false;
        }
        if (isOk) {
            Pattern pattern = Pattern.compile("^[1-9]\\d*$");
            Matcher matcher = pattern.matcher(value.trim());
            isOk = matcher.matches();
            if (bThrowErr && !isOk) {
                throw new KDException(BosErrorCode.filterSqlBuilder, new Object[]{ResManager.loadKDString((String)"\u65e0\u6548\u7684\u8f93\u5165\u503c\uff0c\u8bf7\u8f93\u5165\u6b63\u6574\u6570", (String)"ScriptBuilder_6", (String)"data-idi-core", (Object[])new Object[0])});
            }
        }
        return isOk;
    }

    private boolean isInt(String value, boolean bThrowErr) {
        boolean isOk = true;
        if (StringUtils.isEmpty((CharSequence)value)) {
            isOk = false;
        }
        if (isOk) {
            Pattern pattern = Pattern.compile("^[+-]?\\d*$");
            Matcher matcher = pattern.matcher(value.trim());
            isOk = matcher.matches();
            if (bThrowErr && !isOk) {
                throw new KDException(BosErrorCode.filterSqlBuilder, new Object[]{ResManager.loadKDString((String)"\u65e0\u6548\u7684\u8f93\u5165\u503c\uff0c\u8bf7\u8f93\u5165\u6574\u6570", (String)"ScriptBuilder_11", (String)"data-idi-core", (Object[])new Object[0])});
            }
        }
        return isOk;
    }

    private boolean isTimeString(String value, boolean bThrowErr) {
        boolean isOk = true;
        if (StringUtils.isEmpty((CharSequence)value)) {
            isOk = false;
        }
        if (isOk) {
            Pattern pattern = Pattern.compile("^((20|21|22|23|[0-1]?\\d):[0-5]?\\d:[0-5]?\\d)$");
            Matcher matcher = pattern.matcher(value.trim());
            isOk = matcher.matches();
            if (bThrowErr && !isOk) {
                throw new KDException(BosErrorCode.filterSqlBuilder, new Object[]{ResManager.loadKDString((String)"\u65e0\u6548\u7684\u8f93\u5165\u503c\uff0c\u8bf7\u8f93\u5165\u65e5\u671f", (String)"ScriptBuilder_7", (String)"data-idi-core", (Object[])new Object[0])});
            }
        }
        return isOk;
    }

    private boolean isDateTimeString(String value, boolean bThrowErr) {
        boolean isOk = true;
        if (StringUtils.isEmpty((CharSequence)value)) {
            isOk = false;
        }
        if (isOk) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-M-d H:m:s");
            try {
                simpleDateFormat.parse(value);
                isOk = true;
            }
            catch (ParseException e) {
                isOk = false;
            }
        }
        if (bThrowErr && !isOk) {
            throw new KDException(BosErrorCode.filterSqlBuilder, new Object[]{ResManager.loadKDString((String)"\u65e0\u6548\u7684\u8f93\u5165\u503c\uff0c\u8bf7\u8f93\u5165\u65e5\u671f\uff0c\u683c\u5f0f\u5982\uff1a1999-12-25 10:30:30", (String)"ScriptBuilder_8", (String)"data-idi-core", (Object[])new Object[0])});
        }
        return isOk;
    }

    private boolean isDateString(String value, boolean bThrowErr) {
        boolean isOk = true;
        if (StringUtils.isEmpty((CharSequence)value)) {
            isOk = false;
        }
        if (isOk) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-M-d");
            try {
                simpleDateFormat.parse(value);
                isOk = true;
            }
            catch (ParseException e) {
                isOk = false;
            }
        }
        if (bThrowErr && !isOk) {
            throw new KDException(BosErrorCode.filterSqlBuilder, new Object[]{ResManager.loadKDString((String)"\u65e0\u6548\u7684\u8f93\u5165\u503c\uff0c\u8bf7\u8f93\u5165\u65e5\u671f\uff0c\u683c\u5f0f\u5982\uff1a1999-12-25", (String)"ScriptBuilder_9", (String)"data-idi-core", (Object[])new Object[0])});
        }
        return isOk;
    }

    private boolean checkIsEmpty(String value, boolean bThrowErr) {
        boolean isOk = true;
        if (StringUtils.isEmpty((CharSequence)value)) {
            isOk = false;
        }
        if (bThrowErr && !isOk) {
            throw new KDException(BosErrorCode.filterSqlBuilder, new Object[]{ResManager.loadKDString((String)"\u65e0\u6548\u7684\u8f93\u5165\u503c", (String)"ScriptBuilder_1", (String)"data-idi-core", (Object[])new Object[0])});
        }
        return isOk;
    }

    private String checkInputDate(List<String> valueList, int index, CompareType compareType) {
        String value;
        String compareValue = compareType.getValue().toUpperCase();
        String strtmp = value = valueList.get(index).trim().split(" ")[0];
        if (compareValue.equals("TODAYBEFORE") || compareValue.equals("TODAYAFTER")) {
            this.isNumeric(value, true);
            strtmp = value;
        } else {
            this.isDateString(value, true);
            Date date = this.getDateByString(value);
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(date);
            GregorianCalendar maxCalendar = new GregorianCalendar();
            maxCalendar.setTime(MinSystemDateTime);
            if (calendar.get(1) < maxCalendar.get(1)) {
                throw new KDException(BosErrorCode.filterSqlBuilder, new Object[]{ResManager.loadKDString((String)"\u65e0\u6548\u7684\u8f93\u5165\u503c", (String)"ScriptBuilder_1", (String)"data-idi-core", (Object[])new Object[0])});
            }
            String operateStr = compareType.getOperate();
            if (operateStr.equals("=") || operateStr.equals("==")) {
                String beginTime = value + " 00:00:00";
                String endTime = value + " 23:59:59";
                strtmp = beginTime + "\",\"" + endTime;
                SchemaExecutorLogger.info("equals strtmp %s ", strtmp);
            } else if (operateStr.equals("!=") || operateStr.equals("<>")) {
                String beginTime = value + " 00:00:00";
                String endTime = value + " 23:59:59";
                strtmp = beginTime + "\",\"" + endTime;
                SchemaExecutorLogger.info("not equals strtmp %s ", strtmp);
            } else {
                strtmp = operateStr.equals("<") ? value + " 00:00:00" : (operateStr.equals("<=") ? value + " 23:59:59" : (operateStr.equals(">") ? value + " 23:59:59" : (operateStr.equals(">=") ? value + " 00:00:00" : (operateStr.equals("between") ? (index == 0 ? value + " 00:00:00" : value + " 23:59:59") : value + " 00:00:00"))));
            }
        }
        return "\"" + strtmp + "\"";
    }

    private String checkInputDateTime(List<String> valueList, int index, CompareType compareType) {
        String value = valueList.get(index).trim();
        this.isDateTimeString(value, true);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-M-d H:m:s");
        Date dateTime = null;
        try {
            dateTime = simpleDateFormat.parse(value);
        }
        catch (ParseException e) {
            throw new KDException((Throwable)e, BosErrorCode.filterSqlBuilder, new Object[]{ResManager.loadKDString((String)"\u65e0\u6548\u7684\u8f93\u5165\u503c\uff0c\u8bf7\u8f93\u5165\u65e5\u671f\uff0c\u683c\u5f0f\u5982\uff1a1999/12/25", (String)"ScriptBuilder_10", (String)"data-idi-core", (Object[])new Object[0])});
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(dateTime);
        GregorianCalendar maxCalendar = new GregorianCalendar();
        maxCalendar.setTime(MinSystemDateTime);
        if (calendar.get(1) < maxCalendar.get(1)) {
            throw new KDException(BosErrorCode.filterSqlBuilder, new Object[]{ResManager.loadKDString((String)"\u65e0\u6548\u7684\u8f93\u5165\u503c", (String)"ScriptBuilder_1", (String)"data-idi-core", (Object[])new Object[0])});
        }
        value = simpleDateFormat.format(dateTime);
        return "\"" + value + "\"";
    }

    private Date getDateByString(String v) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-M-d");
        Date date = null;
        try {
            date = simpleDateFormat.parse(v);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return date;
    }

    private ValueAndDesc checkInputValue(FilterField filterField, CompareType compareType, List<String> fieldValue) {
        String strtmp;
        String value = "";
        if (fieldValue.size() > 0) {
            value = fieldValue.get(0);
        }
        String valueDesc = value;
        String operateStr = compareType.getOperate().trim();
        int fieldType = filterField.getFieldType();
        if (operateStr.equals("=") || operateStr.equals("==") || operateStr.equals("!=") || operateStr.equals("<>") || operateStr.equals("<=") || operateStr.equals("<") || operateStr.equals(">=") || operateStr.equals(">")) {
            if (fieldType == 3 || fieldType == 6 || fieldType == 2 || fieldType == 7) {
                value = value.trim();
                this.isNumeric(value, true);
                strtmp = value;
            } else if (fieldType == -5 || fieldType == 4 || fieldType == 5) {
                value = value.trim();
                if ("seq".equals(filterField.getFieldProp().getName())) {
                    this.isUint(value, true);
                } else {
                    this.isInt(value, true);
                }
                strtmp = value;
            } else if (fieldType == -6) {
                value = value.trim();
                this.isUint(value, true);
                strtmp = value;
            } else if (fieldType == 91) {
                strtmp = this.checkInputDate(fieldValue, 0, compareType);
            } else if (fieldType == 92 || fieldType == 93) {
                strtmp = this.checkInputDateTime(fieldValue, 0, compareType);
            } else if (fieldType == -7) {
                this.checkIsEmpty(value, true);
                strtmp = value;
            } else if (fieldType == 1) {
                strtmp = value;
                valueDesc = value.equals("true") ? ResManager.loadKDString((String)"\u662f", (String)"ScriptBuilder_4", (String)"data-idi-core", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"ScriptBuilder_5", (String)"data-idi-core", (Object[])new Object[0]);
            } else {
                if (value.endsWith("'") || value.endsWith("\"")) {
                    value = value.substring(0, value.length() - 1);
                }
                if (value.startsWith("'") || value.startsWith("\"")) {
                    value = value.substring(1);
                }
                value = value.replace("'", "\\'");
                strtmp = marks + value + marks;
            }
        } else if (operateStr.equalsIgnoreCase("IN") || operateStr.equalsIgnoreCase("NOT IN")) {
            if (this.isNumberField(fieldType)) {
                value = String.join((CharSequence)",", fieldValue);
                strtmp = "newArray(" + value + ")";
                valueDesc = value;
            } else {
                value = String.join((CharSequence)(marks + "," + marks), fieldValue);
                valueDesc = String.join((CharSequence)",", fieldValue);
                strtmp = "newArray(" + marks + value + marks + ")";
            }
        } else if (operateStr.equalsIgnoreCase("BETWEEN")) {
            String value1 = null;
            String value2 = null;
            if (fieldType == 91) {
                this.checkIsEmpty(value, true);
                value1 = this.checkInputDate(fieldValue, 0, compareType);
                value2 = this.checkInputDate(fieldValue, 1, compareType);
            } else if (fieldType == 92 || fieldType == 93) {
                this.checkIsEmpty(value, true);
                value1 = this.checkInputDateTime(fieldValue, 0, compareType);
                value2 = this.checkInputDateTime(fieldValue, 1, compareType);
            }
            strtmp = value1 + "," + value2;
        } else if (operateStr.equalsIgnoreCase("LIKE") || operateStr.equalsIgnoreCase("NOT LIKE")) {
            strtmp = "\"" + value + "\"";
        } else {
            throw new KDException(BosErrorCode.filterSqlBuilder, new Object[]{ResManager.loadKDString((String)"\u65e0\u6548\u7684\u8f93\u5165\u503c", (String)"ScriptBuilder_1", (String)"data-idi-core", (Object[])new Object[0])});
        }
        ValueAndDesc valueAndDesc = new ValueAndDesc();
        valueAndDesc.setValue(strtmp);
        valueAndDesc.setDesc(valueDesc);
        return valueAndDesc;
    }

    private String getFieldCaption(String fieldName) {
        String fieldCaption = "";
        if (StringUtils.isBlank((CharSequence)fieldName)) {
            return fieldCaption;
        }
        FieldName fieldNameObj = EntityTypeUtil.getORMFieldName((String)fieldName, (EntityType)this.billEntityType);
        fieldCaption = fieldNameObj == null || fieldNameObj.getFieldCaption() == null ? fieldName : fieldNameObj.getFieldCaption().toString();
        return fieldCaption;
    }

    private static String appendQuotes(String dateStr) {
        String result = dateStr;
        if (!dateStr.startsWith("\"")) {
            result = "\"" + result;
        }
        if (!dateStr.endsWith("\"")) {
            result = result + "\"";
        }
        return result;
    }

    public String getBillPrefix() {
        return this.billPrefix;
    }

    public void setBillPrefix(String billPrefix) {
        this.billPrefix = billPrefix;
    }

    static {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1900, 0, 1);
        MinSystemDateTime = calendar.getTime();
    }

    public static class ValueAndDesc {
        private String value = null;
        private String desc = null;

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }
}

