/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.engine;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.formula.platform.api.BaseFormulaFunctions;
import kd.bos.formula.platform.engine.FormulaEngine;
import kd.bos.formula.platform.engine.RunFormulaException;
import kd.bos.kscript.IFunctionProvider;
import kd.bos.kscript.dom.expr.ArrayIndexerExpr;
import kd.bos.kscript.dom.expr.BinaryOpExpr;
import kd.bos.kscript.dom.expr.CodeExpr;
import kd.bos.kscript.dom.expr.ConditionExpr;
import kd.bos.kscript.dom.expr.IdentifierExpr;
import kd.bos.kscript.dom.expr.LambdaExpr;
import kd.bos.kscript.dom.expr.MethodInvokeExpr;
import kd.bos.kscript.dom.expr.ObjectCreateExpr;
import kd.bos.kscript.dom.expr.PropertyExpr;
import kd.bos.kscript.dom.expr.UnaryExpr;
import kd.bos.kscript.dom.stmt.BlockStmt;
import kd.bos.kscript.dom.stmt.CaseItem;
import kd.bos.kscript.dom.stmt.CodeStmt;
import kd.bos.kscript.dom.stmt.DoStmt;
import kd.bos.kscript.dom.stmt.ExprListStmt;
import kd.bos.kscript.dom.stmt.ExprStmt;
import kd.bos.kscript.dom.stmt.ForStmt;
import kd.bos.kscript.dom.stmt.IfStmt;
import kd.bos.kscript.dom.stmt.ReturnStmt;
import kd.bos.kscript.dom.stmt.SwitchStmt;
import kd.bos.kscript.dom.stmt.VarDeclItem;
import kd.bos.kscript.dom.stmt.VarDeclStmt;
import kd.bos.kscript.dom.stmt.WhileStmt;
import kd.bos.kscript.parser.KScriptParser;
import kd.bos.kscript.parser.Lexer;
import kd.bos.kscript.parser.TokenList;
import kd.bos.kscript.runtime.Interpreter;
import kd.data.idi.engine.IDIFormulaFunctions;
import kd.data.idi.engine.SchemaExecutorLogger;

public class ScriptEngine {
    private static ScriptEngine engine;
    private static final ThreadLocal<Interpreter> interpreterThreadLocal;
    private static final ThreadLocal<Integer> scriptRunCountThreadLocal;
    private Interpreter synInterpreter;
    private AtomicInteger scriptRunCount;

    private ScriptEngine() {
    }

    public static synchronized ScriptEngine getEngine() {
        if (engine == null) {
            engine = new ScriptEngine();
            engine.getInterpreter();
        }
        return engine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Interpreter getInterpreter() {
        if (this.scriptRunCount == null) {
            this.scriptRunCount = new AtomicInteger(1);
        } else {
            if (this.scriptRunCount.get() > 1000) {
                this.scriptRunCount.set(1);
                ScriptEngine scriptEngine = this;
                synchronized (scriptEngine) {
                    this.synInterpreter = this.createInterpreter();
                    return this.synInterpreter;
                }
            }
            this.scriptRunCount.incrementAndGet();
        }
        ScriptEngine scriptEngine = this;
        synchronized (scriptEngine) {
            if (this.synInterpreter == null) {
                this.synInterpreter = this.createInterpreter();
            }
        }
        return this.synInterpreter;
    }

    public synchronized void clear() {
        this.synInterpreter = this.createInterpreter();
    }

    private Interpreter createInterpreter() {
        Interpreter interpreter = new Interpreter();
        interpreter.funcProviderList.clear();
        interpreter.addFunctionProvider((IFunctionProvider)new IDIFormulaFunctions());
        interpreter.addFunctionProvider((IFunctionProvider)new BaseFormulaFunctions());
        interpreter.setForBot(true);
        return interpreter;
    }

    public Object runScript(String script, Map ctx) {
        Interpreter interpreter = this.getInterpreter();
        try {
            return FormulaEngine.runFormula((Interpreter)interpreter, (String)script, (Map)ctx);
        }
        catch (RunFormulaException e) {
            SchemaExecutorLogger.error("script:" + script + ",error :" + e.getMessage(), e);
            String errMsg = e.getMessage().contains("null") ? ResManager.loadKDString((String)"\u68c0\u67e5\u5b57\u6bb5\u7684\u503c\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u68c0\u67e5", (String)"ScriptEngine_0", (String)"data-idi-core", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u811a\u672c\u6267\u884c\u51fa\u9519\uff0c\u65e0\u6cd5\u6267\u884c\u68c0\u67e5", (String)"ScriptEngine_1", (String)"data-idi-core", (Object[])new Object[0]);
            throw new KDBizException(errMsg);
        }
    }

    public Set<String> extractVariables(String script) {
        HashSet<String> vars = new HashSet<String>();
        try {
            Lexer lexer = new Lexer(script);
            TokenList tokList = new TokenList(lexer);
            KScriptParser parser = new KScriptParser(tokList);
            parser.parse();
            for (Object stmtItem : parser.stmtList) {
                this.extractVariables((CodeStmt)stmtItem, vars);
            }
        }
        catch (Exception ex) {
            SchemaExecutorLogger.error(ex);
        }
        return vars;
    }

    private void extractVariables(CodeStmt stmt, Set<String> vars) {
        block19: {
            block27: {
                block26: {
                    block25: {
                        block24: {
                            block23: {
                                block22: {
                                    block21: {
                                        block20: {
                                            block18: {
                                                if (stmt == null) {
                                                    return;
                                                }
                                                if (!(stmt instanceof ExprStmt)) break block18;
                                                this.extractVariables(((ExprStmt)stmt).expr, vars);
                                                break block19;
                                            }
                                            if (!(stmt instanceof BlockStmt)) break block20;
                                            if (((BlockStmt)stmt).stmtList == null) break block19;
                                            for (Object stmtItem : ((BlockStmt)stmt).stmtList) {
                                                this.extractVariables((CodeStmt)stmtItem, vars);
                                            }
                                            break block19;
                                        }
                                        if (!(stmt instanceof DoStmt)) break block21;
                                        this.extractVariables(((DoStmt)stmt).testExpr, vars);
                                        if (((DoStmt)stmt).stmtList == null) break block19;
                                        for (Object stmtItem : ((DoStmt)stmt).stmtList) {
                                            this.extractVariables((CodeStmt)stmtItem, vars);
                                        }
                                        break block19;
                                    }
                                    if (!(stmt instanceof ExprListStmt)) break block22;
                                    if (((ExprListStmt)stmt).exprList == null) break block19;
                                    for (Object paramExpr : ((ExprListStmt)stmt).exprList) {
                                        this.extractVariables((CodeExpr)paramExpr, vars);
                                    }
                                    break block19;
                                }
                                if (!(stmt instanceof ForStmt)) break block23;
                                this.extractVariables(((ForStmt)stmt).testExpr, vars);
                                this.extractVariables(((ForStmt)stmt).initStmt, vars);
                                this.extractVariables(((ForStmt)stmt).incrementStmt, vars);
                                if (((ForStmt)stmt).stmtList == null) break block19;
                                for (Object stmtItem : ((ForStmt)stmt).stmtList) {
                                    this.extractVariables((CodeStmt)stmtItem, vars);
                                }
                                break block19;
                            }
                            if (!(stmt instanceof IfStmt)) break block24;
                            this.extractVariables(((IfStmt)stmt).testExpr, vars);
                            if (((IfStmt)stmt).trueStmtList != null) {
                                for (Object stmtItem : ((IfStmt)stmt).trueStmtList) {
                                    this.extractVariables((CodeStmt)stmtItem, vars);
                                }
                            }
                            if (((IfStmt)stmt).elseIfList != null) {
                                for (Object stmtItem : ((IfStmt)stmt).elseIfList) {
                                    this.extractVariables((CodeStmt)stmtItem, vars);
                                }
                            }
                            if (((IfStmt)stmt).elseStmtList == null) break block19;
                            for (Object stmtItem : ((IfStmt)stmt).elseStmtList) {
                                this.extractVariables((CodeStmt)stmtItem, vars);
                            }
                            break block19;
                        }
                        if (!(stmt instanceof ReturnStmt)) break block25;
                        this.extractVariables(((ReturnStmt)stmt).expr, vars);
                        break block19;
                    }
                    if (!(stmt instanceof SwitchStmt)) break block26;
                    this.extractVariables(((SwitchStmt)stmt).testExpr, vars);
                    if (((SwitchStmt)stmt).caseItemList != null) {
                        for (Object stmtItem : ((SwitchStmt)stmt).caseItemList) {
                            CaseItem caseItem = (CaseItem)stmtItem;
                            if (caseItem.stmtList == null) continue;
                            for (Object caseItemStmt : caseItem.stmtList) {
                                this.extractVariables((CodeStmt)caseItemStmt, vars);
                            }
                        }
                    }
                    if (((SwitchStmt)stmt).defaultCaseItem == null || ((SwitchStmt)stmt).defaultCaseItem.stmtList == null) break block19;
                    for (Object caseItemStmt : ((SwitchStmt)stmt).defaultCaseItem.stmtList) {
                        this.extractVariables((CodeStmt)caseItemStmt, vars);
                    }
                    break block19;
                }
                if (!(stmt instanceof VarDeclStmt)) break block27;
                if (((VarDeclStmt)stmt).varDeclList == null) break block19;
                for (Object item : ((VarDeclStmt)stmt).varDeclList) {
                    this.extractVariables(((VarDeclItem)item).initExpr, vars);
                }
                break block19;
            }
            if (stmt instanceof WhileStmt) {
                this.extractVariables(((WhileStmt)stmt).testExpr, vars);
                if (((WhileStmt)stmt).stmtList != null) {
                    for (Object stmtItem : ((WhileStmt)stmt).stmtList) {
                        this.extractVariables((CodeStmt)stmtItem, vars);
                    }
                }
            }
        }
    }

    private void extractVariables(CodeExpr expr, Set<String> vars) {
        if (expr == null) {
            return;
        }
        if (expr instanceof PropertyExpr) {
            vars.add(expr.toString());
        } else if (expr instanceof IdentifierExpr) {
            vars.add(expr.toString());
        } else if (expr instanceof BinaryOpExpr) {
            this.extractVariables(((BinaryOpExpr)expr).left, vars);
            this.extractVariables(((BinaryOpExpr)expr).right, vars);
        } else if (expr instanceof ArrayIndexerExpr) {
            this.extractVariables(((ArrayIndexerExpr)expr).targetObjExpr, vars);
            this.extractVariables(((ArrayIndexerExpr)expr).indexExpr, vars);
        } else if (expr instanceof ConditionExpr) {
            this.extractVariables(((ConditionExpr)expr).testExpr, vars);
            this.extractVariables(((ConditionExpr)expr).trueExpr, vars);
            this.extractVariables(((ConditionExpr)expr).falseExpr, vars);
        } else if (expr instanceof LambdaExpr) {
            if (((LambdaExpr)expr).paramList != null) {
                for (Object paramExpr : ((LambdaExpr)expr).paramList) {
                    this.extractVariables((CodeExpr)paramExpr, vars);
                }
            }
            this.extractVariables(((LambdaExpr)expr).expr, vars);
        } else if (expr instanceof MethodInvokeExpr) {
            this.extractVariables(((MethodInvokeExpr)expr).owner, vars);
            if (((MethodInvokeExpr)expr).paramList != null) {
                for (Object paramExpr : ((MethodInvokeExpr)expr).paramList) {
                    this.extractVariables((CodeExpr)paramExpr, vars);
                }
            }
        } else if (expr instanceof ObjectCreateExpr) {
            if (((ObjectCreateExpr)expr).initExprList != null) {
                for (Object paramExpr : ((ObjectCreateExpr)expr).initExprList) {
                    this.extractVariables((CodeExpr)paramExpr, vars);
                }
            }
            if (((ObjectCreateExpr)expr).paramList != null) {
                for (Object paramExpr : ((ObjectCreateExpr)expr).paramList) {
                    this.extractVariables((CodeExpr)paramExpr, vars);
                }
            }
        } else if (expr instanceof UnaryExpr) {
            this.extractVariables(((UnaryExpr)expr).expr, vars);
        }
    }

    static {
        interpreterThreadLocal = new ThreadLocal();
        scriptRunCountThreadLocal = new ThreadLocal();
    }
}

