/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.engine.attachment;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.data.idi.api.external.IExternalApiAbutment;
import kd.data.idi.api.external.impl.LCAttachmentApiAbutmentImpl;
import kd.data.idi.api.external.impl.LCAttachmentParam;
import kd.data.idi.api.external.impl.UrlParam;
import kd.data.idi.data.attachment.LcDataDetail;
import kd.data.idi.data.attachment.OriginAttachRecord;
import kd.data.idi.engine.CacheManager;
import kd.data.idi.engine.SchemaExecutorLogger;
import kd.data.idi.engine.attachment.AIParam;
import kd.data.idi.engine.attachment.AIRecognizerErrorInfo;
import kd.data.idi.engine.attachment.AIRecognizerParam;
import kd.data.idi.engine.attachment.AIRecognizerResult;
import kd.data.idi.engine.attachment.AIRecognizerSuccessInfo;
import kd.data.idi.engine.attachment.AITemplate;
import kd.data.idi.engine.attachment.Attachment;
import kd.data.idi.engine.attachment.AttachmentDataSourceEnum;
import kd.data.idi.engine.attachment.AttachmentField;
import kd.data.idi.engine.attachment.IAttachmentService;
import kd.data.idi.util.AttachmentFieldHelper;
import kd.data.idi.util.AttachmentResultRecordHelper;

public class LCAttachmentServiceImpl
implements IAttachmentService<AIRecognizerResult> {
    private static final Set<String> supportedFileTypeSet = new HashSet<String>();
    private static final long fileSize = 0x200000L;

    @Override
    public List<AttachmentField> queryTemplateField(AIParam fieldQueryParam) {
        Long templateId = fieldQueryParam.getLcTemplateId();
        if (templateId == null) {
            throw new KDBizException("lc template is null");
        }
        List<AttachmentField> fieldList = AttachmentFieldHelper.queryLcTemplateAndField(templateId);
        if (CollectionUtils.isEmpty(fieldList)) {
            throw new KDBizException("lc field not setting");
        }
        return fieldList;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public AIRecognizerResult recognizer(AIRecognizerParam param) {
        block39: {
            lcTemplateFieldMap = param.getLcTemplateFieldMap();
            if (lcTemplateFieldMap == null || lcTemplateFieldMap.isEmpty()) {
                SchemaExecutorLogger.error("[DATA-IDI] LCAttachmentServiceImpl recognizer : no lc template selected!");
                throw new KDBizException("no lc template selected");
            }
            fieldMapJson = JSON.toJSONString(lcTemplateFieldMap);
            SchemaExecutorLogger.info(String.format("LCAttachmentServiceImpl before execute lcTemplateFieldMap : %s", new Object[]{fieldMapJson}), new Object[0]);
            dealLcTemplateFieldMap = (Map)JSON.parseObject((String)fieldMapJson, (TypeReference)new TypeReference<Map<Long, Set<String>>>(){}, (Feature[])new Feature[0]);
            templateMap = AttachmentFieldHelper.queryLcTemplateById(lcTemplateFieldMap.keySet());
            SchemaExecutorLogger.info(String.format("LCAttachmentServiceImpl templateMap %s", new Object[]{JSON.toJSONString(templateMap)}), new Object[0]);
            currTemplate = templateMap.get(param.getLcTemplateId());
            attachmentTypeMap = param.getAttachmentList().stream().collect(Collectors.groupingBy((Function<Attachment, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$recognizer$0(kd.data.idi.engine.attachment.Attachment ), (Lkd/data/idi/engine/attachment/Attachment;)Ljava/lang/String;)()));
            supportList = attachmentTypeMap.get("support");
            attachmentSizeMap = supportList.stream().collect(Collectors.groupingBy((Function<Attachment, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$recognizer$1(kd.data.idi.engine.attachment.Attachment ), (Lkd/data/idi/engine/attachment/Attachment;)Ljava/lang/String;)()));
            notExceedList = attachmentSizeMap.get("notExceed");
            existRecognizerList = null;
            lcRecordList = null;
            if (!(notExceedList == null || notExceedList.isEmpty() || (lcRecordList = AttachmentResultRecordHelper.getLcRecord(lcTemplateFieldMap, templateMap, notExceedList, existFieldMap = new HashMap<Long, Map<String, Set<String>>>(4))) == null || lcRecordList.isEmpty() || existFieldMap.isEmpty())) {
                SchemaExecutorLogger.info(String.format("LCAttachmentServiceImpl recognizer hit recognition result, lcRecordList : %s, existFiledMap : %s", new Object[]{JSON.toJSONString(lcRecordList), JSON.toJSONString(existFieldMap)}), new Object[0]);
                for (Map.Entry<Long, Set<String>> entry : lcTemplateFieldMap.entrySet()) {
                    templateId = entry.getKey();
                    templateFieldSet = entry.getValue();
                    templateAttachFieldMap = (Map)existFieldMap.get(templateId);
                    if (templateAttachFieldMap == null || templateAttachFieldMap.isEmpty()) continue;
                    for (String field : templateFieldSet) {
                        allAttachHasNeedFieldRecord = true;
                        for (Map.Entry<K, V> attachEntry : templateAttachFieldMap.entrySet()) {
                            attachFieldSet = (Set)attachEntry.getValue();
                            if (attachFieldSet != null && !attachFieldSet.isEmpty() && attachFieldSet.contains(field)) continue;
                            allAttachHasNeedFieldRecord = false;
                            break;
                        }
                        if (!allAttachHasNeedFieldRecord) continue;
                        dealFieldSet = (Set)dealLcTemplateFieldMap.get(templateId);
                        dealFieldSet.remove(field);
                        if (!dealFieldSet.isEmpty()) continue;
                        dealLcTemplateFieldMap.remove(templateId);
                    }
                }
                existRecognizerList = new ArrayList<AIRecognizerSuccessInfo>(lcRecordList.size());
                for (LcDataDetail lcDataDetail : lcRecordList) {
                    templateNumber = lcDataDetail.getVoucherCode();
                    optional = templateMap.values().stream().filter((Predicate<AITemplate>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$recognizer$2(java.lang.String kd.data.idi.engine.attachment.AITemplate ), (Lkd/data/idi/engine/attachment/AITemplate;)Z)((String)templateNumber)).findFirst();
                    if (!optional.isPresent()) continue;
                    recognizerSuccessInfo = AttachmentResultRecordHelper.convertLcDataDetailToRecognizer(lcDataDetail, optional.get());
                    existRecognizerList.add(recognizerSuccessInfo);
                }
                SchemaExecutorLogger.info(String.format("LCAttachmentServiceImpl existRecognizerList : %s", new Object[]{JSON.toJSONString(existRecognizerList)}), new Object[0]);
            }
            SchemaExecutorLogger.info(String.format("LCAttachmentServiceImpl after execute lcTemplateFieldMap : %s, dealLcTemplateFieldMap : %s", new Object[]{JSON.toJSONString(param.getLcTemplateFieldMap()), JSON.toJSONString((Object)dealLcTemplateFieldMap)}), new Object[0]);
            zmcFilterConditionMap = new HashMap<String, List<String>>(3);
            dealLcTemplateFieldMap.forEach((BiConsumer<Long, Set>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$recognizer$3(java.util.Map java.util.Map java.lang.Long java.util.Set ), (Ljava/lang/Long;Ljava/util/Set;)V)(templateMap, zmcFilterConditionMap));
            if (CollectionUtils.isNotEmpty(notExceedList) && !zmcFilterConditionMap.isEmpty()) {
                lcAttachmentApiAbutment = new LCAttachmentApiAbutmentImpl();
                urlParam = lcAttachmentApiAbutment.getUrlParam("lincai_sign", null);
                requestNo = param.getLockMessage().getValue();
                SchemaExecutorLogger.info(String.format("[DATA-IDI] SchemaParallelExecutor childThread traceId\uff1a%s!", new Object[]{requestNo}), new Object[0]);
                if (StringUtils.isEmpty((String)requestNo) || "null".equalsIgnoreCase((String)requestNo)) {
                    requestNo = RequestContext.get().getTraceId();
                    SchemaExecutorLogger.info(String.format("[DATA-IDI] SchemaParallelExecutor childThread reset requestNo to RequestContext.get().getTraceId()\uff1a%s!", new Object[]{requestNo}), new Object[0]);
                }
                cacheKey = lcAttachmentApiAbutment.buildCacheKey(null);
                SchemaExecutorLogger.info("[DATA-IDI] LCAttachmentServiceImpl cacheKey:" + cacheKey + "/r/n", new Object[0]);
                lockMessage = param.getLockMessage();
                lcAttachmentParam = new LCAttachmentParam(param.getBillName(), param.getBillNo(), zmcFilterConditionMap, notExceedList, currTemplate);
                lcAttachmentParam.setRequestNo((String)requestNo);
                if (lockMessage != null && lockMessage.getKey().booleanValue()) {
                    dLock = this.createDlock(lockMessage.getValue());
                    allAttachHasNeedFieldRecord = null;
                    try {
                        if (!dLock.tryLock(120000L)) ** GOTO lbl90
                        SchemaExecutorLogger.info("[DATA-IDI] LCAttachmentServiceImpl parallel execute!", new Object[0]);
                        this.toLc(cacheKey, (String)requestNo, urlParam, lcAttachmentParam, lcAttachmentApiAbutment);
                    }
                    catch (Throwable var23_27) {
                        allAttachHasNeedFieldRecord = var23_27;
                        throw var23_27;
                    }
                    finally {
                        if (dLock != null) {
                            if (allAttachHasNeedFieldRecord != null) {
                                try {
                                    dLock.close();
                                }
                                catch (Throwable var23_26) {
                                    allAttachHasNeedFieldRecord.addSuppressed(var23_26);
                                }
                            } else {
                                dLock.close();
                            }
                        }
                    }
                } else {
                    SchemaExecutorLogger.info("[DATA-IDI] LCAttachmentServiceImpl execute!", new Object[0]);
                    this.toLc(cacheKey, (String)requestNo, urlParam, lcAttachmentParam, lcAttachmentApiAbutment);
                }
lbl90:
                // 3 sources

                data = CacheManager.get(cacheKey, (String)requestNo);
                interval = 500L;
                limit = 240000L;
                for (time = 0L; requestNo.equals(data) && time < limit; time += interval) {
                    try {
                        Thread.sleep(interval);
                    }
                    catch (InterruptedException e) {
                        SchemaExecutorLogger.error(e);
                        throw new KDBizException((Throwable)e, new ErrorCode("", ""), new Object[]{e.getMessage()});
                    }
                    data = CacheManager.get(cacheKey, (String)requestNo);
                }
                if (requestNo.equals(data)) {
                    SchemaExecutorLogger.error("[DATA-IDI] LCAttachmentServiceImpl recognizer time out\uff08240s\uff09! requestNo\uff1a" + (String)requestNo);
                    throw new KDBizException("lc recognizer time out");
                }
                result = (AIRecognizerResult)lcAttachmentApiAbutment.parseResult(data, lcAttachmentParam);
                try {
                    originAttachRecord = new OriginAttachRecord(result.getRequestId(), lcAttachmentParam.getBillName(), lcAttachmentParam.getBillNo(), AttachmentDataSourceEnum.LC.getDataSource(), data);
                    AttachmentResultRecordHelper.saveOriginAttachRecord(originAttachRecord);
                    templateNumberIdMap = new HashMap<String, Long>(templateMap.size());
                    for (Map.Entry<Long, AITemplate> entry : templateMap.entrySet()) {
                        template = entry.getValue();
                        templateNumberIdMap.put(template.getNumber(), template.getId());
                    }
                    SchemaExecutorLogger.info(String.format("LCAttachmentServiceImpl templateNumberIdMap %s", new Object[]{JSON.toJSONString(templateNumberIdMap)}), new Object[0]);
                    fileNameMd5Map = new HashMap<String, String>(notExceedList.size());
                    notExceedList.forEach((Consumer<Attachment>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$recognizer$4(java.util.Map kd.data.idi.engine.attachment.Attachment ), (Lkd/data/idi/engine/attachment/Attachment;)V)(fileNameMd5Map));
                    SchemaExecutorLogger.info(String.format("LCAttachmentServiceImpl fileNameMd5Map %s", new Object[]{JSON.toJSONString(fileNameMd5Map)}), new Object[0]);
                    if (existRecognizerList != null && !existRecognizerList.isEmpty()) {
                        detailDataList = result.getDetailDatas();
                        if (detailDataList == null || detailDataList.isEmpty()) {
                            SchemaExecutorLogger.info("LCAttachmentServiceImpl addSuccessInfoList", new Object[0]);
                            result.addSuccessInfoList(existRecognizerList);
                        } else {
                            if (!lcRecordList.isEmpty()) {
                                SchemaExecutorLogger.info("LCAttachmentServiceImpl mergeRecognizerAndLcDetail", new Object[0]);
                                AttachmentResultRecordHelper.mergeRecognizerAndLcDetail(detailDataList, lcRecordList);
                            }
                            SchemaExecutorLogger.info("LCAttachmentServiceImpl updateLcProcessResult", new Object[0]);
                            AttachmentResultRecordHelper.updateLcProcessResult(templateNumberIdMap, fileNameMd5Map, data);
                        }
                        break block39;
                    }
                    SchemaExecutorLogger.info("LCAttachmentServiceImpl updateLcProcessResult, no exist record", new Object[0]);
                    AttachmentResultRecordHelper.updateLcProcessResult(templateNumberIdMap, fileNameMd5Map, data);
                }
                catch (Exception ex) {
                    SchemaExecutorLogger.error("LCAttachmentServiceImpl recognizer save record error", ex);
                }
            } else {
                result = new AIRecognizerResult();
                SchemaExecutorLogger.info("LCAttachmentServiceImpl all fields can be found from the record", new Object[0]);
                if (existRecognizerList != null && !existRecognizerList.isEmpty()) {
                    result.addSuccessInfoList((List<AIRecognizerSuccessInfo>)existRecognizerList);
                }
            }
        }
        if (CollectionUtils.isNotEmpty(unsupportedList = attachmentTypeMap.get("unsupported"))) {
            errorMesg = ResManager.loadKDString((String)"\u8bc6\u522b\u5931\u8d25\uff0c\u4e0d\u652f\u6301\u6587\u4ef6\u7c7b\u578b\uff1a", (String)"LCAttachmentServiceImpl_2", (String)"data-idi-core", (Object[])new Object[0]);
            for (Attachment attr : unsupportedList) {
                errorInfo = new AIRecognizerErrorInfo();
                errorInfo.setFileName(attr.getFileName());
                errorInfo.setErrorCode("lc406");
                errorInfo.setDescription(errorMesg + attr.getFileType());
                result.addErrorInfo(errorInfo);
            }
        }
        if (CollectionUtils.isNotEmpty(exceedList = attachmentSizeMap.get("exceed"))) {
            errorMesg = ResManager.loadKDString((String)"excel\u6587\u4ef6\u5927\u5c0f\u8d85\u8fc72M", (String)"LCAttachmentServiceImpl_3", (String)"data-idi-core", (Object[])new Object[0]);
            for (Attachment attr : exceedList) {
                errorInfo = new AIRecognizerErrorInfo();
                errorInfo.setFileName(attr.getFileName());
                errorInfo.setErrorCode("lc407");
                errorInfo.setDescription(errorMesg);
                result.addErrorInfo(errorInfo);
            }
        }
        return result;
    }

    private void toLc(String cacheKey, String requestNo, UrlParam urlParam, LCAttachmentParam lcAttachmentParam, IExternalApiAbutment<LCAttachmentParam, AIRecognizerResult> lcAttachmentApiAbutment) {
        String data = CacheManager.get(cacheKey, requestNo);
        SchemaExecutorLogger.info(String.format("[DATA-IDI] LCAttachmentServiceImpl toLc data:%s", data), new Object[0]);
        if (StringUtils.isEmpty((String)data)) {
            SchemaExecutorLogger.info("[DATA-IDI] LCAttachmentServiceImpl apiAction start!", new Object[0]);
            lcAttachmentApiAbutment.apiAction(urlParam, lcAttachmentParam);
            SchemaExecutorLogger.info("[DATA-IDI] LCAttachmentServiceImpl apiAction end!", new Object[0]);
        }
    }

    private DLock createDlock(String traceId) {
        String key = String.format("data/idi/lc/%s", traceId);
        return DLock.create((String)key);
    }

    private static /* synthetic */ void lambda$recognizer$4(Map fileNameMd5Map, Attachment p) {
        fileNameMd5Map.put(p.getFileName(), p.getFileMD5());
    }

    private static /* synthetic */ void lambda$recognizer$3(Map templateMap, Map zmcFilterConditionMap, Long templateId, Set fieldSet) {
        AITemplate template = (AITemplate)templateMap.get(templateId);
        template.setCustomTemplate(false);
        String templateNumber = template.getNumber();
        ArrayList fieldList = new ArrayList(10);
        if (CollectionUtils.isNotEmpty((Collection)fieldSet)) {
            HashSet<String> repeatSet = new HashSet<String>(fieldSet.size());
            for (String field : fieldSet) {
                if (!StringUtils.isNotEmpty((String)field)) continue;
                if (field.contains(".")) {
                    String[] fields = field.split("\\.");
                    Collections.addAll(repeatSet, fields);
                    continue;
                }
                repeatSet.add(field);
            }
            fieldList.addAll(repeatSet);
        }
        if (!fieldList.isEmpty()) {
            zmcFilterConditionMap.put(templateNumber, fieldList);
        }
    }

    private static /* synthetic */ boolean lambda$recognizer$2(String templateNumber, AITemplate p) {
        return p.getNumber().equals(templateNumber);
    }

    private static /* synthetic */ String lambda$recognizer$1(Attachment att) {
        return ("xls".equals(att.getFileType()) || "xlsx".equals(att.getFileType())) && att.getSize() > 0x200000L ? "exceed" : "notExceed";
    }

    private static /* synthetic */ String lambda$recognizer$0(Attachment att) {
        return supportedFileTypeSet.contains(att.getFileType()) ? "support" : "unsupported";
    }

    static {
        supportedFileTypeSet.add("eml");
        supportedFileTypeSet.add("gif");
        supportedFileTypeSet.add("html");
        supportedFileTypeSet.add("htm");
        supportedFileTypeSet.add("jpg");
        supportedFileTypeSet.add("png");
        supportedFileTypeSet.add("jpeg");
        supportedFileTypeSet.add("msg");
        supportedFileTypeSet.add("ofd");
        supportedFileTypeSet.add("xls");
        supportedFileTypeSet.add("xlsx");
        supportedFileTypeSet.add("ppt");
        supportedFileTypeSet.add("pptx");
        supportedFileTypeSet.add("doc");
        supportedFileTypeSet.add("docx");
        supportedFileTypeSet.add("csv");
        supportedFileTypeSet.add("xlsm");
        supportedFileTypeSet.add("txt");
        supportedFileTypeSet.add("plain");
        supportedFileTypeSet.add("rar");
        supportedFileTypeSet.add("7z");
        supportedFileTypeSet.add("webp");
        supportedFileTypeSet.add("zip");
        supportedFileTypeSet.add("pdf");
    }
}

