/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.engine.courier.service;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.data.idi.engine.CacheManager;
import kd.data.idi.engine.ParamFactory;
import kd.data.idi.engine.SchemaExecutorLogger;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.SystemDefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;

@Deprecated
public class CourierLogisticsHelper {
    private static MessageDigest mdInst = null;
    private static char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final String TOKENSERVICE = "/open/oauth/token";
    private static final String QUERYSERVICE = "/v7/open/api/routeQuery";
    private static final String TOKEN_KEY = "kuaidi";
    private static final String COMPANYNUM_SF = "shunfeng";
    private static final String CHARSET = "UTF-8";

    public static Map<String, String> getUrlParam() {
        HashMap<String, String> map = new HashMap<String, String>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"CourierLogisticsHelper.getUrlParam", (String)"idi_api_config", (String)"number,url,clientid,clientsecret,httpmethod,paramentryentity.paramname,paramentryentity.paramtype", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"KDGJ"), new QFilter("enable", "=", (Object)"1")}, null);){
            if (dataSet != null) {
                for (Row row : dataSet) {
                    String url = row.getString("url");
                    String app_key = row.getString("clientid");
                    String secret = row.getString("clientsecret");
                    String method = row.getString("httpmethod");
                    String mobileName = row.getString("paramentryentity.paramname");
                    String mobile = row.getString("paramentryentity.paramtype");
                    map.put("url", url);
                    map.put("app_key", app_key);
                    map.put("secret", secret);
                    map.put("httpmethod", method);
                    map.put(mobileName, mobile);
                }
            }
        }
        return map;
    }

    public Map<String, Object> getSysParamTemplate(Map<String, String> urlParam) {
        HashMap<String, Object> sysMap = new HashMap<String, Object>();
        sysMap.put("app_key", urlParam.get("app_key"));
        sysMap.put("timestamp", System.currentTimeMillis());
        return sysMap;
    }

    public static String getToken(Map<String, String> urlParam) throws Exception {
        TreeMap<String, Object> requestParam = new TreeMap<String, Object>();
        requestParam.put("client_id", urlParam.get("app_key"));
        requestParam.put("client_secret", urlParam.get("secret"));
        requestParam.put("timestamp", String.valueOf(System.currentTimeMillis()));
        requestParam.put("grant_type", "client_credentials");
        requestParam.put("mobile", urlParam.get("mobile"));
        String sign = CourierLogisticsHelper.buildSign(urlParam.get("secret"), requestParam);
        SchemaExecutorLogger.info("getToken, sign=" + sign, new Object[0]);
        requestParam.put("sign", sign);
        String paramStr = CourierLogisticsHelper.processParam(requestParam);
        SchemaExecutorLogger.info("getToken, paramStr=" + paramStr, new Object[0]);
        String url = urlParam.get("url") + TOKENSERVICE;
        SchemaExecutorLogger.info("getToken, url=" + url, new Object[0]);
        String content = CourierLogisticsHelper.sendHttpRequest(url, paramStr);
        SchemaExecutorLogger.info("getToken, content=" + content, new Object[0]);
        return content;
    }

    public static String getOriginToken(Map<String, String> urlParam) throws Exception {
        String tokenStr = CacheManager.get("token", TOKEN_KEY);
        SchemaExecutorLogger.info("tokenStr in cache :" + tokenStr, new Object[0]);
        if (StringUtils.isEmpty((String)tokenStr)) {
            String content = CourierLogisticsHelper.getToken(urlParam);
            String[] token = CourierLogisticsHelper.tokenProcess(content);
            if (token == null && (token = CourierLogisticsHelper.tokenProcess(content = CourierLogisticsHelper.getToken(urlParam))) == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6token\u5931\u8d25\uff0c\u68c0\u67e5API\u53c2\u6570\u662f\u5426\u6b63\u786e", (String)"CourierLogisticsHelper_0", (String)"data-idi-core", (Object[])new Object[0]));
            }
            int tokenIdnex = 0;
            int expiresIndex = 1;
            tokenStr = token[tokenIdnex];
            SchemaExecutorLogger.info("tokenStr of https return :" + tokenStr, new Object[0]);
            CacheManager.put("token", TOKEN_KEY, token[tokenIdnex], Integer.parseInt(token[expiresIndex]));
        }
        return tokenStr;
    }

    public static String queryKuaidi(Map<String, String> urlParam, String company, String orderId, String mobile, int executorNum) throws Exception {
        String token = CourierLogisticsHelper.getOriginToken(urlParam);
        TreeMap<String, Object> requestParam = new TreeMap<String, Object>();
        requestParam.put("app_key", urlParam.get("app_key"));
        requestParam.put("access_token", token);
        requestParam.put("timestamp", String.valueOf(System.currentTimeMillis()));
        JSONObject josn = new JSONObject();
        josn.put("kuaidi_com", (Object)company);
        josn.put("kuaidi_num", (Object)orderId);
        if (COMPANYNUM_SF.equals(company)) {
            josn.put("mobile", (Object)mobile);
        }
        requestParam.put("data", josn.toJSONString());
        String sign = CourierLogisticsHelper.buildSign(urlParam.get("secret"), requestParam);
        SchemaExecutorLogger.info("queryKuaidi, sign=" + sign, new Object[0]);
        requestParam.put("sign", sign);
        String paramStr = CourierLogisticsHelper.processParam(requestParam);
        SchemaExecutorLogger.info("queryKuaidi, paramStr=" + paramStr, new Object[0]);
        String url = urlParam.get("url") + QUERYSERVICE;
        SchemaExecutorLogger.info("queryKuaidi, url=" + url, new Object[0]);
        String content = CourierLogisticsHelper.sendHttpRequest(url, paramStr);
        SchemaExecutorLogger.info("queryKuaidi, content=" + content, new Object[0]);
        if (StringUtils.isNotEmpty((String)content) && content.contains("40018")) {
            if (executorNum < 1) {
                CacheManager.del("token", TOKEN_KEY);
                return CourierLogisticsHelper.queryKuaidi(urlParam, company, orderId, mobile, ++executorNum);
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570access_token\u975e\u6cd5\u6216\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u67e5\u8be2", (String)"CourierLogisticsHelper_1", (String)"data-idi-core", (Object[])new Object[0]));
        }
        return content;
    }

    private static String[] tokenProcess(String content) {
        JSONObject contentJson;
        if (content != null && content.length() > 0 && (contentJson = JSONObject.parseObject((String)content)).containsKey((Object)"access_token")) {
            String expiresSecond = contentJson.getString("expires_in");
            return new String[]{contentJson.getString("access_token"), expiresSecond};
        }
        return null;
    }

    public static String sendHttpRequest(String url, String paramStr) throws Exception {
        String data = "";
        int timeOut = ParamFactory.getTimeOut();
        int readOut = ParamFactory.getReadTimeOut();
        SystemDefaultHttpClient client = new SystemDefaultHttpClient();
        HttpParams httpParams = client.getParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)timeOut);
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)readOut);
        HttpPost post = new HttpPost(url);
        URI uri = post.getURI();
        try {
            if ("https".equals(uri.getScheme())) {
                client = CourierLogisticsHelper.wapperHttps((HttpClient)client);
            }
            StringEntity se = new StringEntity(paramStr, ContentType.APPLICATION_FORM_URLENCODED);
            post.setEntity((HttpEntity)se);
            HttpResponse response = client.execute((HttpUriRequest)post);
            SchemaExecutorLogger.info("response = " + response, new Object[0]);
            if (response.getStatusLine().getStatusCode() == 200) {
                HttpEntity resEntity = response.getEntity();
                if (resEntity != null) {
                    data = EntityUtils.toString((HttpEntity)resEntity, (String)CHARSET);
                    SchemaExecutorLogger.info("data of response : " + data, new Object[0]);
                }
            } else {
                String errorMessage = ResManager.loadKDString((String)"\u53d1\u9001HTTP POST\u51fa\u9519\uff1a", (String)"CourierLogisticsHelper_2", (String)"data-idi-core", (Object[])new Object[0]);
                SchemaExecutorLogger.info(errorMessage + response, new Object[0]);
            }
        }
        catch (IOException | KeyManagementException | NoSuchAlgorithmException e) {
            SchemaExecutorLogger.error("Http postjson error", e);
            throw e;
        }
        finally {
            post.releaseConnection();
        }
        return data;
    }

    public static HttpClient wapperHttps(HttpClient httpClient) throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException {
        try {
            SSLContext ctx = SSLContext.getInstance("TLSv1.2");
            TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            factory.init((KeyStore)null);
            ctx.init(null, new TrustManager[]{factory.getTrustManagers()[0]}, null);
            SSLSocketFactory ssf = new SSLSocketFactory(ctx, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            SchemeRegistry registry = new SchemeRegistry();
            registry.register(new Scheme("https", 443, (SchemeSocketFactory)ssf));
            ThreadSafeClientConnManager mgr = new ThreadSafeClientConnManager(registry);
            return new DefaultHttpClient((ClientConnectionManager)mgr, httpClient.getParams());
        }
        catch (NoSuchAlgorithmException e) {
            SchemaExecutorLogger.error("wapperHttps is error", e);
            throw e;
        }
        catch (KeyManagementException e) {
            SchemaExecutorLogger.error("wapperHttps is error", e);
            throw e;
        }
        catch (KeyStoreException e) {
            SchemaExecutorLogger.error("wapperHttps is error", e);
            throw e;
        }
    }

    public static MessageDigest getMdInst() throws NoSuchAlgorithmException {
        if (mdInst == null) {
            try {
                mdInst = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                SchemaExecutorLogger.error("getMdInst error", e);
                throw e;
            }
        }
        return mdInst;
    }

    public static String encode(String s) throws Exception {
        try {
            byte[] btInput = s.getBytes(CHARSET);
            CourierLogisticsHelper.getMdInst().update(btInput);
            byte[] md = CourierLogisticsHelper.getMdInst().digest();
            int j = md.length;
            char[] str = new char[j * 2];
            int k = 0;
            for (int i = 0; i < j; ++i) {
                byte byte0 = md[i];
                str[k++] = hexDigits[byte0 >>> 4 & 0xF];
                str[k++] = hexDigits[byte0 & 0xF];
            }
            return new String(str);
        }
        catch (Exception e) {
            SchemaExecutorLogger.error("encode error", e);
            throw e;
        }
    }

    public static String buildSign(String clientSecret, Map<String, Object> requestParam) throws Exception {
        Map<String, Object> paramsMap = null;
        if (requestParam instanceof TreeMap) {
            paramsMap = requestParam;
        } else {
            paramsMap = new TreeMap<String, Object>();
            paramsMap.putAll(requestParam);
        }
        StringBuilder strBuffer = new StringBuilder(clientSecret);
        Set<Map.Entry<String, Object>> entrySet = paramsMap.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            strBuffer.append(entry.getKey()).append(entry.getValue());
        }
        strBuffer.append(clientSecret);
        String paramStr = strBuffer.toString();
        String errorMessage = ResManager.loadKDString((String)"\u53c2\u6570\u8fde\u63a5\u5b57\u7b26\u4e32\uff1a", (String)"CourierLogisticsHelper_3", (String)"data-idi-core", (Object[])new Object[0]);
        SchemaExecutorLogger.info(errorMessage + paramStr, new Object[0]);
        return CourierLogisticsHelper.encode(paramStr);
    }

    public static String processParam(Map<String, Object> requestParam) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        try {
            for (Map.Entry<String, Object> entry : requestParam.entrySet()) {
                String paramName = URLEncoder.encode(entry.getKey(), CHARSET);
                String paramValue = URLEncoder.encode(String.valueOf(entry.getValue()), CHARSET);
                sb.append(paramName).append('=').append(paramValue).append('&');
            }
        }
        catch (UnsupportedEncodingException e) {
            SchemaExecutorLogger.error("processParam error ", e);
            throw e;
        }
        return sb.substring(0, sb.length() - 1);
    }
}

