/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.engine.functions;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.util.CollectionUtils;
import kd.data.idi.data.IDICompareType;
import kd.data.idi.engine.ScriptUtils;
import kd.data.idi.engine.functions.CustomFuncInfoChain;
import kd.data.idi.engine.functions.CustomFuncSpecialDeal;
import kd.data.idi.util.MetadataUtil;
import kd.data.idi.util.ObjectValueCompareUtil;

public class ArrayDiffFunc {
    private static final String arrayDiffFuncName = "arrayDiff";

    public static void dealFunc(CustomFuncInfoChain customFuncChain, DynamicObject srcObj, DynamicObject targetObj, String startConditionEntry, List<Integer> matchStartConditionEntryIndexList) {
        String regex = arrayDiffFuncName;
        String script = customFuncChain.getDealScript();
        Map<String, Object> funcValueMap = customFuncChain.getFuncValueMap();
        Set<String> entrySet = customFuncChain.getEntrySet();
        String srcEntity = srcObj.getDataEntityType().getName();
        MainEntityType srcMainType = EntityMetadataCache.getDataEntityType((String)srcEntity);
        String targetEntity = targetObj != null ? targetObj.getDataEntityType().getName() : null;
        MainEntityType targetMainType = targetEntity != null ? EntityMetadataCache.getDataEntityType((String)targetEntity) : null;
        String[] extractCustomAns = new String[4];
        extractCustomAns[3] = "0";
        while (extractCustomAns[3] != null && (extractCustomAns = ScriptUtils.extractCustomFunc(script, regex, Integer.parseInt(extractCustomAns[3])))[1] != null) {
            ArrayList tempValueList;
            String beforeSpecialDealScript = extractCustomAns[1];
            String funcStr = CustomFuncSpecialDeal.specialDeal(beforeSpecialDealScript.replace(" ", ""));
            String funcInnerStr = funcStr.substring(0, funcStr.length() - 1).replace("arrayDiff(", "");
            String[] filedOfScriptArr = funcInnerStr.split(",");
            if (filedOfScriptArr.length != 2) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5728arrayDiff\u51fd\u6570\u4e2d\u914d\u7f6e\u4e24\u4e2a\u53c2\u6570\u3002", (String)"ArrayDiffFunc_0", (String)"data-idi-core", (Object[])new Object[0]));
            }
            ArrayList<Object> leftValueList = new ArrayList(8);
            List<Object> rightValueList = new ArrayList<Object>(8);
            for (int i = 0; i < 2; ++i) {
                String funcParam = filedOfScriptArr[i];
                String funcParaBillEntity = funcParam.substring(0, funcParam.indexOf(".")).replace("_billObj", "");
                boolean isSourceBill = funcParaBillEntity.equals(srcEntity);
                Map<String, String> entryMap = MetadataUtil.getEntryMapByScriptStr(isSourceBill ? srcMainType : targetMainType, funcParam);
                List<Object> fieldValueList = MetadataUtil.getFieldValueList(isSourceBill ? srcObj : targetObj, entryMap, startConditionEntry, matchStartConditionEntryIndexList, null);
                if (i == 0) {
                    leftValueList.addAll(fieldValueList);
                } else {
                    rightValueList.addAll(fieldValueList);
                }
                if (isSourceBill) {
                    entrySet.addAll(ScriptUtils.getEntries(srcMainType, funcParam, new String[]{srcEntity}));
                    continue;
                }
                if (targetEntity == null) continue;
                entrySet.addAll(ScriptUtils.getEntries(targetMainType, funcParam, new String[]{targetEntity}));
            }
            boolean arrayDiff = true;
            if (CollectionUtils.isNotEmpty(leftValueList)) {
                tempValueList = leftValueList;
                leftValueList = tempValueList.stream().filter(value1 -> {
                    if (value1 instanceof Integer) {
                        return (Integer)value1 != 0;
                    }
                    if (value1 instanceof Long) {
                        return (Long)value1 != 0L;
                    }
                    if (value1 instanceof String) {
                        return !"".equals(value1) && !" ".equals(value1);
                    }
                    return value1 != null;
                }).collect(Collectors.toList());
            }
            if (CollectionUtils.isNotEmpty(rightValueList)) {
                tempValueList = rightValueList;
                rightValueList = tempValueList.stream().filter(value1 -> {
                    if (value1 instanceof Integer) {
                        return (Integer)value1 != 0;
                    }
                    if (value1 instanceof Long) {
                        return (Long)value1 != 0L;
                    }
                    if (value1 instanceof String) {
                        return !"".equals(value1) && !" ".equals(value1);
                    }
                    return value1 != null;
                }).collect(Collectors.toList());
            }
            if (leftValueList.isEmpty() && !rightValueList.isEmpty() || !leftValueList.isEmpty() && rightValueList.isEmpty()) {
                arrayDiff = false;
            } else if (ArrayDiffFunc.ListHasDiffValue(leftValueList, rightValueList) || ArrayDiffFunc.ListHasDiffValue(rightValueList, leftValueList)) {
                arrayDiff = false;
            }
            funcValueMap.put(funcStr, arrayDiff);
            ScriptUtils.replaceStartIndexAndNewValue(String.valueOf(arrayDiff), extractCustomAns);
            script = ScriptUtils.assembleArray(extractCustomAns);
        }
        customFuncChain.setDealScript(script);
    }

    public static boolean ListHasDiffValue(List<Object> currentValueList, List<Object> otherEntryValueList) {
        for (Object source : currentValueList) {
            boolean currentSourceExistInOther = false;
            for (Object target : otherEntryValueList) {
                if (!ObjectValueCompareUtil.valueCompare(source, target, IDICompareType.BOOLEAN_EQUALS)) continue;
                currentSourceExistInOther = true;
                break;
            }
            if (currentSourceExistInOther) continue;
            return true;
        }
        return false;
    }
}

