/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.export.schema;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.data.idi.engine.SchemaExecutorLogger;
import kd.data.idi.export.IDataExImport;
import kd.data.idi.export.schema.SchemaExImportProcessor;

public class SchemaExportBuilder
extends SchemaExImportProcessor {
    private final String filename;
    private final StringBuilder sb;

    public SchemaExportBuilder(Object[] primaryKeyValues) {
        super(primaryKeyValues);
        DynamicObject schema = BusinessDataServiceHelper.loadSingleFromCache((Object)primaryKeyValues[0], (String)"idi_schema", (String)"number");
        String number = schema.getString("number");
        this.filename = primaryKeyValues.length == 1 ? number : number + "_" + primaryKeyValues.length;
        this.sb = new StringBuilder();
    }

    public String build() {
        for (IDataExImport exImport : this.exImportList) {
            try {
                String toBase64 = exImport.exportToString();
                if (!StringUtils.isNotEmpty((CharSequence)toBase64)) continue;
                this.sb.append(toBase64).append("\r\n");
            }
            catch (Exception ex) {
                SchemaExecutorLogger.error("export schema error", ex);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u51b3\u7b56\u65b9\u6848\u53d1\u751f\u9519\u8bef\uff1a%s\u3002", (String)"SchemaExportBuilder_0", (String)"data-idi-core", (Object[])new Object[0]), ex.getMessage()));
            }
        }
        return this.sb.toString();
    }

    public String getExportFileName() {
        return "schema-" + this.filename + ".dts";
    }
}

