/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.log;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.data.idi.data.Area;
import kd.data.idi.data.Decision;
import kd.data.idi.data.Schema;
import kd.data.idi.log.EventTrackingTypeEnum;

public class IDIEventTrackingLog {
    private static final Log logger = LogFactory.getLog(IDIEventTrackingLog.class);
    private Schema schema;
    private EventTrackingTypeEnum eventTrackingTypeEnum;
    private String billType;

    private IDIEventTrackingLog() {
    }

    public static IDIEventTrackingLog instance(Schema schema, EventTrackingTypeEnum eventTrackingTypeEnum, String billType) {
        IDIEventTrackingLog eventTrackingLog = new IDIEventTrackingLog();
        eventTrackingLog.setSchema(schema);
        eventTrackingLog.setEventTrackingTypeEnum(eventTrackingTypeEnum);
        eventTrackingLog.setBillType(billType);
        return eventTrackingLog;
    }

    public void print() {
        try {
            if (this.schema == null || this.billType == null || this.eventTrackingTypeEnum == null) {
                return;
            }
            this.schemaPrint();
            this.decisionPrint();
        }
        catch (Exception e) {
            logger.error("[DATA-IDI] IDIEventTrackingLog print error!", (Throwable)e);
        }
    }

    private void schemaPrint() {
        HashMap<String, Object> varMap = new HashMap<String, Object>(8);
        varMap.put("mode", this.eventTrackingTypeEnum.getCode());
        varMap.put("billType", this.billType);
        varMap.put("schemaName", this.schema.getName());
        varMap.put("executeDate", new Date());
        HashMap<String, Object> basicMap = new HashMap<String, Object>(8);
        basicMap.put("keyword", "POA-FEATURE-MONITOR");
        basicMap.put("featureNumber", "DATA_IDI_SCHEMA");
        basicMap.put("count", "1");
        basicMap.put("time", "");
        basicMap.put("app_id", "idi");
        basicMap.put("formid", "");
        basicMap.put("var", varMap);
        String logJson = SerializationUtils.toJsonString(basicMap);
        logger.info(logJson);
    }

    private void decisionPrint() {
        HashMap<String, Decision> decisionMap = new HashMap<String, Decision>(8);
        List<Area> areaList = this.schema.getArea();
        for (Area area : areaList) {
            List<Decision> decisionList = area.getDecision();
            for (Decision decision : decisionList) {
                String pk = decision.getPk();
                if (!StringUtils.isNotEmpty((CharSequence)pk)) continue;
                decisionMap.put(pk, decision);
            }
        }
        if (!decisionMap.isEmpty()) {
            for (Decision decision : decisionMap.values()) {
                HashMap<String, Object> varMap = new HashMap<String, Object>(8);
                varMap.put("mode", this.eventTrackingTypeEnum.getCode());
                varMap.put("billType", this.billType);
                varMap.put("schemaName", this.schema.getName());
                varMap.put("decisionName", decision.getName());
                varMap.put("matchType", decision.getMatchType());
                varMap.put("executeDate", new Date());
                HashMap<String, Object> basicMap = new HashMap<String, Object>(8);
                basicMap.put("keyword", "POA-FEATURE-MONITOR");
                basicMap.put("featureNumber", "DATA_IDI_DECISION");
                basicMap.put("count", "1");
                basicMap.put("time", "");
                basicMap.put("app_id", "idi");
                basicMap.put("formid", "");
                basicMap.put("var", varMap);
                String logJson = SerializationUtils.toJsonString(basicMap);
                logger.info(logJson);
            }
        }
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public EventTrackingTypeEnum getEventTrackingTypeEnum() {
        return this.eventTrackingTypeEnum;
    }

    public void setEventTrackingTypeEnum(EventTrackingTypeEnum eventTrackingTypeEnum) {
        this.eventTrackingTypeEnum = eventTrackingTypeEnum;
    }

    public String getBillType() {
        return this.billType;
    }

    public void setBillType(String billType) {
        this.billType = billType;
    }
}

