/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.util;

import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Hex;

public class IDIEncryptUtils {
    private static final Log logger = LogFactory.getLog(IDIEncryptUtils.class);

    public static String getMD5(String str) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(str.getBytes("UTF-8"));
            return new BigInteger(1, md.digest()).toString(16);
        }
        catch (Exception ex) {
            logger.error("error md5 encrypt\uff1a" + ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public static String getSM4(String str, String secretKey) {
        try {
            Cipher cipher = Cipher.getInstance("SM4/ECB/PKCS7Padding", "BC");
            byte[] keys = Hex.decode((String)secretKey);
            SecretKeySpec sm4Key = new SecretKeySpec(keys, "SM4");
            cipher.init(1, sm4Key);
            byte[] datas = str.getBytes(StandardCharsets.UTF_8);
            int inputLen = datas.length;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int offSet = 0;
            int i = 0;
            int size = 1024;
            while (inputLen - offSet > 0) {
                byte[] cache = inputLen - offSet > size ? cipher.doFinal(datas, offSet, size) : cipher.doFinal(datas, offSet, inputLen - offSet);
                out.write(cache, 0, cache.length);
                offSet = ++i * size;
            }
            byte[] cipherArray = out.toByteArray();
            out.close();
            return Base64.getEncoder().encodeToString(cipherArray);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return null;
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

