/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.util;

import java.util.ArrayList;
import java.util.List;
import kd.bos.util.StringUtils;

public class IDIStringUtils {
    public static final String defaultSplitor = ",";

    public static List<String> strSplite(String str, String spliteStr) {
        ArrayList<String> results = new ArrayList<String>(2);
        if (!StringUtils.isEmpty((String)str)) {
            if (str.contains(spliteStr)) {
                String[] numbers;
                for (String number : numbers = str.split(spliteStr)) {
                    if (StringUtils.isEmpty((String)number)) continue;
                    results.add(number);
                }
            } else {
                results.add(str);
            }
        }
        return results;
    }

    public static List<String> strSplite(String str) {
        return IDIStringUtils.strSplite(str, defaultSplitor);
    }

    public static String buildTemplateField(Long templateId, String originField) {
        return IDIStringUtils.templatePrefix(templateId) + originField;
    }

    public static String buildTemplateField(String templateIdStr, String originField) {
        return IDIStringUtils.templatePrefix(templateIdStr) + originField;
    }

    public static String templatePrefix(Long templateId) {
        return IDIStringUtils.templatePrefixNoBillObj(String.valueOf(templateId)) + "_billObj.";
    }

    public static String templatePrefix(String templateIdStr) {
        return IDIStringUtils.templatePrefixNoBillObj(templateIdStr) + "_billObj.";
    }

    public static String templatePrefixNoBillObj(String templateIdStr) {
        return "idi" + templateIdStr;
    }

    public static boolean isInteger(String value) {
        return StringUtils.isNotEmpty((String)value) && value.matches("^\\d+$");
    }
}

