/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.mservice;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.result.ServiceResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.data.idi.data.Schema;
import kd.data.idi.data.SchemaContext;
import kd.data.idi.data.SchemaResult;
import kd.data.idi.data.show.CardRowModel;
import kd.data.idi.data.show.TextItemModel;
import kd.data.idi.dataconverter.IDISchemaResultMobileDataConvert;
import kd.data.idi.dataconverter.IDISchemaResultOpDataConvert;
import kd.data.idi.dataconverter.IDISchemaResultPCDataConvert;
import kd.data.idi.dataconverter.IDISchemaResultSSCDataConverter;
import kd.data.idi.engine.CacheManager;
import kd.data.idi.engine.SchemaExecutor;
import kd.data.idi.engine.SchemaSearcher;
import kd.data.idi.engine.courier.service.CourierParam;
import kd.data.idi.log.EventTrackingTypeEnum;
import kd.data.idi.log.IDIEventTrackingLog;
import kd.data.idi.mservice.IDISchemaService;
import kd.data.idi.util.DynamicObjectCopyMergeUtil;
import kd.data.idi.util.IDIJSONUtils;

public class IDISchemaServiceImpl
implements IDISchemaService {
    private static final Log logger = LogFactory.getLog(IDISchemaServiceImpl.class);

    public String findMatchSchema(DynamicObject bizObj) {
        SchemaSearcher schemaSearch = new SchemaSearcher();
        List schemaList = schemaSearch.matchAll(bizObj);
        ArrayList result = new ArrayList(schemaList.size());
        for (Schema schema : schemaList) {
            HashMap<String, String> data = new HashMap<String, String>(2);
            data.put("number", schema.getNumber());
            data.put("name", schema.getName());
            result.add(data);
        }
        return IDIJSONUtils.toJsonString(result);
    }

    public String executeSchema(DynamicObject bizObj) {
        return this.executeSchemaByPageId(bizObj, null);
    }

    public String executeSchema(DynamicObject bizObj, String schemaNumber) {
        return this.executeSchema(bizObj, schemaNumber, null);
    }

    public String executeSchemaByList(DynamicObject bizObj, List<String> schemaNumers) {
        return this.executeSchemaByList(bizObj, schemaNumers, null);
    }

    private Object[] executeSchemaCore(DynamicObject bizObj, String pageId, boolean isBackstage) {
        SchemaSearcher schemaSearch = new SchemaSearcher();
        Object[] result = schemaSearch.match(bizObj);
        Schema schema = (Schema)result[1];
        String billType = bizObj.getDataEntityType().getName();
        if (schema != null) {
            result[0] = new SchemaExecutor().execute(schema, billType, (Long)bizObj.getPkValue(), bizObj, pageId, isBackstage);
        }
        IDIEventTrackingLog eventTrackingLog = IDIEventTrackingLog.instance((Schema)schema, (EventTrackingTypeEnum)EventTrackingTypeEnum.SSC, (String)billType);
        eventTrackingLog.print();
        return result;
    }

    private Object[] executeSchemaCore(DynamicObject bizObj, String schemaNumber, String pageId, boolean isBackstage) {
        Object[] result = new SchemaSearcher().match(bizObj, schemaNumber);
        Schema schema = (Schema)result[1];
        String billType = bizObj.getDataEntityType().getName();
        if (schema != null) {
            result[0] = new SchemaExecutor().execute(schema, billType, (Long)bizObj.getPkValue(), bizObj, pageId, isBackstage);
        }
        IDIEventTrackingLog eventTrackingLog = IDIEventTrackingLog.instance((Schema)schema, (EventTrackingTypeEnum)EventTrackingTypeEnum.SSC, (String)billType);
        eventTrackingLog.print();
        return result;
    }

    private Object[] executeSchemaCore(DynamicObject bizObj, List<String> schemaNumers, String pageId, boolean isBackstage) {
        Object[] result = new SchemaSearcher().match(bizObj, schemaNumers);
        Schema schema = (Schema)result[1];
        String billType = bizObj.getDataEntityType().getName();
        if (schema != null) {
            result[0] = new SchemaExecutor().execute(schema, billType, (Long)bizObj.getPkValue(), bizObj, pageId, isBackstage);
        }
        IDIEventTrackingLog eventTrackingLog = IDIEventTrackingLog.instance((Schema)schema, (EventTrackingTypeEnum)EventTrackingTypeEnum.SSC, (String)billType);
        eventTrackingLog.print();
        return result;
    }

    public String executeSchemaNativeByList(DynamicObject bizObj, List<String> schemaNumers) {
        return this.executeSchemaByList(bizObj, schemaNumers, null);
    }

    public String executeSchemaMobile(DynamicObject bizObj, List<String> schemaNumbers, boolean isRefresh) {
        String billId = String.valueOf(bizObj.getPkValue());
        String billEntityType = bizObj.getDataEntityType().getName();
        String resultStr = null;
        if (isRefresh) {
            Map<String, Object> resultMap = this.executeSchemaMobileCore(bizObj, schemaNumbers);
            resultStr = IDIJSONUtils.toJsonString(resultMap);
            CacheManager.put((String)billEntityType, (String)billId, (String)resultStr);
        } else {
            resultStr = CacheManager.get((String)billEntityType, (String)billId);
            if (StringUtils.isEmpty((String)resultStr)) {
                Map<String, Object> resultMap = this.executeSchemaMobileCore(bizObj, schemaNumbers);
                resultStr = IDIJSONUtils.toJsonString(resultMap);
                CacheManager.put((String)billEntityType, (String)billId, (String)resultStr);
            }
        }
        return Objects.requireNonNull(resultStr, "reslut is null");
    }

    private Map<String, Object> executeSchemaMobileCore(DynamicObject bizObj, List<String> schemaNumbers) {
        String billType = bizObj.getDataEntityType().getName();
        Object[] result = this.executeSchemaCore(bizObj, schemaNumbers, null, true);
        SchemaResult schemaResult = (SchemaResult)result[0];
        Schema schema = (Schema)result[1];
        IDISchemaResultMobileDataConvert mobileDataConvert = new IDISchemaResultMobileDataConvert();
        IDIEventTrackingLog eventTrackingLog = IDIEventTrackingLog.instance((Schema)schema, (EventTrackingTypeEnum)EventTrackingTypeEnum.MOBILE, (String)billType);
        eventTrackingLog.print();
        return mobileDataConvert.convertObject(schemaResult, schema);
    }

    public String getSchemaSummary(DynamicObject bizObj, List<String> schemaNumbers) {
        Object[] result = this.executeSchemaCore(bizObj, schemaNumbers, null, true);
        SchemaResult schemaResult = (SchemaResult)result[0];
        Schema schema = (Schema)result[1];
        IDISchemaResultMobileDataConvert mobileDataConvert = new IDISchemaResultMobileDataConvert();
        Map resultMap = mobileDataConvert.convertObject(schemaResult, schema);
        String resultStr = IDIJSONUtils.toJsonString((Object)resultMap);
        String billId = String.valueOf(bizObj.getPkValue());
        String billEntityType = bizObj.getDataEntityType().getName();
        CacheManager.put((String)billEntityType, (String)billId, (String)resultStr);
        List headerList = (List)resultMap.get("headerList");
        HashMap<String, String> summaryMap = new HashMap<String, String>();
        summaryMap.put("status", schemaResult.getStatus());
        String summaryText = "";
        if (!headerList.isEmpty()) {
            CardRowModel comment = (CardRowModel)headerList.get(0);
            List itemModelList = comment.getMainDesc();
            TextItemModel textItemModel = (TextItemModel)itemModelList.get(itemModelList.size() - 1);
            summaryText = textItemModel.getContent();
        }
        summaryMap.put("content", summaryText);
        return IDIJSONUtils.toJsonString(summaryMap);
    }

    public String executeSchemaByList(DynamicObject bizObj) {
        return this.executeSchemaByList(bizObj, new ArrayList<String>(), null);
    }

    public String executeSchemaCourier(DynamicObject bizObj, String schemaNumber, Map<String, CourierParam> courierParam) {
        return this.executeSchemaCourier(bizObj, schemaNumber, courierParam, null);
    }

    public String executeSchemaByListExt(DynamicObject bizObj, List<String> schemaNumers) {
        Object[] result = this.executeSchemaCore(bizObj, schemaNumers, null, true);
        return IDIJSONUtils.toJsonString((Object)result);
    }

    public String billControl(DynamicObject bizObj) {
        Object[] result;
        Schema schema;
        String billType = bizObj.getDataEntityType().getName();
        Object pkValue = bizObj.getPkValue();
        boolean hasBill = false;
        if (pkValue != null) {
            try {
                if (pkValue instanceof Long && (Long)pkValue > 0L || pkValue instanceof String && !String.valueOf(pkValue).isEmpty()) {
                    DynamicObject newBizObj = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)billType);
                    bizObj = DynamicObjectCopyMergeUtil.mergeDynamicObject((DynamicObject)bizObj, (DynamicObject)newBizObj);
                    hasBill = true;
                }
            }
            catch (Exception newBizObj) {
                // empty catch block
            }
        }
        if ((schema = (Schema)(result = new SchemaSearcher().billControlMatch(bizObj))[1]) != null) {
            if (schema.hasControl()) {
                SchemaExecutor executor = new SchemaExecutor();
                SchemaContext context = executor.buildContext(schema, billType, bizObj);
                if (hasBill) {
                    context.setBillId((Long)pkValue);
                }
                SchemaResult schemaResult = executor.executeSchema(schema, context);
                result[0] = schemaResult;
            } else {
                SchemaResult schemaResult = new SchemaResult();
                schemaResult.setStatus("noexecute");
                result[0] = schemaResult;
            }
        }
        IDISchemaResultOpDataConvert converter = new IDISchemaResultOpDataConvert();
        Map resultMap = converter.convertObject((SchemaResult)result[0], schema);
        return IDIJSONUtils.toJsonString((Object)resultMap);
    }

    public String originalExecuteSchema(DynamicObject bizObj) {
        Object[] result = this.executeSchemaCore(bizObj, null, true);
        Schema schema = (Schema)result[1];
        SchemaResult schemaResult = (SchemaResult)result[0];
        schemaResult.setSchema(schema);
        return IDIJSONUtils.toJsonString((Object)schemaResult);
    }

    public String originalExecuteSchema(DynamicObject bizObj, String schemaNumber) {
        Object[] result = this.executeSchemaCore(bizObj, schemaNumber, null, true);
        Schema schema = (Schema)result[1];
        SchemaResult schemaResult = (SchemaResult)result[0];
        schemaResult.setSchema(schema);
        return IDIJSONUtils.toJsonString((Object)schemaResult);
    }

    public ServiceResult<Object> querySchemaBasicInfo(Long pkId) {
        logger.info("querySchemaBasicInfo param: {}", (Object)pkId);
        HashMap<String, Object> basicInfoMap = new HashMap<String, Object>(8);
        if (pkId != null) {
            try {
                DynamicObject schema = BusinessDataServiceHelper.loadSingleFromCache((Object)pkId, (String)"idi_schema");
                if (schema != null) {
                    basicInfoMap.put("number", schema.getString("number"));
                    basicInfoMap.put("name", schema.getString("name"));
                    basicInfoMap.put("sourceentitynumber", schema.getDynamicObject("sourceentitynumber").getString("number"));
                    Date modifytime = (Date)schema.get("modifytime");
                    basicInfoMap.put("modifytime", modifytime.getTime());
                }
            }
            catch (Exception e) {
                logger.error("query schema error", (Throwable)e);
                basicInfoMap.clear();
            }
        }
        if (basicInfoMap.isEmpty()) {
            ServiceResult errorResult = ServiceResult.error();
            errorResult.setMessage(ResManager.loadKDString((String)"\u5355\u636eid\u4e0d\u5b58\u5728\u3002", (String)"IDISchemaServiceImpl_0", (String)"data-idi-mservice", (Object[])new Object[0]));
            return errorResult;
        }
        return ServiceResult.success(basicInfoMap);
    }

    public String executeSchemaByPageId(DynamicObject bizObj, String pageId) {
        Object[] result = this.executeSchemaCore(bizObj, pageId, false);
        Schema schema = (Schema)result[1];
        SchemaResult schemaResult = (SchemaResult)result[0];
        IDISchemaResultPCDataConvert converter = new IDISchemaResultPCDataConvert();
        Map htmlMap = converter.convertObject(schemaResult, schema);
        return IDIJSONUtils.toJsonString((Object)htmlMap);
    }

    public String executeSchema(DynamicObject bizObj, String schemaNumber, String pageId) {
        Object[] result = this.executeSchemaCore(bizObj, schemaNumber, pageId, false);
        Schema schema = (Schema)result[1];
        SchemaResult schemaResult = (SchemaResult)result[0];
        IDISchemaResultPCDataConvert converter = new IDISchemaResultPCDataConvert();
        Map htmlMap = converter.convertObject(schemaResult, schema);
        return IDIJSONUtils.toJsonString((Object)htmlMap);
    }

    public String executeSchemaByList(DynamicObject bizObj, List<String> schemaNumers, String pageId) {
        Object[] result = this.executeSchemaCore(bizObj, schemaNumers, pageId, true);
        Schema schema = (Schema)result[1];
        SchemaResult schemaResult = (SchemaResult)result[0];
        IDISchemaResultSSCDataConverter schemaResultSSCDataConverter = new IDISchemaResultSSCDataConverter();
        Map map = schemaResultSSCDataConverter.convertObject(schemaResult, schema);
        return IDIJSONUtils.toJsonString((Object)map);
    }

    public String executeSchemaByListPageId(DynamicObject bizObj, String pageId) {
        return this.executeSchemaByList(bizObj, new ArrayList<String>(), pageId);
    }

    public String executeSchemaCourier(DynamicObject bizObj, String schemaNumber, Map<String, CourierParam> courierParam, String pageId) {
        SchemaResult schemaResult = new SchemaResult();
        Object[] result = new SchemaSearcher().match(bizObj, schemaNumber);
        Schema schema = (Schema)result[1];
        if (schema != null) {
            String billType = bizObj.getDataEntityType().getName();
            SchemaExecutor executor = new SchemaExecutor();
            SchemaContext context = executor.buildContext(schema, billType, (Long)bizObj.getPkValue(), pageId, false);
            context.setCourierParam(courierParam);
            schemaResult = executor.executeSchema(schema, context);
        }
        IDISchemaResultPCDataConvert converter = new IDISchemaResultPCDataConvert();
        Map htmlMap = converter.convertObject(schemaResult, schema);
        return IDIJSONUtils.toJsonString((Object)htmlMap);
    }
}

