/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.mservice.upgradeservice;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.data.idi.data.Area;
import kd.data.idi.data.Decision;
import kd.data.idi.data.DecisionRule;
import kd.data.idi.data.InvoiceConfig;
import kd.data.idi.data.KeywordConfig;
import kd.data.idi.data.KeywordConfigItem;
import kd.data.idi.data.Schema;
import kd.data.idi.util.IDIJSONUtils;
import kd.data.idi.util.Pair;

public class IDISchemaUpgradeKeyWordServiceImpl
implements IUpgradeService {
    private static final String PARAM_KEYWORD = "keywords";
    private static final String PARAM_IDS = "ids";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        DBRoute bdai = DBRoute.of((String)"bdai");
        String schemaEntity = "idi_schema";
        DynamicObject[] schemaArray = BusinessDataServiceHelper.load((String)schemaEntity, (String)"id,sourceentitynumber,rule,rule_tag", null);
        if (schemaArray != null && schemaArray.length > 0) {
            StringBuilder logBuffer = new StringBuilder();
            StringBuilder successMessage = new StringBuilder("Schema update success\u3002");
            String nameSuffix = ResManager.loadKDString((String)"\u654f\u611f\u8bcd\u5e93", (String)"IDISchemaUpgradeServiceImpl_0", (String)"data-idi-mservice", (Object[])new Object[0]);
            try {
                Map<String, Set<DynamicObject>> schemaMap = this.classifySchema(schemaArray);
                Map<String, Pair<String, Boolean>> entityToHasCompanyMap = this.queryEntityHasCompany(schemaMap, successMessage);
                ParseKeyWord parseKeyWord = new ParseKeyWord();
                SetNewKeyWord setNewKeyWord = new SetNewKeyWord();
                Map<String, Pair<Long, String>> keyWordMap = this.queryKeyWordByEntityNumber(schemaMap, bdai);
                String insertKeyWordSql = "INSERT INTO t_idi_keyword_library(FID,FKEYWORD,FCREATETIME,FENABLE,FSTATUS,FDESC,FNUMBER) VALUES (?,?,?,?,?,?,?)";
                ArrayList<Object[]> insertParamList = new ArrayList<Object[]>(5);
                String insertKeyWordSqll = "INSERT INTO T_IDI_KEYWORD_LIBRARY_L(FID,FPKID,FLOCALEID,FNAME) VALUES (?,?,?,?)";
                ArrayList<Object[]> insertLParamList = new ArrayList<Object[]>(5);
                String updateKeyWordSql = "UPDATE t_idi_keyword_library SET FKEYWORD = ?, FMODIFYTIME=? WHERE fid = ?";
                ArrayList<Object[]> updateParamList = new ArrayList<Object[]>(5);
                for (Map.Entry<String, Set<DynamicObject>> schemaEntry : schemaMap.entrySet()) {
                    String entityNumber = schemaEntry.getKey();
                    Set<DynamicObject> entityObjSet = schemaEntry.getValue();
                    logBuffer.append(String.format("entitynumber is %s in processing", entityNumber));
                    Pair<String, Boolean> aliasAndHasCompany = entityToHasCompanyMap.get(entityNumber);
                    boolean hasCompany = (Boolean)aliasAndHasCompany.getValue();
                    HashMap<String, Object> paramMap = new HashMap<String, Object>();
                    HashSet<String> keywordSet = new HashSet<String>();
                    paramMap.put(PARAM_KEYWORD, keywordSet);
                    this.parsekeyWord(entityObjSet, paramMap, parseKeyWord, hasCompany, logBuffer, "parse, schema id is %s", false);
                    if (!keywordSet.isEmpty()) {
                        Pair<Long, String> keyWordPair = keyWordMap.get(entityNumber);
                        Long id = 0L;
                        if (keyWordPair == null) {
                            logBuffer.append("keyWord isnot Exist");
                            id = this.createInsertSql(keywordSet, entityNumber, insertParamList);
                            this.createInsertSqll(id, aliasAndHasCompany, insertLParamList, nameSuffix);
                        } else {
                            id = (Long)keyWordPair.getKey();
                            logBuffer.append(String.format("keyWord 'id is %s", id));
                            this.createUpdateSql(id, (String)keyWordPair.getValue(), keywordSet, updateParamList);
                        }
                        ArrayList<Long> ids = new ArrayList<Long>(1);
                        ids.add(id);
                        paramMap.put(PARAM_IDS, ids);
                        this.parsekeyWord(entityObjSet, paramMap, setNewKeyWord, hasCompany, logBuffer, "save,schema id is %s", true);
                        continue;
                    }
                    this.parsekeyWord(entityObjSet, null, null, hasCompany, logBuffer, "save. keyword is empty. schema id is %s", true);
                }
                if (!insertParamList.isEmpty()) {
                    DB.executeBatch((DBRoute)bdai, (String)insertKeyWordSql, insertParamList);
                }
                if (!insertLParamList.isEmpty()) {
                    DB.executeBatch((DBRoute)bdai, (String)insertKeyWordSqll, insertLParamList);
                }
                if (!updateParamList.isEmpty()) {
                    DB.executeBatch((DBRoute)bdai, (String)updateKeyWordSql, updateParamList);
                }
                SaveServiceHelper.save((DynamicObject[])schemaArray);
            }
            catch (Exception e) {
                result.setSuccess(false);
                logBuffer.append(e.getMessage());
                result.setErrorInfo(logBuffer.toString());
            }
        } else {
            result.setSuccess(true);
            result.setLog("Schema is empty,do not need update");
        }
        return result;
    }

    private Map<String, Set<DynamicObject>> classifySchema(DynamicObject[] schemaArray) {
        HashMap<String, Set<DynamicObject>> schemaMap = new HashMap<String, Set<DynamicObject>>(5);
        for (DynamicObject schemaObj : schemaArray) {
            DynamicObject sourceEntityNumber = schemaObj.getDynamicObject("sourceentitynumber");
            String entityName = (String)sourceEntityNumber.getPkValue();
            HashSet<DynamicObject> idSet = (HashSet<DynamicObject>)schemaMap.get(entityName);
            if (idSet == null) {
                idSet = new HashSet<DynamicObject>();
                schemaMap.put(entityName, idSet);
            }
            idSet.add(schemaObj);
        }
        return schemaMap;
    }

    private void parsekeyWord(Set<DynamicObject> entityObjSet, Map<String, Object> paramMap, ProcessKeyWord parseKeyWord, boolean hasCompany, StringBuilder logBuffer, String logStr, boolean isUpdate) throws Exception {
        for (DynamicObject dobj : entityObjSet) {
            String schemaConfigStr = dobj.getString("rule_tag");
            schemaConfigStr = this.processSchemaConfig(schemaConfigStr, paramMap, isUpdate, parseKeyWord, hasCompany);
            if (isUpdate) {
                dobj.set("rule_tag", (Object)schemaConfigStr);
            }
            logBuffer.append(String.format(logStr, dobj.getPkValue()));
        }
    }

    private void createUpdateSql(Long id, String keywordStr, Set<String> keywordSet, List<Object[]> updateParamList) {
        Set<String> oldSet = this.stringToSet(keywordStr);
        int increaseCount = keywordSet.size();
        keywordSet.addAll(oldSet);
        int newCount = keywordSet.size();
        if (newCount > increaseCount) {
            Object[] updateParams = new Object[]{this.setToString(keywordSet), new Date(), id};
            updateParamList.add(updateParams);
        }
    }

    private void createInsertSqll(Long id, Pair<String, Boolean> aliasAndHasCompany, List<Object[]> insertLParamList, String nameSuffix) {
        Object[] cnParams = new Object[4];
        String lang = Lang.get().toString();
        cnParams[0] = id;
        cnParams[1] = Uuid16.create().toString();
        cnParams[2] = lang;
        cnParams[3] = (String)aliasAndHasCompany.getKey() + nameSuffix;
        insertLParamList.add(cnParams);
    }

    private Long createInsertSql(Set<String> keywordSet, String entityNumber, List<Object[]> insertParamList) {
        long[] casPks = DB.genLongIds((String)"t_idi_keyword_library", (int)1);
        Long id = casPks[0];
        Object[] params = new Object[]{id, this.setToString(keywordSet), new Date(), "1", "C", ResManager.loadKDString((String)"\u6570\u636e\u5347\u7ea7\u521b\u5efa", (String)"IDISchemaUpgradeServiceImpl_1", (String)"data-idi-mservice", (Object[])new Object[0]), entityNumber};
        insertParamList.add(params);
        return id;
    }

    private Map<String, Pair<Long, String>> queryKeyWordByEntityNumber(Map<String, Set<DynamicObject>> schemaMap, DBRoute bdai) {
        HashMap<String, Pair<Long, String>> keyWordMap = new HashMap<String, Pair<Long, String>>(5);
        StringBuilder sql = new StringBuilder("select fid,fnumber,fkeyword from t_idi_keyword_library where fnumber in (");
        for (String entityNumber : schemaMap.keySet()) {
            sql.append('\'').append(entityNumber).append("',");
        }
        sql.replace(sql.length() - 1, sql.length(), ")");
        try (DataSet dataSet = DB.queryDataSet((String)IDISchemaUpgradeKeyWordServiceImpl.class.getName(), (DBRoute)bdai, (String)sql.toString());){
            if (dataSet != null) {
                for (Row row : dataSet) {
                    String entityNumber = row.getString("fnumber");
                    String keyWord = row.getString("fkeyword");
                    Long id = row.getLong("fid");
                    Pair idToKeyWord = new Pair((Object)id, (Object)keyWord);
                    keyWordMap.put(entityNumber, (Pair<Long, String>)idToKeyWord);
                }
            }
        }
        return keyWordMap;
    }

    private Map<String, Pair<String, Boolean>> queryEntityHasCompany(Map<String, Set<DynamicObject>> schemaMap, StringBuilder successMessage) {
        HashMap<String, Pair<String, Boolean>> entityToHasCompanyMap;
        block16: {
            entityToHasCompanyMap = new HashMap<String, Pair<String, Boolean>>(5);
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"IDISchemaUpgradeKeyWordServiceImpl.beforeExecuteSqlWithResult.hasCompany", (String)"bos_entityobject", (String)"id,name,bizappid.bizcloud.number", (QFilter[])new QFilter[]{new QFilter("id", "in", schemaMap.keySet())}, null);){
                if (dataSet == null) break block16;
                for (Row row : dataSet) {
                    Boolean hasCostCompany = Boolean.FALSE;
                    String cloudId = row.getString("bizappid.bizcloud.number");
                    String entityNumber = row.getString("id");
                    if ("FI".equalsIgnoreCase(cloudId)) {
                        try {
                            MainEntityType schemaType = EntityMetadataCache.getDataEntityType((String)entityNumber);
                            hasCostCompany = schemaType.findProperty("costcompany") != null ? Boolean.TRUE : Boolean.FALSE;
                        }
                        catch (Exception e) {
                            successMessage.append(String.format("metadata is Exception:%s", e.getMessage()));
                        }
                    }
                    String alias = row.getString("name");
                    entityToHasCompanyMap.put(entityNumber, (Pair<String, Boolean>)new Pair((Object)alias, (Object)hasCostCompany));
                }
            }
        }
        return entityToHasCompanyMap;
    }

    private String setToString(Set<String> keywords) {
        if (keywords == null || keywords.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String keyWord : keywords) {
            sb.append(keyWord).append('-');
        }
        return sb.length() > 0 ? sb.substring(0, sb.length() - 1) : "";
    }

    private Set<String> stringToSet(String keywordStr) {
        HashSet keywordSet = Sets.newHashSetWithExpectedSize((int)10);
        if (StringUtils.isNotEmpty((String)keywordStr)) {
            String[] keywords = keywordStr.split("-");
            Collections.addAll(keywordSet, keywords);
        }
        return keywordSet;
    }

    private String processSchemaConfig(String schemaConfigStr, Map<String, Object> paramMap, boolean needToString, ProcessKeyWord processKeyWord, boolean hasCostCompany) throws Exception {
        List areaList;
        if (StringUtils.isEmpty((String)schemaConfigStr)) {
            return null;
        }
        Schema schema = (Schema)IDIJSONUtils.cast((String)schemaConfigStr, Schema.class);
        if (schema != null && (areaList = schema.getArea()) != null && !areaList.isEmpty()) {
            for (Area area : areaList) {
                List decisionList = area.getDecision();
                if (decisionList == null || decisionList.isEmpty()) continue;
                for (Decision decision : decisionList) {
                    String companyFieldName;
                    List keywordItems;
                    KeywordConfig keywordConfig = decision.getKeywordConfig();
                    if (keywordConfig != null && (keywordItems = keywordConfig.getItems()) != null && !keywordItems.isEmpty()) {
                        for (KeywordConfigItem item : keywordItems) {
                            if (item == null || processKeyWord == null) continue;
                            processKeyWord.processKeyWord(item, paramMap);
                        }
                    }
                    if (!needToString) continue;
                    List ruleList = decision.getRules();
                    if (ruleList != null && !ruleList.isEmpty()) {
                        for (DecisionRule dr : ruleList) {
                            dr.setDeductionGradePercent(100 - dr.getPercent());
                        }
                    }
                    InvoiceConfig invoiceConfig = decision.getInvoiceConfig();
                    if (!hasCostCompany || invoiceConfig == null || !StringUtils.isEmpty((String)(companyFieldName = invoiceConfig.getCompanyFieldName()))) continue;
                    invoiceConfig.setCompanyFieldName("costcompany");
                }
            }
        }
        return needToString ? IDIJSONUtils.toJsonString((Object)schema) : null;
    }

    private static class SetNewKeyWord
    implements ProcessKeyWord {
        private SetNewKeyWord() {
        }

        @Override
        public void processKeyWord(KeywordConfigItem keyWordItem, Map<String, Object> paramMap) throws Exception {
            List keywords = keyWordItem.getKeywords();
            List keywordLibraryIds = keyWordItem.getKeywordLibraryIds();
            if (keywords != null && !keywords.isEmpty() && (keywordLibraryIds == null || keywordLibraryIds.isEmpty())) {
                List newKeywordLibraryIds = (List)paramMap.get(IDISchemaUpgradeKeyWordServiceImpl.PARAM_IDS);
                keyWordItem.setKeywordLibraryIds(newKeywordLibraryIds);
            }
        }
    }

    private static class ParseKeyWord
    implements ProcessKeyWord {
        private ParseKeyWord() {
        }

        @Override
        public void processKeyWord(KeywordConfigItem keyWordItem, Map<String, Object> paramMap) throws Exception {
            List keywords = keyWordItem.getKeywords();
            List keywordLibraryIds = keyWordItem.getKeywordLibraryIds();
            if (keywords != null && !keywords.isEmpty() && (keywordLibraryIds == null || keywordLibraryIds.isEmpty())) {
                Set keywordSet = (Set)paramMap.get(IDISchemaUpgradeKeyWordServiceImpl.PARAM_KEYWORD);
                keywordSet.addAll(keywords);
            }
        }
    }

    private static interface ProcessKeyWord {
        public void processKeyWord(KeywordConfigItem var1, Map<String, Object> var2) throws Exception;
    }
}

