/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.norinco.services.payment;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.norinco.services.payment.CompanyQueryPayImpl;
import kd.ebg.aqap.banks.norinco.utils.NorincoPacker;
import kd.ebg.aqap.banks.norinco.utils.NorincoParser;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;

public class CompanyPayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return CompanyQueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        return NorincoPacker.packTransactionPay(bankPayRequest);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        return NorincoParser.parseTransactionPay(bankPayRequest, s);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "transaction.pay";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5bf9\u5916\u652f\u4ed8", (String)"CompanyPayImpl_0", (String)"ebg-aqap-banks-norinco", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "pay".equalsIgnoreCase(paymentInfo.getSubBizType());
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "text/xml");
        StringBuilder builder = new StringBuilder();
        String userId = RequestContextUtils.getBankParameterValue((String)"USER_ID");
        String packageId = RequestContextUtils.getRunningParam((String)"PackageID");
        builder.append("/com.norfico.directAPIservlet?userID=").append(userId).append("&PackageID=").append(packageId).append("&SendTime=").append(System.currentTimeMillis());
        factory.setUri(builder.toString());
    }
}

