/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.norinco.utils;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class NorincoPacker {
    public static final String PackageID = "PackageID";

    public static Element packRoot() {
        Element root = JDomUtils.createRoot((String)"norfico");
        JDomUtils.addChild((Element)root, (String)"request");
        return root;
    }

    public static String getPackageId() {
        String userId = RequestContextUtils.getBankParameterValue((String)"USER_ID");
        LocalDateTime dateTime = LocalDateTime.now();
        String dateStr = dateTime.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        String secondTimestamp = String.valueOf(dateTime.toInstant(ZoneOffset.of("+8")).toEpochMilli());
        String sq = secondTimestamp.substring(4, 11);
        String packageId = userId + dateStr + sq;
        if (packageId.length() != 21) {
            throw new EBServiceException(String.format(ResManager.loadKDString((String)"PackageId\u4e0d\u6b63\u786e%s\u3002", (String)"NorincoPacker_1", (String)"ebg-aqap-banks-norinco", (Object[])new Object[0]), packageId));
        }
        return packageId;
    }

    public static String packBalance(BankBalanceRequest request) {
        Element root = NorincoPacker.packRoot();
        Element requestNode = root.getChild("request");
        JDomUtils.addChild((Element)requestNode, (String)"command", (String)"query.balance");
        Element parameterNode = JDomUtils.addChild((Element)requestNode, (String)"parameter");
        JDomUtils.addChild((Element)parameterNode, (String)"TransDate", (String)request.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        StringBuilder accountStr = new StringBuilder();
        List bankAcntList = request.getBankAcntList();
        if (bankAcntList != null && bankAcntList.size() > 0) {
            for (BankAcnt bankAcnt : bankAcntList) {
                accountStr.append(bankAcnt.getAccNo()).append(",");
            }
            accountStr.deleteCharAt(accountStr.length() - 1);
        }
        JDomUtils.addChild((Element)parameterNode, (String)"AccountCode", (String)accountStr.toString());
        EBContext context = EBContext.getContext();
        JDomUtils.addChild((Element)parameterNode, (String)"UserID", (String)context.getParameter().getBankParameter("USER_ID"));
        String packageId = NorincoPacker.getPackageId();
        JDomUtils.addChild((Element)parameterNode, (String)PackageID, (String)packageId);
        RequestContextUtils.setRunningParam((String)PackageID, (String)packageId);
        return JDomUtils.root2String((Element)root, (String)context.getCharsetName());
    }

    public static String packTodayDetail(BankDetailRequest request) {
        Element root = NorincoPacker.packRoot();
        Element requestNode = root.getChild("request");
        JDomUtils.addChild((Element)requestNode, (String)"command", (String)"query.current.detail");
        Element parameterNode = JDomUtils.addChild((Element)requestNode, (String)"parameter");
        JDomUtils.addChild((Element)parameterNode, (String)"AccountCode", (String)request.getHeader().getAcnt().getAccNo());
        EBContext context = EBContext.getContext();
        JDomUtils.addChild((Element)parameterNode, (String)"UserID", (String)context.getParameter().getBankParameter("USER_ID"));
        String packageId = NorincoPacker.getPackageId();
        JDomUtils.addChild((Element)parameterNode, (String)PackageID, (String)packageId);
        RequestContextUtils.setRunningParam((String)PackageID, (String)packageId);
        return JDomUtils.root2String((Element)root, (String)context.getCharsetName());
    }

    public static String packHisDetail(BankDetailRequest request) {
        Element root = NorincoPacker.packRoot();
        Element requestNode = root.getChild("request");
        JDomUtils.addChild((Element)requestNode, (String)"command", (String)"query.history.detail");
        Element parameterNode = JDomUtils.addChild((Element)requestNode, (String)"parameter");
        JDomUtils.addChild((Element)parameterNode, (String)"AccountCode", (String)request.getHeader().getAcnt().getAccNo());
        JDomUtils.addChild((Element)parameterNode, (String)"BeginDate", (String)request.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)parameterNode, (String)"EndDate", (String)request.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        EBContext context = EBContext.getContext();
        JDomUtils.addChild((Element)parameterNode, (String)"UserID", (String)context.getParameter().getBankParameter("USER_ID"));
        String packageId = NorincoPacker.getPackageId();
        JDomUtils.addChild((Element)parameterNode, (String)PackageID, (String)packageId);
        RequestContextUtils.setRunningParam((String)PackageID, (String)packageId);
        return JDomUtils.root2String((Element)root, (String)context.getCharsetName());
    }

    public static String packTransactionPay(BankPayRequest request) {
        PaymentInfo paymentInfo;
        Element root = NorincoPacker.packRoot();
        Element requestNode = root.getChild("request");
        JDomUtils.addChild((Element)requestNode, (String)"command", (String)"transaction.pay");
        Element parameterNode = JDomUtils.addChild((Element)requestNode, (String)"parameter");
        JDomUtils.addChild((Element)parameterNode, (String)"TransDate", (String)LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        List paymentInfos = request.getPaymentInfos();
        if (paymentInfos != null && !paymentInfos.isEmpty()) {
            paymentInfo = (PaymentInfo)paymentInfos.get(0);
            JDomUtils.addChild((Element)parameterNode, (String)"AccountCode", (String)paymentInfo.getAccNo());
            JDomUtils.addChild((Element)parameterNode, (String)"AccountName", (String)paymentInfo.getAccName());
            JDomUtils.addChild((Element)parameterNode, (String)"BankName", (String)paymentInfo.getBankName());
            JDomUtils.addChild((Element)parameterNode, (String)"OppAccountCode", (String)paymentInfo.getIncomeAccNo());
            JDomUtils.addChild((Element)parameterNode, (String)"OppAccountName", (String)paymentInfo.getIncomeAccName());
            JDomUtils.addChild((Element)parameterNode, (String)"OppBankName", (String)paymentInfo.getIncomeBankName());
            JDomUtils.addChild((Element)parameterNode, (String)"OppAccountType", (String)(paymentInfo.getIndividual() != false ? "1" : "0"));
            JDomUtils.addChild((Element)parameterNode, (String)"OppBankProvince", (String)paymentInfo.getIncomeProvince());
            JDomUtils.addChild((Element)parameterNode, (String)"OppBankCity", (String)paymentInfo.getIncomeCity());
            JDomUtils.addChild((Element)parameterNode, (String)"OppBankCode", (String)paymentInfo.getIncomeCnaps());
            JDomUtils.addChild((Element)parameterNode, (String)"Amount", (String)paymentInfo.getAmount().toString());
            JDomUtils.addChild((Element)parameterNode, (String)"CurrencyCode", (String)paymentInfo.getCurrency());
            JDomUtils.addChild((Element)parameterNode, (String)"Uses", (String)paymentInfo.getUseCn());
            String subBizType = paymentInfo.getSubBizType();
            if (subBizType.equalsIgnoreCase("pay")) {
                JDomUtils.addChild((Element)parameterNode, (String)"ProxyType", (String)"0");
            } else if (subBizType.equalsIgnoreCase("agent")) {
                JDomUtils.addChild((Element)parameterNode, (String)"ProxyType", (String)"1");
            }
        } else {
            throw new EBServiceException();
        }
        JDomUtils.addChild((Element)parameterNode, (String)"PayType", (String)(paymentInfo.is2Urgent() ? "1" : "0"));
        JDomUtils.addChild((Element)parameterNode, (String)"Description", (String)paymentInfo.getExplanation());
        String packageId = NorincoPacker.getPackageId();
        paymentInfo.setBankBatchSeqID(packageId);
        RequestContextUtils.setRunningParam((String)PackageID, (String)packageId);
        JDomUtils.addChild((Element)parameterNode, (String)PackageID, (String)packageId);
        EBContext context = EBContext.getContext();
        JDomUtils.addChild((Element)parameterNode, (String)"UserID", (String)context.getParameter().getBankParameter("USER_ID"));
        return JDomUtils.root2String((Element)root, (String)context.getCharsetName());
    }

    public static String packQueryTransactionPay(BankPayRequest request) {
        Element root = NorincoPacker.packRoot();
        Element requestNode = root.getChild("request");
        JDomUtils.addChild((Element)requestNode, (String)"command", (String)"query.transaction.pay");
        Element parameterNode = JDomUtils.addChild((Element)requestNode, (String)"parameter");
        JDomUtils.addChild((Element)parameterNode, (String)"TransDate", (String)LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        PaymentInfo paymentInfo = null;
        List paymentInfos = request.getPaymentInfos();
        if (paymentInfos == null || paymentInfos.isEmpty()) {
            throw new EBServiceException();
        }
        paymentInfo = (PaymentInfo)paymentInfos.get(0);
        EBContext context = EBContext.getContext();
        JDomUtils.addChild((Element)parameterNode, (String)"UserID", (String)context.getParameter().getBankParameter("USER_ID"));
        JDomUtils.addChild((Element)parameterNode, (String)PackageID, (String)paymentInfo.getBankBatchSeqId());
        return JDomUtils.root2String((Element)root, (String)context.getCharsetName());
    }
}

