/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.icbc.opa.service.payment.company;

import com.icbc.api.BizContent;
import com.icbc.api.DefaultIcbcClient;
import com.icbc.api.IcbcRequest;
import com.icbc.api.request.MybankEnterprisePayPayentRequestV2;
import com.icbc.api.response.MybankEnterprisePayPayentResponseV2;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.icbc.opa.service.payment.company.PayPacker;
import kd.ebg.aqap.banks.icbc.opa.service.payment.company.PayParser;
import kd.ebg.aqap.banks.icbc.opa.service.payment.company.QueryPayImpl;
import kd.ebg.aqap.banks.icbc.opa.service.util.GetStore;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import net.sf.json.JSONObject;

public class PaymentImpl
extends AbstractPayImpl
implements IPay {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(PaymentImpl.class);

    public String getDeveloper() {
        return "simon";
    }

    public String getBizCode() {
        return "PAYENT";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u652f\u4ed8\u6307\u4ee4", (String)"PaymentImpl_0", (String)"ebg-aqap-banks-icbc-opa", (Object[])new Object[0]);
    }

    public EBBankPayResponse pay(BankPayRequest bankPayRequest) {
        PaymentInfo[] paymentInfos = bankPayRequest.getPaymentInfoAsArray();
        String BASE_URL = GetStore.getBaseUrl();
        String URI = "mybank/enterprise/pay/payent/V2";
        DefaultIcbcClient client = GetStore.getClient();
        try {
            MybankEnterprisePayPayentRequestV2.MybankEnterprisePayPayentRequestBizV2 bizContent = PayPacker.packer(paymentInfos);
            MybankEnterprisePayPayentRequestV2 request = new MybankEnterprisePayPayentRequestV2();
            request.setServiceUrl(BASE_URL + URI);
            request.setBizContent((BizContent)bizContent);
            logger.info("\u4ed8\u6b3e\u63d0\u4ea4\u94f6\u884c\u8bf7\u6c42\u53c2\u6570:\n" + JSONObject.fromObject((Object)request).toString());
            try {
                MybankEnterprisePayPayentResponseV2 response = (MybankEnterprisePayPayentResponseV2)client.execute((IcbcRequest)request);
                logger.info("\u4ed8\u6b3e\u63d0\u4ea4\u94f6\u884c\u8fd4\u56de\u53c2\u6570:\n" + JSONObject.fromObject((Object)response).toString());
                PayParser.parse(paymentInfos, response);
            }
            catch (Throwable t) {
                EBContext.getContext().setThrowableAfterSend(t);
            }
        }
        catch (Exception e) {
            logger.error("pay error :", (Throwable)e);
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        return null;
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        return null;
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

