/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.icbc.opa.service.payment.salary;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.icbc.api.request.MybankEnterpriseSalaryFinancialofficeMesfinstrsubmitRequestV1;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import kd.ebg.aqap.banks.icbc.opa.service.util.PackerUtils;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;

class PayPacker {
    PayPacker() {
    }

    public static MybankEnterpriseSalaryFinancialofficeMesfinstrsubmitRequestV1.MybankEnterpriseSalaryFinancialofficeMesfinstrsubmitRequestBizV1 packer(PaymentInfo[] paymentInfos) throws IOException {
        EBGLogger logger = EBGLogger.getInstance().getLogger(PayPacker.class);
        MybankEnterpriseSalaryFinancialofficeMesfinstrsubmitRequestV1.MybankEnterpriseSalaryFinancialofficeMesfinstrsubmitRequestBizV1 bizContent = new MybankEnterpriseSalaryFinancialofficeMesfinstrsubmitRequestV1.MybankEnterpriseSalaryFinancialofficeMesfinstrsubmitRequestBizV1();
        Date date = new Date();
        bizContent.setTransCode("PAYPER");
        bizContent.setTranDate(DateTimeUtils.format((Date)date, (String)"yyyyMMdd"));
        bizContent.setTranTime(DateTimeUtils.format((Date)date, (String)"HHmmssSSS"));
        bizContent.setLanguage("zh_CN");
        bizContent.setfSeqNo(paymentInfos[0].getBankBatchSeqId());
        bizContent.setInstrCount(Integer.valueOf(paymentInfos.length));
        bizContent.setTotalAmount(PackerUtils.getTotalAmountLong(paymentInfos));
        if (paymentInfos[0].is2Merge()) {
            bizContent.setSettleMode("2");
        } else {
            bizContent.setSettleMode("0");
        }
        bizContent.setSummaryTotal(paymentInfos[0].getExplanation());
        ArrayList<MybankEnterpriseSalaryFinancialofficeMesfinstrsubmitRequestV1.MybankEnterpriseSalaryFinancialofficeMesfinstrsubmitRequestRdV1> rds = new ArrayList<MybankEnterpriseSalaryFinancialofficeMesfinstrsubmitRequestV1.MybankEnterpriseSalaryFinancialofficeMesfinstrsubmitRequestRdV1>(16);
        for (int i = 0; i < paymentInfos.length; ++i) {
            MybankEnterpriseSalaryFinancialofficeMesfinstrsubmitRequestV1.MybankEnterpriseSalaryFinancialofficeMesfinstrsubmitRequestRdV1 rd = new MybankEnterpriseSalaryFinancialofficeMesfinstrsubmitRequestV1.MybankEnterpriseSalaryFinancialofficeMesfinstrsubmitRequestRdV1();
            rd.setiSeqNo(paymentInfos[i].getBankSerialNo());
            rd.setPayType(paymentInfos[i].is2Urgent() ? "1" : "2");
            rd.setPayerAccount(paymentInfos[i].getAccNo());
            rd.setPayeeAccount(paymentInfos[i].getIncomeAccNo());
            rd.setPayeeCnname(paymentInfos[i].getIncomeAccName());
            rd.setIoFlag(paymentInfos[i].is2SameBank() ? "1" : "2");
            if (!paymentInfos[i].is2SameBank()) {
                rd.setPayeeBankNo(paymentInfos[i].getIncomeCnaps());
                rd.setPayeeBankName(paymentInfos[i].getIncomeBankName());
            }
            rd.setCurrency(paymentInfos[i].getCurrency());
            rd.setAmount(Long.valueOf(PackerUtils.getAmount(paymentInfos[i]).longValue()));
            rd.setErpSerialNo(paymentInfos[i].getBankDetailSeqId());
            rd.setRefNo(paymentInfos[i].getBankDetailSeqId());
            String summary = paymentInfos[i].getExplanation();
            if (!StringUtils.isEmpty((String)summary) && summary.length() > 20) {
                summary = summary.substring(0, 20);
            }
            rd.setSummary(summary);
            rd.setPurpose(summary);
            rds.add(rd);
        }
        bizContent.setRd(rds);
        if (paymentInfos.length > 200) {
            bizContent.setZipFlag("1");
            JSONObject jsonObject = (JSONObject)JSON.toJSON((Object)bizContent);
            logger.info("\u538b\u7f29\u524d\u62a5\u6587===" + jsonObject.toJSONString());
            PackerUtils.zip(jsonObject);
            bizContent = (MybankEnterpriseSalaryFinancialofficeMesfinstrsubmitRequestV1.MybankEnterpriseSalaryFinancialofficeMesfinstrsubmitRequestBizV1)JSON.toJavaObject((JSON)jsonObject, MybankEnterpriseSalaryFinancialofficeMesfinstrsubmitRequestV1.MybankEnterpriseSalaryFinancialofficeMesfinstrsubmitRequestBizV1.class);
        }
        return bizContent;
    }
}

