/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bnpp.h2h.services.balance;

import com.google.common.collect.Lists;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.aqap.proxy.oversea.entity.OverseaBalance;
import kd.ebg.aqap.proxy.oversea.repository.OverseaBalanceRepository;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;

public class BalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(BalanceImpl.class);

    public EBBankBalanceResponse balance(BankBalanceRequest request) {
        return this.queryBalance(request);
    }

    private EBBankBalanceResponse queryBalance(BankBalanceRequest request) {
        BankAcnt acnt = request.getAcnt();
        EBContext context = EBContext.getContext();
        OverseaBalanceRepository overseaBalanceRepository = (OverseaBalanceRepository)SpringContextUtil.getBean(OverseaBalanceRepository.class);
        OverseaBalance balance = overseaBalanceRepository.getLastestBalance(acnt.getAccNo(), context.getCustomID(), context.getBankVersionID(), request.getBankCurrency());
        if (balance == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6cd5\u5df4\u94f6\u884c\u5f53\u65e5\u4f59\u989d\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u786e\u8ba4\u94f6\u884c\u662f\u5426\u63a8\u9001\u4e86\u5bf9\u5e94\u7684\u6587\u4ef6\u6570\u636e\u3002", (String)"BalanceImpl_8", (String)"ebg-aqap-banks-bnpp-h2h", (Object[])new Object[0]));
        }
        BalanceInfo balanceInfo = new BalanceInfo();
        balanceInfo.setCurrentBalance(balance.getCurrentBalance());
        balanceInfo.setBankCurrency(request.getBankCurrency());
        balanceInfo.setAvailableBalance(balance.getAvailableBalance());
        balanceInfo.setBankAcnt(acnt);
        balanceInfo.setLastDayAvlBalance(balance.getLastDayBalance());
        balanceInfo.setBalanceDateTime(balance.getBalanceDate());
        return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{balanceInfo}));
    }

    public String pack(BankBalanceRequest request) {
        return null;
    }

    public EBBankBalanceResponse parse(BankBalanceRequest rqst, String rspStr) {
        return null;
    }

    public String getDeveloper() {
        return "simon";
    }

    public String getBizCode() {
        return "";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5f53\u65e5\u4f59\u989d\u63a5\u53e3", (String)"BalanceImpl_7", (String)"ebg-aqap-banks-bnpp-h2h", (Object[])new Object[0]);
    }
}

