/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ocbc.dc.services.payment.company;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ocbc.dc.services.OCBC_DC_Parser;
import kd.ebg.aqap.banks.ocbc.dc.services.payment.company.CompanyPaymentQueryImpl;
import kd.ebg.aqap.banks.ocbc.dc.services.payment.company.PayPacker;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PaymentImpl
extends AbstractPayImpl
implements IPay {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(PaymentImpl.class);

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return CompanyPaymentQueryImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo[] infos = paymentInfos.toArray(new PaymentInfo[paymentInfos.size()]);
        String s = PayPacker.packPay(infos);
        return s;
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rsp) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element root = JDomUtils.string2Root((String)rsp, (String)RequestContextUtils.getCharset());
        Element opRep = root.getChild("opRep");
        BankResponse bankRsp = OCBC_DC_Parser.parseHeader(opRep);
        if ("000000".equals(bankRsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)bankRsp.getResponseCode(), (String)bankRsp.getResponseMessage());
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)bankRsp.getResponseCode(), (String)bankRsp.getResponseMessage());
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u884c\u5185\u8f6c\u5e10\u3001\u884c\u5916\u8f6c\u5e10", (String)"PaymentImpl_0", (String)"ebg-aqap-banks-ocbc-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setUri("/DirectLinkClient/srv012_CNY_transfr.do");
    }

    public String getDeveloper() {
        return "guoqiangyao";
    }
}

