/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.proxy.swift.model;

import java.text.SimpleDateFormat;
import java.util.Date;
import kd.ebg.aqap.proxy.swift.exception.SwiftException;
import kd.ebg.aqap.proxy.swift.model.SwiftBlock;

public final class SwiftApplicationHeaderBlock
extends SwiftBlock {
    private static final long serialVersionUID = 1L;
    public static final String BLOCKTYPE = "2:";
    private String ioType;
    private String messageType;
    private String inputTime;
    private String mir;
    private Date outputDateTime;
    private String messagePriority;

    @Override
    public void parserText() {
        if (this.unParserText == null) {
            return;
        }
        if (this.unParserText.trim().length() != 51) {
            String msg = "Parse Application Header Block error, the length of unParserText is not 51.";
            throw new SwiftException(msg);
        }
        String content = this.getUnParserText().trim();
        if (!content.startsWith("{2:")) {
            throw new SwiftException("The block start is not matched for SwiftApplicationHeaderBlock : " + content.substring(0, 3));
        }
        if (!content.endsWith("}")) {
            throw new SwiftException("The block end is not matched for SwiftApplicationHeaderBlock : " + content.substring(content.length() - 1));
        }
        this.ioType = this.unParserText.substring(3, 4);
        this.messageType = this.unParserText.substring(4, 7);
        this.inputTime = this.unParserText.substring(7, 11);
        this.mir = this.unParserText.substring(11, 39);
        String odate = this.unParserText.substring(39, 45);
        String otime = this.unParserText.substring(45, 49);
        try {
            this.outputDateTime = new SimpleDateFormat("yyyyMMddHHmmss").parse("20" + odate + otime + "00");
        }
        catch (Exception e) {
            throw new SwiftException(e);
        }
        this.messagePriority = this.unParserText.substring(49, 50);
    }

    public String getMessageType() {
        return this.messageType;
    }

    public Date getOutputDateTime() {
        return this.outputDateTime;
    }

    public String getMessagePriority() {
        return this.messagePriority;
    }

    public String getIOType() {
        return this.ioType;
    }

    public String getMIR() {
        return this.mir;
    }

    public String getInputTime() {
        return this.inputTime;
    }
}

