/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.proxy.swift.model.field;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Currency;
import java.util.List;
import java.util.Locale;
import kd.ebg.aqap.proxy.swift.model.BIC;
import kd.ebg.aqap.proxy.swift.utils.SwiftFormatUtils;
import kd.ebg.aqap.proxy.swift.utils.SwiftStringUtils;

public class Field {
    protected List components;

    protected Field() {
    }

    protected Field(int components) {
        this.components = new ArrayList(components);
        for (int i = 0; i < components; ++i) {
            this.components.add(null);
        }
    }

    protected static String formatNumber(Object aValue) {
        DecimalFormat fmt = new DecimalFormat("#,###.00");
        NumberFormat f = NumberFormat.getInstance(Locale.getDefault());
        if (f instanceof DecimalFormat) {
            ((DecimalFormat)f).setDecimalSeparatorAlwaysShown(true);
            fmt.setDecimalFormatSymbols(((DecimalFormat)f).getDecimalFormatSymbols());
        }
        String formatted = fmt.format(aValue);
        return formatted;
    }

    protected static String formatAccount(String a) {
        if (a == null) {
            return "";
        }
        StringBuilder result = new StringBuilder(a);
        try {
            result.insert(4, '-');
            result.insert(9, '-');
            result.insert(12, '-');
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result.toString();
    }

    protected void appendInLines(StringBuffer sb, String[] lines) {
        if (lines == null || sb == null) {
            return;
        }
        for (int i = 0; i < lines.length; ++i) {
            if (!SwiftStringUtils.isNotBlank(lines[i])) continue;
            if (i != 0) {
                sb.append("\n");
            }
            sb.append(lines[i]);
        }
    }

    public List getComponents() {
        return this.components;
    }

    public void setComponents(List components) {
        this.components = components;
    }

    public void setComponent(int number, String value) {
        if (number <= 0) {
            throw new IllegalArgumentException("component number is 1-based");
        }
        if (number > this.components.size()) {
            throw new IllegalArgumentException("The index to set is out of bounds.");
        }
        int position = number - 1;
        if (this.components == null) {
            this.components = new ArrayList();
        }
        if (position >= 0) {
            this.components.set(position, value);
        }
    }

    public String getComponent(int number) {
        int position = number - 1;
        if (this.components != null && position >= 0 && position < this.components.size()) {
            return (String)this.components.get(position);
        }
        return null;
    }

    protected Object getComponentAs(int component, Class c) {
        String s = this.getComponent(component);
        if (c.equals(String.class)) {
            return s;
        }
        if (c.equals(BigDecimal.class)) {
            return SwiftFormatUtils.getBigDecimal(s);
        }
        if (c.equals(Number.class)) {
            return SwiftFormatUtils.getNumber(s);
        }
        if (c.equals(BIC.class)) {
            return new BIC(s);
        }
        if (c.equals(Currency.class)) {
            return Currency.getInstance(s);
        }
        if (c.equals(Character.class)) {
            return SwiftFormatUtils.getSign(s);
        }
        if (c.equals(Integer.class)) {
            return Integer.valueOf(s);
        }
        try {
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String toString() {
        int length = this.components.size();
        if (this.components == null || length <= 0) {
            return "[]";
        }
        StringBuilder buffer = new StringBuilder("[");
        for (int i = 0; i < length - 1; ++i) {
            buffer.append(this.components.get(i)).append(", ");
        }
        buffer.append(this.components.get(length - 1)).append("]");
        return buffer.toString();
    }
}

