/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.glb.dc.services.balance;

import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.glb.dc.services.utils.GLBPacker;
import kd.ebg.aqap.banks.glb.dc.services.utils.GLBStringUtils;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    private static EBGLogger ebgLogger = EBGLogger.getInstance().getLogger(BalanceImpl.class);

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/corporbank/httpAccess");
        factory.setHttpHeader("Content-Type", "text/xml; charset=UTF-8");
    }

    public String pack(BankBalanceRequest bankBalanceRequest) {
        Element ebank_root = new Element("ebank");
        JDomUtils.addChild((Element)ebank_root, (Element)GLBPacker.getHeadPackerData(this.getBizCode()));
        Element body = new Element("body");
        JDomUtils.addChild((Element)body, (String)"accountNo", (String)bankBalanceRequest.getAcnt().getAccNo());
        JDomUtils.addChild((Element)ebank_root, (Element)body);
        String headtosign = JDomUtils.element2StringPlain((Element)ebank_root.getChild("head"), (String)RequestContextUtils.getCharset());
        String bodytosign = JDomUtils.element2StringPlain((Element)ebank_root.getChild("body"), (String)RequestContextUtils.getCharset());
        String reqstMsg = headtosign + bodytosign;
        String sign = GLBPacker.sign(reqstMsg);
        JDomUtils.addChild((Element)ebank_root, (String)"sign", (String)sign);
        sign = JDomUtils.element2StringPlain((Element)ebank_root.getChild("sign"), (String)RequestContextUtils.getCharset());
        String requestXml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?><ebank>" + GLBStringUtils.replaceBlank(reqstMsg) + GLBStringUtils.replaceBlank(sign) + "</ebank>";
        return requestXml;
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String s) {
        String encoding = RequestContextUtils.getCharset();
        Element ebenk = JDomUtils.string2Root((String)s, (String)encoding);
        Element head = ebenk.getChild("head");
        String retcode = head.getChildText("retCode");
        if ("000000".equalsIgnoreCase(retcode)) {
            BalanceInfo balanceInfo = new BalanceInfo();
            Element body = ebenk.getChild("body");
            String balance = body.getChildText("balance");
            this.setCurrentBalance(balanceInfo, balance);
            String balanceAvailable = body.getChildText("balanceAvailable");
            this.setAvailableBalance(balanceInfo, balanceAvailable);
            this.setBankCurrency(balanceInfo, bankBalanceRequest.getBankCurrency());
            String accNo = body.getChildTextTrim("accountNo");
            this.setBankAcnt(balanceInfo, bankBalanceRequest.getBankAcntList(), accNo);
            this.setBalanceDateTime(balanceInfo, LocalDateTime.now());
            return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{balanceInfo}));
        }
        String retMessage = head.getChildText("retMessage");
        throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)retcode, (String)retMessage));
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CBE010101";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"CBE010101,\u67e5\u8be2\u4f59\u989d\u4ea4\u6613", (String)"BalanceImpl_6", (String)"ebg-aqap-banks-glb-dc", (Object[])new Object[0]);
    }
}

